/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_PHONEBOOKACCESSPROXY_H
#define ORG_BLUEZ_OBEX_PHONEBOOKACCESSPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/PhonebookAccess.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace PhonebookAccess {

class PhonebookAccessProxy;

class GetSizeCallbackIF {
public:
    virtual ~GetSizeCallbackIF() {}

    virtual void onGetSizeError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< GetSizeError >& error) = 0;

    virtual void onGetSizeResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< GetSizeResponse >& response) = 0;
};

class ListCallbackIF {
public:
    virtual ~ListCallbackIF() {}

    virtual void onListError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< ListError >& error) = 0;

    virtual void onListResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< ListResponse >& response) = 0;
};

class ListFilterFieldsCallbackIF {
public:
    virtual ~ListFilterFieldsCallbackIF() {}

    virtual void onListFilterFieldsError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< ListFilterFieldsError >& error) = 0;

    virtual void onListFilterFieldsResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< ListFilterFieldsResponse >& response) = 0;
};

class PullAllCallbackIF {
public:
    virtual ~PullAllCallbackIF() {}

    virtual void onPullAllError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< PullAllError >& error) = 0;

    virtual void onPullAllResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< PullAllResponse >& response) = 0;
};

class PullCallbackIF {
public:
    virtual ~PullCallbackIF() {}

    virtual void onPullError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< PullError >& error) = 0;

    virtual void onPullResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< PullResponse >& response) = 0;
};

class SelectCallbackIF {
public:
    virtual ~SelectCallbackIF() {}

    virtual void onSelectError(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< SelectError >& error) = 0;

    virtual void onSelectResponse(const ::boost::shared_ptr< PhonebookAccessProxy >& proxy, const ::boost::shared_ptr< SelectResponse >& response) = 0;
};


/**
 * PhonebookAccessProxy is the client side representation of the D-Bus
 * service interface 'org.bluez.obex.PhonebookAccess' (specified in file
 * phonebook_phonebook_access.xml).
 *
 * If the meaning of "org.bluez.obex.PhonebookAccess" isn't clear, then there should be a description here.
 */
class PhonebookAccessProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of PhonebookAccessProxy.
     */
    static ::boost::shared_ptr< PhonebookAccessProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of PhonebookAccessProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< PhonebookAccessProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of PhonebookAccessProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< PhonebookAccessProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< PhonebookAccessProxy > proxyNew(new PhonebookAccessProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~PhonebookAccessProxy ();




    // Method 'Select'

    /**
     * Call the method 'Select'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Select'</b>:
     *
     * If the meaning of "Select" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param location If the meaning of "location" isn't clear, then there should be a description here.
     *
     * @param phonebook If the meaning of "phonebook" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSelectRequest(SelectCallbackIF& cb, const ::std::string& location, const ::std::string& phonebook) const;

    // Method 'PullAll'

    /**
     * Call the method 'PullAll'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'PullAll'</b>:
     *
     * If the meaning of "PullAll" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param targetfile If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPullAllRequest(PullAllCallbackIF& cb, const ::std::string& targetfile, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const;

    // Method 'Pull'

    /**
     * Call the method 'Pull'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Pull'</b>:
     *
     * If the meaning of "Pull" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param vcard If the meaning of "vcard" isn't clear, then there should be a description here.
     *
     * @param targetfile If the meaning of "targetfile" isn't clear, then there should be a description here.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPullRequest(PullCallbackIF& cb, const ::std::string& vcard, const ::std::string& targetfile, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const;

    // Method 'List'

    /**
     * Call the method 'List'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'List'</b>:
     *
     * If the meaning of "List" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListRequest(ListCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const;

    // Method 'GetSize'

    /**
     * Call the method 'GetSize'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetSize'</b>:
     *
     * If the meaning of "GetSize" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetSizeRequest(GetSizeCallbackIF& cb) const;

    // Method 'ListFilterFields'

    /**
     * Call the method 'ListFilterFields'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ListFilterFields'</b>:
     *
     * If the meaning of "ListFilterFields" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListFilterFieldsRequest(ListFilterFieldsCallbackIF& cb) const;


private:

    PhonebookAccessProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class PhonebookAccessProxyCallback;
};

} // namespace PhonebookAccess
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_PHONEBOOKACCESSPROXY_H
