/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGESTUB_H
#define ORG_BLUEZ_OBEX_MESSAGESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Message.h"
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Message {

class MessageStubDelegate;

class MessageStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the MessageStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    MessageStub (const std::string& portName);

    /**
     * Create an instance of the MessageStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    MessageStub (const std::string& portName, const std::string& objectPath);

    virtual ~MessageStub();

    // property 'Folder'

    /**
     * The method onFolderGet() is called by ASF when a client invokes the
     * read method for the property 'Folder'. The onFolderGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     */
    virtual void onFolderGet(const ::boost::shared_ptr< FolderGet >& payload);

    /**
     * Sends back the update to a previous onFolderGet().
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onFolderGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendFolderGetUpdate(const ::std::string& folder, act_t act = 0);

    /**
     * Set the value of the property 'Folder' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     */
    void setFolder(const ::std::string& folder);

    /**
     * Returns the current value of the property 'Folder'.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     */
    const ::std::string& getFolder() const;

    /**
     * Returns the current value of the property 'Folder' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendFolderUpdate() method.
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     */
    ::std::string& getFolderMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendFolderUpdate().
     *
     * <b>Documentation of 'Folder'</b>:
     *
     * If the meaning of "Folder" isn't clear, then there should be a description here.
     */
    void sendFolderUpdate();

    // property 'Subject'

    /**
     * The method onSubjectGet() is called by ASF when a client invokes the
     * read method for the property 'Subject'. The onSubjectGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     */
    virtual void onSubjectGet(const ::boost::shared_ptr< SubjectGet >& payload);

    /**
     * Sends back the update to a previous onSubjectGet().
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSubjectGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSubjectGetUpdate(const ::std::string& subject, act_t act = 0);

    /**
     * Set the value of the property 'Subject' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     */
    void setSubject(const ::std::string& subject);

    /**
     * Returns the current value of the property 'Subject'.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     */
    const ::std::string& getSubject() const;

    /**
     * Returns the current value of the property 'Subject' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSubjectUpdate() method.
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     */
    ::std::string& getSubjectMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSubjectUpdate().
     *
     * <b>Documentation of 'Subject'</b>:
     *
     * If the meaning of "Subject" isn't clear, then there should be a description here.
     */
    void sendSubjectUpdate();

    // property 'Timestamp'

    /**
     * The method onTimestampGet() is called by ASF when a client invokes the
     * read method for the property 'Timestamp'. The onTimestampGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     */
    virtual void onTimestampGet(const ::boost::shared_ptr< TimestampGet >& payload);

    /**
     * Sends back the update to a previous onTimestampGet().
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTimestampGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTimestampGetUpdate(const ::std::string& timestamp, act_t act = 0);

    /**
     * Set the value of the property 'Timestamp' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     */
    void setTimestamp(const ::std::string& timestamp);

    /**
     * Returns the current value of the property 'Timestamp'.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     */
    const ::std::string& getTimestamp() const;

    /**
     * Returns the current value of the property 'Timestamp' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTimestampUpdate() method.
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     */
    ::std::string& getTimestampMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTimestampUpdate().
     *
     * <b>Documentation of 'Timestamp'</b>:
     *
     * If the meaning of "Timestamp" isn't clear, then there should be a description here.
     */
    void sendTimestampUpdate();

    // property 'Sender'

    /**
     * The method onSenderGet() is called by ASF when a client invokes the
     * read method for the property 'Sender'. The onSenderGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     */
    virtual void onSenderGet(const ::boost::shared_ptr< SenderGet >& payload);

    /**
     * Sends back the update to a previous onSenderGet().
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSenderGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSenderGetUpdate(const ::std::string& sender, act_t act = 0);

    /**
     * Set the value of the property 'Sender' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     */
    void setSender(const ::std::string& sender);

    /**
     * Returns the current value of the property 'Sender'.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     */
    const ::std::string& getSender() const;

    /**
     * Returns the current value of the property 'Sender' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSenderUpdate() method.
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     */
    ::std::string& getSenderMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSenderUpdate().
     *
     * <b>Documentation of 'Sender'</b>:
     *
     * If the meaning of "Sender" isn't clear, then there should be a description here.
     */
    void sendSenderUpdate();

    // property 'SenderAddress'

    /**
     * The method onSenderAddressGet() is called by ASF when a client invokes
     * the read method for the property 'SenderAddress'. The
     * onSenderAddressGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     */
    virtual void onSenderAddressGet(const ::boost::shared_ptr< SenderAddressGet >& payload);

    /**
     * Sends back the update to a previous onSenderAddressGet().
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSenderAddressGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendSenderAddressGetUpdate(const ::std::string& senderAddress, act_t act = 0);

    /**
     * Set the value of the property 'SenderAddress' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     */
    void setSenderAddress(const ::std::string& senderAddress);

    /**
     * Returns the current value of the property 'SenderAddress'.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     */
    const ::std::string& getSenderAddress() const;

    /**
     * Returns the current value of the property 'SenderAddress' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendSenderAddressUpdate() method.
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     */
    ::std::string& getSenderAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSenderAddressUpdate().
     *
     * <b>Documentation of 'SenderAddress'</b>:
     *
     * If the meaning of "SenderAddress" isn't clear, then there should be a description here.
     */
    void sendSenderAddressUpdate();

    // property 'ReplyTo'

    /**
     * The method onReplyToGet() is called by ASF when a client invokes the
     * read method for the property 'ReplyTo'. The onReplyToGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     */
    virtual void onReplyToGet(const ::boost::shared_ptr< ReplyToGet >& payload);

    /**
     * Sends back the update to a previous onReplyToGet().
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onReplyToGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReplyToGetUpdate(const ::std::string& replyTo, act_t act = 0);

    /**
     * Set the value of the property 'ReplyTo' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     */
    void setReplyTo(const ::std::string& replyTo);

    /**
     * Returns the current value of the property 'ReplyTo'.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     */
    const ::std::string& getReplyTo() const;

    /**
     * Returns the current value of the property 'ReplyTo' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendReplyToUpdate() method.
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     */
    ::std::string& getReplyToMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReplyToUpdate().
     *
     * <b>Documentation of 'ReplyTo'</b>:
     *
     * If the meaning of "ReplyTo" isn't clear, then there should be a description here.
     */
    void sendReplyToUpdate();

    // property 'Recipient'

    /**
     * The method onRecipientGet() is called by ASF when a client invokes the
     * read method for the property 'Recipient'. The onRecipientGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     */
    virtual void onRecipientGet(const ::boost::shared_ptr< RecipientGet >& payload);

    /**
     * Sends back the update to a previous onRecipientGet().
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRecipientGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendRecipientGetUpdate(const ::std::string& recipient, act_t act = 0);

    /**
     * Set the value of the property 'Recipient' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     */
    void setRecipient(const ::std::string& recipient);

    /**
     * Returns the current value of the property 'Recipient'.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     */
    const ::std::string& getRecipient() const;

    /**
     * Returns the current value of the property 'Recipient' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRecipientUpdate() method.
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     */
    ::std::string& getRecipientMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRecipientUpdate().
     *
     * <b>Documentation of 'Recipient'</b>:
     *
     * If the meaning of "Recipient" isn't clear, then there should be a description here.
     */
    void sendRecipientUpdate();

    // property 'RecipientAddress'

    /**
     * The method onRecipientAddressGet() is called by ASF when a client
     * invokes the read method for the property 'RecipientAddress'. The
     * onRecipientAddressGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     */
    virtual void onRecipientAddressGet(const ::boost::shared_ptr< RecipientAddressGet >& payload);

    /**
     * Sends back the update to a previous onRecipientAddressGet().
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRecipientAddressGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRecipientAddressGetUpdate(const ::std::string& recipientAddress, act_t act = 0);

    /**
     * Set the value of the property 'RecipientAddress' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     */
    void setRecipientAddress(const ::std::string& recipientAddress);

    /**
     * Returns the current value of the property 'RecipientAddress'.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     */
    const ::std::string& getRecipientAddress() const;

    /**
     * Returns the current value of the property 'RecipientAddress' as a
     * mutable reference. If you change the content of the returned object you
     * have to send updates to registered clients by yourself with the help of
     * the sendRecipientAddressUpdate() method.
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     */
    ::std::string& getRecipientAddressMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRecipientAddressUpdate().
     *
     * <b>Documentation of 'RecipientAddress'</b>:
     *
     * If the meaning of "RecipientAddress" isn't clear, then there should be a description here.
     */
    void sendRecipientAddressUpdate();

    // property 'Type'

    /**
     * The method onTypeGet() is called by ASF when a client invokes the read
     * method for the property 'Type'. The onTypeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    virtual void onTypeGet(const ::boost::shared_ptr< TypeGet >& payload);

    /**
     * Sends back the update to a previous onTypeGet().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTypeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTypeGetUpdate(const ::std::string& type, act_t act = 0);

    /**
     * Set the value of the property 'Type' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void setType(const ::std::string& type);

    /**
     * Returns the current value of the property 'Type'.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    const ::std::string& getType() const;

    /**
     * Returns the current value of the property 'Type' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendTypeUpdate() method.
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    ::std::string& getTypeMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTypeUpdate().
     *
     * <b>Documentation of 'Type'</b>:
     *
     * If the meaning of "Type" isn't clear, then there should be a description here.
     */
    void sendTypeUpdate();

    // property 'Size'

    /**
     * The method onSizeGet() is called by ASF when a client invokes the read
     * method for the property 'Size'. The onSizeGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    virtual void onSizeGet(const ::boost::shared_ptr< SizeGet >& payload);

    /**
     * Sends back the update to a previous onSizeGet().
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSizeGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSizeGetUpdate(uint64 size, act_t act = 0);

    /**
     * Set the value of the property 'Size' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    void setSize(uint64 size);

    /**
     * Returns the current value of the property 'Size'.
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    uint64 getSize() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSizeUpdate().
     *
     * <b>Documentation of 'Size'</b>:
     *
     * If the meaning of "Size" isn't clear, then there should be a description here.
     */
    void sendSizeUpdate();

    // property 'AttachmentSize'

    /**
     * The method onAttachmentSizeGet() is called by ASF when a client invokes
     * the read method for the property 'AttachmentSize'. The
     * onAttachmentSizeGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     */
    virtual void onAttachmentSizeGet(const ::boost::shared_ptr< AttachmentSizeGet >& payload);

    /**
     * Sends back the update to a previous onAttachmentSizeGet().
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onAttachmentSizeGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAttachmentSizeGetUpdate(uint64 attachmentSize, act_t act = 0);

    /**
     * Set the value of the property 'AttachmentSize' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     */
    void setAttachmentSize(uint64 attachmentSize);

    /**
     * Returns the current value of the property 'AttachmentSize'.
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     */
    uint64 getAttachmentSize() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendAttachmentSizeUpdate().
     *
     * <b>Documentation of 'AttachmentSize'</b>:
     *
     * If the meaning of "AttachmentSize" isn't clear, then there should be a description here.
     */
    void sendAttachmentSizeUpdate();

    // property 'Status'

    /**
     * The method onStatusGet() is called by ASF when a client invokes the
     * read method for the property 'Status'. The onStatusGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    virtual void onStatusGet(const ::boost::shared_ptr< StatusGet >& payload);

    /**
     * Sends back the update to a previous onStatusGet().
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onStatusGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStatusGetUpdate(const ::std::string& status, act_t act = 0);

    /**
     * Set the value of the property 'Status' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    void setStatus(const ::std::string& status);

    /**
     * Returns the current value of the property 'Status'.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    const ::std::string& getStatus() const;

    /**
     * Returns the current value of the property 'Status' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStatusUpdate() method.
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    ::std::string& getStatusMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStatusUpdate().
     *
     * <b>Documentation of 'Status'</b>:
     *
     * If the meaning of "Status" isn't clear, then there should be a description here.
     */
    void sendStatusUpdate();

    // property 'Priority'

    /**
     * The method onPriorityGet() is called by ASF when a client invokes the
     * read method for the property 'Priority'. The onPriorityGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     */
    virtual void onPriorityGet(const ::boost::shared_ptr< PriorityGet >& payload);

    /**
     * Sends back the update to a previous onPriorityGet().
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onPriorityGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendPriorityGetUpdate(bool priority, act_t act = 0);

    /**
     * Set the value of the property 'Priority' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     */
    void setPriority(bool priority);

    /**
     * Returns the current value of the property 'Priority'.
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     */
    bool getPriority() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendPriorityUpdate().
     *
     * <b>Documentation of 'Priority'</b>:
     *
     * If the meaning of "Priority" isn't clear, then there should be a description here.
     */
    void sendPriorityUpdate();

    // property 'Read'

    /**
     * The method onReadGet() is called by ASF when a client invokes the read
     * method for the property 'Read'. The onReadGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    virtual void onReadGet(const ::boost::shared_ptr< ReadGet >& payload);

    /**
     * Sends back the update to a previous onReadGet().
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onReadGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReadGetUpdate(bool read, act_t act = 0);

    /**
     * The method onReadSet() is called by ASF when a client invokes the write
     * method for the property 'Read'. The onReadSet() method set property
     * value to the given parameter Read by default. If this default behavior
     * doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    virtual void onReadSet(const ::boost::shared_ptr< ReadSet >& payload);

    /**
     * Sends back the update to a previous onReadSet().
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onReadSet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReadSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Read' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    void setRead(bool read);

    /**
     * Returns the current value of the property 'Read'.
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    bool getRead() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendReadUpdate().
     *
     * <b>Documentation of 'Read'</b>:
     *
     * If the meaning of "Read" isn't clear, then there should be a description here.
     */
    void sendReadUpdate();

    // property 'Deleted'

    /**
     * The method onDeletedSet() is called by ASF when a client invokes the
     * write method for the property 'Deleted'. The onDeletedSet() method set
     * property value to the given parameter Deleted by default. If this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     */
    virtual void onDeletedSet(const ::boost::shared_ptr< DeletedSet >& payload);

    /**
     * Sends back the update to a previous onDeletedSet().
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDeletedSet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDeletedSetUpdate(act_t act = 0);

    /**
     * Set the value of the property 'Deleted' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     */
    void setDeleted(bool deleted);

    /**
     * Returns the current value of the property 'Deleted'.
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     */
    bool getDeleted() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeletedUpdate().
     *
     * <b>Documentation of 'Deleted'</b>:
     *
     * If the meaning of "Deleted" isn't clear, then there should be a description here.
     */
    void sendDeletedUpdate();

    // property 'Sent'

    /**
     * The method onSentGet() is called by ASF when a client invokes the read
     * method for the property 'Sent'. The onSentGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     */
    virtual void onSentGet(const ::boost::shared_ptr< SentGet >& payload);

    /**
     * Sends back the update to a previous onSentGet().
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onSentGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSentGetUpdate(bool sent, act_t act = 0);

    /**
     * Set the value of the property 'Sent' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     */
    void setSent(bool sent);

    /**
     * Returns the current value of the property 'Sent'.
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     */
    bool getSent() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendSentUpdate().
     *
     * <b>Documentation of 'Sent'</b>:
     *
     * If the meaning of "Sent" isn't clear, then there should be a description here.
     */
    void sendSentUpdate();

    // property 'Protected'

    /**
     * The method onProtectedGet() is called by ASF when a client invokes the
     * read method for the property 'Protected'. The onProtectedGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     */
    virtual void onProtectedGet(const ::boost::shared_ptr< ProtectedGet >& payload);

    /**
     * Sends back the update to a previous onProtectedGet().
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onProtectedGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendProtectedGetUpdate(bool protected_, act_t act = 0);

    /**
     * Set the value of the property 'Protected' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     */
    void setProtected(bool protected_);

    /**
     * Returns the current value of the property 'Protected'.
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     */
    bool getProtected() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendProtectedUpdate().
     *
     * <b>Documentation of 'Protected'</b>:
     *
     * If the meaning of "Protected" isn't clear, then there should be a description here.
     */
    void sendProtectedUpdate();

    // property 'Text'

    /**
     * The method onTextGet() is called by ASF when a client invokes the read
     * method for the property 'Text'. The onTextGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     */
    virtual void onTextGet(const ::boost::shared_ptr< TextGet >& payload);

    /**
     * Sends back the update to a previous onTextGet().
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onTextGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendTextGetUpdate(bool text, act_t act = 0);

    /**
     * Set the value of the property 'Text' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     */
    void setText(bool text);

    /**
     * Returns the current value of the property 'Text'.
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     */
    bool getText() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendTextUpdate().
     *
     * <b>Documentation of 'Text'</b>:
     *
     * If the meaning of "Text" isn't clear, then there should be a description here.
     */
    void sendTextUpdate();

    // method 'Get'

    /**
     * The method onGet() is called by ASF when a client invokes the method
     * 'Get'. A subclass has to implement this method and send back a response
     * to the client either with the sendGet() or sendGetError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetRequest (const ::boost::shared_ptr< GetRequest >& request) = 0;

    /**
     * The method sendGetResponse() sends a response of a previous method
     * invocation of 'Get' back to the client.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param transfer If the meaning of "transfer" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGet(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetResponse (const ::std::string& transfer, act_t act = 0);

    /**
     * The method sendGetError() sends an error response of a previous method
     * invocation of 'Get' back to the client.
     *
     * <b>Documentation of 'Get'</b>:
     *
     * If the meaning of "Get" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGet(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendGetError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    FolderUpdate _FolderProperty;

    SubjectUpdate _SubjectProperty;

    TimestampUpdate _TimestampProperty;

    SenderUpdate _SenderProperty;

    SenderAddressUpdate _SenderAddressProperty;

    ReplyToUpdate _ReplyToProperty;

    RecipientUpdate _RecipientProperty;

    RecipientAddressUpdate _RecipientAddressProperty;

    TypeUpdate _TypeProperty;

    SizeUpdate _SizeProperty;

    AttachmentSizeUpdate _AttachmentSizeProperty;

    StatusUpdate _StatusProperty;

    PriorityUpdate _PriorityProperty;

    ReadUpdate _ReadProperty;

    DeletedUpdate _DeletedProperty;

    SentUpdate _SentProperty;

    ProtectedUpdate _ProtectedProperty;

    TextUpdate _TextProperty;

    friend class MessageStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Message
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGESTUB_H
