/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Message.h"
#include "org/bluez/obex/MessageDBus.h"
#include "org/bluez/obex/MessageJson.h"
#include "org/bluez/obex/MessageStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Message {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/message/created/during/runtime/org/bluez/obex/Message", MessageStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 3, "Get", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Read", 13 },
    { 4, "Sent", 15 },
    { 4, "Size", 9 },
    { 4, "Text", 17 },
    { 4, "Type", 8 },
    { 6, "Folder", 0 },
    { 6, "Sender", 3 },
    { 6, "Status", 11 },
    { 7, "Deleted", 14 },
    { 7, "ReplyTo", 5 },
    { 7, "Subject", 1 },
    { 8, "Priority", 12 },
    { 9, "Protected", 16 },
    { 9, "Recipient", 6 },
    { 9, "Timestamp", 2 },
    { 13, "SenderAddress", 4 },
    { 14, "AttachmentSize", 10 },
    { 16, "RecipientAddress", 7 },
};

class MessageStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    MessageStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    MessageStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    MessageStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.Message"),
          _logger(logger) {}

    virtual ~MessageStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void MessageStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Get'

            LOG_DEBUG_STUB("process method '%s'", "Get");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Get", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetRequest > payload = ::boost::static_pointer_cast<GetRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageStub*>(getStub())->onGetRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* MessageStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.Message\">\n"
            "      <method name=\"Get\">\n"
            "        <arg direction=\"in\" name=\"targetfile\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"attachment\" type=\"b\"/>\n"
            "        <arg direction=\"out\" name=\"transfer\" type=\"o\"/>\n"
            "      </method>\n"
            "      <property access=\"read\" name=\"Folder\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Subject\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Timestamp\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Sender\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"SenderAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"ReplyTo\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Recipient\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"RecipientAddress\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Type\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Size\" type=\"t\"/>\n"
            "      <property access=\"read\" name=\"AttachmentSize\" type=\"t\"/>\n"
            "      <property access=\"read\" name=\"Status\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Priority\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Read\" type=\"b\"/>\n"
            "      <property access=\"write\" name=\"Deleted\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Sent\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Protected\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Text\" type=\"b\"/>\n"
            "</interface>\n";
}

void MessageStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<MessageStub*>(getStub()))->onGetAll (properties);
}

void MessageStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 18, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Folder");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Subject");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Timestamp");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Sender");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "SenderAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "ReplyTo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Recipient");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "RecipientAddress");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Size");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "AttachmentSize");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "Status");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "Priority");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "Read");
            ::boost::shared_ptr< ReadSet > payload(new ReadSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<MessageStub*>(getStub())->onReadSet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "Deleted");
            ::boost::shared_ptr< DeletedSet > payload(new DeletedSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<MessageStub*>(getStub())->onDeletedSet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "Sent");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "Protected");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Text");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void MessageStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 18, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Folder");
            ::boost::shared_ptr< FolderGet > payload(new FolderGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onFolderGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Subject");
            ::boost::shared_ptr< SubjectGet > payload(new SubjectGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onSubjectGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Timestamp");
            ::boost::shared_ptr< TimestampGet > payload(new TimestampGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onTimestampGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "Sender");
            ::boost::shared_ptr< SenderGet > payload(new SenderGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onSenderGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "SenderAddress");
            ::boost::shared_ptr< SenderAddressGet > payload(new SenderAddressGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onSenderAddressGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "ReplyTo");
            ::boost::shared_ptr< ReplyToGet > payload(new ReplyToGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onReplyToGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Recipient");
            ::boost::shared_ptr< RecipientGet > payload(new RecipientGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onRecipientGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "RecipientAddress");
            ::boost::shared_ptr< RecipientAddressGet > payload(new RecipientAddressGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onRecipientAddressGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Type");
            ::boost::shared_ptr< TypeGet > payload(new TypeGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onTypeGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Size");
            ::boost::shared_ptr< SizeGet > payload(new SizeGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onSizeGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "AttachmentSize");
            ::boost::shared_ptr< AttachmentSizeGet > payload(new AttachmentSizeGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onAttachmentSizeGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "Status");
            ::boost::shared_ptr< StatusGet > payload(new StatusGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onStatusGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "Priority");
            ::boost::shared_ptr< PriorityGet > payload(new PriorityGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onPriorityGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "Read");
            ::boost::shared_ptr< ReadGet > payload(new ReadGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onReadGet (payload);
            return;
        }
        case 14: {
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is write only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendGetError(DBUS_ERROR_ACCESS_DENIED, errorMessage.str(), act);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "Sent");
            ::boost::shared_ptr< SentGet > payload(new SentGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onSentGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "Protected");
            ::boost::shared_ptr< ProtectedGet > payload(new ProtectedGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onProtectedGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Text");
            ::boost::shared_ptr< TextGet > payload(new TextGet());
            payload->setAct(act);
            static_cast<MessageStub*>(getStub())->onTextGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

MessageStub::MessageStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new MessageStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

MessageStub::MessageStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new MessageStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

MessageStub::~MessageStub() {
    delete _stubDelegate;
}

void MessageStub::sendFolderUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FolderUpdate payload(_FolderProperty);

        LOG_INFO ("-> send%s", "FolderUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Folder", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FolderUpdate");
    }
}

void MessageStub::onFolderGet(const ::boost::shared_ptr< FolderGet >& folder) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FolderGet", folder->getAct());
    sendFolderGetUpdate(_FolderProperty.getFolder(), folder->getAct());
}

void MessageStub::sendFolderGetUpdate(const ::std::string& folder, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FolderGet payload(folder);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FolderGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setFolder(const ::std::string& folder) {
    if(folder!=_FolderProperty.getFolder()) {
        _FolderProperty.setFolder(folder);
        sendFolderUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getFolder() const {
    return _FolderProperty.getFolder();
}

::std::string& MessageStub::getFolderMutable() {
    return _FolderProperty.getFolderMutable();
}

void MessageStub::sendSubjectUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SubjectUpdate payload(_SubjectProperty);

        LOG_INFO ("-> send%s", "SubjectUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Subject", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SubjectUpdate");
    }
}

void MessageStub::onSubjectGet(const ::boost::shared_ptr< SubjectGet >& subject) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SubjectGet", subject->getAct());
    sendSubjectGetUpdate(_SubjectProperty.getSubject(), subject->getAct());
}

void MessageStub::sendSubjectGetUpdate(const ::std::string& subject, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SubjectGet payload(subject);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SubjectGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setSubject(const ::std::string& subject) {
    if(subject!=_SubjectProperty.getSubject()) {
        _SubjectProperty.setSubject(subject);
        sendSubjectUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getSubject() const {
    return _SubjectProperty.getSubject();
}

::std::string& MessageStub::getSubjectMutable() {
    return _SubjectProperty.getSubjectMutable();
}

void MessageStub::sendTimestampUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TimestampUpdate payload(_TimestampProperty);

        LOG_INFO ("-> send%s", "TimestampUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Timestamp", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TimestampUpdate");
    }
}

void MessageStub::onTimestampGet(const ::boost::shared_ptr< TimestampGet >& timestamp) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TimestampGet", timestamp->getAct());
    sendTimestampGetUpdate(_TimestampProperty.getTimestamp(), timestamp->getAct());
}

void MessageStub::sendTimestampGetUpdate(const ::std::string& timestamp, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TimestampGet payload(timestamp);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TimestampGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setTimestamp(const ::std::string& timestamp) {
    if(timestamp!=_TimestampProperty.getTimestamp()) {
        _TimestampProperty.setTimestamp(timestamp);
        sendTimestampUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getTimestamp() const {
    return _TimestampProperty.getTimestamp();
}

::std::string& MessageStub::getTimestampMutable() {
    return _TimestampProperty.getTimestampMutable();
}

void MessageStub::sendSenderUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SenderUpdate payload(_SenderProperty);

        LOG_INFO ("-> send%s", "SenderUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Sender", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SenderUpdate");
    }
}

void MessageStub::onSenderGet(const ::boost::shared_ptr< SenderGet >& sender) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SenderGet", sender->getAct());
    sendSenderGetUpdate(_SenderProperty.getSender(), sender->getAct());
}

void MessageStub::sendSenderGetUpdate(const ::std::string& sender, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SenderGet payload(sender);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SenderGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setSender(const ::std::string& sender) {
    if(sender!=_SenderProperty.getSender()) {
        _SenderProperty.setSender(sender);
        sendSenderUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getSender() const {
    return _SenderProperty.getSender();
}

::std::string& MessageStub::getSenderMutable() {
    return _SenderProperty.getSenderMutable();
}

void MessageStub::sendSenderAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SenderAddressUpdate payload(_SenderAddressProperty);

        LOG_INFO ("-> send%s", "SenderAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("SenderAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SenderAddressUpdate");
    }
}

void MessageStub::onSenderAddressGet(const ::boost::shared_ptr< SenderAddressGet >& senderAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SenderAddressGet", senderAddress->getAct());
    sendSenderAddressGetUpdate(_SenderAddressProperty.getSenderAddress(), senderAddress->getAct());
}

void MessageStub::sendSenderAddressGetUpdate(const ::std::string& senderAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SenderAddressGet payload(senderAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SenderAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setSenderAddress(const ::std::string& senderAddress) {
    if(senderAddress!=_SenderAddressProperty.getSenderAddress()) {
        _SenderAddressProperty.setSenderAddress(senderAddress);
        sendSenderAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getSenderAddress() const {
    return _SenderAddressProperty.getSenderAddress();
}

::std::string& MessageStub::getSenderAddressMutable() {
    return _SenderAddressProperty.getSenderAddressMutable();
}

void MessageStub::sendReplyToUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReplyToUpdate payload(_ReplyToProperty);

        LOG_INFO ("-> send%s", "ReplyToUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ReplyTo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReplyToUpdate");
    }
}

void MessageStub::onReplyToGet(const ::boost::shared_ptr< ReplyToGet >& replyTo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReplyToGet", replyTo->getAct());
    sendReplyToGetUpdate(_ReplyToProperty.getReplyTo(), replyTo->getAct());
}

void MessageStub::sendReplyToGetUpdate(const ::std::string& replyTo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReplyToGet payload(replyTo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReplyToGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setReplyTo(const ::std::string& replyTo) {
    if(replyTo!=_ReplyToProperty.getReplyTo()) {
        _ReplyToProperty.setReplyTo(replyTo);
        sendReplyToUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getReplyTo() const {
    return _ReplyToProperty.getReplyTo();
}

::std::string& MessageStub::getReplyToMutable() {
    return _ReplyToProperty.getReplyToMutable();
}

void MessageStub::sendRecipientUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RecipientUpdate payload(_RecipientProperty);

        LOG_INFO ("-> send%s", "RecipientUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Recipient", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RecipientUpdate");
    }
}

void MessageStub::onRecipientGet(const ::boost::shared_ptr< RecipientGet >& recipient) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RecipientGet", recipient->getAct());
    sendRecipientGetUpdate(_RecipientProperty.getRecipient(), recipient->getAct());
}

void MessageStub::sendRecipientGetUpdate(const ::std::string& recipient, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RecipientGet payload(recipient);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RecipientGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setRecipient(const ::std::string& recipient) {
    if(recipient!=_RecipientProperty.getRecipient()) {
        _RecipientProperty.setRecipient(recipient);
        sendRecipientUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getRecipient() const {
    return _RecipientProperty.getRecipient();
}

::std::string& MessageStub::getRecipientMutable() {
    return _RecipientProperty.getRecipientMutable();
}

void MessageStub::sendRecipientAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RecipientAddressUpdate payload(_RecipientAddressProperty);

        LOG_INFO ("-> send%s", "RecipientAddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RecipientAddress", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RecipientAddressUpdate");
    }
}

void MessageStub::onRecipientAddressGet(const ::boost::shared_ptr< RecipientAddressGet >& recipientAddress) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RecipientAddressGet", recipientAddress->getAct());
    sendRecipientAddressGetUpdate(_RecipientAddressProperty.getRecipientAddress(), recipientAddress->getAct());
}

void MessageStub::sendRecipientAddressGetUpdate(const ::std::string& recipientAddress, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RecipientAddressGet payload(recipientAddress);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RecipientAddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setRecipientAddress(const ::std::string& recipientAddress) {
    if(recipientAddress!=_RecipientAddressProperty.getRecipientAddress()) {
        _RecipientAddressProperty.setRecipientAddress(recipientAddress);
        sendRecipientAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getRecipientAddress() const {
    return _RecipientAddressProperty.getRecipientAddress();
}

::std::string& MessageStub::getRecipientAddressMutable() {
    return _RecipientAddressProperty.getRecipientAddressMutable();
}

void MessageStub::sendTypeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TypeUpdate payload(_TypeProperty);

        LOG_INFO ("-> send%s", "TypeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Type", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TypeUpdate");
    }
}

void MessageStub::onTypeGet(const ::boost::shared_ptr< TypeGet >& type) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TypeGet", type->getAct());
    sendTypeGetUpdate(_TypeProperty.getType(), type->getAct());
}

void MessageStub::sendTypeGetUpdate(const ::std::string& type, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TypeGet payload(type);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TypeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setType(const ::std::string& type) {
    if(type!=_TypeProperty.getType()) {
        _TypeProperty.setType(type);
        sendTypeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getType() const {
    return _TypeProperty.getType();
}

::std::string& MessageStub::getTypeMutable() {
    return _TypeProperty.getTypeMutable();
}

void MessageStub::sendSizeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SizeUpdate payload(_SizeProperty);

        LOG_INFO ("-> send%s", "SizeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Size", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SizeUpdate");
    }
}

void MessageStub::onSizeGet(const ::boost::shared_ptr< SizeGet >& size) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SizeGet", size->getAct());
    sendSizeGetUpdate(_SizeProperty.getSize(), size->getAct());
}

void MessageStub::sendSizeGetUpdate(uint64 size, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SizeGet payload(size);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SizeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setSize(uint64 size) {
    if(size!=_SizeProperty.getSize()) {
        _SizeProperty.setSize(size);
        sendSizeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 MessageStub::getSize() const {
    return _SizeProperty.getSize();
}

void MessageStub::sendAttachmentSizeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AttachmentSizeUpdate payload(_AttachmentSizeProperty);

        LOG_INFO ("-> send%s", "AttachmentSizeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("AttachmentSize", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AttachmentSizeUpdate");
    }
}

void MessageStub::onAttachmentSizeGet(const ::boost::shared_ptr< AttachmentSizeGet >& attachmentSize) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AttachmentSizeGet", attachmentSize->getAct());
    sendAttachmentSizeGetUpdate(_AttachmentSizeProperty.getAttachmentSize(), attachmentSize->getAct());
}

void MessageStub::sendAttachmentSizeGetUpdate(uint64 attachmentSize, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AttachmentSizeGet payload(attachmentSize);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AttachmentSizeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setAttachmentSize(uint64 attachmentSize) {
    if(attachmentSize!=_AttachmentSizeProperty.getAttachmentSize()) {
        _AttachmentSizeProperty.setAttachmentSize(attachmentSize);
        sendAttachmentSizeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 MessageStub::getAttachmentSize() const {
    return _AttachmentSizeProperty.getAttachmentSize();
}

void MessageStub::sendStatusUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        StatusUpdate payload(_StatusProperty);

        LOG_INFO ("-> send%s", "StatusUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Status", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "StatusUpdate");
    }
}

void MessageStub::onStatusGet(const ::boost::shared_ptr< StatusGet >& status) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "StatusGet", status->getAct());
    sendStatusGetUpdate(_StatusProperty.getStatus(), status->getAct());
}

void MessageStub::sendStatusGetUpdate(const ::std::string& status, act_t act) {
    ::asf::dbus::DBusVariant variant;
    StatusGet payload(status);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "StatusGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setStatus(const ::std::string& status) {
    if(status!=_StatusProperty.getStatus()) {
        _StatusProperty.setStatus(status);
        sendStatusUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageStub::getStatus() const {
    return _StatusProperty.getStatus();
}

::std::string& MessageStub::getStatusMutable() {
    return _StatusProperty.getStatusMutable();
}

void MessageStub::sendPriorityUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PriorityUpdate payload(_PriorityProperty);

        LOG_INFO ("-> send%s", "PriorityUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Priority", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PriorityUpdate");
    }
}

void MessageStub::onPriorityGet(const ::boost::shared_ptr< PriorityGet >& priority) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PriorityGet", priority->getAct());
    sendPriorityGetUpdate(_PriorityProperty.getPriority(), priority->getAct());
}

void MessageStub::sendPriorityGetUpdate(bool priority, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PriorityGet payload(priority);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PriorityGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setPriority(bool priority) {
    if(priority!=_PriorityProperty.getPriority()) {
        _PriorityProperty.setPriority(priority);
        sendPriorityUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getPriority() const {
    return _PriorityProperty.getPriority();
}

void MessageStub::sendReadUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ReadUpdate payload(_ReadProperty);

        LOG_INFO ("-> send%s", "ReadUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Read", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ReadUpdate");
    }
}

void MessageStub::onReadGet(const ::boost::shared_ptr< ReadGet >& read) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReadGet", read->getAct());
    sendReadGetUpdate(_ReadProperty.getRead(), read->getAct());
}

void MessageStub::sendReadGetUpdate(bool read, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ReadGet payload(read);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReadGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::onReadSet(const ::boost::shared_ptr< ReadSet >& read) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ReadSet", read->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*read, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setRead (read->getRead());
    sendReadSetUpdate(read->getAct());
}

void MessageStub::sendReadSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ReadSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void MessageStub::setRead(bool read) {
    if(read!=_ReadProperty.getRead()) {
        _ReadProperty.setRead(read);
        sendReadUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getRead() const {
    return _ReadProperty.getRead();
}

void MessageStub::sendDeletedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeletedUpdate payload(_DeletedProperty);

        LOG_INFO ("-> send%s", "DeletedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Deleted", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeletedUpdate");
    }
}

void MessageStub::onDeletedSet(const ::boost::shared_ptr< DeletedSet >& deleted) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeletedSet", deleted->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*deleted, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setDeleted (deleted->getDeleted());
    sendDeletedSetUpdate(deleted->getAct());
}

void MessageStub::sendDeletedSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeletedSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void MessageStub::setDeleted(bool deleted) {
    if(deleted!=_DeletedProperty.getDeleted()) {
        _DeletedProperty.setDeleted(deleted);
        sendDeletedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getDeleted() const {
    return _DeletedProperty.getDeleted();
}

void MessageStub::sendSentUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        SentUpdate payload(_SentProperty);

        LOG_INFO ("-> send%s", "SentUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Sent", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "SentUpdate");
    }
}

void MessageStub::onSentGet(const ::boost::shared_ptr< SentGet >& sent) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "SentGet", sent->getAct());
    sendSentGetUpdate(_SentProperty.getSent(), sent->getAct());
}

void MessageStub::sendSentGetUpdate(bool sent, act_t act) {
    ::asf::dbus::DBusVariant variant;
    SentGet payload(sent);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "SentGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setSent(bool sent) {
    if(sent!=_SentProperty.getSent()) {
        _SentProperty.setSent(sent);
        sendSentUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getSent() const {
    return _SentProperty.getSent();
}

void MessageStub::sendProtectedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProtectedUpdate payload(_ProtectedProperty);

        LOG_INFO ("-> send%s", "ProtectedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Protected", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProtectedUpdate");
    }
}

void MessageStub::onProtectedGet(const ::boost::shared_ptr< ProtectedGet >& protected_) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProtectedGet", protected_->getAct());
    sendProtectedGetUpdate(_ProtectedProperty.getProtected(), protected_->getAct());
}

void MessageStub::sendProtectedGetUpdate(bool protected_, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProtectedGet payload(protected_);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProtectedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setProtected(bool protected_) {
    if(protected_!=_ProtectedProperty.getProtected()) {
        _ProtectedProperty.setProtected(protected_);
        sendProtectedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getProtected() const {
    return _ProtectedProperty.getProtected();
}

void MessageStub::sendTextUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TextUpdate payload(_TextProperty);

        LOG_INFO ("-> send%s", "TextUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Text", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.Message", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TextUpdate");
    }
}

void MessageStub::onTextGet(const ::boost::shared_ptr< TextGet >& text) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TextGet", text->getAct());
    sendTextGetUpdate(_TextProperty.getText(), text->getAct());
}

void MessageStub::sendTextGetUpdate(bool text, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TextGet payload(text);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TextGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageStub::setText(bool text) {
    if(text!=_TextProperty.getText()) {
        _TextProperty.setText(text);
        sendTextUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool MessageStub::getText() const {
    return _TextProperty.getText();
}

void  MessageStub::sendGetResponse (const ::std::string& transfer, act_t act) {
    GetResponse* payload = new GetResponse(transfer);
    DBUS_MESSAGE_REPLY(dbusMessage, "Get", GetResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Get", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageStub::sendGetError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetError* payload = new GetError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Get", GetError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Get", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void MessageStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Folder'
    {
        ::asf::dbus::DBusVariant variant;
        FolderGet payload(_FolderProperty.getFolder());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Folder", variant));
    }

    //property 'Subject'
    {
        ::asf::dbus::DBusVariant variant;
        SubjectGet payload(_SubjectProperty.getSubject());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Subject", variant));
    }

    //property 'Timestamp'
    {
        ::asf::dbus::DBusVariant variant;
        TimestampGet payload(_TimestampProperty.getTimestamp());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Timestamp", variant));
    }

    //property 'Sender'
    {
        ::asf::dbus::DBusVariant variant;
        SenderGet payload(_SenderProperty.getSender());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Sender", variant));
    }

    //property 'SenderAddress'
    {
        ::asf::dbus::DBusVariant variant;
        SenderAddressGet payload(_SenderAddressProperty.getSenderAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("SenderAddress", variant));
    }

    //property 'ReplyTo'
    {
        ::asf::dbus::DBusVariant variant;
        ReplyToGet payload(_ReplyToProperty.getReplyTo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ReplyTo", variant));
    }

    //property 'Recipient'
    {
        ::asf::dbus::DBusVariant variant;
        RecipientGet payload(_RecipientProperty.getRecipient());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Recipient", variant));
    }

    //property 'RecipientAddress'
    {
        ::asf::dbus::DBusVariant variant;
        RecipientAddressGet payload(_RecipientAddressProperty.getRecipientAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RecipientAddress", variant));
    }

    //property 'Type'
    {
        ::asf::dbus::DBusVariant variant;
        TypeGet payload(_TypeProperty.getType());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Type", variant));
    }

    //property 'Size'
    {
        ::asf::dbus::DBusVariant variant;
        SizeGet payload(_SizeProperty.getSize());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Size", variant));
    }

    //property 'AttachmentSize'
    {
        ::asf::dbus::DBusVariant variant;
        AttachmentSizeGet payload(_AttachmentSizeProperty.getAttachmentSize());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("AttachmentSize", variant));
    }

    //property 'Status'
    {
        ::asf::dbus::DBusVariant variant;
        StatusGet payload(_StatusProperty.getStatus());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Status", variant));
    }

    //property 'Priority'
    {
        ::asf::dbus::DBusVariant variant;
        PriorityGet payload(_PriorityProperty.getPriority());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Priority", variant));
    }

    //property 'Read'
    {
        ::asf::dbus::DBusVariant variant;
        ReadGet payload(_ReadProperty.getRead());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Read", variant));
    }

    //property 'Deleted'
    // silently ignore, because defined as write only

    //property 'Sent'
    {
        ::asf::dbus::DBusVariant variant;
        SentGet payload(_SentProperty.getSent());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Sent", variant));
    }

    //property 'Protected'
    {
        ::asf::dbus::DBusVariant variant;
        ProtectedGet payload(_ProtectedProperty.getProtected());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Protected", variant));
    }

    //property 'Text'
    {
        ::asf::dbus::DBusVariant variant;
        TextGet payload(_TextProperty.getText());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Text", variant));
    }
}

} // namespace Message
} // namespace obex
} // namespace bluez
} // namespace org
