/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Message.h"
#include "org/bluez/obex/MessageDBus.h"
#include "org/bluez/obex/MessageJson.h"
#include "org/bluez/obex/MessageProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Message {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/message/created/during/runtime/org/bluez/obex/Message", MessageProxy);

class MessageProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    MessageProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< MessageProxy >& proxyShared = ::boost::static_pointer_cast< MessageProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Folder:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FolderError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Folder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FolderError> payload = ::boost::static_pointer_cast<FolderError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FolderCallbackIF*) _callback)->onFolderError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FolderUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Folder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FolderUpdate> payload = ::boost::static_pointer_cast<FolderUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FolderCallbackIF*) _callback)->onFolderUpdate(proxyShared, payload);
                        proxyShared->_folder = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Subject:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubjectError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Subject", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubjectError> payload = ::boost::static_pointer_cast<SubjectError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SubjectCallbackIF*) _callback)->onSubjectError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SubjectUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Subject", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SubjectUpdate> payload = ::boost::static_pointer_cast<SubjectUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SubjectCallbackIF*) _callback)->onSubjectUpdate(proxyShared, payload);
                        proxyShared->_subject = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Timestamp:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimestampError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Timestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimestampError> payload = ::boost::static_pointer_cast<TimestampError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TimestampCallbackIF*) _callback)->onTimestampError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TimestampUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Timestamp", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TimestampUpdate> payload = ::boost::static_pointer_cast<TimestampUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TimestampCallbackIF*) _callback)->onTimestampUpdate(proxyShared, payload);
                        proxyShared->_timestamp = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Sender:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SenderError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sender", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SenderError> payload = ::boost::static_pointer_cast<SenderError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SenderCallbackIF*) _callback)->onSenderError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SenderUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sender", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SenderUpdate> payload = ::boost::static_pointer_cast<SenderUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SenderCallbackIF*) _callback)->onSenderUpdate(proxyShared, payload);
                        proxyShared->_sender = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SenderAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SenderAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SenderAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SenderAddressError> payload = ::boost::static_pointer_cast<SenderAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SenderAddressCallbackIF*) _callback)->onSenderAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SenderAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SenderAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SenderAddressUpdate> payload = ::boost::static_pointer_cast<SenderAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SenderAddressCallbackIF*) _callback)->onSenderAddressUpdate(proxyShared, payload);
                        proxyShared->_senderAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_ReplyTo:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReplyToError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReplyTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReplyToError> payload = ::boost::static_pointer_cast<ReplyToError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReplyToCallbackIF*) _callback)->onReplyToError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReplyToUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "ReplyTo", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReplyToUpdate> payload = ::boost::static_pointer_cast<ReplyToUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReplyToCallbackIF*) _callback)->onReplyToUpdate(proxyShared, payload);
                        proxyShared->_replyTo = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Recipient:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RecipientError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Recipient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RecipientError> payload = ::boost::static_pointer_cast<RecipientError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RecipientCallbackIF*) _callback)->onRecipientError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RecipientUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Recipient", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RecipientUpdate> payload = ::boost::static_pointer_cast<RecipientUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RecipientCallbackIF*) _callback)->onRecipientUpdate(proxyShared, payload);
                        proxyShared->_recipient = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_RecipientAddress:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RecipientAddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RecipientAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RecipientAddressError> payload = ::boost::static_pointer_cast<RecipientAddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((RecipientAddressCallbackIF*) _callback)->onRecipientAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RecipientAddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "RecipientAddress", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RecipientAddressUpdate> payload = ::boost::static_pointer_cast<RecipientAddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((RecipientAddressCallbackIF*) _callback)->onRecipientAddressUpdate(proxyShared, payload);
                        proxyShared->_recipientAddress = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Type:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeError> payload = ::boost::static_pointer_cast<TypeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TypeCallbackIF*) _callback)->onTypeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TypeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Type", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TypeUpdate> payload = ::boost::static_pointer_cast<TypeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TypeCallbackIF*) _callback)->onTypeUpdate(proxyShared, payload);
                        proxyShared->_type = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Size:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SizeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Size", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SizeError> payload = ::boost::static_pointer_cast<SizeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SizeCallbackIF*) _callback)->onSizeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SizeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Size", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SizeUpdate> payload = ::boost::static_pointer_cast<SizeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SizeCallbackIF*) _callback)->onSizeUpdate(proxyShared, payload);
                        proxyShared->_size = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AttachmentSize:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AttachmentSizeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AttachmentSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AttachmentSizeError> payload = ::boost::static_pointer_cast<AttachmentSizeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AttachmentSizeCallbackIF*) _callback)->onAttachmentSizeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AttachmentSizeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AttachmentSize", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AttachmentSizeUpdate> payload = ::boost::static_pointer_cast<AttachmentSizeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AttachmentSizeCallbackIF*) _callback)->onAttachmentSizeUpdate(proxyShared, payload);
                        proxyShared->_attachmentSize = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Status:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusError> payload = ::boost::static_pointer_cast<StatusError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((StatusCallbackIF*) _callback)->onStatusError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StatusUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Status", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StatusUpdate> payload = ::boost::static_pointer_cast<StatusUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((StatusCallbackIF*) _callback)->onStatusUpdate(proxyShared, payload);
                        proxyShared->_status = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Priority:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PriorityError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Priority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PriorityError> payload = ::boost::static_pointer_cast<PriorityError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PriorityCallbackIF*) _callback)->onPriorityError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PriorityUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Priority", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PriorityUpdate> payload = ::boost::static_pointer_cast<PriorityUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PriorityCallbackIF*) _callback)->onPriorityUpdate(proxyShared, payload);
                        proxyShared->_priority = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Read:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Read", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadError> payload = ::boost::static_pointer_cast<ReadError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ReadCallbackIF*) _callback)->onReadError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReadUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Read", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReadUpdate> payload = ::boost::static_pointer_cast<ReadUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ReadCallbackIF*) _callback)->onReadUpdate(proxyShared, payload);
                        proxyShared->_read = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Deleted:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeletedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Deleted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeletedError> payload = ::boost::static_pointer_cast<DeletedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DeletedCallbackIF*) _callback)->onDeletedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeletedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Deleted", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DeletedUpdate> payload = ::boost::static_pointer_cast<DeletedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DeletedCallbackIF*) _callback)->onDeletedUpdate(proxyShared, payload);
                        proxyShared->_deleted = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Sent:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SentError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SentError> payload = ::boost::static_pointer_cast<SentError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((SentCallbackIF*) _callback)->onSentError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SentUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Sent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SentUpdate> payload = ::boost::static_pointer_cast<SentUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((SentCallbackIF*) _callback)->onSentUpdate(proxyShared, payload);
                        proxyShared->_sent = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Protected:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectedError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Protected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectedError> payload = ::boost::static_pointer_cast<ProtectedError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ProtectedCallbackIF*) _callback)->onProtectedError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtectedUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Protected", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ProtectedUpdate> payload = ::boost::static_pointer_cast<ProtectedUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ProtectedCallbackIF*) _callback)->onProtectedUpdate(proxyShared, payload);
                        proxyShared->_protected = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Text:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TextError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Text", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TextError> payload = ::boost::static_pointer_cast<TextError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TextCallbackIF*) _callback)->onTextError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TextUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Text", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TextUpdate> payload = ::boost::static_pointer_cast<TextUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TextCallbackIF*) _callback)->onTextUpdate(proxyShared, payload);
                        proxyShared->_text = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Get:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetError> payload = ::boost::static_pointer_cast<GetError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallbackIF*) _callback)->onGetError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Get", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetResponse> payload = ::boost::static_pointer_cast<GetResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetCallbackIF*) _callback)->onGetResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Folder: {
                ::boost::shared_ptr< FolderError > payload = ::boost::shared_ptr< FolderError >
                (new FolderError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Folder", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FolderCallbackIF*) _callback)->onFolderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Subject: {
                ::boost::shared_ptr< SubjectError > payload = ::boost::shared_ptr< SubjectError >
                (new SubjectError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Subject", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SubjectCallbackIF*) _callback)->onSubjectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Timestamp: {
                ::boost::shared_ptr< TimestampError > payload = ::boost::shared_ptr< TimestampError >
                (new TimestampError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Timestamp", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TimestampCallbackIF*) _callback)->onTimestampError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Sender: {
                ::boost::shared_ptr< SenderError > payload = ::boost::shared_ptr< SenderError >
                (new SenderError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sender", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SenderCallbackIF*) _callback)->onSenderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SenderAddress: {
                ::boost::shared_ptr< SenderAddressError > payload = ::boost::shared_ptr< SenderAddressError >
                (new SenderAddressError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SenderAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SenderAddressCallbackIF*) _callback)->onSenderAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ReplyTo: {
                ::boost::shared_ptr< ReplyToError > payload = ::boost::shared_ptr< ReplyToError >
                (new ReplyToError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ReplyTo", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReplyToCallbackIF*) _callback)->onReplyToError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Recipient: {
                ::boost::shared_ptr< RecipientError > payload = ::boost::shared_ptr< RecipientError >
                (new RecipientError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Recipient", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RecipientCallbackIF*) _callback)->onRecipientError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RecipientAddress: {
                ::boost::shared_ptr< RecipientAddressError > payload = ::boost::shared_ptr< RecipientAddressError >
                (new RecipientAddressError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RecipientAddress", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RecipientAddressCallbackIF*) _callback)->onRecipientAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Type: {
                ::boost::shared_ptr< TypeError > payload = ::boost::shared_ptr< TypeError >
                (new TypeError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Type", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TypeCallbackIF*) _callback)->onTypeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Size: {
                ::boost::shared_ptr< SizeError > payload = ::boost::shared_ptr< SizeError >
                (new SizeError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Size", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SizeCallbackIF*) _callback)->onSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AttachmentSize: {
                ::boost::shared_ptr< AttachmentSizeError > payload = ::boost::shared_ptr< AttachmentSizeError >
                (new AttachmentSizeError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AttachmentSize", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AttachmentSizeCallbackIF*) _callback)->onAttachmentSizeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Status: {
                ::boost::shared_ptr< StatusError > payload = ::boost::shared_ptr< StatusError >
                (new StatusError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Status", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StatusCallbackIF*) _callback)->onStatusError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Priority: {
                ::boost::shared_ptr< PriorityError > payload = ::boost::shared_ptr< PriorityError >
                (new PriorityError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Priority", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PriorityCallbackIF*) _callback)->onPriorityError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Read: {
                ::boost::shared_ptr< ReadError > payload = ::boost::shared_ptr< ReadError >
                (new ReadError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Read", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReadCallbackIF*) _callback)->onReadError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Deleted: {
                ::boost::shared_ptr< DeletedError > payload = ::boost::shared_ptr< DeletedError >
                (new DeletedError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Deleted", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeletedCallbackIF*) _callback)->onDeletedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Sent: {
                ::boost::shared_ptr< SentError > payload = ::boost::shared_ptr< SentError >
                (new SentError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Sent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SentCallbackIF*) _callback)->onSentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Protected: {
                ::boost::shared_ptr< ProtectedError > payload = ::boost::shared_ptr< ProtectedError >
                (new ProtectedError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Protected", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ProtectedCallbackIF*) _callback)->onProtectedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Text: {
                ::boost::shared_ptr< TextError > payload = ::boost::shared_ptr< TextError >
                (new TextError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Text", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TextCallbackIF*) _callback)->onTextError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Get: {
                ::boost::shared_ptr< GetError > payload = ::boost::shared_ptr< GetError >
                (new GetError(DBUS_ERROR_NO_SERVER, "The DBus service Message is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Get", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageProxy> proxyShared = ::boost::static_pointer_cast<MessageProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetCallbackIF*) _callback)->onGetError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& MessageProxyCallback::_logger (MessageProxy::_logger);

MessageProxy::MessageProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.Message", serviceAvailable, _logger) {
}

MessageProxy::~MessageProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< MessageProxy > MessageProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<MessageProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< MessageProxy > proxyNew(new MessageProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t MessageProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    MessageProxyCallback* callback = new MessageProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t MessageProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    MessageProxyCallback* callback = new MessageProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void MessageProxy::clearAllProperties ()
{
    _folder = ::asf::core::nullable< FolderUpdate >();
    _subject = ::asf::core::nullable< SubjectUpdate >();
    _timestamp = ::asf::core::nullable< TimestampUpdate >();
    _sender = ::asf::core::nullable< SenderUpdate >();
    _senderAddress = ::asf::core::nullable< SenderAddressUpdate >();
    _replyTo = ::asf::core::nullable< ReplyToUpdate >();
    _recipient = ::asf::core::nullable< RecipientUpdate >();
    _recipientAddress = ::asf::core::nullable< RecipientAddressUpdate >();
    _type = ::asf::core::nullable< TypeUpdate >();
    _size = ::asf::core::nullable< SizeUpdate >();
    _attachmentSize = ::asf::core::nullable< AttachmentSizeUpdate >();
    _status = ::asf::core::nullable< StatusUpdate >();
    _priority = ::asf::core::nullable< PriorityUpdate >();
    _read = ::asf::core::nullable< ReadUpdate >();
    _deleted = ::asf::core::nullable< DeletedUpdate >();
    _sent = ::asf::core::nullable< SentUpdate >();
    _protected = ::asf::core::nullable< ProtectedUpdate >();
    _text = ::asf::core::nullable< TextUpdate >();
}

void MessageProxy::sendDeregisterAll () const
{
    sendFolderDeregisterAll();
    sendSubjectDeregisterAll();
    sendTimestampDeregisterAll();
    sendSenderDeregisterAll();
    sendSenderAddressDeregisterAll();
    sendReplyToDeregisterAll();
    sendRecipientDeregisterAll();
    sendRecipientAddressDeregisterAll();
    sendTypeDeregisterAll();
    sendSizeDeregisterAll();
    sendAttachmentSizeDeregisterAll();
    sendStatusDeregisterAll();
    sendPriorityDeregisterAll();
    sendReadDeregisterAll();
    sendDeletedDeregisterAll();
    sendSentDeregisterAll();
    sendProtectedDeregisterAll();
    sendTextDeregisterAll();
}

act_t MessageProxy::sendFolderRegister(FolderCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Folder, "Folder", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Folder", &cb, act);
    return act;
}

bool MessageProxy::sendFolderDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Folder", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Folder", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendFolderGet(FolderCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Folder, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Folder", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Folder", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getFolder() const {
    return _folder.get().getFolder();
}

bool MessageProxy::hasFolder() const {
    return _folder.hasValue();
}

void MessageProxy::sendFolderDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Folder");
    _dbusProxyDelegate->deregisterSignalCallback("Folder", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendSubjectRegister(SubjectCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Subject, "Subject", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Subject", &cb, act);
    return act;
}

bool MessageProxy::sendSubjectDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Subject", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Subject", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendSubjectGet(SubjectCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Subject, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Subject", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Subject", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getSubject() const {
    return _subject.get().getSubject();
}

bool MessageProxy::hasSubject() const {
    return _subject.hasValue();
}

void MessageProxy::sendSubjectDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Subject");
    _dbusProxyDelegate->deregisterSignalCallback("Subject", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendTimestampRegister(TimestampCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Timestamp, "Timestamp", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Timestamp", &cb, act);
    return act;
}

bool MessageProxy::sendTimestampDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Timestamp", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Timestamp", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendTimestampGet(TimestampCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Timestamp, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Timestamp", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Timestamp", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getTimestamp() const {
    return _timestamp.get().getTimestamp();
}

bool MessageProxy::hasTimestamp() const {
    return _timestamp.hasValue();
}

void MessageProxy::sendTimestampDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Timestamp");
    _dbusProxyDelegate->deregisterSignalCallback("Timestamp", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendSenderRegister(SenderCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Sender, "Sender", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sender", &cb, act);
    return act;
}

bool MessageProxy::sendSenderDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Sender", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sender", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendSenderGet(SenderCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Sender, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Sender", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Sender", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getSender() const {
    return _sender.get().getSender();
}

bool MessageProxy::hasSender() const {
    return _sender.hasValue();
}

void MessageProxy::sendSenderDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sender");
    _dbusProxyDelegate->deregisterSignalCallback("Sender", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendSenderAddressRegister(SenderAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_SenderAddress, "SenderAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SenderAddress", &cb, act);
    return act;
}

bool MessageProxy::sendSenderAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SenderAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SenderAddress", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendSenderAddressGet(SenderAddressCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_SenderAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "SenderAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("SenderAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getSenderAddress() const {
    return _senderAddress.get().getSenderAddress();
}

bool MessageProxy::hasSenderAddress() const {
    return _senderAddress.hasValue();
}

void MessageProxy::sendSenderAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SenderAddress");
    _dbusProxyDelegate->deregisterSignalCallback("SenderAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendReplyToRegister(ReplyToCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_ReplyTo, "ReplyTo", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ReplyTo", &cb, act);
    return act;
}

bool MessageProxy::sendReplyToDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("ReplyTo", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "ReplyTo", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendReplyToGet(ReplyToCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_ReplyTo, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "ReplyTo", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("ReplyTo", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getReplyTo() const {
    return _replyTo.get().getReplyTo();
}

bool MessageProxy::hasReplyTo() const {
    return _replyTo.hasValue();
}

void MessageProxy::sendReplyToDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "ReplyTo");
    _dbusProxyDelegate->deregisterSignalCallback("ReplyTo", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendRecipientRegister(RecipientCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Recipient, "Recipient", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Recipient", &cb, act);
    return act;
}

bool MessageProxy::sendRecipientDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Recipient", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Recipient", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendRecipientGet(RecipientCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Recipient, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Recipient", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Recipient", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getRecipient() const {
    return _recipient.get().getRecipient();
}

bool MessageProxy::hasRecipient() const {
    return _recipient.hasValue();
}

void MessageProxy::sendRecipientDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Recipient");
    _dbusProxyDelegate->deregisterSignalCallback("Recipient", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendRecipientAddressRegister(RecipientAddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_RecipientAddress, "RecipientAddress", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "RecipientAddress", &cb, act);
    return act;
}

bool MessageProxy::sendRecipientAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("RecipientAddress", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "RecipientAddress", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendRecipientAddressGet(RecipientAddressCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_RecipientAddress, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "RecipientAddress", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("RecipientAddress", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getRecipientAddress() const {
    return _recipientAddress.get().getRecipientAddress();
}

bool MessageProxy::hasRecipientAddress() const {
    return _recipientAddress.hasValue();
}

void MessageProxy::sendRecipientAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "RecipientAddress");
    _dbusProxyDelegate->deregisterSignalCallback("RecipientAddress", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendTypeRegister(TypeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Type, "Type", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Type", &cb, act);
    return act;
}

bool MessageProxy::sendTypeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Type", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Type", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendTypeGet(TypeCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Type, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Type", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Type", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getType() const {
    return _type.get().getType();
}

bool MessageProxy::hasType() const {
    return _type.hasValue();
}

void MessageProxy::sendTypeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Type");
    _dbusProxyDelegate->deregisterSignalCallback("Type", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendSizeRegister(SizeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Size, "Size", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Size", &cb, act);
    return act;
}

bool MessageProxy::sendSizeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Size", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Size", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendSizeGet(SizeCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Size, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Size", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Size", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 MessageProxy::getSize() const {
    return _size.get().getSize();
}

bool MessageProxy::hasSize() const {
    return _size.hasValue();
}

void MessageProxy::sendSizeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Size");
    _dbusProxyDelegate->deregisterSignalCallback("Size", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendAttachmentSizeRegister(AttachmentSizeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AttachmentSize, "AttachmentSize", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AttachmentSize", &cb, act);
    return act;
}

bool MessageProxy::sendAttachmentSizeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AttachmentSize", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AttachmentSize", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendAttachmentSizeGet(AttachmentSizeCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_AttachmentSize, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AttachmentSize", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AttachmentSize", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint64 MessageProxy::getAttachmentSize() const {
    return _attachmentSize.get().getAttachmentSize();
}

bool MessageProxy::hasAttachmentSize() const {
    return _attachmentSize.hasValue();
}

void MessageProxy::sendAttachmentSizeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AttachmentSize");
    _dbusProxyDelegate->deregisterSignalCallback("AttachmentSize", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendStatusRegister(StatusCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Status, "Status", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Status", &cb, act);
    return act;
}

bool MessageProxy::sendStatusDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Status", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Status", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendStatusGet(StatusCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Status, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Status", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Status", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageProxy::getStatus() const {
    return _status.get().getStatus();
}

bool MessageProxy::hasStatus() const {
    return _status.hasValue();
}

void MessageProxy::sendStatusDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Status");
    _dbusProxyDelegate->deregisterSignalCallback("Status", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendPriorityRegister(PriorityCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Priority, "Priority", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Priority", &cb, act);
    return act;
}

bool MessageProxy::sendPriorityDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Priority", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Priority", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendPriorityGet(PriorityCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Priority, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Priority", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Priority", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool MessageProxy::getPriority() const {
    return _priority.get().getPriority();
}

bool MessageProxy::hasPriority() const {
    return _priority.hasValue();
}

void MessageProxy::sendPriorityDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Priority");
    _dbusProxyDelegate->deregisterSignalCallback("Priority", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendReadRegister(ReadCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Read, "Read", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Read", &cb, act);
    return act;
}

bool MessageProxy::sendReadDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Read", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Read", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendReadGet(ReadCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Read, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Read", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Read", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void MessageProxy::sendReadSet(bool read) {
    ReadSet parameter(read);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Read");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Read", propertyContent);
}

act_t MessageProxy::sendReadSet(ReadCallbackIF& cb, bool read) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Read, &cb);
    ReadSet parameter(read);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Read", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Read", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool MessageProxy::getRead() const {
    return _read.get().getRead();
}

bool MessageProxy::hasRead() const {
    return _read.hasValue();
}

void MessageProxy::sendReadDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Read");
    _dbusProxyDelegate->deregisterSignalCallback("Read", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendDeletedRegister(DeletedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Deleted, "Deleted", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Deleted", &cb, act);
    return act;
}

bool MessageProxy::sendDeletedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Deleted", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Deleted", act, static_cast<int>(rv));
    return rv;
}


void MessageProxy::sendDeletedSet(bool deleted) {
    DeletedSet parameter(deleted);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Deleted");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Deleted", propertyContent);
}

act_t MessageProxy::sendDeletedSet(DeletedCallbackIF& cb, bool deleted) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Deleted, &cb);
    DeletedSet parameter(deleted);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Deleted", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Deleted", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool MessageProxy::getDeleted() const {
    return _deleted.get().getDeleted();
}

bool MessageProxy::hasDeleted() const {
    return _deleted.hasValue();
}

void MessageProxy::sendDeletedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Deleted");
    _dbusProxyDelegate->deregisterSignalCallback("Deleted", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendSentRegister(SentCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Sent, "Sent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Sent", &cb, act);
    return act;
}

bool MessageProxy::sendSentDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Sent", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Sent", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendSentGet(SentCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Sent, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Sent", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Sent", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool MessageProxy::getSent() const {
    return _sent.get().getSent();
}

bool MessageProxy::hasSent() const {
    return _sent.hasValue();
}

void MessageProxy::sendSentDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Sent");
    _dbusProxyDelegate->deregisterSignalCallback("Sent", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendProtectedRegister(ProtectedCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Protected, "Protected", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Protected", &cb, act);
    return act;
}

bool MessageProxy::sendProtectedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Protected", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Protected", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendProtectedGet(ProtectedCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Protected, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Protected", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Protected", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool MessageProxy::getProtected() const {
    return _protected.get().getProtected();
}

bool MessageProxy::hasProtected() const {
    return _protected.hasValue();
}

void MessageProxy::sendProtectedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Protected");
    _dbusProxyDelegate->deregisterSignalCallback("Protected", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendTextRegister(TextCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Text, "Text", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Text", &cb, act);
    return act;
}

bool MessageProxy::sendTextDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Text", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Text", act, static_cast<int>(rv));
    return rv;
}

act_t MessageProxy::sendTextGet(TextCallbackIF& cb) {
    MessageProxyCallback* callback = new MessageProxyCallback(ID_Text, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Text", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Text", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool MessageProxy::getText() const {
    return _text.get().getText();
}

bool MessageProxy::hasText() const {
    return _text.hasValue();
}

void MessageProxy::sendTextDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Text");
    _dbusProxyDelegate->deregisterSignalCallback("Text", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageProxy::sendGetRequest(GetCallbackIF& cb, const ::std::string& targetfile, bool attachment) const {
    GetRequest* payload = new GetRequest();
    CHECK_ALLOCATION(payload);
    payload->setTargetfile(targetfile);
    payload->setAttachment(attachment);
    DBUS_MESSAGE_CALL(dbusMessage, "Get", GetRequest, payload, true)
    act_t act = addMethodCallback(ID_Get, dbusMessage.getUniqueSerial(), "Get", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Get", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Message
} // namespace obex
} // namespace bluez
} // namespace org
