/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/MessageAccess.h"
#include "org/bluez/obex/MessageAccessDBus.h"
#include "org/bluez/obex/MessageAccessJson.h"
#include "org/bluez/obex/MessageAccessStub.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace MessageAccess {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/MessageAccess", MessageAccessStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 9, "SetFolder", 0 },
    { 11, "ListFolders", 1 },
    { 11, "PushMessage", 4 },
    { 11, "UpdateInbox", 5 },
    { 12, "ListMessages", 3 },
    { 16, "ListFilterFields", 2 },
    { 20, "NotificationRegistry", 6 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 12, "Notification", 0 },
};

class MessageAccessStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    MessageAccessStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    MessageAccessStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    MessageAccessStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.MessageAccess"),
          _logger(logger) {}

    virtual ~MessageAccessStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void MessageAccessStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 7, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SetFolder'

            LOG_DEBUG_STUB("process method '%s'", "SetFolder");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFolderRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetFolder", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetFolderRequest > payload = ::boost::static_pointer_cast<SetFolderRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onSetFolderRequest(payload);
            return;
        }
        case 1: {

            // method 'ListFolders'

            LOG_DEBUG_STUB("process method '%s'", "ListFolders");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFoldersRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListFolders", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListFoldersRequest > payload = ::boost::static_pointer_cast<ListFoldersRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onListFoldersRequest(payload);
            return;
        }
        case 2: {

            // method 'ListFilterFields'

            LOG_DEBUG_STUB("process method '%s'", "ListFilterFields");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListFilterFields", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListFilterFieldsRequest > payload = ::boost::static_pointer_cast<ListFilterFieldsRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onListFilterFieldsRequest(payload);
            return;
        }
        case 3: {

            // method 'ListMessages'

            LOG_DEBUG_STUB("process method '%s'", "ListMessages");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListMessagesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ListMessages", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ListMessagesRequest > payload = ::boost::static_pointer_cast<ListMessagesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onListMessagesRequest(payload);
            return;
        }
        case 4: {

            // method 'PushMessage'

            LOG_DEBUG_STUB("process method '%s'", "PushMessage");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "PushMessage", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PushMessageRequest > payload = ::boost::static_pointer_cast<PushMessageRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onPushMessageRequest(payload);
            return;
        }
        case 5: {

            // method 'UpdateInbox'

            LOG_DEBUG_STUB("process method '%s'", "UpdateInbox");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateInboxRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UpdateInbox", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UpdateInboxRequest > payload = ::boost::static_pointer_cast<UpdateInboxRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onUpdateInboxRequest(payload);
            return;
        }
        case 6: {

            // method 'NotificationRegistry'

            LOG_DEBUG_STUB("process method '%s'", "NotificationRegistry");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotificationRegistryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "NotificationRegistry", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< NotificationRegistryRequest > payload = ::boost::static_pointer_cast<NotificationRegistryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<MessageAccessStub*>(getStub())->onNotificationRegistryRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* MessageAccessStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.MessageAccess\">\n"
            "      <method name=\"SetFolder\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"ListFolders\">\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"folderList\" type=\"aa{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"ListFilterFields\">\n"
            "        <arg direction=\"out\" name=\"fields\" type=\"as\"/>\n"
            "      </method>\n"
            "      <method name=\"ListMessages\">\n"
            "        <arg direction=\"in\" name=\"folder\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"messages\" type=\"a{oa{sv}}\"/>\n"
            "      </method>\n"
            "      <method name=\"PushMessage\">\n"
            "        <arg direction=\"in\" name=\"sourcefile\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"folder\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"args\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"transfer\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"UpdateInbox\"/>\n"
            "      <method name=\"NotificationRegistry\">\n"
            "        <arg direction=\"in\" name=\"action\" type=\"b\"/>\n"
            "      </method>\n"
            "      <signal name=\"NewMessageNotification\">\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "        <arg name=\"path\" type=\"o\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"Notification\" type=\"s\"/>\n"
            "</interface>\n";
}

void MessageAccessStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<MessageAccessStub*>(getStub()))->onGetAll (properties);
}

void MessageAccessStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Notification");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void MessageAccessStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Notification");
            ::boost::shared_ptr< NotificationGet > payload(new NotificationGet());
            payload->setAct(act);
            static_cast<MessageAccessStub*>(getStub())->onNotificationGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

MessageAccessStub::MessageAccessStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new MessageAccessStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

MessageAccessStub::MessageAccessStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new MessageAccessStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

MessageAccessStub::~MessageAccessStub() {
    delete _stubDelegate;
}

void MessageAccessStub::sendNewMessageNotificationSignal(const ::std::vector< uint8 >& data, const ::std::string& path) {
    if (_stubDelegate->isConnected()) {
        NewMessageNotificationSignal* payload = new NewMessageNotificationSignal(data, path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "NewMessageNotification", NewMessageNotificationSignal, payload)
        LOG_INFO ("-> send%sSignal", "NewMessageNotification");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "NewMessageNotification");
    }
}

void MessageAccessStub::sendNotificationUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        NotificationUpdate payload(_NotificationProperty);

        LOG_INFO ("-> send%s", "NotificationUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Notification", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.obex.MessageAccess", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "NotificationUpdate");
    }
}

void MessageAccessStub::onNotificationGet(const ::boost::shared_ptr< NotificationGet >& notification) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "NotificationGet", notification->getAct());
    sendNotificationGetUpdate(_NotificationProperty.getNotification(), notification->getAct());
}

void MessageAccessStub::sendNotificationGetUpdate(const ::std::string& notification, act_t act) {
    ::asf::dbus::DBusVariant variant;
    NotificationGet payload(notification);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "NotificationGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void MessageAccessStub::setNotification(const ::std::string& notification) {
    if(notification!=_NotificationProperty.getNotification()) {
        _NotificationProperty.setNotification(notification);
        sendNotificationUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& MessageAccessStub::getNotification() const {
    return _NotificationProperty.getNotification();
}

::std::string& MessageAccessStub::getNotificationMutable() {
    return _NotificationProperty.getNotificationMutable();
}

void  MessageAccessStub::sendSetFolderResponse (act_t act) {
    SetFolderResponse* payload = new SetFolderResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetFolder", SetFolderResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetFolder", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendSetFolderError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetFolderError* payload = new SetFolderError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetFolder", SetFolderError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetFolder", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListFoldersResponse (const ::std::vector< ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& folderList, act_t act) {
    ListFoldersResponse* payload = new ListFoldersResponse(folderList);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListFolders", ListFoldersResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListFolders", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListFoldersError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListFoldersError* payload = new ListFoldersError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListFolders", ListFoldersError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListFolders", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListFilterFieldsResponse (const ::std::vector< ::std::string >& fields, act_t act) {
    ListFilterFieldsResponse* payload = new ListFilterFieldsResponse(fields);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListFilterFields", ListFilterFieldsResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListFilterFields", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListFilterFieldsError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListFilterFieldsError* payload = new ListFilterFieldsError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListFilterFields", ListFilterFieldsError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListFilterFields", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListMessagesResponse (const ::std::map< ::std::string, ::std::map< ::std::string, ::asf::dbus::DBusVariant > >& messages, act_t act) {
    ListMessagesResponse* payload = new ListMessagesResponse(messages);
    DBUS_MESSAGE_REPLY(dbusMessage, "ListMessages", ListMessagesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ListMessages", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendListMessagesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ListMessagesError* payload = new ListMessagesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ListMessages", ListMessagesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ListMessages", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendPushMessageResponse (const ::std::string& transfer, act_t act) {
    PushMessageResponse* payload = new PushMessageResponse(transfer);
    DBUS_MESSAGE_REPLY(dbusMessage, "PushMessage", PushMessageResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "PushMessage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendPushMessageError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PushMessageError* payload = new PushMessageError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "PushMessage", PushMessageError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "PushMessage", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendUpdateInboxResponse (act_t act) {
    UpdateInboxResponse* payload = new UpdateInboxResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UpdateInbox", UpdateInboxResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UpdateInbox", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendUpdateInboxError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UpdateInboxError* payload = new UpdateInboxError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UpdateInbox", UpdateInboxError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UpdateInbox", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendNotificationRegistryResponse (act_t act) {
    NotificationRegistryResponse* payload = new NotificationRegistryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "NotificationRegistry", NotificationRegistryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "NotificationRegistry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  MessageAccessStub::sendNotificationRegistryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    NotificationRegistryError* payload = new NotificationRegistryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "NotificationRegistry", NotificationRegistryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "NotificationRegistry", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void MessageAccessStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Notification'
    {
        ::asf::dbus::DBusVariant variant;
        NotificationGet payload(_NotificationProperty.getNotification());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Notification", variant));
    }
}

} // namespace MessageAccess
} // namespace obex
} // namespace bluez
} // namespace org
