/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_MESSAGEACCESSPROXY_H
#define ORG_BLUEZ_OBEX_MESSAGEACCESSPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/obex/MessageAccess.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace MessageAccess {

class MessageAccessProxy;

class ListFilterFieldsCallbackIF {
public:
    virtual ~ListFilterFieldsCallbackIF() {}

    virtual void onListFilterFieldsError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListFilterFieldsError >& error) = 0;

    virtual void onListFilterFieldsResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListFilterFieldsResponse >& response) = 0;
};

class ListFoldersCallbackIF {
public:
    virtual ~ListFoldersCallbackIF() {}

    virtual void onListFoldersError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListFoldersError >& error) = 0;

    virtual void onListFoldersResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListFoldersResponse >& response) = 0;
};

class ListMessagesCallbackIF {
public:
    virtual ~ListMessagesCallbackIF() {}

    virtual void onListMessagesError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListMessagesError >& error) = 0;

    virtual void onListMessagesResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< ListMessagesResponse >& response) = 0;
};

class NewMessageNotificationCallbackIF {
public:
    virtual ~NewMessageNotificationCallbackIF() {}

    virtual void onNewMessageNotificationError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NewMessageNotificationError >& error) = 0;

    virtual void onNewMessageNotificationSignal(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NewMessageNotificationSignal >& signal) = 0;
};

class NotificationCallbackIF {
public:
    virtual ~NotificationCallbackIF() {}

    virtual void onNotificationError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NotificationError >& error) = 0;

    virtual void onNotificationUpdate(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NotificationUpdate >& update) = 0;
};

class NotificationRegistryCallbackIF {
public:
    virtual ~NotificationRegistryCallbackIF() {}

    virtual void onNotificationRegistryError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NotificationRegistryError >& error) = 0;

    virtual void onNotificationRegistryResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< NotificationRegistryResponse >& response) = 0;
};

class PushMessageCallbackIF {
public:
    virtual ~PushMessageCallbackIF() {}

    virtual void onPushMessageError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< PushMessageError >& error) = 0;

    virtual void onPushMessageResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< PushMessageResponse >& response) = 0;
};

class SetFolderCallbackIF {
public:
    virtual ~SetFolderCallbackIF() {}

    virtual void onSetFolderError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< SetFolderError >& error) = 0;

    virtual void onSetFolderResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< SetFolderResponse >& response) = 0;
};

class UpdateInboxCallbackIF {
public:
    virtual ~UpdateInboxCallbackIF() {}

    virtual void onUpdateInboxError(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< UpdateInboxError >& error) = 0;

    virtual void onUpdateInboxResponse(const ::boost::shared_ptr< MessageAccessProxy >& proxy, const ::boost::shared_ptr< UpdateInboxResponse >& response) = 0;
};


/**
 * MessageAccessProxy is the client side representation of the D-Bus
 * service interface 'org.bluez.obex.MessageAccess' (specified in file
 * map_message_access.xml).
 *
 * If the meaning of "org.bluez.obex.MessageAccess" isn't clear, then there should be a description here.
 */
class MessageAccessProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of MessageAccessProxy.
     */
    static ::boost::shared_ptr< MessageAccessProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of MessageAccessProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< MessageAccessProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of MessageAccessProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< MessageAccessProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< MessageAccessProxy > proxyNew(new MessageAccessProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~MessageAccessProxy ();


    // Signal 'NewMessageNotification'

    /**
     * Notify on the signal 'NewMessageNotification'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'NewMessageNotification'</b>:
     *
     * If the meaning of "NewMessageNotification" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNewMessageNotificationRegister(NewMessageNotificationCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'NewMessageNotification'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'NewMessageNotification'</b>:
     *
     * If the meaning of "NewMessageNotification" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNewMessageNotificationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNewMessageNotificationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'NewMessageNotification'.
     */
    void sendNewMessageNotificationDeregisterAll () const;


    // Property 'Notification'

    /**
     * Notify on the property 'Notification'. This method registers for
     * property changes by D-Bus service.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotificationRegister(NotificationCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Notification'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendNotificationRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendNotificationDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Notification'.
     */
    void sendNotificationDeregisterAll() const;

    /**
     * Request the value of the property 'Notification' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Notification'</b>:
     *
     * If the meaning of "Notification" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotificationGet(NotificationCallbackIF& cb);


    /**
     * Returns the current value of the property 'Notification' (as known by
     * the proxy). This method is only allowed to be called when a status
     * message for this property was received before. Otherwise the behavior
     * of this method is undefined. It is safe to call this method when
     * hasNotification() returns true.
     *
     * @return the previously received value of the property 'Notification'.
     */
    const ::std::string& getNotification() const;

    /**
     * Determines whether a status message for the property 'Notification' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasNotification() const;


    // Method 'SetFolder'

    /**
     * Call the method 'SetFolder'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetFolder'</b>:
     *
     * If the meaning of "SetFolder" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetFolderRequest(SetFolderCallbackIF& cb, const ::std::string& name) const;

    // Method 'ListFolders'

    /**
     * Call the method 'ListFolders'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'ListFolders'</b>:
     *
     * If the meaning of "ListFolders" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListFoldersRequest(ListFoldersCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const;

    // Method 'ListFilterFields'

    /**
     * Call the method 'ListFilterFields'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ListFilterFields'</b>:
     *
     * If the meaning of "ListFilterFields" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListFilterFieldsRequest(ListFilterFieldsCallbackIF& cb) const;

    // Method 'ListMessages'

    /**
     * Call the method 'ListMessages'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'ListMessages'</b>:
     *
     * If the meaning of "ListMessages" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param folder If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param filter If the meaning of "filter" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendListMessagesRequest(ListMessagesCallbackIF& cb, const ::std::string& folder, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const;

    // Method 'PushMessage'

    /**
     * Call the method 'PushMessage'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'PushMessage'</b>:
     *
     * If the meaning of "PushMessage" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param sourcefile If the meaning of "sourcefile" isn't clear, then there should be a description here.
     *
     * @param folder If the meaning of "folder" isn't clear, then there should be a description here.
     *
     * @param args If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPushMessageRequest(PushMessageCallbackIF& cb, const ::std::string& sourcefile, const ::std::string& folder, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const;

    // Method 'UpdateInbox'

    /**
     * Call the method 'UpdateInbox'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'UpdateInbox'</b>:
     *
     * If the meaning of "UpdateInbox" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUpdateInboxRequest(UpdateInboxCallbackIF& cb) const;

    // Method 'NotificationRegistry'

    /**
     * Call the method 'NotificationRegistry'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'NotificationRegistry'</b>:
     *
     * If the meaning of "NotificationRegistry" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param action If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendNotificationRegistryRequest(NotificationRegistryCallbackIF& cb, bool action) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    MessageAccessProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'Notification'

    ::asf::core::nullable< NotificationUpdate > _notification;

    DECLARE_CLASS_LOGGER();

    friend class MessageAccessProxyCallback;
};

} // namespace MessageAccess
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_MESSAGEACCESSPROXY_H
