/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/MessageAccess.h"
#include "org/bluez/obex/MessageAccessDBus.h"
#include "org/bluez/obex/MessageAccessJson.h"
#include "org/bluez/obex/MessageAccessProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace MessageAccess {

DEFINE_CLASS_LOGGER("//org/bluez/obex/client/session/created/during/runtime/org/bluez/obex/MessageAccess", MessageAccessProxy);

class MessageAccessProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    MessageAccessProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< MessageAccessProxy >& proxyShared = ::boost::static_pointer_cast< MessageAccessProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_NewMessageNotification:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NewMessageNotificationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "NewMessageNotification", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<NewMessageNotificationSignal> payload = ::boost::static_pointer_cast<NewMessageNotificationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((NewMessageNotificationCallbackIF*) _callback)->onNewMessageNotificationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Notification:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotificationError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Notification", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotificationError> payload = ::boost::static_pointer_cast<NotificationError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((NotificationCallbackIF*) _callback)->onNotificationError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotificationUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Notification", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotificationUpdate> payload = ::boost::static_pointer_cast<NotificationUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((NotificationCallbackIF*) _callback)->onNotificationUpdate(proxyShared, payload);
                        proxyShared->_notification = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SetFolder:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetFolderError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFolder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFolderError> payload = ::boost::static_pointer_cast<SetFolderError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFolderCallbackIF*) _callback)->onSetFolderError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetFolderResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetFolder", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetFolderResponse> payload = ::boost::static_pointer_cast<SetFolderResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetFolderCallbackIF*) _callback)->onSetFolderResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListFolders:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListFoldersError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFolders", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFoldersError> payload = ::boost::static_pointer_cast<ListFoldersError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFoldersCallbackIF*) _callback)->onListFoldersError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFoldersResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFolders", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFoldersResponse> payload = ::boost::static_pointer_cast<ListFoldersResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFoldersCallbackIF*) _callback)->onListFoldersResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListFilterFields:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFilterFieldsError> payload = ::boost::static_pointer_cast<ListFilterFieldsError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListFilterFieldsResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListFilterFieldsResponse> payload = ::boost::static_pointer_cast<ListFilterFieldsResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_ListMessages:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ListMessagesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListMessages", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListMessagesError> payload = ::boost::static_pointer_cast<ListMessagesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListMessagesCallbackIF*) _callback)->onListMessagesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ListMessagesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "ListMessages", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ListMessagesResponse> payload = ::boost::static_pointer_cast<ListMessagesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ListMessagesCallbackIF*) _callback)->onListMessagesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_PushMessage:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "PushMessage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PushMessageError> payload = ::boost::static_pointer_cast<PushMessageError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PushMessageCallbackIF*) _callback)->onPushMessageError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PushMessageResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "PushMessage", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PushMessageResponse> payload = ::boost::static_pointer_cast<PushMessageResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((PushMessageCallbackIF*) _callback)->onPushMessageResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UpdateInbox:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UpdateInboxError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateInbox", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateInboxError> payload = ::boost::static_pointer_cast<UpdateInboxError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateInboxCallbackIF*) _callback)->onUpdateInboxError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UpdateInboxResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UpdateInbox", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UpdateInboxResponse> payload = ::boost::static_pointer_cast<UpdateInboxResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UpdateInboxCallbackIF*) _callback)->onUpdateInboxResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_NotificationRegistry:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), NotificationRegistryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "NotificationRegistry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotificationRegistryError> payload = ::boost::static_pointer_cast<NotificationRegistryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((NotificationRegistryCallbackIF*) _callback)->onNotificationRegistryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), NotificationRegistryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "NotificationRegistry", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<NotificationRegistryResponse> payload = ::boost::static_pointer_cast<NotificationRegistryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((NotificationRegistryCallbackIF*) _callback)->onNotificationRegistryResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_NewMessageNotification: {
                ::boost::shared_ptr< NewMessageNotificationError > payload = ::boost::shared_ptr< NewMessageNotificationError >
                (new NewMessageNotificationError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NewMessageNotification", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NewMessageNotificationCallbackIF*) _callback)->onNewMessageNotificationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Notification: {
                ::boost::shared_ptr< NotificationError > payload = ::boost::shared_ptr< NotificationError >
                (new NotificationError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Notification", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NotificationCallbackIF*) _callback)->onNotificationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetFolder: {
                ::boost::shared_ptr< SetFolderError > payload = ::boost::shared_ptr< SetFolderError >
                (new SetFolderError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetFolder", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetFolderCallbackIF*) _callback)->onSetFolderError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListFolders: {
                ::boost::shared_ptr< ListFoldersError > payload = ::boost::shared_ptr< ListFoldersError >
                (new ListFoldersError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListFolders", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListFoldersCallbackIF*) _callback)->onListFoldersError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListFilterFields: {
                ::boost::shared_ptr< ListFilterFieldsError > payload = ::boost::shared_ptr< ListFilterFieldsError >
                (new ListFilterFieldsError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListFilterFields", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListFilterFieldsCallbackIF*) _callback)->onListFilterFieldsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_ListMessages: {
                ::boost::shared_ptr< ListMessagesError > payload = ::boost::shared_ptr< ListMessagesError >
                (new ListMessagesError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "ListMessages", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ListMessagesCallbackIF*) _callback)->onListMessagesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PushMessage: {
                ::boost::shared_ptr< PushMessageError > payload = ::boost::shared_ptr< PushMessageError >
                (new PushMessageError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PushMessage", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PushMessageCallbackIF*) _callback)->onPushMessageError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UpdateInbox: {
                ::boost::shared_ptr< UpdateInboxError > payload = ::boost::shared_ptr< UpdateInboxError >
                (new UpdateInboxError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UpdateInbox", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UpdateInboxCallbackIF*) _callback)->onUpdateInboxError (proxyShared,payload);
                return true;
            }
            break;
            case ID_NotificationRegistry: {
                ::boost::shared_ptr< NotificationRegistryError > payload = ::boost::shared_ptr< NotificationRegistryError >
                (new NotificationRegistryError(DBUS_ERROR_NO_SERVER, "The DBus service MessageAccess is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "NotificationRegistry", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<MessageAccessProxy> proxyShared = ::boost::static_pointer_cast<MessageAccessProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((NotificationRegistryCallbackIF*) _callback)->onNotificationRegistryError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& MessageAccessProxyCallback::_logger (MessageAccessProxy::_logger);

MessageAccessProxy::MessageAccessProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.MessageAccess", serviceAvailable, _logger) {
}

MessageAccessProxy::~MessageAccessProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< MessageAccessProxy > MessageAccessProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<MessageAccessProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< MessageAccessProxy > proxyNew(new MessageAccessProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t MessageAccessProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    MessageAccessProxyCallback* callback = new MessageAccessProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t MessageAccessProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    MessageAccessProxyCallback* callback = new MessageAccessProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void MessageAccessProxy::clearAllProperties ()
{
    _notification = ::asf::core::nullable< NotificationUpdate >();
}

void MessageAccessProxy::sendDeregisterAll () const
{
    sendNotificationDeregisterAll();
    sendNewMessageNotificationDeregisterAll();
}

act_t MessageAccessProxy::sendNewMessageNotificationRegister(NewMessageNotificationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "NewMessageNotification");
    act_t act = addSignalCallback(ID_NewMessageNotification, "NewMessageNotification", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "NewMessageNotification", &cb, act);
    return act;
}

bool MessageAccessProxy::sendNewMessageNotificationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("NewMessageNotification", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NewMessageNotification", act, static_cast<int>(rv));
    return rv;
}

void MessageAccessProxy::sendNewMessageNotificationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "NewMessageNotification");
    _dbusProxyDelegate->deregisterSignalCallback("NewMessageNotification", 0, _dbusDaemonProxy.get(), false);
}

act_t MessageAccessProxy::sendNotificationRegister(NotificationCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Notification, "Notification", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Notification", &cb, act);
    return act;
}

bool MessageAccessProxy::sendNotificationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Notification", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Notification", act, static_cast<int>(rv));
    return rv;
}

act_t MessageAccessProxy::sendNotificationGet(NotificationCallbackIF& cb) {
    MessageAccessProxyCallback* callback = new MessageAccessProxyCallback(ID_Notification, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Notification", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Notification", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& MessageAccessProxy::getNotification() const {
    return _notification.get().getNotification();
}

bool MessageAccessProxy::hasNotification() const {
    return _notification.hasValue();
}

void MessageAccessProxy::sendNotificationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Notification");
    _dbusProxyDelegate->deregisterSignalCallback("Notification", 0, _dbusDaemonProxy.get(), true);
}

act_t MessageAccessProxy::sendSetFolderRequest(SetFolderCallbackIF& cb, const ::std::string& name) const {
    SetFolderRequest* payload = new SetFolderRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    DBUS_MESSAGE_CALL(dbusMessage, "SetFolder", SetFolderRequest, payload, true)
    act_t act = addMethodCallback(ID_SetFolder, dbusMessage.getUniqueSerial(), "SetFolder", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetFolder", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendListFoldersRequest(ListFoldersCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const {
    ListFoldersRequest* payload = new ListFoldersRequest();
    CHECK_ALLOCATION(payload);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "ListFolders", ListFoldersRequest, payload, true)
    act_t act = addMethodCallback(ID_ListFolders, dbusMessage.getUniqueSerial(), "ListFolders", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListFolders", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendListFilterFieldsRequest(ListFilterFieldsCallbackIF& cb) const {
    ListFilterFieldsRequest* payload = new ListFilterFieldsRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "ListFilterFields", ListFilterFieldsRequest, payload, true)
    act_t act = addMethodCallback(ID_ListFilterFields, dbusMessage.getUniqueSerial(), "ListFilterFields", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListFilterFields", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendListMessagesRequest(ListMessagesCallbackIF& cb, const ::std::string& folder, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& filter) const {
    ListMessagesRequest* payload = new ListMessagesRequest();
    CHECK_ALLOCATION(payload);
    payload->setFolder(folder);
    payload->setFilter(filter);
    DBUS_MESSAGE_CALL(dbusMessage, "ListMessages", ListMessagesRequest, payload, true)
    act_t act = addMethodCallback(ID_ListMessages, dbusMessage.getUniqueSerial(), "ListMessages", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "ListMessages", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendPushMessageRequest(PushMessageCallbackIF& cb, const ::std::string& sourcefile, const ::std::string& folder, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const {
    PushMessageRequest* payload = new PushMessageRequest();
    CHECK_ALLOCATION(payload);
    payload->setSourcefile(sourcefile);
    payload->setFolder(folder);
    payload->setArgs(args);
    DBUS_MESSAGE_CALL(dbusMessage, "PushMessage", PushMessageRequest, payload, true)
    act_t act = addMethodCallback(ID_PushMessage, dbusMessage.getUniqueSerial(), "PushMessage", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "PushMessage", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendUpdateInboxRequest(UpdateInboxCallbackIF& cb) const {
    UpdateInboxRequest* payload = new UpdateInboxRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "UpdateInbox", UpdateInboxRequest, payload, true)
    act_t act = addMethodCallback(ID_UpdateInbox, dbusMessage.getUniqueSerial(), "UpdateInbox", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UpdateInbox", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t MessageAccessProxy::sendNotificationRegistryRequest(NotificationRegistryCallbackIF& cb, bool action) const {
    NotificationRegistryRequest* payload = new NotificationRegistryRequest();
    CHECK_ALLOCATION(payload);
    payload->setAction(action);
    DBUS_MESSAGE_CALL(dbusMessage, "NotificationRegistry", NotificationRegistryRequest, payload, true)
    act_t act = addMethodCallback(ID_NotificationRegistry, dbusMessage.getUniqueSerial(), "NotificationRegistry", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "NotificationRegistry", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace MessageAccess
} // namespace obex
} // namespace bluez
} // namespace org
