/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_CLIENTSTUB_H
#define ORG_BLUEZ_OBEX_CLIENTSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Client.h"
#include <string>

namespace org {
namespace bluez {
namespace obex {
namespace Client {

class ClientStubDelegate;

class ClientStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ClientStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ClientStub (const std::string& portName);

    /**
     * Create an instance of the ClientStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ClientStub (const std::string& portName, const std::string& objectPath);

    virtual ~ClientStub();

    // signal 'SessionCreated'

    /**
     * Raise the signal 'SessionCreated' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SessionCreated'</b>:
     *
     * If the meaning of "SessionCreated" isn't clear, then there should be a description here.
     */
    void sendSessionCreatedSignal(const ::std::string& address, const ::std::string& session, uint8 remode_instance, const ::std::string& uUID);

    // signal 'SessionRemoved'

    /**
     * Raise the signal 'SessionRemoved' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'SessionRemoved'</b>:
     *
     * If the meaning of "SessionRemoved" isn't clear, then there should be a description here.
     */
    void sendSessionRemovedSignal(const ::std::string& address, const ::std::string& session, uint8 remode_instance, const ::std::string& uUID);

    // method 'CreateSession'

    /**
     * The method onCreateSession() is called by ASF when a client invokes the
     * method 'CreateSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendCreateSession()
     * or sendCreateSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCreateSessionRequest (const ::boost::shared_ptr< CreateSessionRequest >& request) = 0;

    /**
     * The method sendCreateSessionResponse() sends a response of a previous
     * method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCreateSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCreateSessionResponse (const ::std::string& session, act_t act = 0);

    /**
     * The method sendCreateSessionError() sends an error response of a
     * previous method invocation of 'CreateSession' back to the client.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCreateSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RemoveSession'

    /**
     * The method onRemoveSession() is called by ASF when a client invokes the
     * method 'RemoveSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendRemoveSession()
     * or sendRemoveSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'RemoveSession'</b>:
     *
     * If the meaning of "RemoveSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRemoveSessionRequest (const ::boost::shared_ptr< RemoveSessionRequest >& request) = 0;

    /**
     * The method sendRemoveSessionResponse() sends a response of a previous
     * method invocation of 'RemoveSession' back to the client.
     *
     * <b>Documentation of 'RemoveSession'</b>:
     *
     * If the meaning of "RemoveSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRemoveSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRemoveSessionResponse (act_t act = 0);

    /**
     * The method sendRemoveSessionError() sends an error response of a
     * previous method invocation of 'RemoveSession' back to the client.
     *
     * <b>Documentation of 'RemoveSession'</b>:
     *
     * If the meaning of "RemoveSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRemoveSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoveSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelSession'

    /**
     * The method onCancelSession() is called by ASF when a client invokes the
     * method 'CancelSession'. A subclass has to implement this method and
     * send back a response to the client either with the sendCancelSession()
     * or sendCancelSessionError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CancelSession'</b>:
     *
     * If the meaning of "CancelSession" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelSessionRequest (const ::boost::shared_ptr< CancelSessionRequest >& request) = 0;

    /**
     * The method sendCancelSessionResponse() sends a response of a previous
     * method invocation of 'CancelSession' back to the client.
     *
     * <b>Documentation of 'CancelSession'</b>:
     *
     * If the meaning of "CancelSession" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelSession(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelSessionResponse (act_t act = 0);

    /**
     * The method sendCancelSessionError() sends an error response of a
     * previous method invocation of 'CancelSession' back to the client.
     *
     * <b>Documentation of 'CancelSession'</b>:
     *
     * If the meaning of "CancelSession" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelSession(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelSessionError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class ClientStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Client
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_CLIENTSTUB_H
