/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Client.h"
#include "org/bluez/obex/ClientDBus.h"
#include "org/bluez/obex/ClientJson.h"
#include "org/bluez/obex/ClientStub.h"
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Client {

DEFINE_CLASS_LOGGER("//org/bluez/obex/org/bluez/obex/Client", ClientStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "CancelSession", 2 },
    { 13, "CreateSession", 0 },
    { 13, "RemoveSession", 1 },
};


class ClientStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ClientStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ClientStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ClientStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.obex.Client"),
          _logger(logger) {}

    virtual ~ClientStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ClientStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'CreateSession'

            LOG_DEBUG_STUB("process method '%s'", "CreateSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CreateSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CreateSessionRequest > payload = ::boost::static_pointer_cast<CreateSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ClientStub*>(getStub())->onCreateSessionRequest(payload);
            return;
        }
        case 1: {

            // method 'RemoveSession'

            LOG_DEBUG_STUB("process method '%s'", "RemoveSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RemoveSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveSessionRequest > payload = ::boost::static_pointer_cast<RemoveSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ClientStub*>(getStub())->onRemoveSessionRequest(payload);
            return;
        }
        case 2: {

            // method 'CancelSession'

            LOG_DEBUG_STUB("process method '%s'", "CancelSession");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelSessionRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelSession", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelSessionRequest > payload = ::boost::static_pointer_cast<CancelSessionRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ClientStub*>(getStub())->onCancelSessionRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ClientStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.obex.Client\">\n"
            "      <method name=\"CreateSession\">\n"
            "        <arg direction=\"in\" name=\"destination\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"args\" type=\"a{sv}\"/>\n"
            "        <arg direction=\"out\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RemoveSession\">\n"
            "        <arg direction=\"in\" name=\"session\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"CancelSession\">\n"
            "        <arg direction=\"in\" name=\"destination\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"args\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <signal name=\"SessionCreated\">\n"
            "        <arg name=\"address\" type=\"s\"/>\n"
            "        <arg name=\"session\" type=\"o\"/>\n"
            "        <arg name=\"remode_instance\" type=\"y\"/>\n"
            "        <arg name=\"UUID\" type=\"s\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SessionRemoved\">\n"
            "        <arg name=\"address\" type=\"s\"/>\n"
            "        <arg name=\"session\" type=\"o\"/>\n"
            "        <arg name=\"remode_instance\" type=\"y\"/>\n"
            "        <arg name=\"UUID\" type=\"s\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ClientStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ClientStub*>(getStub()))->onGetAll (properties);
}

void ClientStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ClientStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ClientStub::ClientStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ClientStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ClientStub::ClientStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ClientStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ClientStub::~ClientStub() {
    delete _stubDelegate;
}

void ClientStub::sendSessionCreatedSignal(const ::std::string& address, const ::std::string& session, uint8 remode_instance, const ::std::string& uUID) {
    if (_stubDelegate->isConnected()) {
        SessionCreatedSignal* payload = new SessionCreatedSignal(address, session, remode_instance, uUID);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SessionCreated", SessionCreatedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SessionCreated");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SessionCreated");
    }
}

void ClientStub::sendSessionRemovedSignal(const ::std::string& address, const ::std::string& session, uint8 remode_instance, const ::std::string& uUID) {
    if (_stubDelegate->isConnected()) {
        SessionRemovedSignal* payload = new SessionRemovedSignal(address, session, remode_instance, uUID);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SessionRemoved", SessionRemovedSignal, payload)
        LOG_INFO ("-> send%sSignal", "SessionRemoved");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SessionRemoved");
    }
}

void  ClientStub::sendCreateSessionResponse (const ::std::string& session, act_t act) {
    CreateSessionResponse* payload = new CreateSessionResponse(session);
    DBUS_MESSAGE_REPLY(dbusMessage, "CreateSession", CreateSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ClientStub::sendCreateSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CreateSessionError* payload = new CreateSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CreateSession", CreateSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CreateSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ClientStub::sendRemoveSessionResponse (act_t act) {
    RemoveSessionResponse* payload = new RemoveSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RemoveSession", RemoveSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RemoveSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ClientStub::sendRemoveSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveSessionError* payload = new RemoveSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RemoveSession", RemoveSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RemoveSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ClientStub::sendCancelSessionResponse (act_t act) {
    CancelSessionResponse* payload = new CancelSessionResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelSession", CancelSessionResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ClientStub::sendCancelSessionError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelSessionError* payload = new CancelSessionError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelSession", CancelSessionError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelSession", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ClientStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Client
} // namespace obex
} // namespace bluez
} // namespace org
