/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/obex/Client.h"
#include "org/bluez/obex/ClientDBus.h"
#include "org/bluez/obex/ClientJson.h"
#include "org/bluez/obex/ClientProxy.h"
#include <map>
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace obex {
namespace Client {

DEFINE_CLASS_LOGGER("//org/bluez/obex/org/bluez/obex/Client", ClientProxy);

class ClientProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    ClientProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< ClientProxy >& proxyShared = ::boost::static_pointer_cast< ClientProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SessionCreated:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SessionCreatedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SessionCreated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SessionCreatedSignal> payload = ::boost::static_pointer_cast<SessionCreatedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SessionCreatedCallbackIF*) _callback)->onSessionCreatedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_SessionRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SessionRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SessionRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SessionRemovedSignal> payload = ::boost::static_pointer_cast<SessionRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SessionRemovedCallbackIF*) _callback)->onSessionRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_CreateSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSessionError> payload = ::boost::static_pointer_cast<CreateSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSessionCallbackIF*) _callback)->onCreateSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateSessionResponse> payload = ::boost::static_pointer_cast<CreateSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateSessionCallbackIF*) _callback)->onCreateSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoveSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveSessionError> payload = ::boost::static_pointer_cast<RemoveSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveSessionCallbackIF*) _callback)->onRemoveSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveSessionResponse> payload = ::boost::static_pointer_cast<RemoveSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveSessionCallbackIF*) _callback)->onRemoveSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelSession:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelSessionError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelSessionError> payload = ::boost::static_pointer_cast<CancelSessionError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelSessionCallbackIF*) _callback)->onCancelSessionError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelSessionResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelSession", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelSessionResponse> payload = ::boost::static_pointer_cast<CancelSessionResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelSessionCallbackIF*) _callback)->onCancelSessionResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SessionCreated: {
                ::boost::shared_ptr< SessionCreatedError > payload = ::boost::shared_ptr< SessionCreatedError >
                (new SessionCreatedError(DBUS_ERROR_NO_SERVER, "The DBus service Client is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SessionCreated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ClientProxy> proxyShared = ::boost::static_pointer_cast<ClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SessionCreatedCallbackIF*) _callback)->onSessionCreatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SessionRemoved: {
                ::boost::shared_ptr< SessionRemovedError > payload = ::boost::shared_ptr< SessionRemovedError >
                (new SessionRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Client is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SessionRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ClientProxy> proxyShared = ::boost::static_pointer_cast<ClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SessionRemovedCallbackIF*) _callback)->onSessionRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateSession: {
                ::boost::shared_ptr< CreateSessionError > payload = ::boost::shared_ptr< CreateSessionError >
                (new CreateSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Client is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ClientProxy> proxyShared = ::boost::static_pointer_cast<ClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateSessionCallbackIF*) _callback)->onCreateSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoveSession: {
                ::boost::shared_ptr< RemoveSessionError > payload = ::boost::shared_ptr< RemoveSessionError >
                (new RemoveSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Client is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ClientProxy> proxyShared = ::boost::static_pointer_cast<ClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveSessionCallbackIF*) _callback)->onRemoveSessionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelSession: {
                ::boost::shared_ptr< CancelSessionError > payload = ::boost::shared_ptr< CancelSessionError >
                (new CancelSessionError(DBUS_ERROR_NO_SERVER, "The DBus service Client is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelSession", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<ClientProxy> proxyShared = ::boost::static_pointer_cast<ClientProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelSessionCallbackIF*) _callback)->onCancelSessionError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& ClientProxyCallback::_logger (ClientProxy::_logger);

ClientProxy::ClientProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.obex.Client", serviceAvailable, _logger) {
}

ClientProxy::~ClientProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< ClientProxy > ClientProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<ClientProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< ClientProxy > proxyNew(new ClientProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t ClientProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    ClientProxyCallback* callback = new ClientProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t ClientProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    ClientProxyCallback* callback = new ClientProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void ClientProxy::sendDeregisterAll () const
{
    sendSessionCreatedDeregisterAll();
    sendSessionRemovedDeregisterAll();
}

act_t ClientProxy::sendSessionCreatedRegister(SessionCreatedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SessionCreated");
    act_t act = addSignalCallback(ID_SessionCreated, "SessionCreated", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SessionCreated", &cb, act);
    return act;
}

bool ClientProxy::sendSessionCreatedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SessionCreated", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SessionCreated", act, static_cast<int>(rv));
    return rv;
}

void ClientProxy::sendSessionCreatedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SessionCreated");
    _dbusProxyDelegate->deregisterSignalCallback("SessionCreated", 0, _dbusDaemonProxy.get(), false);
}

act_t ClientProxy::sendSessionRemovedRegister(SessionRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SessionRemoved");
    act_t act = addSignalCallback(ID_SessionRemoved, "SessionRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SessionRemoved", &cb, act);
    return act;
}

bool ClientProxy::sendSessionRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SessionRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SessionRemoved", act, static_cast<int>(rv));
    return rv;
}

void ClientProxy::sendSessionRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SessionRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("SessionRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t ClientProxy::sendCreateSessionRequest(CreateSessionCallbackIF& cb, const ::std::string& destination, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const {
    CreateSessionRequest* payload = new CreateSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setDestination(destination);
    payload->setArgs(args);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateSession", CreateSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateSession, dbusMessage.getUniqueSerial(), "CreateSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ClientProxy::sendRemoveSessionRequest(RemoveSessionCallbackIF& cb, const ::std::string& session) const {
    RemoveSessionRequest* payload = new RemoveSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setSession(session);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoveSession", RemoveSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoveSession, dbusMessage.getUniqueSerial(), "RemoveSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t ClientProxy::sendCancelSessionRequest(CancelSessionCallbackIF& cb, const ::std::string& destination, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args) const {
    CancelSessionRequest* payload = new CancelSessionRequest();
    CHECK_ALLOCATION(payload);
    payload->setDestination(destination);
    payload->setArgs(args);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelSession", CancelSessionRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelSession, dbusMessage.getUniqueSerial(), "CancelSession", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelSession", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Client
} // namespace obex
} // namespace bluez
} // namespace org
