#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_OBEX_CLIENT_H
#define ORG_BLUEZ_OBEX_CLIENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include "asf/dbus/DBusVariant.h"
#include <cstddef>
#include <cstring>
#include <map>
#include <string>

/**
 * If the meaning of "Client" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace obex {
namespace Client {

// method IDs
static const uint16 ID_CreateSession = 0;
static const uint16 ID_RemoveSession = 1;
static const uint16 ID_CancelSession = 2;

// signal IDs
static const uint16 ID_SessionCreated = 3;
static const uint16 ID_SessionRemoved = 4;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class CreateSessionRequest;

class CreateSessionResponse;

class RemoveSessionRequest;

class CancelSessionRequest;

class SessionCreatedSignal;

class SessionRemovedSignal;

// type definitions
/**
 * If the meaning of "CreateSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CreateSessionError;

/**
 * If the meaning of "RemoveSessionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RemoveSessionResponse;

/**
 * If the meaning of "RemoveSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoveSessionError;

/**
 * If the meaning of "CancelSessionResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelSessionResponse;

/**
 * If the meaning of "CancelSessionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelSessionError;

/**
 * If the meaning of "SessionCreatedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SessionCreatedError;

/**
 * If the meaning of "SessionRemovedError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError SessionRemovedError;


/**
 * If the meaning of "CreateSessionRequest" isn't clear, then there should be a description here.
 */
class CreateSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionRequest ();

    /**
     * Copy constructor
     */
    inline  CreateSessionRequest (const CreateSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionRequest (const ::std::string& destination_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionRequest();

    /**
     * Assignment operator
     */
    inline CreateSessionRequest& operator = (const CreateSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destination"

    static const int kDestination = 0;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const ::std::string& destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    // API of field "args"

    static const int kArgs = 1;

    /**
     * Clears the field "args".
     *
     * The field will be set to its default value. The hasArgs()
     * method will return false.
     */
    inline void clearArgs();

    /**
     * Checks whether the field "args" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArgs()). Otherwise it will return false.
     */
    inline bool hasArgs () const;

    /**
     * Returns the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return The value of the field "args"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgs () const;

    /**
     * Retrieves the value of the field "args" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "args".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgsMutable ();

    /**
     * Sets the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @param args The value which will be set
     */
    inline void setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    static const CreateSessionRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    inline void set_has_args ();

    inline void clear_has_args ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _destination;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _args;

};

/**
 * If the meaning of "CreateSessionResponse" isn't clear, then there should be a description here.
 */
class CreateSessionResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CreateSessionResponse ();

    /**
     * Copy constructor
     */
    inline  CreateSessionResponse (const CreateSessionResponse &rhs);

    /**
     * All fields constructor
     */
    inline  CreateSessionResponse (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~CreateSessionResponse();

    /**
     * Assignment operator
     */
    inline CreateSessionResponse& operator = (const CreateSessionResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CreateSessionResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CreateSessionResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CreateSessionResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CreateSessionResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const CreateSessionResponse &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "RemoveSessionRequest" isn't clear, then there should be a description here.
 */
class RemoveSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoveSessionRequest ();

    /**
     * Copy constructor
     */
    inline  RemoveSessionRequest (const RemoveSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RemoveSessionRequest (const ::std::string& session_);

    /**
     * Destructor
     */
    inline virtual  ~RemoveSessionRequest();

    /**
     * Assignment operator
     */
    inline RemoveSessionRequest& operator = (const RemoveSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoveSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoveSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoveSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoveSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "session"

    static const int kSession = 0;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    static const RemoveSessionRequest &getDefaultInstance();

private:

    inline void set_has_session ();

    inline void clear_has_session ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _session;

};

/**
 * If the meaning of "CancelSessionRequest" isn't clear, then there should be a description here.
 */
class CancelSessionRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelSessionRequest ();

    /**
     * Copy constructor
     */
    inline  CancelSessionRequest (const CancelSessionRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CancelSessionRequest (const ::std::string& destination_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    /**
     * Destructor
     */
    inline virtual  ~CancelSessionRequest();

    /**
     * Assignment operator
     */
    inline CancelSessionRequest& operator = (const CancelSessionRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelSessionRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelSessionRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelSessionRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelSessionRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "destination"

    static const int kDestination = 0;

    /**
     * Clears the field "destination".
     *
     * The field will be set to its default value. The hasDestination()
     * method will return false.
     */
    inline void clearDestination();

    /**
     * Checks whether the field "destination" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDestination()). Otherwise it will return false.
     */
    inline bool hasDestination () const;

    /**
     * Returns the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @return The value of the field "destination"
     */
    inline const ::std::string& getDestination () const;

    /**
     * Retrieves the value of the field "destination" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "destination".
     */
    inline ::std::string& getDestinationMutable ();

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const ::std::string& destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* destination_);

    /**
     * Sets the value of the member "destination".
     *
     * If the meaning of "destination" isn't clear, then there should be a description here.
     *
     * @param destination The value which will be set
     */
    inline void setDestination (const char* value, size_t size);

    // API of field "args"

    static const int kArgs = 1;

    /**
     * Clears the field "args".
     *
     * The field will be set to its default value. The hasArgs()
     * method will return false.
     */
    inline void clearArgs();

    /**
     * Checks whether the field "args" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setArgs()). Otherwise it will return false.
     */
    inline bool hasArgs () const;

    /**
     * Returns the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @return The value of the field "args"
     */
    inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgs () const;

    /**
     * Retrieves the value of the field "args" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "args".
     */
    inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getArgsMutable ();

    /**
     * Sets the value of the member "args".
     *
     * If the meaning of "args" isn't clear, then there should be a description here.
     *
     * @param args The value which will be set
     */
    inline void setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_);

    static const CancelSessionRequest &getDefaultInstance();

private:

    static const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& getStringTo__asf__dbus__DBusVariantMap_DefaultInstance ();

    inline void set_has_destination ();

    inline void clear_has_destination ();

    inline void set_has_args ();

    inline void clear_has_args ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _destination;

    ::std::map< ::std::string, ::asf::dbus::DBusVariant > _args;

};

/**
 * If the meaning of "SessionCreatedSignal" isn't clear, then there should be a description here.
 */
class SessionCreatedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionCreatedSignal ();

    /**
     * Copy constructor
     */
    inline  SessionCreatedSignal (const SessionCreatedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SessionCreatedSignal (const ::std::string& address_, const ::std::string& session_, uint8 remode_instance_, const ::std::string& UUID_);

    /**
     * Destructor
     */
    inline virtual  ~SessionCreatedSignal();

    /**
     * Assignment operator
     */
    inline SessionCreatedSignal& operator = (const SessionCreatedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionCreatedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionCreatedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionCreatedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionCreatedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "session"

    static const int kSession = 1;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    // API of field "remode_instance"

    static const int kRemode_instance = 2;

    /**
     * Clears the field "remode_instance".
     *
     * The field will be set to its default value. The hasRemode_instance()
     * method will return false.
     */
    inline void clearRemode_instance();

    /**
     * Checks whether the field "remode_instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemode_instance()). Otherwise it will return false.
     */
    inline bool hasRemode_instance () const;

    /**
     * Returns the value of the member "remode_instance".
     *
     * If the meaning of "remode_instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "remode_instance"
     */
    inline uint8 getRemode_instance () const;

    /**
     * Sets the value of the member "remode_instance".
     *
     * If the meaning of "remode_instance" isn't clear, then there should be a description here.
     *
     * @param remode_instance The value which will be set
     */
    inline void setRemode_instance (uint8 remode_instance_);

    // API of field "UUID"

    static const int kUUID = 3;

    /**
     * Clears the field "UUID".
     *
     * The field will be set to its default value. The hasUUID()
     * method will return false.
     */
    inline void clearUUID();

    /**
     * Checks whether the field "UUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUUID()). Otherwise it will return false.
     */
    inline bool hasUUID () const;

    /**
     * Returns the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UUID"
     */
    inline const ::std::string& getUUID () const;

    /**
     * Retrieves the value of the field "UUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UUID".
     */
    inline ::std::string& getUUIDMutable ();

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const ::std::string& UUID_);

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const char* UUID_);

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const char* value, size_t size);

    static const SessionCreatedSignal &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_session ();

    inline void clear_has_session ();

    inline void set_has_remode_instance ();

    inline void clear_has_remode_instance ();

    inline void set_has_UUID ();

    inline void clear_has_UUID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _address;

    ::std::string _session;

    uint8 _remode_instance;

    ::std::string _UUID;

};

/**
 * If the meaning of "SessionRemovedSignal" isn't clear, then there should be a description here.
 */
class SessionRemovedSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  SessionRemovedSignal ();

    /**
     * Copy constructor
     */
    inline  SessionRemovedSignal (const SessionRemovedSignal &rhs);

    /**
     * All fields constructor
     */
    inline  SessionRemovedSignal (const ::std::string& address_, const ::std::string& session_, uint8 remode_instance_, const ::std::string& UUID_);

    /**
     * Destructor
     */
    inline virtual  ~SessionRemovedSignal();

    /**
     * Assignment operator
     */
    inline SessionRemovedSignal& operator = (const SessionRemovedSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const SessionRemovedSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const SessionRemovedSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const SessionRemovedSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const SessionRemovedSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "address"

    static const int kAddress = 0;

    /**
     * Clears the field "address".
     *
     * The field will be set to its default value. The hasAddress()
     * method will return false.
     */
    inline void clearAddress();

    /**
     * Checks whether the field "address" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAddress()). Otherwise it will return false.
     */
    inline bool hasAddress () const;

    /**
     * Returns the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @return The value of the field "address"
     */
    inline const ::std::string& getAddress () const;

    /**
     * Retrieves the value of the field "address" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "address".
     */
    inline ::std::string& getAddressMutable ();

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const ::std::string& address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* address_);

    /**
     * Sets the value of the member "address".
     *
     * If the meaning of "address" isn't clear, then there should be a description here.
     *
     * @param address The value which will be set
     */
    inline void setAddress (const char* value, size_t size);

    // API of field "session"

    static const int kSession = 1;

    /**
     * Clears the field "session".
     *
     * The field will be set to its default value. The hasSession()
     * method will return false.
     */
    inline void clearSession();

    /**
     * Checks whether the field "session" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setSession()). Otherwise it will return false.
     */
    inline bool hasSession () const;

    /**
     * Returns the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return The value of the field "session"
     */
    inline const ::std::string& getSession () const;

    /**
     * Retrieves the value of the field "session" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "session".
     */
    inline ::std::string& getSessionMutable ();

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const ::std::string& session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* session_);

    /**
     * Sets the value of the member "session".
     *
     * If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @param session The value which will be set
     */
    inline void setSession (const char* value, size_t size);

    // API of field "remode_instance"

    static const int kRemode_instance = 2;

    /**
     * Clears the field "remode_instance".
     *
     * The field will be set to its default value. The hasRemode_instance()
     * method will return false.
     */
    inline void clearRemode_instance();

    /**
     * Checks whether the field "remode_instance" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemode_instance()). Otherwise it will return false.
     */
    inline bool hasRemode_instance () const;

    /**
     * Returns the value of the member "remode_instance".
     *
     * If the meaning of "remode_instance" isn't clear, then there should be a description here.
     *
     * @return The value of the field "remode_instance"
     */
    inline uint8 getRemode_instance () const;

    /**
     * Sets the value of the member "remode_instance".
     *
     * If the meaning of "remode_instance" isn't clear, then there should be a description here.
     *
     * @param remode_instance The value which will be set
     */
    inline void setRemode_instance (uint8 remode_instance_);

    // API of field "UUID"

    static const int kUUID = 3;

    /**
     * Clears the field "UUID".
     *
     * The field will be set to its default value. The hasUUID()
     * method will return false.
     */
    inline void clearUUID();

    /**
     * Checks whether the field "UUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUUID()). Otherwise it will return false.
     */
    inline bool hasUUID () const;

    /**
     * Returns the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "UUID"
     */
    inline const ::std::string& getUUID () const;

    /**
     * Retrieves the value of the field "UUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "UUID".
     */
    inline ::std::string& getUUIDMutable ();

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const ::std::string& UUID_);

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const char* UUID_);

    /**
     * Sets the value of the member "UUID".
     *
     * If the meaning of "UUID" isn't clear, then there should be a description here.
     *
     * @param UUID The value which will be set
     */
    inline void setUUID (const char* value, size_t size);

    static const SessionRemovedSignal &getDefaultInstance();

private:

    inline void set_has_address ();

    inline void clear_has_address ();

    inline void set_has_session ();

    inline void clear_has_session ();

    inline void set_has_remode_instance ();

    inline void clear_has_remode_instance ();

    inline void set_has_UUID ();

    inline void clear_has_UUID ();

    uint32 _has_bits_[ (4 + 31) / 32];

    ::std::string _address;

    ::std::string _session;

    uint8 _remode_instance;

    ::std::string _UUID;

};

inline  CreateSessionRequest::CreateSessionRequest ()  :
    _destination (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionRequest::CreateSessionRequest (const CreateSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _destination (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionRequest::CreateSessionRequest (const ::std::string& destination_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_)  :
    _destination (destination_),
    _args (args_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionRequest::~CreateSessionRequest() {
}

inline CreateSessionRequest& CreateSessionRequest::operator = (const CreateSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
        if (rhs.hasArgs()) {
            setArgs(rhs.getArgs());
        } else {
            clearArgs();
        }
    }
    return *this;
}

inline bool CreateSessionRequest::operator == (const CreateSessionRequest& rhs) const {
    return (((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()) &&
        ((!hasArgs() && !rhs.hasArgs()) || getArgs() == rhs.getArgs()));
}

inline bool CreateSessionRequest::operator != (const CreateSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionRequest::operator < (const CreateSessionRequest& rhs) const {
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    if (hasArgs() || rhs.hasArgs()) {
        if (getArgs() < rhs.getArgs()) return true;
        if (getArgs() > rhs.getArgs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionRequest::clone() {
    return new CreateSessionRequest(*this);
}

inline bool CreateSessionRequest::operator > (const CreateSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionRequest::clear() {
    clearDestination();
    clearArgs();
}

inline void CreateSessionRequest::clearDestination() {
    if (hasDestination()) {
         clear_has_destination();
        _destination.clear();
     }
}

inline bool CreateSessionRequest::hasDestination () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateSessionRequest::getDestination () const {
    return _destination;
}

inline ::std::string& CreateSessionRequest::getDestinationMutable () {
    set_has_destination();
    return _destination;
}

inline void CreateSessionRequest::setDestination (const ::std::string& destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination = destination_;
}

inline void CreateSessionRequest::setDestination (const char* destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(destination_);
}

inline void CreateSessionRequest::setDestination (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(value, size);
}

inline void CreateSessionRequest::clearArgs() {
    if (hasArgs()) {
         clear_has_args();
        _args.clear();
     }
}

inline bool CreateSessionRequest::hasArgs () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getArgs () const {
    return _args;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CreateSessionRequest::getArgsMutable () {
    set_has_args();
    return _args;
}

inline void CreateSessionRequest::setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_) {
    set_has_args();
    this->_args = args_;
}

inline void CreateSessionRequest::set_has_destination () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionRequest::clear_has_destination () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CreateSessionRequest::set_has_args () {
    _has_bits_[0] |= 1u << 1;
}

inline void CreateSessionRequest::clear_has_args () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CreateSessionResponse::CreateSessionResponse ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CreateSessionResponse::CreateSessionResponse (const CreateSessionResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CreateSessionResponse::CreateSessionResponse (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CreateSessionResponse::~CreateSessionResponse() {
}

inline CreateSessionResponse& CreateSessionResponse::operator = (const CreateSessionResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool CreateSessionResponse::operator == (const CreateSessionResponse& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool CreateSessionResponse::operator != (const CreateSessionResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool CreateSessionResponse::operator < (const CreateSessionResponse& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CreateSessionResponse::clone() {
    return new CreateSessionResponse(*this);
}

inline bool CreateSessionResponse::operator > (const CreateSessionResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CreateSessionResponse::clear() {
    clearSession();
}

inline void CreateSessionResponse::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool CreateSessionResponse::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CreateSessionResponse::getSession () const {
    return _session;
}

inline ::std::string& CreateSessionResponse::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void CreateSessionResponse::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void CreateSessionResponse::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void CreateSessionResponse::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void CreateSessionResponse::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void CreateSessionResponse::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoveSessionRequest::RemoveSessionRequest ()  :
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoveSessionRequest::RemoveSessionRequest (const RemoveSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _session ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoveSessionRequest::RemoveSessionRequest (const ::std::string& session_)  :
    _session (session_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoveSessionRequest::~RemoveSessionRequest() {
}

inline RemoveSessionRequest& RemoveSessionRequest::operator = (const RemoveSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
    }
    return *this;
}

inline bool RemoveSessionRequest::operator == (const RemoveSessionRequest& rhs) const {
    return (((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()));
}

inline bool RemoveSessionRequest::operator != (const RemoveSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoveSessionRequest::operator < (const RemoveSessionRequest& rhs) const {
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoveSessionRequest::clone() {
    return new RemoveSessionRequest(*this);
}

inline bool RemoveSessionRequest::operator > (const RemoveSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoveSessionRequest::clear() {
    clearSession();
}

inline void RemoveSessionRequest::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool RemoveSessionRequest::hasSession () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoveSessionRequest::getSession () const {
    return _session;
}

inline ::std::string& RemoveSessionRequest::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void RemoveSessionRequest::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void RemoveSessionRequest::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void RemoveSessionRequest::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void RemoveSessionRequest::set_has_session () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoveSessionRequest::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  CancelSessionRequest::CancelSessionRequest ()  :
    _destination (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CancelSessionRequest::CancelSessionRequest (const CancelSessionRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _destination (),
    _args ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CancelSessionRequest::CancelSessionRequest (const ::std::string& destination_, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_)  :
    _destination (destination_),
    _args (args_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CancelSessionRequest::~CancelSessionRequest() {
}

inline CancelSessionRequest& CancelSessionRequest::operator = (const CancelSessionRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDestination()) {
            setDestination(rhs.getDestination());
        } else {
            clearDestination();
        }
        if (rhs.hasArgs()) {
            setArgs(rhs.getArgs());
        } else {
            clearArgs();
        }
    }
    return *this;
}

inline bool CancelSessionRequest::operator == (const CancelSessionRequest& rhs) const {
    return (((!hasDestination() && !rhs.hasDestination()) || getDestination() == rhs.getDestination()) &&
        ((!hasArgs() && !rhs.hasArgs()) || getArgs() == rhs.getArgs()));
}

inline bool CancelSessionRequest::operator != (const CancelSessionRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CancelSessionRequest::operator < (const CancelSessionRequest& rhs) const {
    if (hasDestination() || rhs.hasDestination()) {
        if (getDestination() < rhs.getDestination()) return true;
        if (getDestination() > rhs.getDestination()) return false;
    }
    if (hasArgs() || rhs.hasArgs()) {
        if (getArgs() < rhs.getArgs()) return true;
        if (getArgs() > rhs.getArgs()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CancelSessionRequest::clone() {
    return new CancelSessionRequest(*this);
}

inline bool CancelSessionRequest::operator > (const CancelSessionRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CancelSessionRequest::clear() {
    clearDestination();
    clearArgs();
}

inline void CancelSessionRequest::clearDestination() {
    if (hasDestination()) {
         clear_has_destination();
        _destination.clear();
     }
}

inline bool CancelSessionRequest::hasDestination () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CancelSessionRequest::getDestination () const {
    return _destination;
}

inline ::std::string& CancelSessionRequest::getDestinationMutable () {
    set_has_destination();
    return _destination;
}

inline void CancelSessionRequest::setDestination (const ::std::string& destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination = destination_;
}

inline void CancelSessionRequest::setDestination (const char* destination_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (destination_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(destination_);
}

inline void CancelSessionRequest::setDestination (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_destination();
    this->_destination.assign(value, size);
}

inline void CancelSessionRequest::clearArgs() {
    if (hasArgs()) {
         clear_has_args();
        _args.clear();
     }
}

inline bool CancelSessionRequest::hasArgs () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CancelSessionRequest::getArgs () const {
    return _args;
}

inline ::std::map< ::std::string, ::asf::dbus::DBusVariant >& CancelSessionRequest::getArgsMutable () {
    set_has_args();
    return _args;
}

inline void CancelSessionRequest::setArgs (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& args_) {
    set_has_args();
    this->_args = args_;
}

inline void CancelSessionRequest::set_has_destination () {
    _has_bits_[0] |= 1u << 0;
}

inline void CancelSessionRequest::clear_has_destination () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void CancelSessionRequest::set_has_args () {
    _has_bits_[0] |= 1u << 1;
}

inline void CancelSessionRequest::clear_has_args () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  SessionCreatedSignal::SessionCreatedSignal ()  :
    _address (),
    _session (),
    _remode_instance (0u),
    _UUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionCreatedSignal::SessionCreatedSignal (const SessionCreatedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _address (),
    _session (),
    _remode_instance (0u),
    _UUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionCreatedSignal::SessionCreatedSignal (const ::std::string& address_, const ::std::string& session_, uint8 remode_instance_, const ::std::string& UUID_)  :
    _address (address_),
    _session (session_),
    _remode_instance (remode_instance_),
    _UUID (UUID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionCreatedSignal::~SessionCreatedSignal() {
}

inline SessionCreatedSignal& SessionCreatedSignal::operator = (const SessionCreatedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
        if (rhs.hasRemode_instance()) {
            setRemode_instance(rhs.getRemode_instance());
        } else {
            clearRemode_instance();
        }
        if (rhs.hasUUID()) {
            setUUID(rhs.getUUID());
        } else {
            clearUUID();
        }
    }
    return *this;
}

inline bool SessionCreatedSignal::operator == (const SessionCreatedSignal& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()) &&
        ((!hasRemode_instance() && !rhs.hasRemode_instance()) || getRemode_instance() == rhs.getRemode_instance()) &&
        ((!hasUUID() && !rhs.hasUUID()) || getUUID() == rhs.getUUID()));
}

inline bool SessionCreatedSignal::operator != (const SessionCreatedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionCreatedSignal::operator < (const SessionCreatedSignal& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    if (hasRemode_instance() || rhs.hasRemode_instance()) {
        if (getRemode_instance() < rhs.getRemode_instance()) return true;
        if (getRemode_instance() > rhs.getRemode_instance()) return false;
    }
    if (hasUUID() || rhs.hasUUID()) {
        if (getUUID() < rhs.getUUID()) return true;
        if (getUUID() > rhs.getUUID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionCreatedSignal::clone() {
    return new SessionCreatedSignal(*this);
}

inline bool SessionCreatedSignal::operator > (const SessionCreatedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionCreatedSignal::clear() {
    clearAddress();
    clearSession();
    clearRemode_instance();
    clearUUID();
}

inline void SessionCreatedSignal::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool SessionCreatedSignal::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionCreatedSignal::getAddress () const {
    return _address;
}

inline ::std::string& SessionCreatedSignal::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void SessionCreatedSignal::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void SessionCreatedSignal::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void SessionCreatedSignal::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void SessionCreatedSignal::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool SessionCreatedSignal::hasSession () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SessionCreatedSignal::getSession () const {
    return _session;
}

inline ::std::string& SessionCreatedSignal::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void SessionCreatedSignal::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void SessionCreatedSignal::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void SessionCreatedSignal::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void SessionCreatedSignal::clearRemode_instance() {
    if (hasRemode_instance()) {
         clear_has_remode_instance();
        _remode_instance = 0u;
     }
}

inline bool SessionCreatedSignal::hasRemode_instance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 SessionCreatedSignal::getRemode_instance () const {
    return _remode_instance;
}

inline void SessionCreatedSignal::setRemode_instance (uint8 remode_instance_) {
    set_has_remode_instance();
    this->_remode_instance = remode_instance_;
}

inline void SessionCreatedSignal::clearUUID() {
    if (hasUUID()) {
         clear_has_UUID();
        _UUID.clear();
     }
}

inline bool SessionCreatedSignal::hasUUID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SessionCreatedSignal::getUUID () const {
    return _UUID;
}

inline ::std::string& SessionCreatedSignal::getUUIDMutable () {
    set_has_UUID();
    return _UUID;
}

inline void SessionCreatedSignal::setUUID (const ::std::string& UUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID = UUID_;
}

inline void SessionCreatedSignal::setUUID (const char* UUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID.assign(UUID_);
}

inline void SessionCreatedSignal::setUUID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID.assign(value, size);
}

inline void SessionCreatedSignal::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionCreatedSignal::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SessionCreatedSignal::set_has_session () {
    _has_bits_[0] |= 1u << 1;
}

inline void SessionCreatedSignal::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SessionCreatedSignal::set_has_remode_instance () {
    _has_bits_[0] |= 1u << 2;
}

inline void SessionCreatedSignal::clear_has_remode_instance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SessionCreatedSignal::set_has_UUID () {
    _has_bits_[0] |= 1u << 3;
}

inline void SessionCreatedSignal::clear_has_UUID () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline  SessionRemovedSignal::SessionRemovedSignal ()  :
    _address (),
    _session (),
    _remode_instance (0u),
    _UUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  SessionRemovedSignal::SessionRemovedSignal (const SessionRemovedSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _address (),
    _session (),
    _remode_instance (0u),
    _UUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  SessionRemovedSignal::SessionRemovedSignal (const ::std::string& address_, const ::std::string& session_, uint8 remode_instance_, const ::std::string& UUID_)  :
    _address (address_),
    _session (session_),
    _remode_instance (remode_instance_),
    _UUID (UUID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  SessionRemovedSignal::~SessionRemovedSignal() {
}

inline SessionRemovedSignal& SessionRemovedSignal::operator = (const SessionRemovedSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAddress()) {
            setAddress(rhs.getAddress());
        } else {
            clearAddress();
        }
        if (rhs.hasSession()) {
            setSession(rhs.getSession());
        } else {
            clearSession();
        }
        if (rhs.hasRemode_instance()) {
            setRemode_instance(rhs.getRemode_instance());
        } else {
            clearRemode_instance();
        }
        if (rhs.hasUUID()) {
            setUUID(rhs.getUUID());
        } else {
            clearUUID();
        }
    }
    return *this;
}

inline bool SessionRemovedSignal::operator == (const SessionRemovedSignal& rhs) const {
    return (((!hasAddress() && !rhs.hasAddress()) || getAddress() == rhs.getAddress()) &&
        ((!hasSession() && !rhs.hasSession()) || getSession() == rhs.getSession()) &&
        ((!hasRemode_instance() && !rhs.hasRemode_instance()) || getRemode_instance() == rhs.getRemode_instance()) &&
        ((!hasUUID() && !rhs.hasUUID()) || getUUID() == rhs.getUUID()));
}

inline bool SessionRemovedSignal::operator != (const SessionRemovedSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool SessionRemovedSignal::operator < (const SessionRemovedSignal& rhs) const {
    if (hasAddress() || rhs.hasAddress()) {
        if (getAddress() < rhs.getAddress()) return true;
        if (getAddress() > rhs.getAddress()) return false;
    }
    if (hasSession() || rhs.hasSession()) {
        if (getSession() < rhs.getSession()) return true;
        if (getSession() > rhs.getSession()) return false;
    }
    if (hasRemode_instance() || rhs.hasRemode_instance()) {
        if (getRemode_instance() < rhs.getRemode_instance()) return true;
        if (getRemode_instance() > rhs.getRemode_instance()) return false;
    }
    if (hasUUID() || rhs.hasUUID()) {
        if (getUUID() < rhs.getUUID()) return true;
        if (getUUID() > rhs.getUUID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* SessionRemovedSignal::clone() {
    return new SessionRemovedSignal(*this);
}

inline bool SessionRemovedSignal::operator > (const SessionRemovedSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void SessionRemovedSignal::clear() {
    clearAddress();
    clearSession();
    clearRemode_instance();
    clearUUID();
}

inline void SessionRemovedSignal::clearAddress() {
    if (hasAddress()) {
         clear_has_address();
        _address.clear();
     }
}

inline bool SessionRemovedSignal::hasAddress () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& SessionRemovedSignal::getAddress () const {
    return _address;
}

inline ::std::string& SessionRemovedSignal::getAddressMutable () {
    set_has_address();
    return _address;
}

inline void SessionRemovedSignal::setAddress (const ::std::string& address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address = address_;
}

inline void SessionRemovedSignal::setAddress (const char* address_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (address_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(address_);
}

inline void SessionRemovedSignal::setAddress (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_address();
    this->_address.assign(value, size);
}

inline void SessionRemovedSignal::clearSession() {
    if (hasSession()) {
         clear_has_session();
        _session.clear();
     }
}

inline bool SessionRemovedSignal::hasSession () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& SessionRemovedSignal::getSession () const {
    return _session;
}

inline ::std::string& SessionRemovedSignal::getSessionMutable () {
    set_has_session();
    return _session;
}

inline void SessionRemovedSignal::setSession (const ::std::string& session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session = session_;
}

inline void SessionRemovedSignal::setSession (const char* session_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (session_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(session_);
}

inline void SessionRemovedSignal::setSession (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_session();
    this->_session.assign(value, size);
}

inline void SessionRemovedSignal::clearRemode_instance() {
    if (hasRemode_instance()) {
         clear_has_remode_instance();
        _remode_instance = 0u;
     }
}

inline bool SessionRemovedSignal::hasRemode_instance () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 SessionRemovedSignal::getRemode_instance () const {
    return _remode_instance;
}

inline void SessionRemovedSignal::setRemode_instance (uint8 remode_instance_) {
    set_has_remode_instance();
    this->_remode_instance = remode_instance_;
}

inline void SessionRemovedSignal::clearUUID() {
    if (hasUUID()) {
         clear_has_UUID();
        _UUID.clear();
     }
}

inline bool SessionRemovedSignal::hasUUID () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& SessionRemovedSignal::getUUID () const {
    return _UUID;
}

inline ::std::string& SessionRemovedSignal::getUUIDMutable () {
    set_has_UUID();
    return _UUID;
}

inline void SessionRemovedSignal::setUUID (const ::std::string& UUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID = UUID_;
}

inline void SessionRemovedSignal::setUUID (const char* UUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (UUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID.assign(UUID_);
}

inline void SessionRemovedSignal::setUUID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_UUID();
    this->_UUID.assign(value, size);
}

inline void SessionRemovedSignal::set_has_address () {
    _has_bits_[0] |= 1u << 0;
}

inline void SessionRemovedSignal::clear_has_address () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void SessionRemovedSignal::set_has_session () {
    _has_bits_[0] |= 1u << 1;
}

inline void SessionRemovedSignal::clear_has_session () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void SessionRemovedSignal::set_has_remode_instance () {
    _has_bits_[0] |= 1u << 2;
}

inline void SessionRemovedSignal::clear_has_remode_instance () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void SessionRemovedSignal::set_has_UUID () {
    _has_bits_[0] |= 1u << 3;
}

inline void SessionRemovedSignal::clear_has_UUID () {
    _has_bits_[0] &= ~ (1u << 3);
}

} // namespace Client
} // namespace obex
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_OBEX_CLIENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
