/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERVICESTUB_H
#define ORG_BLUEZ_SERVICESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Service.h"
#include <string>

namespace org {
namespace bluez {
namespace Service {

class ServiceStubDelegate;

class ServiceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the ServiceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    ServiceStub (const std::string& portName);

    /**
     * Create an instance of the ServiceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    ServiceStub (const std::string& portName, const std::string& objectPath);

    virtual ~ServiceStub();

    // property 'RemoteUUID'

    /**
     * The method onRemoteUUIDGet() is called by ASF when a client invokes the
     * read method for the property 'RemoteUUID'. The onRemoteUUIDGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     */
    virtual void onRemoteUUIDGet(const ::boost::shared_ptr< RemoteUUIDGet >& payload);

    /**
     * Sends back the update to a previous onRemoteUUIDGet().
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onRemoteUUIDGet(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRemoteUUIDGetUpdate(const ::std::string& remoteUUID, act_t act = 0);

    /**
     * Set the value of the property 'RemoteUUID' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     */
    void setRemoteUUID(const ::std::string& remoteUUID);

    /**
     * Returns the current value of the property 'RemoteUUID'.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     */
    const ::std::string& getRemoteUUID() const;

    /**
     * Returns the current value of the property 'RemoteUUID' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendRemoteUUIDUpdate() method.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     */
    ::std::string& getRemoteUUIDMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendRemoteUUIDUpdate().
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     */
    void sendRemoteUUIDUpdate();

    // property 'State'

    /**
     * The method onStateGet() is called by ASF when a client invokes the read
     * method for the property 'State'. The onStateGet() method returns by
     * default the current property value to the caller. In case this default
     * behavior doesn't match your needs feel free to override this method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    virtual void onStateGet(const ::boost::shared_ptr< StateGet >& payload);

    /**
     * Sends back the update to a previous onStateGet().
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onStateGet(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendStateGetUpdate(const ::std::string& state, act_t act = 0);

    /**
     * Set the value of the property 'State' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    void setState(const ::std::string& state);

    /**
     * Returns the current value of the property 'State'.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    const ::std::string& getState() const;

    /**
     * Returns the current value of the property 'State' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendStateUpdate() method.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    ::std::string& getStateMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendStateUpdate().
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     */
    void sendStateUpdate();

    // property 'Device'

    /**
     * The method onDeviceGet() is called by ASF when a client invokes the
     * read method for the property 'Device'. The onDeviceGet() method returns
     * by default the current property value to the caller. In case this
     * default behavior doesn't match your needs feel free to override this
     * method.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     */
    virtual void onDeviceGet(const ::boost::shared_ptr< DeviceGet >& payload);

    /**
     * Sends back the update to a previous onDeviceGet().
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDeviceGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDeviceGetUpdate(const ::std::string& device, act_t act = 0);

    /**
     * Set the value of the property 'Device' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     */
    void setDevice(const ::std::string& device);

    /**
     * Returns the current value of the property 'Device'.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     */
    const ::std::string& getDevice() const;

    /**
     * Returns the current value of the property 'Device' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDeviceUpdate() method.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     */
    ::std::string& getDeviceMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceUpdate().
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     */
    void sendDeviceUpdate();

    // property 'Version'

    /**
     * The method onVersionGet() is called by ASF when a client invokes the
     * read method for the property 'Version'. The onVersionGet() method
     * returns by default the current property value to the caller. In case
     * this default behavior doesn't match your needs feel free to override
     * this method.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    virtual void onVersionGet(const ::boost::shared_ptr< VersionGet >& payload);

    /**
     * Sends back the update to a previous onVersionGet().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onVersionGet(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendVersionGetUpdate(uint16 version, act_t act = 0);

    /**
     * Set the value of the property 'Version' and send updates to registered
     * clients. No updates will be sent if the property value does not change.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void setVersion(uint16 version);

    /**
     * Returns the current value of the property 'Version'.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    uint16 getVersion() const;

    /**
     * Sends updates to all registered clients with the current property
     * value, see sendVersionUpdate().
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     */
    void sendVersionUpdate();

    // method 'Connect'

    /**
     * The method onConnect() is called by ASF when a client invokes the
     * method 'Connect'. A subclass has to implement this method and send back
     * a response to the client either with the sendConnect() or
     * sendConnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConnectRequest (const ::boost::shared_ptr< ConnectRequest >& request) = 0;

    /**
     * The method sendConnectResponse() sends a response of a previous method
     * invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onConnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendConnectResponse (act_t act = 0);

    /**
     * The method sendConnectError() sends an error response of a previous
     * method invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onConnect(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    RemoteUUIDUpdate _RemoteUUIDProperty;

    StateUpdate _StateProperty;

    DeviceUpdate _DeviceProperty;

    VersionUpdate _VersionProperty;

    friend class ServiceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Service
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERVICESTUB_H
