/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERVICEPROXY_H
#define ORG_BLUEZ_SERVICEPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/core/nullable.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/Service.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace Service {

class ServiceProxy;

class ConnectCallbackIF {
public:
    virtual ~ConnectCallbackIF() {}

    virtual void onConnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectError >& error) = 0;

    virtual void onConnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< ConnectResponse >& response) = 0;
};

class DeviceCallbackIF {
public:
    virtual ~DeviceCallbackIF() {}

    virtual void onDeviceError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceError >& error) = 0;

    virtual void onDeviceUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DeviceUpdate >& update) = 0;
};

class DisconnectCallbackIF {
public:
    virtual ~DisconnectCallbackIF() {}

    virtual void onDisconnectError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectError >& error) = 0;

    virtual void onDisconnectResponse(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< DisconnectResponse >& response) = 0;
};

class RemoteUUIDCallbackIF {
public:
    virtual ~RemoteUUIDCallbackIF() {}

    virtual void onRemoteUUIDError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDError >& error) = 0;

    virtual void onRemoteUUIDUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< RemoteUUIDUpdate >& update) = 0;
};

class StateCallbackIF {
public:
    virtual ~StateCallbackIF() {}

    virtual void onStateError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateError >& error) = 0;

    virtual void onStateUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< StateUpdate >& update) = 0;
};

class VersionCallbackIF {
public:
    virtual ~VersionCallbackIF() {}

    virtual void onVersionError(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionError >& error) = 0;

    virtual void onVersionUpdate(const ::boost::shared_ptr< ServiceProxy >& proxy, const ::boost::shared_ptr< VersionUpdate >& update) = 0;
};


/**
 * ServiceProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.Service' (specified in file
 * stack_component_service.xml).
 *
 * If the meaning of "org.bluez.Service" isn't clear, then there should be a description here.
 */
class ServiceProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ServiceProxy.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ServiceProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ServiceProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ServiceProxy > proxyNew(new ServiceProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(true);
        return proxyNew;
    }

    virtual ~ServiceProxy ();



    // Property 'RemoteUUID'

    /**
     * Notify on the property 'RemoteUUID'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteUUIDRegister(RemoteUUIDCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'RemoteUUID'. This method
     * deregisters property changes from the D-Bus service.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendRemoteUUIDRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendRemoteUUIDDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'RemoteUUID'.
     */
    void sendRemoteUUIDDeregisterAll() const;

    /**
     * Request the value of the property 'RemoteUUID' from the D-Bus server.
     * This method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'RemoteUUID'</b>:
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRemoteUUIDGet(RemoteUUIDCallbackIF& cb);


    /**
     * Returns the current value of the property 'RemoteUUID' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when
     * hasRemoteUUID() returns true.
     *
     * @return the previously received value of the property 'RemoteUUID'.
     */
    const ::std::string& getRemoteUUID() const;

    /**
     * Determines whether a status message for the property 'RemoteUUID' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasRemoteUUID() const;

    // Property 'State'

    /**
     * Notify on the property 'State'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateRegister(StateCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'State'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendStateRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendStateDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'State'.
     */
    void sendStateDeregisterAll() const;

    /**
     * Request the value of the property 'State' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'State'</b>:
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendStateGet(StateCallbackIF& cb);


    /**
     * Returns the current value of the property 'State' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasState()
     * returns true.
     *
     * @return the previously received value of the property 'State'.
     */
    const ::std::string& getState() const;

    /**
     * Determines whether a status message for the property 'State' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasState() const;

    // Property 'Device'

    /**
     * Notify on the property 'Device'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceRegister(DeviceCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Device'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendDeviceRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendDeviceDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Device'.
     */
    void sendDeviceDeregisterAll() const;

    /**
     * Request the value of the property 'Device' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Device'</b>:
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDeviceGet(DeviceCallbackIF& cb);


    /**
     * Returns the current value of the property 'Device' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasDevice()
     * returns true.
     *
     * @return the previously received value of the property 'Device'.
     */
    const ::std::string& getDevice() const;

    /**
     * Determines whether a status message for the property 'Device' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasDevice() const;

    // Property 'Version'

    /**
     * Notify on the property 'Version'. This method registers for property
     * changes by D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionRegister(VersionCallbackIF& cb) const;

    /**
     * Remove the notifcation on property 'Version'. This method deregisters
     * property changes from the D-Bus service.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendVersionRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendVersionDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on property 'Version'.
     */
    void sendVersionDeregisterAll() const;

    /**
     * Request the value of the property 'Version' from the D-Bus server. This
     * method sends a Get message to the D-Bus server.
     *
     * <b>Documentation of 'Version'</b>:
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a status or error message
     * is received in return to the Get message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendVersionGet(VersionCallbackIF& cb);


    /**
     * Returns the current value of the property 'Version' (as known by the
     * proxy). This method is only allowed to be called when a status message
     * for this property was received before. Otherwise the behavior of this
     * method is undefined. It is safe to call this method when hasVersion()
     * returns true.
     *
     * @return the previously received value of the property 'Version'.
     */
    uint16 getVersion() const;

    /**
     * Determines whether a status message for the property 'Version' was
     * received before.
     *
     * @return true if a status message was received, otherwise false.
     */
    bool hasVersion() const;


    // Method 'Connect'

    /**
     * Call the method 'Connect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendConnectRequest(ConnectCallbackIF& cb) const;

    // Method 'Disconnect'

    /**
     * Call the method 'Disconnect'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisconnectRequest(DisconnectCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ServiceProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;

    virtual void clearAllProperties ();

    // Property 'RemoteUUID'

    ::asf::core::nullable< RemoteUUIDUpdate > _remoteUUID;

    // Property 'State'

    ::asf::core::nullable< StateUpdate > _state;

    // Property 'Device'

    ::asf::core::nullable< DeviceUpdate > _device;

    // Property 'Version'

    ::asf::core::nullable< VersionUpdate > _version;

    DECLARE_CLASS_LOGGER();

    friend class ServiceProxyCallback;
};

} // namespace Service
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERVICEPROXY_H
