#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_SERVICE_H
#define ORG_BLUEZ_SERVICE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>

/**
 * If the meaning of "Service" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace Service {

// method IDs
static const uint16 ID_Connect = 0;
static const uint16 ID_Disconnect = 1;

// signal IDs

// property IDs
static const uint16 ID_RemoteUUID = 2;
static const uint16 ID_State = 3;
static const uint16 ID_Device = 4;
static const uint16 ID_Version = 5;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RemoteUUIDUpdate;

class RemoteUUIDRegister;

class StateUpdate;

class StateRegister;

class DeviceUpdate;

class DeviceRegister;

class VersionUpdate;

class VersionRegister;

// type definitions
/**
 * If the meaning of "ConnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectRequest;

/**
 * If the meaning of "ConnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ConnectResponse;

/**
 * If the meaning of "ConnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ConnectError;

/**
 * If the meaning of "DisconnectRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectRequest;

/**
 * If the meaning of "DisconnectResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisconnectResponse;

/**
 * If the meaning of "DisconnectError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisconnectError;

/**
 * If the meaning of "RemoteUUIDSet" isn't clear, then there should be a description here.
 */
typedef RemoteUUIDUpdate RemoteUUIDSet;

/**
 * If the meaning of "RemoteUUIDGet" isn't clear, then there should be a description here.
 */
typedef RemoteUUIDUpdate RemoteUUIDGet;

/**
 * If the meaning of "RemoteUUIDError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RemoteUUIDError;

/**
 * If the meaning of "StateSet" isn't clear, then there should be a description here.
 */
typedef StateUpdate StateSet;

/**
 * If the meaning of "StateGet" isn't clear, then there should be a description here.
 */
typedef StateUpdate StateGet;

/**
 * If the meaning of "StateError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError StateError;

/**
 * If the meaning of "DeviceSet" isn't clear, then there should be a description here.
 */
typedef DeviceUpdate DeviceSet;

/**
 * If the meaning of "DeviceGet" isn't clear, then there should be a description here.
 */
typedef DeviceUpdate DeviceGet;

/**
 * If the meaning of "DeviceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceError;

/**
 * If the meaning of "VersionSet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionSet;

/**
 * If the meaning of "VersionGet" isn't clear, then there should be a description here.
 */
typedef VersionUpdate VersionGet;

/**
 * If the meaning of "VersionError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError VersionError;


/**
 * If the meaning of "RemoteUUIDUpdate" isn't clear, then there should be a description here.
 */
class RemoteUUIDUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteUUIDUpdate ();

    /**
     * Copy constructor
     */
    inline  RemoteUUIDUpdate (const RemoteUUIDUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  RemoteUUIDUpdate (const ::std::string& RemoteUUID_);

    /**
     * Destructor
     */
    inline virtual  ~RemoteUUIDUpdate();

    /**
     * Assignment operator
     */
    inline RemoteUUIDUpdate& operator = (const RemoteUUIDUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteUUIDUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteUUIDUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteUUIDUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteUUIDUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "RemoteUUID"

    static const int kRemoteUUID = 0;

    /**
     * Clears the field "RemoteUUID".
     *
     * The field will be set to its default value. The hasRemoteUUID()
     * method will return false.
     */
    inline void clearRemoteUUID();

    /**
     * Checks whether the field "RemoteUUID" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setRemoteUUID()). Otherwise it will return false.
     */
    inline bool hasRemoteUUID () const;

    /**
     * Returns the value of the member "RemoteUUID".
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @return The value of the field "RemoteUUID"
     */
    inline const ::std::string& getRemoteUUID () const;

    /**
     * Retrieves the value of the field "RemoteUUID" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "RemoteUUID".
     */
    inline ::std::string& getRemoteUUIDMutable ();

    /**
     * Sets the value of the member "RemoteUUID".
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param RemoteUUID The value which will be set
     */
    inline void setRemoteUUID (const ::std::string& RemoteUUID_);

    /**
     * Sets the value of the member "RemoteUUID".
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param RemoteUUID The value which will be set
     */
    inline void setRemoteUUID (const char* RemoteUUID_);

    /**
     * Sets the value of the member "RemoteUUID".
     *
     * If the meaning of "RemoteUUID" isn't clear, then there should be a description here.
     *
     * @param RemoteUUID The value which will be set
     */
    inline void setRemoteUUID (const char* value, size_t size);

    static const RemoteUUIDUpdate &getDefaultInstance();

private:

    inline void set_has_RemoteUUID ();

    inline void clear_has_RemoteUUID ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _RemoteUUID;

};

/**
 * If the meaning of "RemoteUUIDRegister" isn't clear, then there should be a description here.
 */
class RemoteUUIDRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RemoteUUIDRegister ();

    /**
     * Copy constructor
     */
    inline  RemoteUUIDRegister (const RemoteUUIDRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~RemoteUUIDRegister();

    /**
     * Assignment operator
     */
    inline RemoteUUIDRegister& operator = (const RemoteUUIDRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RemoteUUIDRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RemoteUUIDRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RemoteUUIDRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RemoteUUIDRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const RemoteUUIDRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "StateUpdate" isn't clear, then there should be a description here.
 */
class StateUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateUpdate ();

    /**
     * Copy constructor
     */
    inline  StateUpdate (const StateUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  StateUpdate (const ::std::string& State_);

    /**
     * Destructor
     */
    inline virtual  ~StateUpdate();

    /**
     * Assignment operator
     */
    inline StateUpdate& operator = (const StateUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "State"

    static const int kState = 0;

    /**
     * Clears the field "State".
     *
     * The field will be set to its default value. The hasState()
     * method will return false.
     */
    inline void clearState();

    /**
     * Checks whether the field "State" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setState()). Otherwise it will return false.
     */
    inline bool hasState () const;

    /**
     * Returns the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @return The value of the field "State"
     */
    inline const ::std::string& getState () const;

    /**
     * Retrieves the value of the field "State" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "State".
     */
    inline ::std::string& getStateMutable ();

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const ::std::string& State_);

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* State_);

    /**
     * Sets the value of the member "State".
     *
     * If the meaning of "State" isn't clear, then there should be a description here.
     *
     * @param State The value which will be set
     */
    inline void setState (const char* value, size_t size);

    static const StateUpdate &getDefaultInstance();

private:

    inline void set_has_State ();

    inline void clear_has_State ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _State;

};

/**
 * If the meaning of "StateRegister" isn't clear, then there should be a description here.
 */
class StateRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  StateRegister ();

    /**
     * Copy constructor
     */
    inline  StateRegister (const StateRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~StateRegister();

    /**
     * Assignment operator
     */
    inline StateRegister& operator = (const StateRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const StateRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const StateRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const StateRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const StateRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const StateRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "DeviceUpdate" isn't clear, then there should be a description here.
 */
class DeviceUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceUpdate (const DeviceUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceUpdate (const ::std::string& Device_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceUpdate();

    /**
     * Assignment operator
     */
    inline DeviceUpdate& operator = (const DeviceUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Device"

    static const int kDevice = 0;

    /**
     * Clears the field "Device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "Device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "Device".
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "Device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "Device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "Device".
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const ::std::string& Device_);

    /**
     * Sets the value of the member "Device".
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* Device_);

    /**
     * Sets the value of the member "Device".
     *
     * If the meaning of "Device" isn't clear, then there should be a description here.
     *
     * @param Device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const DeviceUpdate &getDefaultInstance();

private:

    inline void set_has_Device ();

    inline void clear_has_Device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _Device;

};

/**
 * If the meaning of "DeviceRegister" isn't clear, then there should be a description here.
 */
class DeviceRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceRegister (const DeviceRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceRegister();

    /**
     * Assignment operator
     */
    inline DeviceRegister& operator = (const DeviceRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "VersionUpdate" isn't clear, then there should be a description here.
 */
class VersionUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionUpdate ();

    /**
     * Copy constructor
     */
    inline  VersionUpdate (const VersionUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  VersionUpdate (uint16 Version_);

    /**
     * Destructor
     */
    inline virtual  ~VersionUpdate();

    /**
     * Assignment operator
     */
    inline VersionUpdate& operator = (const VersionUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "Version"

    static const int kVersion = 0;

    /**
     * Clears the field "Version".
     *
     * The field will be set to its default value. The hasVersion()
     * method will return false.
     */
    inline void clearVersion();

    /**
     * Checks whether the field "Version" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setVersion()). Otherwise it will return false.
     */
    inline bool hasVersion () const;

    /**
     * Returns the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @return The value of the field "Version"
     */
    inline uint16 getVersion () const;

    /**
     * Sets the value of the member "Version".
     *
     * If the meaning of "Version" isn't clear, then there should be a description here.
     *
     * @param Version The value which will be set
     */
    inline void setVersion (uint16 Version_);

    static const VersionUpdate &getDefaultInstance();

private:

    inline void set_has_Version ();

    inline void clear_has_Version ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint16 _Version;

};

/**
 * If the meaning of "VersionRegister" isn't clear, then there should be a description here.
 */
class VersionRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  VersionRegister ();

    /**
     * Copy constructor
     */
    inline  VersionRegister (const VersionRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~VersionRegister();

    /**
     * Assignment operator
     */
    inline VersionRegister& operator = (const VersionRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const VersionRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const VersionRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const VersionRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const VersionRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const VersionRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

inline  RemoteUUIDUpdate::RemoteUUIDUpdate ()  :
    _RemoteUUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteUUIDUpdate::RemoteUUIDUpdate (const RemoteUUIDUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _RemoteUUID ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteUUIDUpdate::RemoteUUIDUpdate (const ::std::string& RemoteUUID_)  :
    _RemoteUUID (RemoteUUID_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RemoteUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RemoteUUIDUpdate::~RemoteUUIDUpdate() {
}

inline RemoteUUIDUpdate& RemoteUUIDUpdate::operator = (const RemoteUUIDUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasRemoteUUID()) {
            setRemoteUUID(rhs.getRemoteUUID());
        } else {
            clearRemoteUUID();
        }
    }
    return *this;
}

inline bool RemoteUUIDUpdate::operator == (const RemoteUUIDUpdate& rhs) const {
    return (((!hasRemoteUUID() && !rhs.hasRemoteUUID()) || getRemoteUUID() == rhs.getRemoteUUID()));
}

inline bool RemoteUUIDUpdate::operator != (const RemoteUUIDUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteUUIDUpdate::operator < (const RemoteUUIDUpdate& rhs) const {
    if (hasRemoteUUID() || rhs.hasRemoteUUID()) {
        if (getRemoteUUID() < rhs.getRemoteUUID()) return true;
        if (getRemoteUUID() > rhs.getRemoteUUID()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RemoteUUIDUpdate::clone() {
    return new RemoteUUIDUpdate(*this);
}

inline bool RemoteUUIDUpdate::operator > (const RemoteUUIDUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteUUIDUpdate::clear() {
    clearRemoteUUID();
}

inline void RemoteUUIDUpdate::clearRemoteUUID() {
    if (hasRemoteUUID()) {
         clear_has_RemoteUUID();
        _RemoteUUID.clear();
     }
}

inline bool RemoteUUIDUpdate::hasRemoteUUID () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RemoteUUIDUpdate::getRemoteUUID () const {
    return _RemoteUUID;
}

inline ::std::string& RemoteUUIDUpdate::getRemoteUUIDMutable () {
    set_has_RemoteUUID();
    return _RemoteUUID;
}

inline void RemoteUUIDUpdate::setRemoteUUID (const ::std::string& RemoteUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RemoteUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RemoteUUID();
    this->_RemoteUUID = RemoteUUID_;
}

inline void RemoteUUIDUpdate::setRemoteUUID (const char* RemoteUUID_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (RemoteUUID_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RemoteUUID();
    this->_RemoteUUID.assign(RemoteUUID_);
}

inline void RemoteUUIDUpdate::setRemoteUUID (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_RemoteUUID();
    this->_RemoteUUID.assign(value, size);
}

inline void RemoteUUIDUpdate::set_has_RemoteUUID () {
    _has_bits_[0] |= 1u << 0;
}

inline void RemoteUUIDUpdate::clear_has_RemoteUUID () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RemoteUUIDRegister::RemoteUUIDRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RemoteUUIDRegister::RemoteUUIDRegister (const RemoteUUIDRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RemoteUUIDRegister::~RemoteUUIDRegister() {
}

inline RemoteUUIDRegister& RemoteUUIDRegister::operator = (const RemoteUUIDRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool RemoteUUIDRegister::operator == (const RemoteUUIDRegister& ) const {
    return true;
}

inline bool RemoteUUIDRegister::operator != (const RemoteUUIDRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool RemoteUUIDRegister::operator < (const RemoteUUIDRegister& ) const {
    return false;
}

inline ::asf::core::Payload* RemoteUUIDRegister::clone() {
    return new RemoteUUIDRegister(*this);
}

inline bool RemoteUUIDRegister::operator > (const RemoteUUIDRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RemoteUUIDRegister::clear() {
}

inline  StateUpdate::StateUpdate ()  :
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateUpdate::StateUpdate (const StateUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _State ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateUpdate::StateUpdate (const ::std::string& State_)  :
    _State (State_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  StateUpdate::~StateUpdate() {
}

inline StateUpdate& StateUpdate::operator = (const StateUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasState()) {
            setState(rhs.getState());
        } else {
            clearState();
        }
    }
    return *this;
}

inline bool StateUpdate::operator == (const StateUpdate& rhs) const {
    return (((!hasState() && !rhs.hasState()) || getState() == rhs.getState()));
}

inline bool StateUpdate::operator != (const StateUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool StateUpdate::operator < (const StateUpdate& rhs) const {
    if (hasState() || rhs.hasState()) {
        if (getState() < rhs.getState()) return true;
        if (getState() > rhs.getState()) return false;
    }
    return false;
}

inline ::asf::core::Payload* StateUpdate::clone() {
    return new StateUpdate(*this);
}

inline bool StateUpdate::operator > (const StateUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateUpdate::clear() {
    clearState();
}

inline void StateUpdate::clearState() {
    if (hasState()) {
         clear_has_State();
        _State.clear();
     }
}

inline bool StateUpdate::hasState () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& StateUpdate::getState () const {
    return _State;
}

inline ::std::string& StateUpdate::getStateMutable () {
    set_has_State();
    return _State;
}

inline void StateUpdate::setState (const ::std::string& State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State = State_;
}

inline void StateUpdate::setState (const char* State_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (State_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(State_);
}

inline void StateUpdate::setState (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_State();
    this->_State.assign(value, size);
}

inline void StateUpdate::set_has_State () {
    _has_bits_[0] |= 1u << 0;
}

inline void StateUpdate::clear_has_State () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  StateRegister::StateRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  StateRegister::StateRegister (const StateRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  StateRegister::~StateRegister() {
}

inline StateRegister& StateRegister::operator = (const StateRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool StateRegister::operator == (const StateRegister& ) const {
    return true;
}

inline bool StateRegister::operator != (const StateRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool StateRegister::operator < (const StateRegister& ) const {
    return false;
}

inline ::asf::core::Payload* StateRegister::clone() {
    return new StateRegister(*this);
}

inline bool StateRegister::operator > (const StateRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void StateRegister::clear() {
}

inline  DeviceUpdate::DeviceUpdate ()  :
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceUpdate::DeviceUpdate (const DeviceUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceUpdate::DeviceUpdate (const ::std::string& Device_)  :
    _Device (Device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceUpdate::~DeviceUpdate() {
}

inline DeviceUpdate& DeviceUpdate::operator = (const DeviceUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool DeviceUpdate::operator == (const DeviceUpdate& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool DeviceUpdate::operator != (const DeviceUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceUpdate::operator < (const DeviceUpdate& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceUpdate::clone() {
    return new DeviceUpdate(*this);
}

inline bool DeviceUpdate::operator > (const DeviceUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceUpdate::clear() {
    clearDevice();
}

inline void DeviceUpdate::clearDevice() {
    if (hasDevice()) {
         clear_has_Device();
        _Device.clear();
     }
}

inline bool DeviceUpdate::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DeviceUpdate::getDevice () const {
    return _Device;
}

inline ::std::string& DeviceUpdate::getDeviceMutable () {
    set_has_Device();
    return _Device;
}

inline void DeviceUpdate::setDevice (const ::std::string& Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device = Device_;
}

inline void DeviceUpdate::setDevice (const char* Device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (Device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(Device_);
}

inline void DeviceUpdate::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_Device();
    this->_Device.assign(value, size);
}

inline void DeviceUpdate::set_has_Device () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceUpdate::clear_has_Device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceRegister::DeviceRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceRegister::DeviceRegister (const DeviceRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceRegister::~DeviceRegister() {
}

inline DeviceRegister& DeviceRegister::operator = (const DeviceRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeviceRegister::operator == (const DeviceRegister& ) const {
    return true;
}

inline bool DeviceRegister::operator != (const DeviceRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceRegister::operator < (const DeviceRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeviceRegister::clone() {
    return new DeviceRegister(*this);
}

inline bool DeviceRegister::operator > (const DeviceRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceRegister::clear() {
}

inline  VersionUpdate::VersionUpdate ()  :
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionUpdate::VersionUpdate (const VersionUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _Version (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionUpdate::VersionUpdate (uint16 Version_)  :
    _Version (Version_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  VersionUpdate::~VersionUpdate() {
}

inline VersionUpdate& VersionUpdate::operator = (const VersionUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasVersion()) {
            setVersion(rhs.getVersion());
        } else {
            clearVersion();
        }
    }
    return *this;
}

inline bool VersionUpdate::operator == (const VersionUpdate& rhs) const {
    return (((!hasVersion() && !rhs.hasVersion()) || getVersion() == rhs.getVersion()));
}

inline bool VersionUpdate::operator != (const VersionUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionUpdate::operator < (const VersionUpdate& rhs) const {
    if (hasVersion() || rhs.hasVersion()) {
        if (getVersion() < rhs.getVersion()) return true;
        if (getVersion() > rhs.getVersion()) return false;
    }
    return false;
}

inline ::asf::core::Payload* VersionUpdate::clone() {
    return new VersionUpdate(*this);
}

inline bool VersionUpdate::operator > (const VersionUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionUpdate::clear() {
    clearVersion();
}

inline void VersionUpdate::clearVersion() {
    if (hasVersion()) {
         clear_has_Version();
        _Version = 0u;
     }
}

inline bool VersionUpdate::hasVersion () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 VersionUpdate::getVersion () const {
    return _Version;
}

inline void VersionUpdate::setVersion (uint16 Version_) {
    set_has_Version();
    this->_Version = Version_;
}

inline void VersionUpdate::set_has_Version () {
    _has_bits_[0] |= 1u << 0;
}

inline void VersionUpdate::clear_has_Version () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  VersionRegister::VersionRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  VersionRegister::VersionRegister (const VersionRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  VersionRegister::~VersionRegister() {
}

inline VersionRegister& VersionRegister::operator = (const VersionRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool VersionRegister::operator == (const VersionRegister& ) const {
    return true;
}

inline bool VersionRegister::operator != (const VersionRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool VersionRegister::operator < (const VersionRegister& ) const {
    return false;
}

inline ::asf::core::Payload* VersionRegister::clone() {
    return new VersionRegister(*this);
}

inline bool VersionRegister::operator > (const VersionRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void VersionRegister::clear() {
}

} // namespace Service
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_SERVICE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
