/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Device1.h"
#include "org/bluez/Device1DBus.h"
#include "org/bluez/Device1Json.h"
#include "org/bluez/Device1Stub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Device1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/created/during/runtime/org/bluez/Device1", Device1Stub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 4, "Pair", 2 },
    { 7, "Connect", 0 },
    { 10, "Disconnect", 1 },
    { 13, "CancelPairing", 3 },
    { 15, "CancelDiscovery", 5 },
    { 16, "DiscoverServices", 4 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 4, "Icon", 2 },
    { 4, "Mode", 19 },
    { 4, "RSSI", 11 },
    { 4, "Role", 20 },
    { 5, "Alias", 8 },
    { 5, "Class", 1 },
    { 5, "UUIDs", 3 },
    { 6, "Paired", 4 },
    { 6, "Vendor", 12 },
    { 7, "Adapter", 9 },
    { 7, "Address", 0 },
    { 7, "Blocked", 7 },
    { 7, "MapInfo", 15 },
    { 7, "Product", 14 },
    { 7, "Trusted", 6 },
    { 7, "Version", 17 },
    { 8, "Modalias", 10 },
    { 8, "PBAPInfo", 18 },
    { 9, "Connected", 5 },
    { 12, "VendorSource", 13 },
    { 14, "EnableAvpPause", 21 },
    { 16, "ConnectedService", 16 },
};

class Device1StubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    Device1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    Device1StubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    Device1StubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.Device1"),
          _logger(logger) {}

    virtual ~Device1StubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void Device1StubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 6, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Connect'

            LOG_DEBUG_STUB("process method '%s'", "Connect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Connect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectRequest > payload = ::boost::static_pointer_cast<ConnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onConnectRequest(payload);
            return;
        }
        case 1: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        case 2: {

            // method 'Pair'

            LOG_DEBUG_STUB("process method '%s'", "Pair");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Pair", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< PairRequest > payload = ::boost::static_pointer_cast<PairRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onPairRequest(payload);
            return;
        }
        case 3: {

            // method 'CancelPairing'

            LOG_DEBUG_STUB("process method '%s'", "CancelPairing");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelPairingRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelPairing", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelPairingRequest > payload = ::boost::static_pointer_cast<CancelPairingRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onCancelPairingRequest(payload);
            return;
        }
        case 4: {

            // method 'DiscoverServices'

            LOG_DEBUG_STUB("process method '%s'", "DiscoverServices");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverServicesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DiscoverServices", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DiscoverServicesRequest > payload = ::boost::static_pointer_cast<DiscoverServicesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onDiscoverServicesRequest(payload);
            return;
        }
        case 5: {

            // method 'CancelDiscovery'

            LOG_DEBUG_STUB("process method '%s'", "CancelDiscovery");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelDiscoveryRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "CancelDiscovery", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< CancelDiscoveryRequest > payload = ::boost::static_pointer_cast<CancelDiscoveryRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<Device1Stub*>(getStub())->onCancelDiscoveryRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* Device1StubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.Device1\">\n"
            "      <method name=\"Connect\"/>\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <method name=\"Pair\"/>\n"
            "      <method name=\"CancelPairing\"/>\n"
            "      <method name=\"DiscoverServices\">\n"
            "        <arg direction=\"in\" name=\"pattern\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"CancelDiscovery\"/>\n"
            "      <signal name=\"ReportLinkkey\">\n"
            "        <arg name=\"linkkey\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"IncomingPairingComp\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"SDPProcessReport\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"Address\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Class\" type=\"u\"/>\n"
            "      <property access=\"read\" name=\"Icon\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"UUIDs\" type=\"as\"/>\n"
            "      <property access=\"read\" name=\"Paired\" type=\"b\"/>\n"
            "      <property access=\"read\" name=\"Connected\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Trusted\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Blocked\" type=\"b\"/>\n"
            "      <property access=\"readwrite\" name=\"Alias\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Adapter\" type=\"o\"/>\n"
            "      <property access=\"read\" name=\"Modalias\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"RSSI\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Vendor\" type=\"q\"/>\n"
            "      <property access=\"read\" name=\"VendorSource\" type=\"q\"/>\n"
            "      <property access=\"read\" name=\"Product\" type=\"q\"/>\n"
            "      <property access=\"read\" name=\"MapInfo\" type=\"as\"/>\n"
            "      <property access=\"read\" name=\"ConnectedService\" type=\"t\"/>\n"
            "      <property access=\"read\" name=\"Version\" type=\"q\"/>\n"
            "      <property access=\"read\" name=\"PBAPInfo\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"Mode\" type=\"y\"/>\n"
            "      <property access=\"read\" name=\"Role\" type=\"y\"/>\n"
            "      <property access=\"readwrite\" name=\"EnableAvpPause\" type=\"b\"/>\n"
            "</interface>\n";
}

void Device1StubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<Device1Stub*>(getStub()))->onGetAll (properties);
}

void Device1StubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 22, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Class");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Icon");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "UUIDs");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Paired");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Trusted");
            ::boost::shared_ptr< TrustedSet > payload(new TrustedSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Device1Stub*>(getStub())->onTrustedSet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Blocked");
            ::boost::shared_ptr< BlockedSet > payload(new BlockedSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Device1Stub*>(getStub())->onBlockedSet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasSet > payload(new AliasSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Device1Stub*>(getStub())->onAliasSet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Adapter");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "Modalias");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "RSSI");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "Vendor");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "VendorSource");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "Product");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "MapInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectedService");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "PBAPInfo");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "Mode");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "Role");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "EnableAvpPause");
            ::boost::shared_ptr< EnableAvpPauseSet > payload(new EnableAvpPauseSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<Device1Stub*>(getStub())->onEnableAvpPauseSet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void Device1StubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 22, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "Address");
            ::boost::shared_ptr< AddressGet > payload(new AddressGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onAddressGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "Class");
            ::boost::shared_ptr< ClassGet > payload(new ClassGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onClassGet (payload);
            return;
        }
        case 2: {
            LOG_DEBUG_STUB("process property '%s'", "Icon");
            ::boost::shared_ptr< IconGet > payload(new IconGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onIconGet (payload);
            return;
        }
        case 3: {
            LOG_DEBUG_STUB("process property '%s'", "UUIDs");
            ::boost::shared_ptr< UUIDsGet > payload(new UUIDsGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onUUIDsGet (payload);
            return;
        }
        case 4: {
            LOG_DEBUG_STUB("process property '%s'", "Paired");
            ::boost::shared_ptr< PairedGet > payload(new PairedGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onPairedGet (payload);
            return;
        }
        case 5: {
            LOG_DEBUG_STUB("process property '%s'", "Connected");
            ::boost::shared_ptr< ConnectedGet > payload(new ConnectedGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onConnectedGet (payload);
            return;
        }
        case 6: {
            LOG_DEBUG_STUB("process property '%s'", "Trusted");
            ::boost::shared_ptr< TrustedGet > payload(new TrustedGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onTrustedGet (payload);
            return;
        }
        case 7: {
            LOG_DEBUG_STUB("process property '%s'", "Blocked");
            ::boost::shared_ptr< BlockedGet > payload(new BlockedGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onBlockedGet (payload);
            return;
        }
        case 8: {
            LOG_DEBUG_STUB("process property '%s'", "Alias");
            ::boost::shared_ptr< AliasGet > payload(new AliasGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onAliasGet (payload);
            return;
        }
        case 9: {
            LOG_DEBUG_STUB("process property '%s'", "Adapter");
            ::boost::shared_ptr< AdapterGet > payload(new AdapterGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onAdapterGet (payload);
            return;
        }
        case 10: {
            LOG_DEBUG_STUB("process property '%s'", "Modalias");
            ::boost::shared_ptr< ModaliasGet > payload(new ModaliasGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onModaliasGet (payload);
            return;
        }
        case 11: {
            LOG_DEBUG_STUB("process property '%s'", "RSSI");
            ::boost::shared_ptr< RSSIGet > payload(new RSSIGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onRSSIGet (payload);
            return;
        }
        case 12: {
            LOG_DEBUG_STUB("process property '%s'", "Vendor");
            ::boost::shared_ptr< VendorGet > payload(new VendorGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onVendorGet (payload);
            return;
        }
        case 13: {
            LOG_DEBUG_STUB("process property '%s'", "VendorSource");
            ::boost::shared_ptr< VendorSourceGet > payload(new VendorSourceGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onVendorSourceGet (payload);
            return;
        }
        case 14: {
            LOG_DEBUG_STUB("process property '%s'", "Product");
            ::boost::shared_ptr< ProductGet > payload(new ProductGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onProductGet (payload);
            return;
        }
        case 15: {
            LOG_DEBUG_STUB("process property '%s'", "MapInfo");
            ::boost::shared_ptr< MapInfoGet > payload(new MapInfoGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onMapInfoGet (payload);
            return;
        }
        case 16: {
            LOG_DEBUG_STUB("process property '%s'", "ConnectedService");
            ::boost::shared_ptr< ConnectedServiceGet > payload(new ConnectedServiceGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onConnectedServiceGet (payload);
            return;
        }
        case 17: {
            LOG_DEBUG_STUB("process property '%s'", "Version");
            ::boost::shared_ptr< VersionGet > payload(new VersionGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onVersionGet (payload);
            return;
        }
        case 18: {
            LOG_DEBUG_STUB("process property '%s'", "PBAPInfo");
            ::boost::shared_ptr< PBAPInfoGet > payload(new PBAPInfoGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onPBAPInfoGet (payload);
            return;
        }
        case 19: {
            LOG_DEBUG_STUB("process property '%s'", "Mode");
            ::boost::shared_ptr< ModeGet > payload(new ModeGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onModeGet (payload);
            return;
        }
        case 20: {
            LOG_DEBUG_STUB("process property '%s'", "Role");
            ::boost::shared_ptr< RoleGet > payload(new RoleGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onRoleGet (payload);
            return;
        }
        case 21: {
            LOG_DEBUG_STUB("process property '%s'", "EnableAvpPause");
            ::boost::shared_ptr< EnableAvpPauseGet > payload(new EnableAvpPauseGet());
            payload->setAct(act);
            static_cast<Device1Stub*>(getStub())->onEnableAvpPauseGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

Device1Stub::Device1Stub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Device1StubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Device1Stub::Device1Stub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new Device1StubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

Device1Stub::~Device1Stub() {
    delete _stubDelegate;
}

void Device1Stub::sendReportLinkkeySignal(const ::std::vector< uint8 >& linkkey) {
    if (_stubDelegate->isConnected()) {
        ReportLinkkeySignal* payload = new ReportLinkkeySignal(linkkey);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ReportLinkkey", ReportLinkkeySignal, payload)
        LOG_INFO ("-> send%sSignal", "ReportLinkkey");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ReportLinkkey");
    }
}

void Device1Stub::sendIncomingPairingCompSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        IncomingPairingCompSignal* payload = new IncomingPairingCompSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "IncomingPairingComp", IncomingPairingCompSignal, payload)
        LOG_INFO ("-> send%sSignal", "IncomingPairingComp");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "IncomingPairingComp");
    }
}

void Device1Stub::sendSDPProcessReportSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        SDPProcessReportSignal* payload = new SDPProcessReportSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SDPProcessReport", SDPProcessReportSignal, payload)
        LOG_INFO ("-> send%sSignal", "SDPProcessReport");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SDPProcessReport");
    }
}

void Device1Stub::sendAddressUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AddressUpdate payload(_AddressProperty);

        LOG_INFO ("-> send%s", "AddressUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Address", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AddressUpdate");
    }
}

void Device1Stub::onAddressGet(const ::boost::shared_ptr< AddressGet >& address) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AddressGet", address->getAct());
    sendAddressGetUpdate(_AddressProperty.getAddress(), address->getAct());
}

void Device1Stub::sendAddressGetUpdate(const ::std::string& address, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AddressGet payload(address);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AddressGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setAddress(const ::std::string& address) {
    if(address!=_AddressProperty.getAddress()) {
        _AddressProperty.setAddress(address);
        sendAddressUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getAddress() const {
    return _AddressProperty.getAddress();
}

::std::string& Device1Stub::getAddressMutable() {
    return _AddressProperty.getAddressMutable();
}

void Device1Stub::sendClassUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ClassUpdate payload(_ClassProperty);

        LOG_INFO ("-> send%s", "ClassUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Class", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ClassUpdate");
    }
}

void Device1Stub::onClassGet(const ::boost::shared_ptr< ClassGet >& class_) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ClassGet", class_->getAct());
    sendClassGetUpdate(_ClassProperty.getClass(), class_->getAct());
}

void Device1Stub::sendClassGetUpdate(uint32 class_, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ClassGet payload(class_);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ClassGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setClass(uint32 class_) {
    if(class_!=_ClassProperty.getClass()) {
        _ClassProperty.setClass(class_);
        sendClassUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint32 Device1Stub::getClass() const {
    return _ClassProperty.getClass();
}

void Device1Stub::sendIconUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        IconUpdate payload(_IconProperty);

        LOG_INFO ("-> send%s", "IconUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Icon", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "IconUpdate");
    }
}

void Device1Stub::onIconGet(const ::boost::shared_ptr< IconGet >& icon) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "IconGet", icon->getAct());
    sendIconGetUpdate(_IconProperty.getIcon(), icon->getAct());
}

void Device1Stub::sendIconGetUpdate(const ::std::string& icon, act_t act) {
    ::asf::dbus::DBusVariant variant;
    IconGet payload(icon);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "IconGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setIcon(const ::std::string& icon) {
    if(icon!=_IconProperty.getIcon()) {
        _IconProperty.setIcon(icon);
        sendIconUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getIcon() const {
    return _IconProperty.getIcon();
}

::std::string& Device1Stub::getIconMutable() {
    return _IconProperty.getIconMutable();
}

void Device1Stub::sendUUIDsUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        UUIDsUpdate payload(_UUIDsProperty);

        LOG_INFO ("-> send%s", "UUIDsUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("UUIDs", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "UUIDsUpdate");
    }
}

void Device1Stub::onUUIDsGet(const ::boost::shared_ptr< UUIDsGet >& uUIDs) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "UUIDsGet", uUIDs->getAct());
    sendUUIDsGetUpdate(_UUIDsProperty.getUUIDs(), uUIDs->getAct());
}

void Device1Stub::sendUUIDsGetUpdate(const ::std::vector< ::std::string >& uUIDs, act_t act) {
    ::asf::dbus::DBusVariant variant;
    UUIDsGet payload(uUIDs);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "UUIDsGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setUUIDs(const ::std::vector< ::std::string >& uUIDs) {
    if(uUIDs!=_UUIDsProperty.getUUIDs()) {
        _UUIDsProperty.setUUIDs(uUIDs);
        sendUUIDsUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Device1Stub::getUUIDs() const {
    return _UUIDsProperty.getUUIDs();
}

::std::vector< ::std::string >& Device1Stub::getUUIDsMutable() {
    return _UUIDsProperty.getUUIDsMutable();
}

void Device1Stub::sendPairedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PairedUpdate payload(_PairedProperty);

        LOG_INFO ("-> send%s", "PairedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Paired", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PairedUpdate");
    }
}

void Device1Stub::onPairedGet(const ::boost::shared_ptr< PairedGet >& paired) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PairedGet", paired->getAct());
    sendPairedGetUpdate(_PairedProperty.getPaired(), paired->getAct());
}

void Device1Stub::sendPairedGetUpdate(bool paired, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PairedGet payload(paired);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PairedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setPaired(bool paired) {
    if(paired!=_PairedProperty.getPaired()) {
        _PairedProperty.setPaired(paired);
        sendPairedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Device1Stub::getPaired() const {
    return _PairedProperty.getPaired();
}

void Device1Stub::sendConnectedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectedUpdate payload(_ConnectedProperty);

        LOG_INFO ("-> send%s", "ConnectedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Connected", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectedUpdate");
    }
}

void Device1Stub::onConnectedGet(const ::boost::shared_ptr< ConnectedGet >& connected) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectedGet", connected->getAct());
    sendConnectedGetUpdate(_ConnectedProperty.getConnected(), connected->getAct());
}

void Device1Stub::sendConnectedGetUpdate(bool connected, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectedGet payload(connected);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setConnected(bool connected) {
    if(connected!=_ConnectedProperty.getConnected()) {
        _ConnectedProperty.setConnected(connected);
        sendConnectedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Device1Stub::getConnected() const {
    return _ConnectedProperty.getConnected();
}

void Device1Stub::sendTrustedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        TrustedUpdate payload(_TrustedProperty);

        LOG_INFO ("-> send%s", "TrustedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Trusted", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "TrustedUpdate");
    }
}

void Device1Stub::onTrustedGet(const ::boost::shared_ptr< TrustedGet >& trusted) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrustedGet", trusted->getAct());
    sendTrustedGetUpdate(_TrustedProperty.getTrusted(), trusted->getAct());
}

void Device1Stub::sendTrustedGetUpdate(bool trusted, act_t act) {
    ::asf::dbus::DBusVariant variant;
    TrustedGet payload(trusted);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrustedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::onTrustedSet(const ::boost::shared_ptr< TrustedSet >& trusted) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "TrustedSet", trusted->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*trusted, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setTrusted (trusted->getTrusted());
    sendTrustedSetUpdate(trusted->getAct());
}

void Device1Stub::sendTrustedSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "TrustedSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Device1Stub::setTrusted(bool trusted) {
    if(trusted!=_TrustedProperty.getTrusted()) {
        _TrustedProperty.setTrusted(trusted);
        sendTrustedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Device1Stub::getTrusted() const {
    return _TrustedProperty.getTrusted();
}

void Device1Stub::sendBlockedUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        BlockedUpdate payload(_BlockedProperty);

        LOG_INFO ("-> send%s", "BlockedUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Blocked", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "BlockedUpdate");
    }
}

void Device1Stub::onBlockedGet(const ::boost::shared_ptr< BlockedGet >& blocked) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockedGet", blocked->getAct());
    sendBlockedGetUpdate(_BlockedProperty.getBlocked(), blocked->getAct());
}

void Device1Stub::sendBlockedGetUpdate(bool blocked, act_t act) {
    ::asf::dbus::DBusVariant variant;
    BlockedGet payload(blocked);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockedGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::onBlockedSet(const ::boost::shared_ptr< BlockedSet >& blocked) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "BlockedSet", blocked->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*blocked, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setBlocked (blocked->getBlocked());
    sendBlockedSetUpdate(blocked->getAct());
}

void Device1Stub::sendBlockedSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "BlockedSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Device1Stub::setBlocked(bool blocked) {
    if(blocked!=_BlockedProperty.getBlocked()) {
        _BlockedProperty.setBlocked(blocked);
        sendBlockedUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Device1Stub::getBlocked() const {
    return _BlockedProperty.getBlocked();
}

void Device1Stub::sendAliasUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AliasUpdate payload(_AliasProperty);

        LOG_INFO ("-> send%s", "AliasUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Alias", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AliasUpdate");
    }
}

void Device1Stub::onAliasGet(const ::boost::shared_ptr< AliasGet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasGet", alias->getAct());
    sendAliasGetUpdate(_AliasProperty.getAlias(), alias->getAct());
}

void Device1Stub::sendAliasGetUpdate(const ::std::string& alias, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AliasGet payload(alias);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::onAliasSet(const ::boost::shared_ptr< AliasSet >& alias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AliasSet", alias->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*alias, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setAlias (alias->getAlias());
    sendAliasSetUpdate(alias->getAct());
}

void Device1Stub::sendAliasSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AliasSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Device1Stub::setAlias(const ::std::string& alias) {
    if(alias!=_AliasProperty.getAlias()) {
        _AliasProperty.setAlias(alias);
        sendAliasUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getAlias() const {
    return _AliasProperty.getAlias();
}

::std::string& Device1Stub::getAliasMutable() {
    return _AliasProperty.getAliasMutable();
}

void Device1Stub::sendAdapterUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        AdapterUpdate payload(_AdapterProperty);

        LOG_INFO ("-> send%s", "AdapterUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Adapter", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "AdapterUpdate");
    }
}

void Device1Stub::onAdapterGet(const ::boost::shared_ptr< AdapterGet >& adapter) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "AdapterGet", adapter->getAct());
    sendAdapterGetUpdate(_AdapterProperty.getAdapter(), adapter->getAct());
}

void Device1Stub::sendAdapterGetUpdate(const ::std::string& adapter, act_t act) {
    ::asf::dbus::DBusVariant variant;
    AdapterGet payload(adapter);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "AdapterGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setAdapter(const ::std::string& adapter) {
    if(adapter!=_AdapterProperty.getAdapter()) {
        _AdapterProperty.setAdapter(adapter);
        sendAdapterUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getAdapter() const {
    return _AdapterProperty.getAdapter();
}

::std::string& Device1Stub::getAdapterMutable() {
    return _AdapterProperty.getAdapterMutable();
}

void Device1Stub::sendModaliasUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ModaliasUpdate payload(_ModaliasProperty);

        LOG_INFO ("-> send%s", "ModaliasUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Modalias", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ModaliasUpdate");
    }
}

void Device1Stub::onModaliasGet(const ::boost::shared_ptr< ModaliasGet >& modalias) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ModaliasGet", modalias->getAct());
    sendModaliasGetUpdate(_ModaliasProperty.getModalias(), modalias->getAct());
}

void Device1Stub::sendModaliasGetUpdate(const ::std::string& modalias, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ModaliasGet payload(modalias);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ModaliasGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setModalias(const ::std::string& modalias) {
    if(modalias!=_ModaliasProperty.getModalias()) {
        _ModaliasProperty.setModalias(modalias);
        sendModaliasUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getModalias() const {
    return _ModaliasProperty.getModalias();
}

::std::string& Device1Stub::getModaliasMutable() {
    return _ModaliasProperty.getModaliasMutable();
}

void Device1Stub::sendRSSIUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RSSIUpdate payload(_RSSIProperty);

        LOG_INFO ("-> send%s", "RSSIUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("RSSI", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RSSIUpdate");
    }
}

void Device1Stub::onRSSIGet(const ::boost::shared_ptr< RSSIGet >& rSSI) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RSSIGet", rSSI->getAct());
    sendRSSIGetUpdate(_RSSIProperty.getRSSI(), rSSI->getAct());
}

void Device1Stub::sendRSSIGetUpdate(uint8 rSSI, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RSSIGet payload(rSSI);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RSSIGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setRSSI(uint8 rSSI) {
    if(rSSI!=_RSSIProperty.getRSSI()) {
        _RSSIProperty.setRSSI(rSSI);
        sendRSSIUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 Device1Stub::getRSSI() const {
    return _RSSIProperty.getRSSI();
}

void Device1Stub::sendVendorUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VendorUpdate payload(_VendorProperty);

        LOG_INFO ("-> send%s", "VendorUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Vendor", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VendorUpdate");
    }
}

void Device1Stub::onVendorGet(const ::boost::shared_ptr< VendorGet >& vendor) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VendorGet", vendor->getAct());
    sendVendorGetUpdate(_VendorProperty.getVendor(), vendor->getAct());
}

void Device1Stub::sendVendorGetUpdate(uint16 vendor, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VendorGet payload(vendor);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VendorGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setVendor(uint16 vendor) {
    if(vendor!=_VendorProperty.getVendor()) {
        _VendorProperty.setVendor(vendor);
        sendVendorUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Device1Stub::getVendor() const {
    return _VendorProperty.getVendor();
}

void Device1Stub::sendVendorSourceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VendorSourceUpdate payload(_VendorSourceProperty);

        LOG_INFO ("-> send%s", "VendorSourceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("VendorSource", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VendorSourceUpdate");
    }
}

void Device1Stub::onVendorSourceGet(const ::boost::shared_ptr< VendorSourceGet >& vendorSource) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VendorSourceGet", vendorSource->getAct());
    sendVendorSourceGetUpdate(_VendorSourceProperty.getVendorSource(), vendorSource->getAct());
}

void Device1Stub::sendVendorSourceGetUpdate(uint16 vendorSource, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VendorSourceGet payload(vendorSource);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VendorSourceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setVendorSource(uint16 vendorSource) {
    if(vendorSource!=_VendorSourceProperty.getVendorSource()) {
        _VendorSourceProperty.setVendorSource(vendorSource);
        sendVendorSourceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Device1Stub::getVendorSource() const {
    return _VendorSourceProperty.getVendorSource();
}

void Device1Stub::sendProductUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ProductUpdate payload(_ProductProperty);

        LOG_INFO ("-> send%s", "ProductUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Product", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ProductUpdate");
    }
}

void Device1Stub::onProductGet(const ::boost::shared_ptr< ProductGet >& product) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ProductGet", product->getAct());
    sendProductGetUpdate(_ProductProperty.getProduct(), product->getAct());
}

void Device1Stub::sendProductGetUpdate(uint16 product, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ProductGet payload(product);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ProductGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setProduct(uint16 product) {
    if(product!=_ProductProperty.getProduct()) {
        _ProductProperty.setProduct(product);
        sendProductUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Device1Stub::getProduct() const {
    return _ProductProperty.getProduct();
}

void Device1Stub::sendMapInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        MapInfoUpdate payload(_MapInfoProperty);

        LOG_INFO ("-> send%s", "MapInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("MapInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "MapInfoUpdate");
    }
}

void Device1Stub::onMapInfoGet(const ::boost::shared_ptr< MapInfoGet >& mapInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "MapInfoGet", mapInfo->getAct());
    sendMapInfoGetUpdate(_MapInfoProperty.getMapInfo(), mapInfo->getAct());
}

void Device1Stub::sendMapInfoGetUpdate(const ::std::vector< ::std::string >& mapInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    MapInfoGet payload(mapInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "MapInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setMapInfo(const ::std::vector< ::std::string >& mapInfo) {
    if(mapInfo!=_MapInfoProperty.getMapInfo()) {
        _MapInfoProperty.setMapInfo(mapInfo);
        sendMapInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< ::std::string >& Device1Stub::getMapInfo() const {
    return _MapInfoProperty.getMapInfo();
}

::std::vector< ::std::string >& Device1Stub::getMapInfoMutable() {
    return _MapInfoProperty.getMapInfoMutable();
}

void Device1Stub::sendConnectedServiceUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ConnectedServiceUpdate payload(_ConnectedServiceProperty);

        LOG_INFO ("-> send%s", "ConnectedServiceUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("ConnectedService", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ConnectedServiceUpdate");
    }
}

void Device1Stub::onConnectedServiceGet(const ::boost::shared_ptr< ConnectedServiceGet >& connectedService) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ConnectedServiceGet", connectedService->getAct());
    sendConnectedServiceGetUpdate(_ConnectedServiceProperty.getConnectedService(), connectedService->getAct());
}

void Device1Stub::sendConnectedServiceGetUpdate(uint64 connectedService, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ConnectedServiceGet payload(connectedService);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ConnectedServiceGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setConnectedService(uint64 connectedService) {
    if(connectedService!=_ConnectedServiceProperty.getConnectedService()) {
        _ConnectedServiceProperty.setConnectedService(connectedService);
        sendConnectedServiceUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint64 Device1Stub::getConnectedService() const {
    return _ConnectedServiceProperty.getConnectedService();
}

void Device1Stub::sendVersionUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        VersionUpdate payload(_VersionProperty);

        LOG_INFO ("-> send%s", "VersionUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Version", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "VersionUpdate");
    }
}

void Device1Stub::onVersionGet(const ::boost::shared_ptr< VersionGet >& version) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "VersionGet", version->getAct());
    sendVersionGetUpdate(_VersionProperty.getVersion(), version->getAct());
}

void Device1Stub::sendVersionGetUpdate(uint16 version, act_t act) {
    ::asf::dbus::DBusVariant variant;
    VersionGet payload(version);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "VersionGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setVersion(uint16 version) {
    if(version!=_VersionProperty.getVersion()) {
        _VersionProperty.setVersion(version);
        sendVersionUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint16 Device1Stub::getVersion() const {
    return _VersionProperty.getVersion();
}

void Device1Stub::sendPBAPInfoUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        PBAPInfoUpdate payload(_PBAPInfoProperty);

        LOG_INFO ("-> send%s", "PBAPInfoUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("PBAPInfo", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "PBAPInfoUpdate");
    }
}

void Device1Stub::onPBAPInfoGet(const ::boost::shared_ptr< PBAPInfoGet >& pBAPInfo) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "PBAPInfoGet", pBAPInfo->getAct());
    sendPBAPInfoGetUpdate(_PBAPInfoProperty.getPBAPInfo(), pBAPInfo->getAct());
}

void Device1Stub::sendPBAPInfoGetUpdate(const ::std::string& pBAPInfo, act_t act) {
    ::asf::dbus::DBusVariant variant;
    PBAPInfoGet payload(pBAPInfo);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "PBAPInfoGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setPBAPInfo(const ::std::string& pBAPInfo) {
    if(pBAPInfo!=_PBAPInfoProperty.getPBAPInfo()) {
        _PBAPInfoProperty.setPBAPInfo(pBAPInfo);
        sendPBAPInfoUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& Device1Stub::getPBAPInfo() const {
    return _PBAPInfoProperty.getPBAPInfo();
}

::std::string& Device1Stub::getPBAPInfoMutable() {
    return _PBAPInfoProperty.getPBAPInfoMutable();
}

void Device1Stub::sendModeUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        ModeUpdate payload(_ModeProperty);

        LOG_INFO ("-> send%s", "ModeUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Mode", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "ModeUpdate");
    }
}

void Device1Stub::onModeGet(const ::boost::shared_ptr< ModeGet >& mode) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "ModeGet", mode->getAct());
    sendModeGetUpdate(_ModeProperty.getMode(), mode->getAct());
}

void Device1Stub::sendModeGetUpdate(uint8 mode, act_t act) {
    ::asf::dbus::DBusVariant variant;
    ModeGet payload(mode);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "ModeGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setMode(uint8 mode) {
    if(mode!=_ModeProperty.getMode()) {
        _ModeProperty.setMode(mode);
        sendModeUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 Device1Stub::getMode() const {
    return _ModeProperty.getMode();
}

void Device1Stub::sendRoleUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        RoleUpdate payload(_RoleProperty);

        LOG_INFO ("-> send%s", "RoleUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("Role", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "RoleUpdate");
    }
}

void Device1Stub::onRoleGet(const ::boost::shared_ptr< RoleGet >& role) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "RoleGet", role->getAct());
    sendRoleGetUpdate(_RoleProperty.getRole(), role->getAct());
}

void Device1Stub::sendRoleGetUpdate(uint8 role, act_t act) {
    ::asf::dbus::DBusVariant variant;
    RoleGet payload(role);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "RoleGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::setRole(uint8 role) {
    if(role!=_RoleProperty.getRole()) {
        _RoleProperty.setRole(role);
        sendRoleUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

uint8 Device1Stub::getRole() const {
    return _RoleProperty.getRole();
}

void Device1Stub::sendEnableAvpPauseUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        EnableAvpPauseUpdate payload(_EnableAvpPauseProperty);

        LOG_INFO ("-> send%s", "EnableAvpPauseUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("EnableAvpPause", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Device1", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "EnableAvpPauseUpdate");
    }
}

void Device1Stub::onEnableAvpPauseGet(const ::boost::shared_ptr< EnableAvpPauseGet >& enableAvpPause) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnableAvpPauseGet", enableAvpPause->getAct());
    sendEnableAvpPauseGetUpdate(_EnableAvpPauseProperty.getEnableAvpPause(), enableAvpPause->getAct());
}

void Device1Stub::sendEnableAvpPauseGetUpdate(bool enableAvpPause, act_t act) {
    ::asf::dbus::DBusVariant variant;
    EnableAvpPauseGet payload(enableAvpPause);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnableAvpPauseGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void Device1Stub::onEnableAvpPauseSet(const ::boost::shared_ptr< EnableAvpPauseSet >& enableAvpPause) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "EnableAvpPauseSet", enableAvpPause->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*enableAvpPause, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setEnableAvpPause (enableAvpPause->getEnableAvpPause());
    sendEnableAvpPauseSetUpdate(enableAvpPause->getAct());
}

void Device1Stub::sendEnableAvpPauseSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "EnableAvpPauseSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void Device1Stub::setEnableAvpPause(bool enableAvpPause) {
    if(enableAvpPause!=_EnableAvpPauseProperty.getEnableAvpPause()) {
        _EnableAvpPauseProperty.setEnableAvpPause(enableAvpPause);
        sendEnableAvpPauseUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

bool Device1Stub::getEnableAvpPause() const {
    return _EnableAvpPauseProperty.getEnableAvpPause();
}

void  Device1Stub::sendConnectResponse (act_t act) {
    ConnectResponse* payload = new ConnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Connect", ConnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectError* payload = new ConnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Connect", ConnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendPairResponse (act_t act) {
    PairResponse* payload = new PairResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Pair", PairResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Pair", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendPairError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    PairError* payload = new PairError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Pair", PairError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Pair", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendCancelPairingResponse (act_t act) {
    CancelPairingResponse* payload = new CancelPairingResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelPairing", CancelPairingResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelPairing", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendCancelPairingError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelPairingError* payload = new CancelPairingError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelPairing", CancelPairingError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelPairing", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendDiscoverServicesResponse (act_t act) {
    DiscoverServicesResponse* payload = new DiscoverServicesResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DiscoverServices", DiscoverServicesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DiscoverServices", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendDiscoverServicesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DiscoverServicesError* payload = new DiscoverServicesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DiscoverServices", DiscoverServicesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DiscoverServices", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendCancelDiscoveryResponse (act_t act) {
    CancelDiscoveryResponse* payload = new CancelDiscoveryResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "CancelDiscovery", CancelDiscoveryResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "CancelDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  Device1Stub::sendCancelDiscoveryError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    CancelDiscoveryError* payload = new CancelDiscoveryError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "CancelDiscovery", CancelDiscoveryError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "CancelDiscovery", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void Device1Stub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'Address'
    {
        ::asf::dbus::DBusVariant variant;
        AddressGet payload(_AddressProperty.getAddress());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Address", variant));
    }

    //property 'Class'
    {
        ::asf::dbus::DBusVariant variant;
        ClassGet payload(_ClassProperty.getClass());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Class", variant));
    }

    //property 'Icon'
    {
        ::asf::dbus::DBusVariant variant;
        IconGet payload(_IconProperty.getIcon());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Icon", variant));
    }

    //property 'UUIDs'
    {
        ::asf::dbus::DBusVariant variant;
        UUIDsGet payload(_UUIDsProperty.getUUIDs());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("UUIDs", variant));
    }

    //property 'Paired'
    {
        ::asf::dbus::DBusVariant variant;
        PairedGet payload(_PairedProperty.getPaired());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Paired", variant));
    }

    //property 'Connected'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectedGet payload(_ConnectedProperty.getConnected());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Connected", variant));
    }

    //property 'Trusted'
    {
        ::asf::dbus::DBusVariant variant;
        TrustedGet payload(_TrustedProperty.getTrusted());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Trusted", variant));
    }

    //property 'Blocked'
    {
        ::asf::dbus::DBusVariant variant;
        BlockedGet payload(_BlockedProperty.getBlocked());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Blocked", variant));
    }

    //property 'Alias'
    {
        ::asf::dbus::DBusVariant variant;
        AliasGet payload(_AliasProperty.getAlias());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Alias", variant));
    }

    //property 'Adapter'
    {
        ::asf::dbus::DBusVariant variant;
        AdapterGet payload(_AdapterProperty.getAdapter());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Adapter", variant));
    }

    //property 'Modalias'
    {
        ::asf::dbus::DBusVariant variant;
        ModaliasGet payload(_ModaliasProperty.getModalias());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Modalias", variant));
    }

    //property 'RSSI'
    {
        ::asf::dbus::DBusVariant variant;
        RSSIGet payload(_RSSIProperty.getRSSI());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("RSSI", variant));
    }

    //property 'Vendor'
    {
        ::asf::dbus::DBusVariant variant;
        VendorGet payload(_VendorProperty.getVendor());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Vendor", variant));
    }

    //property 'VendorSource'
    {
        ::asf::dbus::DBusVariant variant;
        VendorSourceGet payload(_VendorSourceProperty.getVendorSource());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("VendorSource", variant));
    }

    //property 'Product'
    {
        ::asf::dbus::DBusVariant variant;
        ProductGet payload(_ProductProperty.getProduct());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Product", variant));
    }

    //property 'MapInfo'
    {
        ::asf::dbus::DBusVariant variant;
        MapInfoGet payload(_MapInfoProperty.getMapInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("MapInfo", variant));
    }

    //property 'ConnectedService'
    {
        ::asf::dbus::DBusVariant variant;
        ConnectedServiceGet payload(_ConnectedServiceProperty.getConnectedService());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("ConnectedService", variant));
    }

    //property 'Version'
    {
        ::asf::dbus::DBusVariant variant;
        VersionGet payload(_VersionProperty.getVersion());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Version", variant));
    }

    //property 'PBAPInfo'
    {
        ::asf::dbus::DBusVariant variant;
        PBAPInfoGet payload(_PBAPInfoProperty.getPBAPInfo());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("PBAPInfo", variant));
    }

    //property 'Mode'
    {
        ::asf::dbus::DBusVariant variant;
        ModeGet payload(_ModeProperty.getMode());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Mode", variant));
    }

    //property 'Role'
    {
        ::asf::dbus::DBusVariant variant;
        RoleGet payload(_RoleProperty.getRole());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("Role", variant));
    }

    //property 'EnableAvpPause'
    {
        ::asf::dbus::DBusVariant variant;
        EnableAvpPauseGet payload(_EnableAvpPauseProperty.getEnableAvpPause());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("EnableAvpPause", variant));
    }
}

} // namespace Device1
} // namespace bluez
} // namespace org
