/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENTSTUB_H
#define ORG_BLUEZ_AGENTSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Agent.h"
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace Agent {

class AgentStubDelegate;

class AgentStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AgentStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AgentStub (const std::string& portName);

    /**
     * Create an instance of the AgentStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AgentStub (const std::string& portName, const std::string& objectPath);

    virtual ~AgentStub();

    // method 'Release'

    /**
     * The method onRelease() is called by ASF when a client invokes the
     * method 'Release'. A subclass has to implement this method and send back
     * a response to the client either with the sendRelease() or
     * sendReleaseError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onReleaseRequest (const ::boost::shared_ptr< ReleaseRequest >& request) = 0;

    /**
     * The method sendReleaseResponse() sends a response of a previous method
     * invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRelease(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendReleaseResponse (act_t act = 0);

    /**
     * The method sendReleaseError() sends an error response of a previous
     * method invocation of 'Release' back to the client.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRelease(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendReleaseError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestPinCode'

    /**
     * The method onRequestPinCode() is called by ASF when a client invokes
     * the method 'RequestPinCode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRequestPinCode() or sendRequestPinCodeError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RequestPinCode'</b>:
     *
     * If the meaning of "RequestPinCode" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestPinCodeRequest (const ::boost::shared_ptr< RequestPinCodeRequest >& request) = 0;

    /**
     * The method sendRequestPinCodeResponse() sends a response of a previous
     * method invocation of 'RequestPinCode' back to the client.
     *
     * <b>Documentation of 'RequestPinCode'</b>:
     *
     * If the meaning of "RequestPinCode" isn't clear, then there should be a description here.
     *
     * @param pincode If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestPinCode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRequestPinCodeResponse (const ::std::string& pincode, act_t act = 0);

    /**
     * The method sendRequestPinCodeError() sends an error response of a
     * previous method invocation of 'RequestPinCode' back to the client.
     *
     * <b>Documentation of 'RequestPinCode'</b>:
     *
     * If the meaning of "RequestPinCode" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestPinCode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestPinCodeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DisplayPinCode'

    /**
     * The method onDisplayPinCode() is called by ASF when a client invokes
     * the method 'DisplayPinCode'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDisplayPinCode() or sendDisplayPinCodeError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'DisplayPinCode'</b>:
     *
     * If the meaning of "DisplayPinCode" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisplayPinCodeRequest (const ::boost::shared_ptr< DisplayPinCodeRequest >& request) = 0;

    /**
     * The method sendDisplayPinCodeResponse() sends a response of a previous
     * method invocation of 'DisplayPinCode' back to the client.
     *
     * <b>Documentation of 'DisplayPinCode'</b>:
     *
     * If the meaning of "DisplayPinCode" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisplayPinCode(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisplayPinCodeResponse (act_t act = 0);

    /**
     * The method sendDisplayPinCodeError() sends an error response of a
     * previous method invocation of 'DisplayPinCode' back to the client.
     *
     * <b>Documentation of 'DisplayPinCode'</b>:
     *
     * If the meaning of "DisplayPinCode" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisplayPinCode(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisplayPinCodeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestPasskey'

    /**
     * The method onRequestPasskey() is called by ASF when a client invokes
     * the method 'RequestPasskey'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRequestPasskey() or sendRequestPasskeyError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RequestPasskey'</b>:
     *
     * If the meaning of "RequestPasskey" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestPasskeyRequest (const ::boost::shared_ptr< RequestPasskeyRequest >& request) = 0;

    /**
     * The method sendRequestPasskeyResponse() sends a response of a previous
     * method invocation of 'RequestPasskey' back to the client.
     *
     * <b>Documentation of 'RequestPasskey'</b>:
     *
     * If the meaning of "RequestPasskey" isn't clear, then there should be a description here.
     *
     * @param passkey If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestPasskey(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRequestPasskeyResponse (uint32 passkey, act_t act = 0);

    /**
     * The method sendRequestPasskeyError() sends an error response of a
     * previous method invocation of 'RequestPasskey' back to the client.
     *
     * <b>Documentation of 'RequestPasskey'</b>:
     *
     * If the meaning of "RequestPasskey" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestPasskey(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestPasskeyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestConfirmation'

    /**
     * The method onRequestConfirmation() is called by ASF when a client
     * invokes the method 'RequestConfirmation'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestConfirmation() or sendRequestConfirmationError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RequestConfirmation'</b>:
     *
     * If the meaning of "RequestConfirmation" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestConfirmationRequest (const ::boost::shared_ptr< RequestConfirmationRequest >& request) = 0;

    /**
     * The method sendRequestConfirmationResponse() sends a response of a
     * previous method invocation of 'RequestConfirmation' back to the client.
     *
     * <b>Documentation of 'RequestConfirmation'</b>:
     *
     * If the meaning of "RequestConfirmation" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestConfirmation(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestConfirmationResponse (act_t act = 0);

    /**
     * The method sendRequestConfirmationError() sends an error response of a
     * previous method invocation of 'RequestConfirmation' back to the client.
     *
     * <b>Documentation of 'RequestConfirmation'</b>:
     *
     * If the meaning of "RequestConfirmation" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestConfirmation().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestConfirmationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Cancel'

    /**
     * The method onCancel() is called by ASF when a client invokes the method
     * 'Cancel'. A subclass has to implement this method and send back a
     * response to the client either with the sendCancel() or
     * sendCancelError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRequest (const ::boost::shared_ptr< CancelRequest >& request) = 0;

    /**
     * The method sendCancelResponse() sends a response of a previous method
     * invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancel(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelResponse (act_t act = 0);

    /**
     * The method sendCancelError() sends an error response of a previous
     * method invocation of 'Cancel' back to the client.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancel(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendCancelError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'CancelRequest'

    /**
     * The method onCancelRequest() is called by ASF when a client invokes the
     * method 'CancelRequest'. A subclass has to implement this method and
     * send back a response to the client either with the sendCancelRequest()
     * or sendCancelRequestError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'CancelRequest'</b>:
     *
     * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onCancelRequestRequest (const ::boost::shared_ptr< CancelRequestRequest >& request) = 0;

    /**
     * The method sendCancelRequestResponse() sends a response of a previous
     * method invocation of 'CancelRequest' back to the client.
     *
     * <b>Documentation of 'CancelRequest'</b>:
     *
     * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onCancelRequest(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendCancelRequestResponse (act_t act = 0);

    /**
     * The method sendCancelRequestError() sends an error response of a
     * previous method invocation of 'CancelRequest' back to the client.
     *
     * <b>Documentation of 'CancelRequest'</b>:
     *
     * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onCancelRequest(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendCancelRequestError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'AuthorizeService'

    /**
     * The method onAuthorizeService() is called by ASF when a client invokes
     * the method 'AuthorizeService'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendAuthorizeService() or sendAuthorizeServiceError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'AuthorizeService'</b>:
     *
     * If the meaning of "AuthorizeService" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onAuthorizeServiceRequest (const ::boost::shared_ptr< AuthorizeServiceRequest >& request) = 0;

    /**
     * The method sendAuthorizeServiceResponse() sends a response of a
     * previous method invocation of 'AuthorizeService' back to the client.
     *
     * <b>Documentation of 'AuthorizeService'</b>:
     *
     * If the meaning of "AuthorizeService" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onAuthorizeService(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendAuthorizeServiceResponse (act_t act = 0);

    /**
     * The method sendAuthorizeServiceError() sends an error response of a
     * previous method invocation of 'AuthorizeService' back to the client.
     *
     * <b>Documentation of 'AuthorizeService'</b>:
     *
     * If the meaning of "AuthorizeService" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onAuthorizeService(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendAuthorizeServiceError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestAuthorization'

    /**
     * The method onRequestAuthorization() is called by ASF when a client
     * invokes the method 'RequestAuthorization'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestAuthorization() or sendRequestAuthorizationError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'RequestAuthorization'</b>:
     *
     * If the meaning of "RequestAuthorization" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestAuthorizationRequest (const ::boost::shared_ptr< RequestAuthorizationRequest >& request) = 0;

    /**
     * The method sendRequestAuthorizationResponse() sends a response of a
     * previous method invocation of 'RequestAuthorization' back to the
     * client.
     *
     * <b>Documentation of 'RequestAuthorization'</b>:
     *
     * If the meaning of "RequestAuthorization" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestAuthorization(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestAuthorizationResponse (act_t act = 0);

    /**
     * The method sendRequestAuthorizationError() sends an error response of a
     * previous method invocation of 'RequestAuthorization' back to the
     * client.
     *
     * <b>Documentation of 'RequestAuthorization'</b>:
     *
     * If the meaning of "RequestAuthorization" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onRequestAuthorization(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestAuthorizationError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestLinkkey'

    /**
     * The method onRequestLinkkey() is called by ASF when a client invokes
     * the method 'RequestLinkkey'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendRequestLinkkey() or sendRequestLinkkeyError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'RequestLinkkey'</b>:
     *
     * If the meaning of "RequestLinkkey" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestLinkkeyRequest (const ::boost::shared_ptr< RequestLinkkeyRequest >& request) = 0;

    /**
     * The method sendRequestLinkkeyResponse() sends a response of a previous
     * method invocation of 'RequestLinkkey' back to the client.
     *
     * <b>Documentation of 'RequestLinkkey'</b>:
     *
     * If the meaning of "RequestLinkkey" isn't clear, then there should be a description here.
     *
     * @param linkkey If the meaning of "linkkey" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestLinkkey(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRequestLinkkeyResponse (const ::std::vector< uint8 >& linkkey, act_t act = 0);

    /**
     * The method sendRequestLinkkeyError() sends an error response of a
     * previous method invocation of 'RequestLinkkey' back to the client.
     *
     * <b>Documentation of 'RequestLinkkey'</b>:
     *
     * If the meaning of "RequestLinkkey" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestLinkkey(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestLinkkeyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'DisplayPasskey'

    /**
     * The method onDisplayPasskey() is called by ASF when a client invokes
     * the method 'DisplayPasskey'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDisplayPasskey() or sendDisplayPasskeyError() method. Do not invoke
     * this method on your own.
     *
     * <b>Documentation of 'DisplayPasskey'</b>:
     *
     * If the meaning of "DisplayPasskey" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisplayPasskeyRequest (const ::boost::shared_ptr< DisplayPasskeyRequest >& request) = 0;

    /**
     * The method sendDisplayPasskeyResponse() sends a response of a previous
     * method invocation of 'DisplayPasskey' back to the client.
     *
     * <b>Documentation of 'DisplayPasskey'</b>:
     *
     * If the meaning of "DisplayPasskey" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisplayPasskey(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisplayPasskeyResponse (act_t act = 0);

    /**
     * The method sendDisplayPasskeyError() sends an error response of a
     * previous method invocation of 'DisplayPasskey' back to the client.
     *
     * <b>Documentation of 'DisplayPasskey'</b>:
     *
     * If the meaning of "DisplayPasskey" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisplayPasskey(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDisplayPasskeyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class AgentStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Agent
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENTSTUB_H
