/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENTPROXY_H
#define ORG_BLUEZ_AGENTPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/bluez/Agent.h"
#include <dbus/dbus.h>
#include <string>

namespace org {
namespace bluez {
namespace Agent {

class AgentProxy;

class AuthorizeServiceCallbackIF {
public:
    virtual ~AuthorizeServiceCallbackIF() {}

    virtual void onAuthorizeServiceError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< AuthorizeServiceError >& error) = 0;

    virtual void onAuthorizeServiceResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< AuthorizeServiceResponse >& response) = 0;
};

class CancelCallbackIF {
public:
    virtual ~CancelCallbackIF() {}

    virtual void onCancelError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelError >& error) = 0;

    virtual void onCancelResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelResponse >& response) = 0;
};

class CancelRequestCallbackIF {
public:
    virtual ~CancelRequestCallbackIF() {}

    virtual void onCancelRequestError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelRequestError >& error) = 0;

    virtual void onCancelRequestResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< CancelRequestResponse >& response) = 0;
};

class DisplayPasskeyCallbackIF {
public:
    virtual ~DisplayPasskeyCallbackIF() {}

    virtual void onDisplayPasskeyError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< DisplayPasskeyError >& error) = 0;

    virtual void onDisplayPasskeyResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< DisplayPasskeyResponse >& response) = 0;
};

class DisplayPinCodeCallbackIF {
public:
    virtual ~DisplayPinCodeCallbackIF() {}

    virtual void onDisplayPinCodeError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< DisplayPinCodeError >& error) = 0;

    virtual void onDisplayPinCodeResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< DisplayPinCodeResponse >& response) = 0;
};

class ReleaseCallbackIF {
public:
    virtual ~ReleaseCallbackIF() {}

    virtual void onReleaseError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReleaseError >& error) = 0;

    virtual void onReleaseResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< ReleaseResponse >& response) = 0;
};

class RequestAuthorizationCallbackIF {
public:
    virtual ~RequestAuthorizationCallbackIF() {}

    virtual void onRequestAuthorizationError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestAuthorizationError >& error) = 0;

    virtual void onRequestAuthorizationResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestAuthorizationResponse >& response) = 0;
};

class RequestConfirmationCallbackIF {
public:
    virtual ~RequestConfirmationCallbackIF() {}

    virtual void onRequestConfirmationError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestConfirmationError >& error) = 0;

    virtual void onRequestConfirmationResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestConfirmationResponse >& response) = 0;
};

class RequestLinkkeyCallbackIF {
public:
    virtual ~RequestLinkkeyCallbackIF() {}

    virtual void onRequestLinkkeyError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestLinkkeyError >& error) = 0;

    virtual void onRequestLinkkeyResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestLinkkeyResponse >& response) = 0;
};

class RequestPasskeyCallbackIF {
public:
    virtual ~RequestPasskeyCallbackIF() {}

    virtual void onRequestPasskeyError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestPasskeyError >& error) = 0;

    virtual void onRequestPasskeyResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestPasskeyResponse >& response) = 0;
};

class RequestPinCodeCallbackIF {
public:
    virtual ~RequestPinCodeCallbackIF() {}

    virtual void onRequestPinCodeError(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestPinCodeError >& error) = 0;

    virtual void onRequestPinCodeResponse(const ::boost::shared_ptr< AgentProxy >& proxy, const ::boost::shared_ptr< RequestPinCodeResponse >& response) = 0;
};


/**
 * AgentProxy is the client side representation of the D-Bus service
 * interface 'org.bluez.Agent' (specified in file
 * stack_component_agent.xml).
 *
 * If the meaning of "org.bluez.Agent" isn't clear, then there should be a description here.
 */
class AgentProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of AgentProxy.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of AgentProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of AgentProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< AgentProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< AgentProxy > proxyNew(new AgentProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~AgentProxy ();




    // Method 'Release'

    /**
     * Call the method 'Release'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Release'</b>:
     *
     * If the meaning of "Release" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendReleaseRequest(ReleaseCallbackIF& cb) const;

    // Method 'RequestPinCode'

    /**
     * Call the method 'RequestPinCode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestPinCode'</b>:
     *
     * If the meaning of "RequestPinCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPinCodeRequest(RequestPinCodeCallbackIF& cb, const ::std::string& device) const;

    // Method 'DisplayPinCode'

    /**
     * Call the method 'DisplayPinCode'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DisplayPinCode'</b>:
     *
     * If the meaning of "DisplayPinCode" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param pincode If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisplayPinCodeRequest(DisplayPinCodeCallbackIF& cb, const ::std::string& device, const ::std::string& pincode) const;

    // Method 'RequestPasskey'

    /**
     * Call the method 'RequestPasskey'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestPasskey'</b>:
     *
     * If the meaning of "RequestPasskey" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestPasskeyRequest(RequestPasskeyCallbackIF& cb, const ::std::string& device) const;

    // Method 'RequestConfirmation'

    /**
     * Call the method 'RequestConfirmation'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RequestConfirmation'</b>:
     *
     * If the meaning of "RequestConfirmation" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param passkey If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestConfirmationRequest(RequestConfirmationCallbackIF& cb, const ::std::string& device, uint32 passkey) const;

    // Method 'Cancel'

    /**
     * Call the method 'Cancel'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Cancel'</b>:
     *
     * If the meaning of "Cancel" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequest(CancelCallbackIF& cb) const;

    // Method 'CancelRequest'

    /**
     * Call the method 'CancelRequest'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CancelRequest'</b>:
     *
     * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCancelRequestRequest(CancelRequestCallbackIF& cb, const ::std::string& device) const;

    // Method 'AuthorizeService'

    /**
     * Call the method 'AuthorizeService'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'AuthorizeService'</b>:
     *
     * If the meaning of "AuthorizeService" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param uuid If the meaning of "uuid" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendAuthorizeServiceRequest(AuthorizeServiceCallbackIF& cb, const ::std::string& device, const ::std::string& uuid) const;

    // Method 'RequestAuthorization'

    /**
     * Call the method 'RequestAuthorization'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'RequestAuthorization'</b>:
     *
     * If the meaning of "RequestAuthorization" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestAuthorizationRequest(RequestAuthorizationCallbackIF& cb, const ::std::string& device) const;

    // Method 'RequestLinkkey'

    /**
     * Call the method 'RequestLinkkey'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RequestLinkkey'</b>:
     *
     * If the meaning of "RequestLinkkey" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRequestLinkkeyRequest(RequestLinkkeyCallbackIF& cb, const ::std::string& device) const;

    // Method 'DisplayPasskey'

    /**
     * Call the method 'DisplayPasskey'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DisplayPasskey'</b>:
     *
     * If the meaning of "DisplayPasskey" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param device If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param passkey If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @param entered If the meaning of "entered" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDisplayPasskeyRequest(DisplayPasskeyCallbackIF& cb, const ::std::string& device, uint32 passkey, uint8 entered) const;


private:

    AgentProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class AgentProxyCallback;
};

} // namespace Agent
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENTPROXY_H
