/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Agent.h"
#include "org/bluez/AgentDBus.h"
#include "org/bluez/AgentJson.h"
#include "org/bluez/AgentProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Agent {

DEFINE_CLASS_LOGGER("//org/bosch/genivi/org/bluez/Agent", AgentProxy);

class AgentProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AgentProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AgentProxy >& proxyShared = ::boost::static_pointer_cast< AgentProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Release:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseError> payload = ::boost::static_pointer_cast<ReleaseError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseCallbackIF*) _callback)->onReleaseError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ReleaseResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Release", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ReleaseResponse> payload = ::boost::static_pointer_cast<ReleaseResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ReleaseCallbackIF*) _callback)->onReleaseResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestPinCode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestPinCodeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPinCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPinCodeError> payload = ::boost::static_pointer_cast<RequestPinCodeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPinCodeCallbackIF*) _callback)->onRequestPinCodeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPinCodeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPinCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPinCodeResponse> payload = ::boost::static_pointer_cast<RequestPinCodeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPinCodeCallbackIF*) _callback)->onRequestPinCodeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DisplayPinCode:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPinCodeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayPinCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayPinCodeError> payload = ::boost::static_pointer_cast<DisplayPinCodeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayPinCodeCallbackIF*) _callback)->onDisplayPinCodeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPinCodeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayPinCode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayPinCodeResponse> payload = ::boost::static_pointer_cast<DisplayPinCodeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayPinCodeCallbackIF*) _callback)->onDisplayPinCodeResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestPasskey:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestPasskeyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPasskey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPasskeyError> payload = ::boost::static_pointer_cast<RequestPasskeyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPasskeyCallbackIF*) _callback)->onRequestPasskeyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestPasskeyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestPasskey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestPasskeyResponse> payload = ::boost::static_pointer_cast<RequestPasskeyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestPasskeyCallbackIF*) _callback)->onRequestPasskeyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestConfirmation:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestConfirmationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestConfirmation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestConfirmationError> payload = ::boost::static_pointer_cast<RequestConfirmationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestConfirmationCallbackIF*) _callback)->onRequestConfirmationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestConfirmationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestConfirmation", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestConfirmationResponse> payload = ::boost::static_pointer_cast<RequestConfirmationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestConfirmationCallbackIF*) _callback)->onRequestConfirmationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Cancel:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelError> payload = ::boost::static_pointer_cast<CancelError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Cancel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelResponse> payload = ::boost::static_pointer_cast<CancelResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelCallbackIF*) _callback)->onCancelResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CancelRequest:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequestError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelRequestError> payload = ::boost::static_pointer_cast<CancelRequestError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelRequestCallbackIF*) _callback)->onCancelRequestError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CancelRequestResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CancelRequest", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CancelRequestResponse> payload = ::boost::static_pointer_cast<CancelRequestResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CancelRequestCallbackIF*) _callback)->onCancelRequestResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_AuthorizeService:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), AuthorizeServiceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "AuthorizeService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AuthorizeServiceError> payload = ::boost::static_pointer_cast<AuthorizeServiceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AuthorizeServiceCallbackIF*) _callback)->onAuthorizeServiceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AuthorizeServiceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "AuthorizeService", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AuthorizeServiceResponse> payload = ::boost::static_pointer_cast<AuthorizeServiceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((AuthorizeServiceCallbackIF*) _callback)->onAuthorizeServiceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestAuthorization:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestAuthorizationError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestAuthorization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestAuthorizationError> payload = ::boost::static_pointer_cast<RequestAuthorizationError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestAuthorizationCallbackIF*) _callback)->onRequestAuthorizationError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestAuthorizationResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestAuthorization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestAuthorizationResponse> payload = ::boost::static_pointer_cast<RequestAuthorizationResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestAuthorizationCallbackIF*) _callback)->onRequestAuthorizationResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestLinkkey:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestLinkkeyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestLinkkey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestLinkkeyError> payload = ::boost::static_pointer_cast<RequestLinkkeyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestLinkkeyCallbackIF*) _callback)->onRequestLinkkeyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestLinkkeyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestLinkkey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestLinkkeyResponse> payload = ::boost::static_pointer_cast<RequestLinkkeyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestLinkkeyCallbackIF*) _callback)->onRequestLinkkeyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_DisplayPasskey:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPasskeyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayPasskey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayPasskeyError> payload = ::boost::static_pointer_cast<DisplayPasskeyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayPasskeyCallbackIF*) _callback)->onDisplayPasskeyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisplayPasskeyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "DisplayPasskey", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisplayPasskeyResponse> payload = ::boost::static_pointer_cast<DisplayPasskeyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisplayPasskeyCallbackIF*) _callback)->onDisplayPasskeyResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Release: {
                ::boost::shared_ptr< ReleaseError > payload = ::boost::shared_ptr< ReleaseError >
                (new ReleaseError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Release", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ReleaseCallbackIF*) _callback)->onReleaseError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestPinCode: {
                ::boost::shared_ptr< RequestPinCodeError > payload = ::boost::shared_ptr< RequestPinCodeError >
                (new RequestPinCodeError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestPinCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestPinCodeCallbackIF*) _callback)->onRequestPinCodeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisplayPinCode: {
                ::boost::shared_ptr< DisplayPinCodeError > payload = ::boost::shared_ptr< DisplayPinCodeError >
                (new DisplayPinCodeError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisplayPinCode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisplayPinCodeCallbackIF*) _callback)->onDisplayPinCodeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestPasskey: {
                ::boost::shared_ptr< RequestPasskeyError > payload = ::boost::shared_ptr< RequestPasskeyError >
                (new RequestPasskeyError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestPasskey", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestPasskeyCallbackIF*) _callback)->onRequestPasskeyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestConfirmation: {
                ::boost::shared_ptr< RequestConfirmationError > payload = ::boost::shared_ptr< RequestConfirmationError >
                (new RequestConfirmationError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestConfirmation", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestConfirmationCallbackIF*) _callback)->onRequestConfirmationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Cancel: {
                ::boost::shared_ptr< CancelError > payload = ::boost::shared_ptr< CancelError >
                (new CancelError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Cancel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelCallbackIF*) _callback)->onCancelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CancelRequest: {
                ::boost::shared_ptr< CancelRequestError > payload = ::boost::shared_ptr< CancelRequestError >
                (new CancelRequestError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CancelRequest", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CancelRequestCallbackIF*) _callback)->onCancelRequestError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AuthorizeService: {
                ::boost::shared_ptr< AuthorizeServiceError > payload = ::boost::shared_ptr< AuthorizeServiceError >
                (new AuthorizeServiceError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AuthorizeService", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AuthorizeServiceCallbackIF*) _callback)->onAuthorizeServiceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestAuthorization: {
                ::boost::shared_ptr< RequestAuthorizationError > payload = ::boost::shared_ptr< RequestAuthorizationError >
                (new RequestAuthorizationError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestAuthorization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestAuthorizationCallbackIF*) _callback)->onRequestAuthorizationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestLinkkey: {
                ::boost::shared_ptr< RequestLinkkeyError > payload = ::boost::shared_ptr< RequestLinkkeyError >
                (new RequestLinkkeyError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestLinkkey", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestLinkkeyCallbackIF*) _callback)->onRequestLinkkeyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DisplayPasskey: {
                ::boost::shared_ptr< DisplayPasskeyError > payload = ::boost::shared_ptr< DisplayPasskeyError >
                (new DisplayPasskeyError(DBUS_ERROR_NO_SERVER, "The DBus service Agent is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DisplayPasskey", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentProxy> proxyShared = ::boost::static_pointer_cast<AgentProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisplayPasskeyCallbackIF*) _callback)->onDisplayPasskeyError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AgentProxyCallback::_logger (AgentProxy::_logger);

AgentProxy::AgentProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.Agent", serviceAvailable, _logger) {
}

AgentProxy::~AgentProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AgentProxy > AgentProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AgentProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AgentProxy > proxyNew(new AgentProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t AgentProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AgentProxyCallback* callback = new AgentProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AgentProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AgentProxyCallback* callback = new AgentProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t AgentProxy::sendReleaseRequest(ReleaseCallbackIF& cb) const {
    ReleaseRequest* payload = new ReleaseRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Release", ReleaseRequest, payload, true)
    act_t act = addMethodCallback(ID_Release, dbusMessage.getUniqueSerial(), "Release", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Release", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestPinCodeRequest(RequestPinCodeCallbackIF& cb, const ::std::string& device) const {
    RequestPinCodeRequest* payload = new RequestPinCodeRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestPinCode", RequestPinCodeRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestPinCode, dbusMessage.getUniqueSerial(), "RequestPinCode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestPinCode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendDisplayPinCodeRequest(DisplayPinCodeCallbackIF& cb, const ::std::string& device, const ::std::string& pincode) const {
    DisplayPinCodeRequest* payload = new DisplayPinCodeRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    payload->setPincode(pincode);
    DBUS_MESSAGE_CALL(dbusMessage, "DisplayPinCode", DisplayPinCodeRequest, payload, true)
    act_t act = addMethodCallback(ID_DisplayPinCode, dbusMessage.getUniqueSerial(), "DisplayPinCode", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DisplayPinCode", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestPasskeyRequest(RequestPasskeyCallbackIF& cb, const ::std::string& device) const {
    RequestPasskeyRequest* payload = new RequestPasskeyRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestPasskey", RequestPasskeyRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestPasskey, dbusMessage.getUniqueSerial(), "RequestPasskey", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestPasskey", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestConfirmationRequest(RequestConfirmationCallbackIF& cb, const ::std::string& device, uint32 passkey) const {
    RequestConfirmationRequest* payload = new RequestConfirmationRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    payload->setPasskey(passkey);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestConfirmation", RequestConfirmationRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestConfirmation, dbusMessage.getUniqueSerial(), "RequestConfirmation", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestConfirmation", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendCancelRequest(CancelCallbackIF& cb) const {
    CancelRequest* payload = new CancelRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Cancel", CancelRequest, payload, true)
    act_t act = addMethodCallback(ID_Cancel, dbusMessage.getUniqueSerial(), "Cancel", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Cancel", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendCancelRequestRequest(CancelRequestCallbackIF& cb, const ::std::string& device) const {
    CancelRequestRequest* payload = new CancelRequestRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "CancelRequest", CancelRequestRequest, payload, true)
    act_t act = addMethodCallback(ID_CancelRequest, dbusMessage.getUniqueSerial(), "CancelRequest", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CancelRequest", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendAuthorizeServiceRequest(AuthorizeServiceCallbackIF& cb, const ::std::string& device, const ::std::string& uuid) const {
    AuthorizeServiceRequest* payload = new AuthorizeServiceRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    payload->setUuid(uuid);
    DBUS_MESSAGE_CALL(dbusMessage, "AuthorizeService", AuthorizeServiceRequest, payload, true)
    act_t act = addMethodCallback(ID_AuthorizeService, dbusMessage.getUniqueSerial(), "AuthorizeService", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "AuthorizeService", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestAuthorizationRequest(RequestAuthorizationCallbackIF& cb, const ::std::string& device) const {
    RequestAuthorizationRequest* payload = new RequestAuthorizationRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestAuthorization", RequestAuthorizationRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestAuthorization, dbusMessage.getUniqueSerial(), "RequestAuthorization", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestAuthorization", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendRequestLinkkeyRequest(RequestLinkkeyCallbackIF& cb, const ::std::string& device) const {
    RequestLinkkeyRequest* payload = new RequestLinkkeyRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestLinkkey", RequestLinkkeyRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestLinkkey, dbusMessage.getUniqueSerial(), "RequestLinkkey", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestLinkkey", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentProxy::sendDisplayPasskeyRequest(DisplayPasskeyCallbackIF& cb, const ::std::string& device, uint32 passkey, uint8 entered) const {
    DisplayPasskeyRequest* payload = new DisplayPasskeyRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    payload->setPasskey(passkey);
    payload->setEntered(entered);
    DBUS_MESSAGE_CALL(dbusMessage, "DisplayPasskey", DisplayPasskeyRequest, payload, true)
    act_t act = addMethodCallback(ID_DisplayPasskey, dbusMessage.getUniqueSerial(), "DisplayPasskey", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "DisplayPasskey", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Agent
} // namespace bluez
} // namespace org
