/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENTMANAGERSTUB_H
#define ORG_BLUEZ_AGENTMANAGERSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/AgentManager.h"

namespace org {
namespace bluez {
namespace AgentManager {

class AgentManagerStubDelegate;

class AgentManagerStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the AgentManagerStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    AgentManagerStub (const std::string& portName);

    /**
     * Create an instance of the AgentManagerStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    AgentManagerStub (const std::string& portName, const std::string& objectPath);

    virtual ~AgentManagerStub();

    // method 'RegisterAgent'

    /**
     * The method onRegisterAgent() is called by ASF when a client invokes the
     * method 'RegisterAgent'. A subclass has to implement this method and
     * send back a response to the client either with the sendRegisterAgent()
     * or sendRegisterAgentError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * possible values for capability:
     * DisplayOnly
     * DisplayYesNo
     * KeyboardOnly
     * NoInputNoOutput
     * KeyboardDisplay
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRegisterAgentRequest (const ::boost::shared_ptr< RegisterAgentRequest >& request) = 0;

    /**
     * The method sendRegisterAgentResponse() sends a response of a previous
     * method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * possible values for capability:
     * DisplayOnly
     * DisplayYesNo
     * KeyboardOnly
     * NoInputNoOutput
     * KeyboardDisplay
     *
     * @param act The parameter act identifies a previous invocation of
     * onRegisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendRegisterAgentResponse (act_t act = 0);

    /**
     * The method sendRegisterAgentError() sends an error response of a
     * previous method invocation of 'RegisterAgent' back to the client.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * possible values for capability:
     * DisplayOnly
     * DisplayYesNo
     * KeyboardOnly
     * NoInputNoOutput
     * KeyboardDisplay
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRegisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'UnregisterAgent'

    /**
     * The method onUnregisterAgent() is called by ASF when a client invokes
     * the method 'UnregisterAgent'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendUnregisterAgent() or sendUnregisterAgentError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onUnregisterAgentRequest (const ::boost::shared_ptr< UnregisterAgentRequest >& request) = 0;

    /**
     * The method sendUnregisterAgentResponse() sends a response of a previous
     * method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onUnregisterAgent(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendUnregisterAgentResponse (act_t act = 0);

    /**
     * The method sendUnregisterAgentError() sends an error response of a
     * previous method invocation of 'UnregisterAgent' back to the client.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onUnregisterAgent(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'RequestDefaultAgent'

    /**
     * The method onRequestDefaultAgent() is called by ASF when a client
     * invokes the method 'RequestDefaultAgent'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendRequestDefaultAgent() or sendRequestDefaultAgentError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'RequestDefaultAgent'</b>:
     *
     * If the meaning of "RequestDefaultAgent" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onRequestDefaultAgentRequest (const ::boost::shared_ptr< RequestDefaultAgentRequest >& request) = 0;

    /**
     * The method sendRequestDefaultAgentResponse() sends a response of a
     * previous method invocation of 'RequestDefaultAgent' back to the client.
     *
     * <b>Documentation of 'RequestDefaultAgent'</b>:
     *
     * If the meaning of "RequestDefaultAgent" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onRequestDefaultAgent(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendRequestDefaultAgentResponse (act_t act = 0);

    /**
     * The method sendRequestDefaultAgentError() sends an error response of a
     * previous method invocation of 'RequestDefaultAgent' back to the client.
     *
     * <b>Documentation of 'RequestDefaultAgent'</b>:
     *
     * If the meaning of "RequestDefaultAgent" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onRequestDefaultAgent().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendRequestDefaultAgentError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class AgentManagerStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace AgentManager
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENTMANAGERSTUB_H
