/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/AgentManager.h"
#include "org/bluez/AgentManagerDBus.h"
#include "org/bluez/AgentManagerJson.h"
#include "org/bluez/AgentManagerStub.h"

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace AgentManager {

DEFINE_CLASS_LOGGER("//org/bluez/org/bluez/AgentManager", AgentManagerStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 13, "RegisterAgent", 0 },
    { 15, "UnregisterAgent", 1 },
    { 19, "RequestDefaultAgent", 2 },
};


class AgentManagerStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    AgentManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    AgentManagerStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    AgentManagerStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.AgentManager"),
          _logger(logger) {}

    virtual ~AgentManagerStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void AgentManagerStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'RegisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "RegisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RegisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RegisterAgentRequest > payload = ::boost::static_pointer_cast<RegisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentManagerStub*>(getStub())->onRegisterAgentRequest(payload);
            return;
        }
        case 1: {

            // method 'UnregisterAgent'

            LOG_DEBUG_STUB("process method '%s'", "UnregisterAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "UnregisterAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< UnregisterAgentRequest > payload = ::boost::static_pointer_cast<UnregisterAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentManagerStub*>(getStub())->onUnregisterAgentRequest(payload);
            return;
        }
        case 2: {

            // method 'RequestDefaultAgent'

            LOG_DEBUG_STUB("process method '%s'", "RequestDefaultAgent");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDefaultAgentRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "RequestDefaultAgent", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RequestDefaultAgentRequest > payload = ::boost::static_pointer_cast<RequestDefaultAgentRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<AgentManagerStub*>(getStub())->onRequestDefaultAgentRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* AgentManagerStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.AgentManager\">\n"
            "      <method name=\"RegisterAgent\">\n"
            "        <doc>\n"
            "          <line>possible values for capability:</line>\n"
            "          <line>DisplayOnly</line>\n"
            "          <line>DisplayYesNo</line>\n"
            "          <line>KeyboardOnly</line>\n"
            "          <line>NoInputNoOutput</line>\n"
            "          <line>KeyboardDisplay</line>\n"
            "        </doc>\n"
            "        <arg direction=\"in\" name=\"agent\" type=\"o\"/>\n"
            "        <arg direction=\"in\" name=\"capability\" type=\"s\"/>\n"
            "      </method>\n"
            "      <method name=\"UnregisterAgent\">\n"
            "        <arg direction=\"in\" name=\"agent\" type=\"o\"/>\n"
            "      </method>\n"
            "      <method name=\"RequestDefaultAgent\">\n"
            "        <arg direction=\"in\" name=\"agent\" type=\"o\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void AgentManagerStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<AgentManagerStub*>(getStub()))->onGetAll (properties);
}

void AgentManagerStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void AgentManagerStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

AgentManagerStub::AgentManagerStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentManagerStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentManagerStub::AgentManagerStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new AgentManagerStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

AgentManagerStub::~AgentManagerStub() {
    delete _stubDelegate;
}

void  AgentManagerStub::sendRegisterAgentResponse (act_t act) {
    RegisterAgentResponse* payload = new RegisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RegisterAgent", RegisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentManagerStub::sendRegisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RegisterAgentError* payload = new RegisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RegisterAgent", RegisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RegisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentManagerStub::sendUnregisterAgentResponse (act_t act) {
    UnregisterAgentResponse* payload = new UnregisterAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "UnregisterAgent", UnregisterAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentManagerStub::sendUnregisterAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    UnregisterAgentError* payload = new UnregisterAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "UnregisterAgent", UnregisterAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "UnregisterAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentManagerStub::sendRequestDefaultAgentResponse (act_t act) {
    RequestDefaultAgentResponse* payload = new RequestDefaultAgentResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "RequestDefaultAgent", RequestDefaultAgentResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "RequestDefaultAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  AgentManagerStub::sendRequestDefaultAgentError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RequestDefaultAgentError* payload = new RequestDefaultAgentError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "RequestDefaultAgent", RequestDefaultAgentError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "RequestDefaultAgent", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void AgentManagerStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace AgentManager
} // namespace bluez
} // namespace org
