/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/AgentManager.h"
#include "org/bluez/AgentManagerDBus.h"
#include "org/bluez/AgentManagerJson.h"
#include "org/bluez/AgentManagerProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace AgentManager {

DEFINE_CLASS_LOGGER("//org/bluez/org/bluez/AgentManager", AgentManagerProxy);

class AgentManagerProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    AgentManagerProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< AgentManagerProxy >& proxyShared = ::boost::static_pointer_cast< AgentManagerProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_RegisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentError> payload = ::boost::static_pointer_cast<RegisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RegisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RegisterAgentResponse> payload = ::boost::static_pointer_cast<RegisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_UnregisterAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentError> payload = ::boost::static_pointer_cast<UnregisterAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UnregisterAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UnregisterAgentResponse> payload = ::boost::static_pointer_cast<UnregisterAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RequestDefaultAgent:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RequestDefaultAgentError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDefaultAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDefaultAgentError> payload = ::boost::static_pointer_cast<RequestDefaultAgentError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDefaultAgentCallbackIF*) _callback)->onRequestDefaultAgentError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RequestDefaultAgentResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RequestDefaultAgent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RequestDefaultAgentResponse> payload = ::boost::static_pointer_cast<RequestDefaultAgentResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RequestDefaultAgentCallbackIF*) _callback)->onRequestDefaultAgentResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_RegisterAgent: {
                ::boost::shared_ptr< RegisterAgentError > payload = ::boost::shared_ptr< RegisterAgentError >
                (new RegisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service AgentManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RegisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentManagerProxy> proxyShared = ::boost::static_pointer_cast<AgentManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RegisterAgentCallbackIF*) _callback)->onRegisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UnregisterAgent: {
                ::boost::shared_ptr< UnregisterAgentError > payload = ::boost::shared_ptr< UnregisterAgentError >
                (new UnregisterAgentError(DBUS_ERROR_NO_SERVER, "The DBus service AgentManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UnregisterAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentManagerProxy> proxyShared = ::boost::static_pointer_cast<AgentManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UnregisterAgentCallbackIF*) _callback)->onUnregisterAgentError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RequestDefaultAgent: {
                ::boost::shared_ptr< RequestDefaultAgentError > payload = ::boost::shared_ptr< RequestDefaultAgentError >
                (new RequestDefaultAgentError(DBUS_ERROR_NO_SERVER, "The DBus service AgentManager is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RequestDefaultAgent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<AgentManagerProxy> proxyShared = ::boost::static_pointer_cast<AgentManagerProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RequestDefaultAgentCallbackIF*) _callback)->onRequestDefaultAgentError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& AgentManagerProxyCallback::_logger (AgentManagerProxy::_logger);

AgentManagerProxy::AgentManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.AgentManager", serviceAvailable, _logger) {
}

AgentManagerProxy::~AgentManagerProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< AgentManagerProxy > AgentManagerProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<AgentManagerProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< AgentManagerProxy > proxyNew(new AgentManagerProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t AgentManagerProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    AgentManagerProxyCallback* callback = new AgentManagerProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t AgentManagerProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    AgentManagerProxyCallback* callback = new AgentManagerProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t AgentManagerProxy::sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& agent, const ::std::string& capability) const {
    RegisterAgentRequest* payload = new RegisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setAgent(agent);
    payload->setCapability(capability);
    DBUS_MESSAGE_CALL(dbusMessage, "RegisterAgent", RegisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_RegisterAgent, dbusMessage.getUniqueSerial(), "RegisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RegisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentManagerProxy::sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& agent) const {
    UnregisterAgentRequest* payload = new UnregisterAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setAgent(agent);
    DBUS_MESSAGE_CALL(dbusMessage, "UnregisterAgent", UnregisterAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_UnregisterAgent, dbusMessage.getUniqueSerial(), "UnregisterAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "UnregisterAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t AgentManagerProxy::sendRequestDefaultAgentRequest(RequestDefaultAgentCallbackIF& cb, const ::std::string& agent) const {
    RequestDefaultAgentRequest* payload = new RequestDefaultAgentRequest();
    CHECK_ALLOCATION(payload);
    payload->setAgent(agent);
    DBUS_MESSAGE_CALL(dbusMessage, "RequestDefaultAgent", RequestDefaultAgentRequest, payload, true)
    act_t act = addMethodCallback(ID_RequestDefaultAgent, dbusMessage.getUniqueSerial(), "RequestDefaultAgent", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RequestDefaultAgent", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace AgentManager
} // namespace bluez
} // namespace org
