#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_AGENT_H
#define ORG_BLUEZ_AGENT_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "Agent" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace Agent {

// method IDs
static const uint16 ID_Release = 0;
static const uint16 ID_RequestPinCode = 1;
static const uint16 ID_DisplayPinCode = 2;
static const uint16 ID_RequestPasskey = 3;
static const uint16 ID_RequestConfirmation = 4;
static const uint16 ID_Cancel = 5;
static const uint16 ID_CancelRequest = 6;
static const uint16 ID_AuthorizeService = 7;
static const uint16 ID_RequestAuthorization = 8;
static const uint16 ID_RequestLinkkey = 9;
static const uint16 ID_DisplayPasskey = 10;

// signal IDs

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class RequestPinCodeRequest;

class RequestPinCodeResponse;

class DisplayPinCodeRequest;

class RequestPasskeyRequest;

class RequestPasskeyResponse;

class RequestConfirmationRequest;

class CancelRequestRequest;

class AuthorizeServiceRequest;

class RequestAuthorizationRequest;

class RequestLinkkeyRequest;

class RequestLinkkeyResponse;

class DisplayPasskeyRequest;

// type definitions
/**
 * If the meaning of "ReleaseRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseRequest;

/**
 * If the meaning of "ReleaseResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage ReleaseResponse;

/**
 * If the meaning of "ReleaseError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReleaseError;

/**
 * If the meaning of "RequestPinCodeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestPinCodeError;

/**
 * If the meaning of "DisplayPinCodeResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisplayPinCodeResponse;

/**
 * If the meaning of "DisplayPinCodeError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayPinCodeError;

/**
 * If the meaning of "RequestPasskeyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestPasskeyError;

/**
 * If the meaning of "RequestConfirmationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestConfirmationResponse;

/**
 * If the meaning of "RequestConfirmationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestConfirmationError;

/**
 * If the meaning of "CancelRequest" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRequest;

/**
 * If the meaning of "CancelResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelResponse;

/**
 * If the meaning of "CancelError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelError;

/**
 * If the meaning of "CancelRequestResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage CancelRequestResponse;

/**
 * If the meaning of "CancelRequestError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError CancelRequestError;

/**
 * If the meaning of "AuthorizeServiceResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage AuthorizeServiceResponse;

/**
 * If the meaning of "AuthorizeServiceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError AuthorizeServiceError;

/**
 * If the meaning of "RequestAuthorizationResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage RequestAuthorizationResponse;

/**
 * If the meaning of "RequestAuthorizationError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestAuthorizationError;

/**
 * If the meaning of "RequestLinkkeyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError RequestLinkkeyError;

/**
 * If the meaning of "DisplayPasskeyResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage DisplayPasskeyResponse;

/**
 * If the meaning of "DisplayPasskeyError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DisplayPasskeyError;


/**
 * If the meaning of "RequestPinCodeRequest" isn't clear, then there should be a description here.
 */
class RequestPinCodeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPinCodeRequest ();

    /**
     * Copy constructor
     */
    inline  RequestPinCodeRequest (const RequestPinCodeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPinCodeRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPinCodeRequest();

    /**
     * Assignment operator
     */
    inline RequestPinCodeRequest& operator = (const RequestPinCodeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPinCodeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPinCodeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPinCodeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPinCodeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RequestPinCodeRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "RequestPinCodeResponse" isn't clear, then there should be a description here.
 */
class RequestPinCodeResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPinCodeResponse ();

    /**
     * Copy constructor
     */
    inline  RequestPinCodeResponse (const RequestPinCodeResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPinCodeResponse (const ::std::string& pincode_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPinCodeResponse();

    /**
     * Assignment operator
     */
    inline RequestPinCodeResponse& operator = (const RequestPinCodeResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPinCodeResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPinCodeResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPinCodeResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPinCodeResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "pincode"

    static const int kPincode = 0;

    /**
     * Clears the field "pincode".
     *
     * The field will be set to its default value. The hasPincode()
     * method will return false.
     */
    inline void clearPincode();

    /**
     * Checks whether the field "pincode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPincode()). Otherwise it will return false.
     */
    inline bool hasPincode () const;

    /**
     * Returns the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pincode"
     */
    inline const ::std::string& getPincode () const;

    /**
     * Retrieves the value of the field "pincode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pincode".
     */
    inline ::std::string& getPincodeMutable ();

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const ::std::string& pincode_);

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const char* pincode_);

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const char* value, size_t size);

    static const RequestPinCodeResponse &getDefaultInstance();

private:

    inline void set_has_pincode ();

    inline void clear_has_pincode ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _pincode;

};

/**
 * If the meaning of "DisplayPinCodeRequest" isn't clear, then there should be a description here.
 */
class DisplayPinCodeRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayPinCodeRequest ();

    /**
     * Copy constructor
     */
    inline  DisplayPinCodeRequest (const DisplayPinCodeRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayPinCodeRequest (const ::std::string& device_, const ::std::string& pincode_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayPinCodeRequest();

    /**
     * Assignment operator
     */
    inline DisplayPinCodeRequest& operator = (const DisplayPinCodeRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayPinCodeRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayPinCodeRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayPinCodeRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayPinCodeRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    // API of field "pincode"

    static const int kPincode = 1;

    /**
     * Clears the field "pincode".
     *
     * The field will be set to its default value. The hasPincode()
     * method will return false.
     */
    inline void clearPincode();

    /**
     * Checks whether the field "pincode" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPincode()). Otherwise it will return false.
     */
    inline bool hasPincode () const;

    /**
     * Returns the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @return The value of the field "pincode"
     */
    inline const ::std::string& getPincode () const;

    /**
     * Retrieves the value of the field "pincode" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "pincode".
     */
    inline ::std::string& getPincodeMutable ();

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const ::std::string& pincode_);

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const char* pincode_);

    /**
     * Sets the value of the member "pincode".
     *
     * If the meaning of "pincode" isn't clear, then there should be a description here.
     *
     * @param pincode The value which will be set
     */
    inline void setPincode (const char* value, size_t size);

    static const DisplayPinCodeRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    inline void set_has_pincode ();

    inline void clear_has_pincode ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _device;

    ::std::string _pincode;

};

/**
 * If the meaning of "RequestPasskeyRequest" isn't clear, then there should be a description here.
 */
class RequestPasskeyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPasskeyRequest ();

    /**
     * Copy constructor
     */
    inline  RequestPasskeyRequest (const RequestPasskeyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPasskeyRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPasskeyRequest();

    /**
     * Assignment operator
     */
    inline RequestPasskeyRequest& operator = (const RequestPasskeyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPasskeyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPasskeyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPasskeyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPasskeyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RequestPasskeyRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "RequestPasskeyResponse" isn't clear, then there should be a description here.
 */
class RequestPasskeyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestPasskeyResponse ();

    /**
     * Copy constructor
     */
    inline  RequestPasskeyResponse (const RequestPasskeyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestPasskeyResponse (uint32 passkey_);

    /**
     * Destructor
     */
    inline virtual  ~RequestPasskeyResponse();

    /**
     * Assignment operator
     */
    inline RequestPasskeyResponse& operator = (const RequestPasskeyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestPasskeyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestPasskeyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestPasskeyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestPasskeyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "passkey"

    static const int kPasskey = 0;

    /**
     * Clears the field "passkey".
     *
     * The field will be set to its default value. The hasPasskey()
     * method will return false.
     */
    inline void clearPasskey();

    /**
     * Checks whether the field "passkey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPasskey()). Otherwise it will return false.
     */
    inline bool hasPasskey () const;

    /**
     * Returns the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "passkey"
     */
    inline uint32 getPasskey () const;

    /**
     * Sets the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @param passkey The value which will be set
     */
    inline void setPasskey (uint32 passkey_);

    static const RequestPasskeyResponse &getDefaultInstance();

private:

    inline void set_has_passkey ();

    inline void clear_has_passkey ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint32 _passkey;

};

/**
 * If the meaning of "RequestConfirmationRequest" isn't clear, then there should be a description here.
 */
class RequestConfirmationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestConfirmationRequest ();

    /**
     * Copy constructor
     */
    inline  RequestConfirmationRequest (const RequestConfirmationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestConfirmationRequest (const ::std::string& device_, uint32 passkey_);

    /**
     * Destructor
     */
    inline virtual  ~RequestConfirmationRequest();

    /**
     * Assignment operator
     */
    inline RequestConfirmationRequest& operator = (const RequestConfirmationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestConfirmationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestConfirmationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestConfirmationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestConfirmationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    // API of field "passkey"

    static const int kPasskey = 1;

    /**
     * Clears the field "passkey".
     *
     * The field will be set to its default value. The hasPasskey()
     * method will return false.
     */
    inline void clearPasskey();

    /**
     * Checks whether the field "passkey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPasskey()). Otherwise it will return false.
     */
    inline bool hasPasskey () const;

    /**
     * Returns the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "passkey"
     */
    inline uint32 getPasskey () const;

    /**
     * Sets the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @param passkey The value which will be set
     */
    inline void setPasskey (uint32 passkey_);

    static const RequestConfirmationRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    inline void set_has_passkey ();

    inline void clear_has_passkey ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _device;

    uint32 _passkey;

};

/**
 * If the meaning of "CancelRequestRequest" isn't clear, then there should be a description here.
 */
class CancelRequestRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  CancelRequestRequest ();

    /**
     * Copy constructor
     */
    inline  CancelRequestRequest (const CancelRequestRequest &rhs);

    /**
     * All fields constructor
     */
    inline  CancelRequestRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~CancelRequestRequest();

    /**
     * Assignment operator
     */
    inline CancelRequestRequest& operator = (const CancelRequestRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const CancelRequestRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const CancelRequestRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const CancelRequestRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const CancelRequestRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const CancelRequestRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "AuthorizeServiceRequest" isn't clear, then there should be a description here.
 */
class AuthorizeServiceRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  AuthorizeServiceRequest ();

    /**
     * Copy constructor
     */
    inline  AuthorizeServiceRequest (const AuthorizeServiceRequest &rhs);

    /**
     * All fields constructor
     */
    inline  AuthorizeServiceRequest (const ::std::string& device_, const ::std::string& uuid_);

    /**
     * Destructor
     */
    inline virtual  ~AuthorizeServiceRequest();

    /**
     * Assignment operator
     */
    inline AuthorizeServiceRequest& operator = (const AuthorizeServiceRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const AuthorizeServiceRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const AuthorizeServiceRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const AuthorizeServiceRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const AuthorizeServiceRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    // API of field "uuid"

    static const int kUuid = 1;

    /**
     * Clears the field "uuid".
     *
     * The field will be set to its default value. The hasUuid()
     * method will return false.
     */
    inline void clearUuid();

    /**
     * Checks whether the field "uuid" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setUuid()). Otherwise it will return false.
     */
    inline bool hasUuid () const;

    /**
     * Returns the value of the member "uuid".
     *
     * If the meaning of "uuid" isn't clear, then there should be a description here.
     *
     * @return The value of the field "uuid"
     */
    inline const ::std::string& getUuid () const;

    /**
     * Retrieves the value of the field "uuid" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "uuid".
     */
    inline ::std::string& getUuidMutable ();

    /**
     * Sets the value of the member "uuid".
     *
     * If the meaning of "uuid" isn't clear, then there should be a description here.
     *
     * @param uuid The value which will be set
     */
    inline void setUuid (const ::std::string& uuid_);

    /**
     * Sets the value of the member "uuid".
     *
     * If the meaning of "uuid" isn't clear, then there should be a description here.
     *
     * @param uuid The value which will be set
     */
    inline void setUuid (const char* uuid_);

    /**
     * Sets the value of the member "uuid".
     *
     * If the meaning of "uuid" isn't clear, then there should be a description here.
     *
     * @param uuid The value which will be set
     */
    inline void setUuid (const char* value, size_t size);

    static const AuthorizeServiceRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    inline void set_has_uuid ();

    inline void clear_has_uuid ();

    uint32 _has_bits_[ (2 + 31) / 32];

    ::std::string _device;

    ::std::string _uuid;

};

/**
 * If the meaning of "RequestAuthorizationRequest" isn't clear, then there should be a description here.
 */
class RequestAuthorizationRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestAuthorizationRequest ();

    /**
     * Copy constructor
     */
    inline  RequestAuthorizationRequest (const RequestAuthorizationRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestAuthorizationRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RequestAuthorizationRequest();

    /**
     * Assignment operator
     */
    inline RequestAuthorizationRequest& operator = (const RequestAuthorizationRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestAuthorizationRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestAuthorizationRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestAuthorizationRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestAuthorizationRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RequestAuthorizationRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "RequestLinkkeyRequest" isn't clear, then there should be a description here.
 */
class RequestLinkkeyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestLinkkeyRequest ();

    /**
     * Copy constructor
     */
    inline  RequestLinkkeyRequest (const RequestLinkkeyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  RequestLinkkeyRequest (const ::std::string& device_);

    /**
     * Destructor
     */
    inline virtual  ~RequestLinkkeyRequest();

    /**
     * Assignment operator
     */
    inline RequestLinkkeyRequest& operator = (const RequestLinkkeyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestLinkkeyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestLinkkeyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestLinkkeyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestLinkkeyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    static const RequestLinkkeyRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::string _device;

};

/**
 * If the meaning of "RequestLinkkeyResponse" isn't clear, then there should be a description here.
 */
class RequestLinkkeyResponse  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  RequestLinkkeyResponse ();

    /**
     * Copy constructor
     */
    inline  RequestLinkkeyResponse (const RequestLinkkeyResponse &rhs);

    /**
     * All fields constructor
     */
    inline  RequestLinkkeyResponse (const ::std::vector< uint8 >& linkkey_);

    /**
     * Destructor
     */
    inline virtual  ~RequestLinkkeyResponse();

    /**
     * Assignment operator
     */
    inline RequestLinkkeyResponse& operator = (const RequestLinkkeyResponse& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const RequestLinkkeyResponse& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const RequestLinkkeyResponse& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const RequestLinkkeyResponse& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const RequestLinkkeyResponse& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "linkkey"

    static const int kLinkkey = 0;

    /**
     * Clears the field "linkkey".
     *
     * The field will be set to its default value. The hasLinkkey()
     * method will return false.
     */
    inline void clearLinkkey();

    /**
     * Checks whether the field "linkkey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLinkkey()). Otherwise it will return false.
     */
    inline bool hasLinkkey () const;

    /**
     * Returns the value of the member "linkkey".
     *
     * If the meaning of "linkkey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "linkkey"
     */
    inline const ::std::vector< uint8 >& getLinkkey () const;

    /**
     * Retrieves the value of the field "linkkey" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "linkkey".
     */
    inline ::std::vector< uint8 >& getLinkkeyMutable ();

    /**
     * Sets the value of the member "linkkey".
     *
     * If the meaning of "linkkey" isn't clear, then there should be a description here.
     *
     * @param linkkey The value which will be set
     */
    inline void setLinkkey (const ::std::vector< uint8 >& linkkey_);

    static const RequestLinkkeyResponse &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_linkkey ();

    inline void clear_has_linkkey ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _linkkey;

};

/**
 * If the meaning of "DisplayPasskeyRequest" isn't clear, then there should be a description here.
 */
class DisplayPasskeyRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DisplayPasskeyRequest ();

    /**
     * Copy constructor
     */
    inline  DisplayPasskeyRequest (const DisplayPasskeyRequest &rhs);

    /**
     * All fields constructor
     */
    inline  DisplayPasskeyRequest (const ::std::string& device_, uint32 passkey_, uint8 entered_);

    /**
     * Destructor
     */
    inline virtual  ~DisplayPasskeyRequest();

    /**
     * Assignment operator
     */
    inline DisplayPasskeyRequest& operator = (const DisplayPasskeyRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DisplayPasskeyRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DisplayPasskeyRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DisplayPasskeyRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DisplayPasskeyRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "device"

    static const int kDevice = 0;

    /**
     * Clears the field "device".
     *
     * The field will be set to its default value. The hasDevice()
     * method will return false.
     */
    inline void clearDevice();

    /**
     * Checks whether the field "device" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDevice()). Otherwise it will return false.
     */
    inline bool hasDevice () const;

    /**
     * Returns the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @return The value of the field "device"
     */
    inline const ::std::string& getDevice () const;

    /**
     * Retrieves the value of the field "device" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "device".
     */
    inline ::std::string& getDeviceMutable ();

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const ::std::string& device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* device_);

    /**
     * Sets the value of the member "device".
     *
     * If the meaning of "device" isn't clear, then there should be a description here.
     *
     * @param device The value which will be set
     */
    inline void setDevice (const char* value, size_t size);

    // API of field "passkey"

    static const int kPasskey = 1;

    /**
     * Clears the field "passkey".
     *
     * The field will be set to its default value. The hasPasskey()
     * method will return false.
     */
    inline void clearPasskey();

    /**
     * Checks whether the field "passkey" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setPasskey()). Otherwise it will return false.
     */
    inline bool hasPasskey () const;

    /**
     * Returns the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @return The value of the field "passkey"
     */
    inline uint32 getPasskey () const;

    /**
     * Sets the value of the member "passkey".
     *
     * If the meaning of "passkey" isn't clear, then there should be a description here.
     *
     * @param passkey The value which will be set
     */
    inline void setPasskey (uint32 passkey_);

    // API of field "entered"

    static const int kEntered = 2;

    /**
     * Clears the field "entered".
     *
     * The field will be set to its default value. The hasEntered()
     * method will return false.
     */
    inline void clearEntered();

    /**
     * Checks whether the field "entered" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setEntered()). Otherwise it will return false.
     */
    inline bool hasEntered () const;

    /**
     * Returns the value of the member "entered".
     *
     * If the meaning of "entered" isn't clear, then there should be a description here.
     *
     * @return The value of the field "entered"
     */
    inline uint8 getEntered () const;

    /**
     * Sets the value of the member "entered".
     *
     * If the meaning of "entered" isn't clear, then there should be a description here.
     *
     * @param entered The value which will be set
     */
    inline void setEntered (uint8 entered_);

    static const DisplayPasskeyRequest &getDefaultInstance();

private:

    inline void set_has_device ();

    inline void clear_has_device ();

    inline void set_has_passkey ();

    inline void clear_has_passkey ();

    inline void set_has_entered ();

    inline void clear_has_entered ();

    uint32 _has_bits_[ (3 + 31) / 32];

    ::std::string _device;

    uint32 _passkey;

    uint8 _entered;

};

inline  RequestPinCodeRequest::RequestPinCodeRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPinCodeRequest::RequestPinCodeRequest (const RequestPinCodeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPinCodeRequest::RequestPinCodeRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPinCodeRequest::~RequestPinCodeRequest() {
}

inline RequestPinCodeRequest& RequestPinCodeRequest::operator = (const RequestPinCodeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RequestPinCodeRequest::operator == (const RequestPinCodeRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RequestPinCodeRequest::operator != (const RequestPinCodeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPinCodeRequest::operator < (const RequestPinCodeRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPinCodeRequest::clone() {
    return new RequestPinCodeRequest(*this);
}

inline bool RequestPinCodeRequest::operator > (const RequestPinCodeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPinCodeRequest::clear() {
    clearDevice();
}

inline void RequestPinCodeRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RequestPinCodeRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestPinCodeRequest::getDevice () const {
    return _device;
}

inline ::std::string& RequestPinCodeRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RequestPinCodeRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RequestPinCodeRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RequestPinCodeRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RequestPinCodeRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPinCodeRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestPinCodeResponse::RequestPinCodeResponse ()  :
    _pincode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPinCodeResponse::RequestPinCodeResponse (const RequestPinCodeResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _pincode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPinCodeResponse::RequestPinCodeResponse (const ::std::string& pincode_)  :
    _pincode (pincode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPinCodeResponse::~RequestPinCodeResponse() {
}

inline RequestPinCodeResponse& RequestPinCodeResponse::operator = (const RequestPinCodeResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPincode()) {
            setPincode(rhs.getPincode());
        } else {
            clearPincode();
        }
    }
    return *this;
}

inline bool RequestPinCodeResponse::operator == (const RequestPinCodeResponse& rhs) const {
    return (((!hasPincode() && !rhs.hasPincode()) || getPincode() == rhs.getPincode()));
}

inline bool RequestPinCodeResponse::operator != (const RequestPinCodeResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPinCodeResponse::operator < (const RequestPinCodeResponse& rhs) const {
    if (hasPincode() || rhs.hasPincode()) {
        if (getPincode() < rhs.getPincode()) return true;
        if (getPincode() > rhs.getPincode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPinCodeResponse::clone() {
    return new RequestPinCodeResponse(*this);
}

inline bool RequestPinCodeResponse::operator > (const RequestPinCodeResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPinCodeResponse::clear() {
    clearPincode();
}

inline void RequestPinCodeResponse::clearPincode() {
    if (hasPincode()) {
         clear_has_pincode();
        _pincode.clear();
     }
}

inline bool RequestPinCodeResponse::hasPincode () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestPinCodeResponse::getPincode () const {
    return _pincode;
}

inline ::std::string& RequestPinCodeResponse::getPincodeMutable () {
    set_has_pincode();
    return _pincode;
}

inline void RequestPinCodeResponse::setPincode (const ::std::string& pincode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode = pincode_;
}

inline void RequestPinCodeResponse::setPincode (const char* pincode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode.assign(pincode_);
}

inline void RequestPinCodeResponse::setPincode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode.assign(value, size);
}

inline void RequestPinCodeResponse::set_has_pincode () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPinCodeResponse::clear_has_pincode () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayPinCodeRequest::DisplayPinCodeRequest ()  :
    _device (),
    _pincode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayPinCodeRequest::DisplayPinCodeRequest (const DisplayPinCodeRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device (),
    _pincode ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayPinCodeRequest::DisplayPinCodeRequest (const ::std::string& device_, const ::std::string& pincode_)  :
    _device (device_),
    _pincode (pincode_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayPinCodeRequest::~DisplayPinCodeRequest() {
}

inline DisplayPinCodeRequest& DisplayPinCodeRequest::operator = (const DisplayPinCodeRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
        if (rhs.hasPincode()) {
            setPincode(rhs.getPincode());
        } else {
            clearPincode();
        }
    }
    return *this;
}

inline bool DisplayPinCodeRequest::operator == (const DisplayPinCodeRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()) &&
        ((!hasPincode() && !rhs.hasPincode()) || getPincode() == rhs.getPincode()));
}

inline bool DisplayPinCodeRequest::operator != (const DisplayPinCodeRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayPinCodeRequest::operator < (const DisplayPinCodeRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    if (hasPincode() || rhs.hasPincode()) {
        if (getPincode() < rhs.getPincode()) return true;
        if (getPincode() > rhs.getPincode()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayPinCodeRequest::clone() {
    return new DisplayPinCodeRequest(*this);
}

inline bool DisplayPinCodeRequest::operator > (const DisplayPinCodeRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayPinCodeRequest::clear() {
    clearDevice();
    clearPincode();
}

inline void DisplayPinCodeRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool DisplayPinCodeRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DisplayPinCodeRequest::getDevice () const {
    return _device;
}

inline ::std::string& DisplayPinCodeRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void DisplayPinCodeRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void DisplayPinCodeRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void DisplayPinCodeRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void DisplayPinCodeRequest::clearPincode() {
    if (hasPincode()) {
         clear_has_pincode();
        _pincode.clear();
     }
}

inline bool DisplayPinCodeRequest::hasPincode () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& DisplayPinCodeRequest::getPincode () const {
    return _pincode;
}

inline ::std::string& DisplayPinCodeRequest::getPincodeMutable () {
    set_has_pincode();
    return _pincode;
}

inline void DisplayPinCodeRequest::setPincode (const ::std::string& pincode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode = pincode_;
}

inline void DisplayPinCodeRequest::setPincode (const char* pincode_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (pincode_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode.assign(pincode_);
}

inline void DisplayPinCodeRequest::setPincode (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_pincode();
    this->_pincode.assign(value, size);
}

inline void DisplayPinCodeRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayPinCodeRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DisplayPinCodeRequest::set_has_pincode () {
    _has_bits_[0] |= 1u << 1;
}

inline void DisplayPinCodeRequest::clear_has_pincode () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestPasskeyRequest::RequestPasskeyRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPasskeyRequest::RequestPasskeyRequest (const RequestPasskeyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPasskeyRequest::RequestPasskeyRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPasskeyRequest::~RequestPasskeyRequest() {
}

inline RequestPasskeyRequest& RequestPasskeyRequest::operator = (const RequestPasskeyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RequestPasskeyRequest::operator == (const RequestPasskeyRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RequestPasskeyRequest::operator != (const RequestPasskeyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPasskeyRequest::operator < (const RequestPasskeyRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPasskeyRequest::clone() {
    return new RequestPasskeyRequest(*this);
}

inline bool RequestPasskeyRequest::operator > (const RequestPasskeyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPasskeyRequest::clear() {
    clearDevice();
}

inline void RequestPasskeyRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RequestPasskeyRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestPasskeyRequest::getDevice () const {
    return _device;
}

inline ::std::string& RequestPasskeyRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RequestPasskeyRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RequestPasskeyRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RequestPasskeyRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RequestPasskeyRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPasskeyRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestPasskeyResponse::RequestPasskeyResponse ()  :
    _passkey (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestPasskeyResponse::RequestPasskeyResponse (const RequestPasskeyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _passkey (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestPasskeyResponse::RequestPasskeyResponse (uint32 passkey_)  :
    _passkey (passkey_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestPasskeyResponse::~RequestPasskeyResponse() {
}

inline RequestPasskeyResponse& RequestPasskeyResponse::operator = (const RequestPasskeyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasPasskey()) {
            setPasskey(rhs.getPasskey());
        } else {
            clearPasskey();
        }
    }
    return *this;
}

inline bool RequestPasskeyResponse::operator == (const RequestPasskeyResponse& rhs) const {
    return (((!hasPasskey() && !rhs.hasPasskey()) || getPasskey() == rhs.getPasskey()));
}

inline bool RequestPasskeyResponse::operator != (const RequestPasskeyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestPasskeyResponse::operator < (const RequestPasskeyResponse& rhs) const {
    if (hasPasskey() || rhs.hasPasskey()) {
        if (getPasskey() < rhs.getPasskey()) return true;
        if (getPasskey() > rhs.getPasskey()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestPasskeyResponse::clone() {
    return new RequestPasskeyResponse(*this);
}

inline bool RequestPasskeyResponse::operator > (const RequestPasskeyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestPasskeyResponse::clear() {
    clearPasskey();
}

inline void RequestPasskeyResponse::clearPasskey() {
    if (hasPasskey()) {
         clear_has_passkey();
        _passkey = 0u;
     }
}

inline bool RequestPasskeyResponse::hasPasskey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint32 RequestPasskeyResponse::getPasskey () const {
    return _passkey;
}

inline void RequestPasskeyResponse::setPasskey (uint32 passkey_) {
    set_has_passkey();
    this->_passkey = passkey_;
}

inline void RequestPasskeyResponse::set_has_passkey () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestPasskeyResponse::clear_has_passkey () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestConfirmationRequest::RequestConfirmationRequest ()  :
    _device (),
    _passkey (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestConfirmationRequest::RequestConfirmationRequest (const RequestConfirmationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device (),
    _passkey (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestConfirmationRequest::RequestConfirmationRequest (const ::std::string& device_, uint32 passkey_)  :
    _device (device_),
    _passkey (passkey_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestConfirmationRequest::~RequestConfirmationRequest() {
}

inline RequestConfirmationRequest& RequestConfirmationRequest::operator = (const RequestConfirmationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
        if (rhs.hasPasskey()) {
            setPasskey(rhs.getPasskey());
        } else {
            clearPasskey();
        }
    }
    return *this;
}

inline bool RequestConfirmationRequest::operator == (const RequestConfirmationRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()) &&
        ((!hasPasskey() && !rhs.hasPasskey()) || getPasskey() == rhs.getPasskey()));
}

inline bool RequestConfirmationRequest::operator != (const RequestConfirmationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestConfirmationRequest::operator < (const RequestConfirmationRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    if (hasPasskey() || rhs.hasPasskey()) {
        if (getPasskey() < rhs.getPasskey()) return true;
        if (getPasskey() > rhs.getPasskey()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestConfirmationRequest::clone() {
    return new RequestConfirmationRequest(*this);
}

inline bool RequestConfirmationRequest::operator > (const RequestConfirmationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestConfirmationRequest::clear() {
    clearDevice();
    clearPasskey();
}

inline void RequestConfirmationRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RequestConfirmationRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestConfirmationRequest::getDevice () const {
    return _device;
}

inline ::std::string& RequestConfirmationRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RequestConfirmationRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RequestConfirmationRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RequestConfirmationRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RequestConfirmationRequest::clearPasskey() {
    if (hasPasskey()) {
         clear_has_passkey();
        _passkey = 0u;
     }
}

inline bool RequestConfirmationRequest::hasPasskey () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 RequestConfirmationRequest::getPasskey () const {
    return _passkey;
}

inline void RequestConfirmationRequest::setPasskey (uint32 passkey_) {
    set_has_passkey();
    this->_passkey = passkey_;
}

inline void RequestConfirmationRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestConfirmationRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void RequestConfirmationRequest::set_has_passkey () {
    _has_bits_[0] |= 1u << 1;
}

inline void RequestConfirmationRequest::clear_has_passkey () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  CancelRequestRequest::CancelRequestRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  CancelRequestRequest::CancelRequestRequest (const CancelRequestRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  CancelRequestRequest::CancelRequestRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  CancelRequestRequest::~CancelRequestRequest() {
}

inline CancelRequestRequest& CancelRequestRequest::operator = (const CancelRequestRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool CancelRequestRequest::operator == (const CancelRequestRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool CancelRequestRequest::operator != (const CancelRequestRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool CancelRequestRequest::operator < (const CancelRequestRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* CancelRequestRequest::clone() {
    return new CancelRequestRequest(*this);
}

inline bool CancelRequestRequest::operator > (const CancelRequestRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void CancelRequestRequest::clear() {
    clearDevice();
}

inline void CancelRequestRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool CancelRequestRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& CancelRequestRequest::getDevice () const {
    return _device;
}

inline ::std::string& CancelRequestRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void CancelRequestRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void CancelRequestRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void CancelRequestRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void CancelRequestRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void CancelRequestRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  AuthorizeServiceRequest::AuthorizeServiceRequest ()  :
    _device (),
    _uuid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  AuthorizeServiceRequest::AuthorizeServiceRequest (const AuthorizeServiceRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device (),
    _uuid ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  AuthorizeServiceRequest::AuthorizeServiceRequest (const ::std::string& device_, const ::std::string& uuid_)  :
    _device (device_),
    _uuid (uuid_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uuid_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  AuthorizeServiceRequest::~AuthorizeServiceRequest() {
}

inline AuthorizeServiceRequest& AuthorizeServiceRequest::operator = (const AuthorizeServiceRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
        if (rhs.hasUuid()) {
            setUuid(rhs.getUuid());
        } else {
            clearUuid();
        }
    }
    return *this;
}

inline bool AuthorizeServiceRequest::operator == (const AuthorizeServiceRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()) &&
        ((!hasUuid() && !rhs.hasUuid()) || getUuid() == rhs.getUuid()));
}

inline bool AuthorizeServiceRequest::operator != (const AuthorizeServiceRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool AuthorizeServiceRequest::operator < (const AuthorizeServiceRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    if (hasUuid() || rhs.hasUuid()) {
        if (getUuid() < rhs.getUuid()) return true;
        if (getUuid() > rhs.getUuid()) return false;
    }
    return false;
}

inline ::asf::core::Payload* AuthorizeServiceRequest::clone() {
    return new AuthorizeServiceRequest(*this);
}

inline bool AuthorizeServiceRequest::operator > (const AuthorizeServiceRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void AuthorizeServiceRequest::clear() {
    clearDevice();
    clearUuid();
}

inline void AuthorizeServiceRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool AuthorizeServiceRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& AuthorizeServiceRequest::getDevice () const {
    return _device;
}

inline ::std::string& AuthorizeServiceRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void AuthorizeServiceRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void AuthorizeServiceRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void AuthorizeServiceRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void AuthorizeServiceRequest::clearUuid() {
    if (hasUuid()) {
         clear_has_uuid();
        _uuid.clear();
     }
}

inline bool AuthorizeServiceRequest::hasUuid () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline const ::std::string& AuthorizeServiceRequest::getUuid () const {
    return _uuid;
}

inline ::std::string& AuthorizeServiceRequest::getUuidMutable () {
    set_has_uuid();
    return _uuid;
}

inline void AuthorizeServiceRequest::setUuid (const ::std::string& uuid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uuid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uuid();
    this->_uuid = uuid_;
}

inline void AuthorizeServiceRequest::setUuid (const char* uuid_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (uuid_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uuid();
    this->_uuid.assign(uuid_);
}

inline void AuthorizeServiceRequest::setUuid (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_uuid();
    this->_uuid.assign(value, size);
}

inline void AuthorizeServiceRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void AuthorizeServiceRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void AuthorizeServiceRequest::set_has_uuid () {
    _has_bits_[0] |= 1u << 1;
}

inline void AuthorizeServiceRequest::clear_has_uuid () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline  RequestAuthorizationRequest::RequestAuthorizationRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestAuthorizationRequest::RequestAuthorizationRequest (const RequestAuthorizationRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestAuthorizationRequest::RequestAuthorizationRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestAuthorizationRequest::~RequestAuthorizationRequest() {
}

inline RequestAuthorizationRequest& RequestAuthorizationRequest::operator = (const RequestAuthorizationRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RequestAuthorizationRequest::operator == (const RequestAuthorizationRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RequestAuthorizationRequest::operator != (const RequestAuthorizationRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestAuthorizationRequest::operator < (const RequestAuthorizationRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestAuthorizationRequest::clone() {
    return new RequestAuthorizationRequest(*this);
}

inline bool RequestAuthorizationRequest::operator > (const RequestAuthorizationRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestAuthorizationRequest::clear() {
    clearDevice();
}

inline void RequestAuthorizationRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RequestAuthorizationRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestAuthorizationRequest::getDevice () const {
    return _device;
}

inline ::std::string& RequestAuthorizationRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RequestAuthorizationRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RequestAuthorizationRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RequestAuthorizationRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RequestAuthorizationRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestAuthorizationRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestLinkkeyRequest::RequestLinkkeyRequest ()  :
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestLinkkeyRequest::RequestLinkkeyRequest (const RequestLinkkeyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestLinkkeyRequest::RequestLinkkeyRequest (const ::std::string& device_)  :
    _device (device_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestLinkkeyRequest::~RequestLinkkeyRequest() {
}

inline RequestLinkkeyRequest& RequestLinkkeyRequest::operator = (const RequestLinkkeyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
    }
    return *this;
}

inline bool RequestLinkkeyRequest::operator == (const RequestLinkkeyRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()));
}

inline bool RequestLinkkeyRequest::operator != (const RequestLinkkeyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestLinkkeyRequest::operator < (const RequestLinkkeyRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestLinkkeyRequest::clone() {
    return new RequestLinkkeyRequest(*this);
}

inline bool RequestLinkkeyRequest::operator > (const RequestLinkkeyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestLinkkeyRequest::clear() {
    clearDevice();
}

inline void RequestLinkkeyRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool RequestLinkkeyRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& RequestLinkkeyRequest::getDevice () const {
    return _device;
}

inline ::std::string& RequestLinkkeyRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void RequestLinkkeyRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void RequestLinkkeyRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void RequestLinkkeyRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void RequestLinkkeyRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestLinkkeyRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  RequestLinkkeyResponse::RequestLinkkeyResponse ()  :
    _linkkey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  RequestLinkkeyResponse::RequestLinkkeyResponse (const RequestLinkkeyResponse &rhs)  :
    ::asf::core::Payload(rhs),
    _linkkey ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  RequestLinkkeyResponse::RequestLinkkeyResponse (const ::std::vector< uint8 >& linkkey_)  :
    _linkkey (linkkey_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  RequestLinkkeyResponse::~RequestLinkkeyResponse() {
}

inline RequestLinkkeyResponse& RequestLinkkeyResponse::operator = (const RequestLinkkeyResponse& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasLinkkey()) {
            setLinkkey(rhs.getLinkkey());
        } else {
            clearLinkkey();
        }
    }
    return *this;
}

inline bool RequestLinkkeyResponse::operator == (const RequestLinkkeyResponse& rhs) const {
    return (((!hasLinkkey() && !rhs.hasLinkkey()) || getLinkkey() == rhs.getLinkkey()));
}

inline bool RequestLinkkeyResponse::operator != (const RequestLinkkeyResponse& rhs) const {
    return ! (*this == rhs);
}

inline bool RequestLinkkeyResponse::operator < (const RequestLinkkeyResponse& rhs) const {
    if (hasLinkkey() || rhs.hasLinkkey()) {
        if (getLinkkey() < rhs.getLinkkey()) return true;
        if (getLinkkey() > rhs.getLinkkey()) return false;
    }
    return false;
}

inline ::asf::core::Payload* RequestLinkkeyResponse::clone() {
    return new RequestLinkkeyResponse(*this);
}

inline bool RequestLinkkeyResponse::operator > (const RequestLinkkeyResponse& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void RequestLinkkeyResponse::clear() {
    clearLinkkey();
}

inline void RequestLinkkeyResponse::clearLinkkey() {
    if (hasLinkkey()) {
         clear_has_linkkey();
        _linkkey.clear();
     }
}

inline bool RequestLinkkeyResponse::hasLinkkey () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& RequestLinkkeyResponse::getLinkkey () const {
    return _linkkey;
}

inline ::std::vector< uint8 >& RequestLinkkeyResponse::getLinkkeyMutable () {
    set_has_linkkey();
    return _linkkey;
}

inline void RequestLinkkeyResponse::setLinkkey (const ::std::vector< uint8 >& linkkey_) {
    set_has_linkkey();
    this->_linkkey = linkkey_;
}

inline void RequestLinkkeyResponse::set_has_linkkey () {
    _has_bits_[0] |= 1u << 0;
}

inline void RequestLinkkeyResponse::clear_has_linkkey () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DisplayPasskeyRequest::DisplayPasskeyRequest ()  :
    _device (),
    _passkey (0u),
    _entered (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DisplayPasskeyRequest::DisplayPasskeyRequest (const DisplayPasskeyRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _device (),
    _passkey (0u),
    _entered (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DisplayPasskeyRequest::DisplayPasskeyRequest (const ::std::string& device_, uint32 passkey_, uint8 entered_)  :
    _device (device_),
    _passkey (passkey_),
    _entered (entered_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DisplayPasskeyRequest::~DisplayPasskeyRequest() {
}

inline DisplayPasskeyRequest& DisplayPasskeyRequest::operator = (const DisplayPasskeyRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDevice()) {
            setDevice(rhs.getDevice());
        } else {
            clearDevice();
        }
        if (rhs.hasPasskey()) {
            setPasskey(rhs.getPasskey());
        } else {
            clearPasskey();
        }
        if (rhs.hasEntered()) {
            setEntered(rhs.getEntered());
        } else {
            clearEntered();
        }
    }
    return *this;
}

inline bool DisplayPasskeyRequest::operator == (const DisplayPasskeyRequest& rhs) const {
    return (((!hasDevice() && !rhs.hasDevice()) || getDevice() == rhs.getDevice()) &&
        ((!hasPasskey() && !rhs.hasPasskey()) || getPasskey() == rhs.getPasskey()) &&
        ((!hasEntered() && !rhs.hasEntered()) || getEntered() == rhs.getEntered()));
}

inline bool DisplayPasskeyRequest::operator != (const DisplayPasskeyRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool DisplayPasskeyRequest::operator < (const DisplayPasskeyRequest& rhs) const {
    if (hasDevice() || rhs.hasDevice()) {
        if (getDevice() < rhs.getDevice()) return true;
        if (getDevice() > rhs.getDevice()) return false;
    }
    if (hasPasskey() || rhs.hasPasskey()) {
        if (getPasskey() < rhs.getPasskey()) return true;
        if (getPasskey() > rhs.getPasskey()) return false;
    }
    if (hasEntered() || rhs.hasEntered()) {
        if (getEntered() < rhs.getEntered()) return true;
        if (getEntered() > rhs.getEntered()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DisplayPasskeyRequest::clone() {
    return new DisplayPasskeyRequest(*this);
}

inline bool DisplayPasskeyRequest::operator > (const DisplayPasskeyRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DisplayPasskeyRequest::clear() {
    clearDevice();
    clearPasskey();
    clearEntered();
}

inline void DisplayPasskeyRequest::clearDevice() {
    if (hasDevice()) {
         clear_has_device();
        _device.clear();
     }
}

inline bool DisplayPasskeyRequest::hasDevice () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::string& DisplayPasskeyRequest::getDevice () const {
    return _device;
}

inline ::std::string& DisplayPasskeyRequest::getDeviceMutable () {
    set_has_device();
    return _device;
}

inline void DisplayPasskeyRequest::setDevice (const ::std::string& device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device = device_;
}

inline void DisplayPasskeyRequest::setDevice (const char* device_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (device_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(device_);
}

inline void DisplayPasskeyRequest::setDevice (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_device();
    this->_device.assign(value, size);
}

inline void DisplayPasskeyRequest::clearPasskey() {
    if (hasPasskey()) {
         clear_has_passkey();
        _passkey = 0u;
     }
}

inline bool DisplayPasskeyRequest::hasPasskey () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint32 DisplayPasskeyRequest::getPasskey () const {
    return _passkey;
}

inline void DisplayPasskeyRequest::setPasskey (uint32 passkey_) {
    set_has_passkey();
    this->_passkey = passkey_;
}

inline void DisplayPasskeyRequest::clearEntered() {
    if (hasEntered()) {
         clear_has_entered();
        _entered = 0u;
     }
}

inline bool DisplayPasskeyRequest::hasEntered () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint8 DisplayPasskeyRequest::getEntered () const {
    return _entered;
}

inline void DisplayPasskeyRequest::setEntered (uint8 entered_) {
    set_has_entered();
    this->_entered = entered_;
}

inline void DisplayPasskeyRequest::set_has_device () {
    _has_bits_[0] |= 1u << 0;
}

inline void DisplayPasskeyRequest::clear_has_device () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void DisplayPasskeyRequest::set_has_passkey () {
    _has_bits_[0] |= 1u << 1;
}

inline void DisplayPasskeyRequest::clear_has_passkey () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void DisplayPasskeyRequest::set_has_entered () {
    _has_bits_[0] |= 1u << 2;
}

inline void DisplayPasskeyRequest::clear_has_entered () {
    _has_bits_[0] &= ~ (1u << 2);
}

} // namespace Agent
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_AGENT_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
