/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Adapter1.h"
#include "org/bluez/Adapter1DBus.h"
#include "org/bluez/Adapter1Json.h"
#include "org/bluez/Adapter1Proxy.h"
#include <map>
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Adapter1 {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/Adapter1", Adapter1Proxy);

class Adapter1ProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    Adapter1ProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< Adapter1Proxy >& proxyShared = ::boost::static_pointer_cast< Adapter1Proxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_AdapterInitialization:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AdapterInitializationSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AdapterInitialization", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<AdapterInitializationSignal> payload = ::boost::static_pointer_cast<AdapterInitializationSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((AdapterInitializationCallbackIF*) _callback)->onAdapterInitializationSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DeviceCreated:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceCreatedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceCreated", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DeviceCreatedSignal> payload = ::boost::static_pointer_cast<DeviceCreatedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DeviceCreatedCallbackIF*) _callback)->onDeviceCreatedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DeviceRemoved:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceRemovedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceRemoved", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DeviceRemovedSignal> payload = ::boost::static_pointer_cast<DeviceRemovedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DeviceRemovedCallbackIF*) _callback)->onDeviceRemovedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtStackLog:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtStackLogSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtStackLog", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtStackLogSignal> payload = ::boost::static_pointer_cast<BtStackLogSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtStackLogCallbackIF*) _callback)->onBtStackLogSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_HCIEvent:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HCIEventSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HCIEvent", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<HCIEventSignal> payload = ::boost::static_pointer_cast<HCIEventSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((HCIEventCallbackIF*) _callback)->onHCIEventSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DeviceFound:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceFoundSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceFound", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DeviceFoundSignal> payload = ::boost::static_pointer_cast<DeviceFoundSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DeviceFoundCallbackIF*) _callback)->onDeviceFoundSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_Address:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressError> payload = ::boost::static_pointer_cast<AddressError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AddressCallbackIF*) _callback)->onAddressError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AddressUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Address", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AddressUpdate> payload = ::boost::static_pointer_cast<AddressUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AddressCallbackIF*) _callback)->onAddressUpdate(proxyShared, payload);
                        proxyShared->_address = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Class:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClassError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Class", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClassError> payload = ::boost::static_pointer_cast<ClassError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ClassCallbackIF*) _callback)->onClassError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ClassUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Class", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ClassUpdate> payload = ::boost::static_pointer_cast<ClassUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ClassCallbackIF*) _callback)->onClassUpdate(proxyShared, payload);
                        proxyShared->_class = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Alias:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasError> payload = ::boost::static_pointer_cast<AliasError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AliasCallbackIF*) _callback)->onAliasError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AliasUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Alias", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AliasUpdate> payload = ::boost::static_pointer_cast<AliasUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AliasCallbackIF*) _callback)->onAliasUpdate(proxyShared, payload);
                        proxyShared->_alias = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Powered:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PoweredError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Powered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PoweredError> payload = ::boost::static_pointer_cast<PoweredError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PoweredCallbackIF*) _callback)->onPoweredError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PoweredUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Powered", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PoweredUpdate> payload = ::boost::static_pointer_cast<PoweredUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PoweredCallbackIF*) _callback)->onPoweredUpdate(proxyShared, payload);
                        proxyShared->_powered = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Discoverable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Discoverable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableError> payload = ::boost::static_pointer_cast<DiscoverableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DiscoverableCallbackIF*) _callback)->onDiscoverableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Discoverable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableUpdate> payload = ::boost::static_pointer_cast<DiscoverableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DiscoverableCallbackIF*) _callback)->onDiscoverableUpdate(proxyShared, payload);
                        proxyShared->_discoverable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_DiscoverableTimeout:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableTimeoutError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DiscoverableTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableTimeoutError> payload = ::boost::static_pointer_cast<DiscoverableTimeoutError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DiscoverableTimeoutCallbackIF*) _callback)->onDiscoverableTimeoutError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoverableTimeoutUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DiscoverableTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoverableTimeoutUpdate> payload = ::boost::static_pointer_cast<DiscoverableTimeoutUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DiscoverableTimeoutCallbackIF*) _callback)->onDiscoverableTimeoutUpdate(proxyShared, payload);
                        proxyShared->_discoverableTimeout = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Pairable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Pairable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairableError> payload = ::boost::static_pointer_cast<PairableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PairableCallbackIF*) _callback)->onPairableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Pairable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairableUpdate> payload = ::boost::static_pointer_cast<PairableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PairableCallbackIF*) _callback)->onPairableUpdate(proxyShared, payload);
                        proxyShared->_pairable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_PairableTimeout:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairableTimeoutError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PairableTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairableTimeoutError> payload = ::boost::static_pointer_cast<PairableTimeoutError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((PairableTimeoutCallbackIF*) _callback)->onPairableTimeoutError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PairableTimeoutUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PairableTimeout", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<PairableTimeoutUpdate> payload = ::boost::static_pointer_cast<PairableTimeoutUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((PairableTimeoutCallbackIF*) _callback)->onPairableTimeoutUpdate(proxyShared, payload);
                        proxyShared->_pairableTimeout = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Discovering:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoveringError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Discovering", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoveringError> payload = ::boost::static_pointer_cast<DiscoveringError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((DiscoveringCallbackIF*) _callback)->onDiscoveringError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DiscoveringUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Discovering", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DiscoveringUpdate> payload = ::boost::static_pointer_cast<DiscoveringUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((DiscoveringCallbackIF*) _callback)->onDiscoveringUpdate(proxyShared, payload);
                        proxyShared->_discovering = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_UUIDs:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UUIDsError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UUIDs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UUIDsError> payload = ::boost::static_pointer_cast<UUIDsError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((UUIDsCallbackIF*) _callback)->onUUIDsError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), UUIDsUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "UUIDs", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<UUIDsUpdate> payload = ::boost::static_pointer_cast<UUIDsUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((UUIDsCallbackIF*) _callback)->onUUIDsUpdate(proxyShared, payload);
                        proxyShared->_uUIDs = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_WBSMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WBSModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WBSMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WBSModeError> payload = ::boost::static_pointer_cast<WBSModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((WBSModeCallbackIF*) _callback)->onWBSModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), WBSModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "WBSMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<WBSModeUpdate> payload = ::boost::static_pointer_cast<WBSModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((WBSModeCallbackIF*) _callback)->onWBSModeUpdate(proxyShared, payload);
                        proxyShared->_wBSMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Connectable:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectableError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connectable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectableError> payload = ::boost::static_pointer_cast<ConnectableError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((ConnectableCallbackIF*) _callback)->onConnectableError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectableUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Connectable", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectableUpdate> payload = ::boost::static_pointer_cast<ConnectableUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((ConnectableCallbackIF*) _callback)->onConnectableUpdate(proxyShared, payload);
                        proxyShared->_connectable = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_HCIMode:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HCIModeError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HCIMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HCIModeError> payload = ::boost::static_pointer_cast<HCIModeError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((HCIModeCallbackIF*) _callback)->onHCIModeError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), HCIModeUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "HCIMode", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<HCIModeUpdate> payload = ::boost::static_pointer_cast<HCIModeUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((HCIModeCallbackIF*) _callback)->onHCIModeUpdate(proxyShared, payload);
                        proxyShared->_hCIMode = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_Version:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionError> payload = ::boost::static_pointer_cast<VersionError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((VersionCallbackIF*) _callback)->onVersionError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), VersionUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Version", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<VersionUpdate> payload = ::boost::static_pointer_cast<VersionUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((VersionCallbackIF*) _callback)->onVersionUpdate(proxyShared, payload);
                        proxyShared->_version = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TraceLevel:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TraceLevelError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TraceLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TraceLevelError> payload = ::boost::static_pointer_cast<TraceLevelError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TraceLevelCallbackIF*) _callback)->onTraceLevelError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TraceLevelUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TraceLevel", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TraceLevelUpdate> payload = ::boost::static_pointer_cast<TraceLevelUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TraceLevelCallbackIF*) _callback)->onTraceLevelUpdate(proxyShared, payload);
                        proxyShared->_traceLevel = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_TraceCategory:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TraceCategoryError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TraceCategory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TraceCategoryError> payload = ::boost::static_pointer_cast<TraceCategoryError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((TraceCategoryCallbackIF*) _callback)->onTraceCategoryError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), TraceCategoryUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "TraceCategory", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<TraceCategoryUpdate> payload = ::boost::static_pointer_cast<TraceCategoryUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((TraceCategoryCallbackIF*) _callback)->onTraceCategoryUpdate(proxyShared, payload);
                        proxyShared->_traceCategory = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_AvailableSPPServers:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AvailableSPPServersError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AvailableSPPServers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AvailableSPPServersError> payload = ::boost::static_pointer_cast<AvailableSPPServersError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((AvailableSPPServersCallbackIF*) _callback)->onAvailableSPPServersError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), AvailableSPPServersUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "AvailableSPPServers", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<AvailableSPPServersUpdate> payload = ::boost::static_pointer_cast<AvailableSPPServersUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((AvailableSPPServersCallbackIF*) _callback)->onAvailableSPPServersUpdate(proxyShared, payload);
                        proxyShared->_availableSPPServers = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_StartDiscovery:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StartDiscoveryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartDiscoveryError> payload = ::boost::static_pointer_cast<StartDiscoveryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartDiscoveryCallbackIF*) _callback)->onStartDiscoveryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StartDiscoveryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StartDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StartDiscoveryResponse> payload = ::boost::static_pointer_cast<StartDiscoveryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StartDiscoveryCallbackIF*) _callback)->onStartDiscoveryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_StopDiscovery:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), StopDiscoveryError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopDiscoveryError> payload = ::boost::static_pointer_cast<StopDiscoveryError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopDiscoveryCallbackIF*) _callback)->onStopDiscoveryError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), StopDiscoveryResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "StopDiscovery", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<StopDiscoveryResponse> payload = ::boost::static_pointer_cast<StopDiscoveryResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((StopDiscoveryCallbackIF*) _callback)->onStopDiscoveryResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_RemoveDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), RemoveDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveDeviceError> payload = ::boost::static_pointer_cast<RemoveDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveDeviceCallbackIF*) _callback)->onRemoveDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "RemoveDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<RemoveDeviceResponse> payload = ::boost::static_pointer_cast<RemoveDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((RemoveDeviceCallbackIF*) _callback)->onRemoveDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_CreateDevice:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), CreateDeviceError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateDeviceError> payload = ::boost::static_pointer_cast<CreateDeviceError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateDeviceCallbackIF*) _callback)->onCreateDeviceError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), CreateDeviceResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "CreateDevice", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<CreateDeviceResponse> payload = ::boost::static_pointer_cast<CreateDeviceResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((CreateDeviceCallbackIF*) _callback)->onCreateDeviceResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SendHCICmd:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendHCICmdError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendHCICmd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendHCICmdError> payload = ::boost::static_pointer_cast<SendHCICmdError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendHCICmdCallbackIF*) _callback)->onSendHCICmdError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendHCICmdResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendHCICmd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendHCICmdResponse> payload = ::boost::static_pointer_cast<SendHCICmdResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendHCICmdCallbackIF*) _callback)->onSendHCICmdResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_AdapterInitialization: {
                ::boost::shared_ptr< AdapterInitializationError > payload = ::boost::shared_ptr< AdapterInitializationError >
                (new AdapterInitializationError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AdapterInitialization", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AdapterInitializationCallbackIF*) _callback)->onAdapterInitializationError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceCreated: {
                ::boost::shared_ptr< DeviceCreatedError > payload = ::boost::shared_ptr< DeviceCreatedError >
                (new DeviceCreatedError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceCreated", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceCreatedCallbackIF*) _callback)->onDeviceCreatedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceRemoved: {
                ::boost::shared_ptr< DeviceRemovedError > payload = ::boost::shared_ptr< DeviceRemovedError >
                (new DeviceRemovedError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceRemoved", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceRemovedCallbackIF*) _callback)->onDeviceRemovedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtStackLog: {
                ::boost::shared_ptr< BtStackLogError > payload = ::boost::shared_ptr< BtStackLogError >
                (new BtStackLogError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtStackLog", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtStackLogCallbackIF*) _callback)->onBtStackLogError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HCIEvent: {
                ::boost::shared_ptr< HCIEventError > payload = ::boost::shared_ptr< HCIEventError >
                (new HCIEventError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HCIEvent", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HCIEventCallbackIF*) _callback)->onHCIEventError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceFound: {
                ::boost::shared_ptr< DeviceFoundError > payload = ::boost::shared_ptr< DeviceFoundError >
                (new DeviceFoundError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceFound", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceFoundCallbackIF*) _callback)->onDeviceFoundError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Address: {
                ::boost::shared_ptr< AddressError > payload = ::boost::shared_ptr< AddressError >
                (new AddressError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Address", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AddressCallbackIF*) _callback)->onAddressError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Class: {
                ::boost::shared_ptr< ClassError > payload = ::boost::shared_ptr< ClassError >
                (new ClassError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Class", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ClassCallbackIF*) _callback)->onClassError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Alias: {
                ::boost::shared_ptr< AliasError > payload = ::boost::shared_ptr< AliasError >
                (new AliasError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Alias", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AliasCallbackIF*) _callback)->onAliasError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Powered: {
                ::boost::shared_ptr< PoweredError > payload = ::boost::shared_ptr< PoweredError >
                (new PoweredError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Powered", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PoweredCallbackIF*) _callback)->onPoweredError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Discoverable: {
                ::boost::shared_ptr< DiscoverableError > payload = ::boost::shared_ptr< DiscoverableError >
                (new DiscoverableError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Discoverable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiscoverableCallbackIF*) _callback)->onDiscoverableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DiscoverableTimeout: {
                ::boost::shared_ptr< DiscoverableTimeoutError > payload = ::boost::shared_ptr< DiscoverableTimeoutError >
                (new DiscoverableTimeoutError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DiscoverableTimeout", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiscoverableTimeoutCallbackIF*) _callback)->onDiscoverableTimeoutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Pairable: {
                ::boost::shared_ptr< PairableError > payload = ::boost::shared_ptr< PairableError >
                (new PairableError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Pairable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PairableCallbackIF*) _callback)->onPairableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_PairableTimeout: {
                ::boost::shared_ptr< PairableTimeoutError > payload = ::boost::shared_ptr< PairableTimeoutError >
                (new PairableTimeoutError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PairableTimeout", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PairableTimeoutCallbackIF*) _callback)->onPairableTimeoutError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Discovering: {
                ::boost::shared_ptr< DiscoveringError > payload = ::boost::shared_ptr< DiscoveringError >
                (new DiscoveringError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Discovering", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DiscoveringCallbackIF*) _callback)->onDiscoveringError (proxyShared,payload);
                return true;
            }
            break;
            case ID_UUIDs: {
                ::boost::shared_ptr< UUIDsError > payload = ::boost::shared_ptr< UUIDsError >
                (new UUIDsError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "UUIDs", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((UUIDsCallbackIF*) _callback)->onUUIDsError (proxyShared,payload);
                return true;
            }
            break;
            case ID_WBSMode: {
                ::boost::shared_ptr< WBSModeError > payload = ::boost::shared_ptr< WBSModeError >
                (new WBSModeError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "WBSMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((WBSModeCallbackIF*) _callback)->onWBSModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connectable: {
                ::boost::shared_ptr< ConnectableError > payload = ::boost::shared_ptr< ConnectableError >
                (new ConnectableError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connectable", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectableCallbackIF*) _callback)->onConnectableError (proxyShared,payload);
                return true;
            }
            break;
            case ID_HCIMode: {
                ::boost::shared_ptr< HCIModeError > payload = ::boost::shared_ptr< HCIModeError >
                (new HCIModeError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "HCIMode", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((HCIModeCallbackIF*) _callback)->onHCIModeError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Version: {
                ::boost::shared_ptr< VersionError > payload = ::boost::shared_ptr< VersionError >
                (new VersionError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Version", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((VersionCallbackIF*) _callback)->onVersionError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TraceLevel: {
                ::boost::shared_ptr< TraceLevelError > payload = ::boost::shared_ptr< TraceLevelError >
                (new TraceLevelError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TraceLevel", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TraceLevelCallbackIF*) _callback)->onTraceLevelError (proxyShared,payload);
                return true;
            }
            break;
            case ID_TraceCategory: {
                ::boost::shared_ptr< TraceCategoryError > payload = ::boost::shared_ptr< TraceCategoryError >
                (new TraceCategoryError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "TraceCategory", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((TraceCategoryCallbackIF*) _callback)->onTraceCategoryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_AvailableSPPServers: {
                ::boost::shared_ptr< AvailableSPPServersError > payload = ::boost::shared_ptr< AvailableSPPServersError >
                (new AvailableSPPServersError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "AvailableSPPServers", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((AvailableSPPServersCallbackIF*) _callback)->onAvailableSPPServersError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StartDiscovery: {
                ::boost::shared_ptr< StartDiscoveryError > payload = ::boost::shared_ptr< StartDiscoveryError >
                (new StartDiscoveryError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StartDiscovery", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StartDiscoveryCallbackIF*) _callback)->onStartDiscoveryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_StopDiscovery: {
                ::boost::shared_ptr< StopDiscoveryError > payload = ::boost::shared_ptr< StopDiscoveryError >
                (new StopDiscoveryError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "StopDiscovery", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((StopDiscoveryCallbackIF*) _callback)->onStopDiscoveryError (proxyShared,payload);
                return true;
            }
            break;
            case ID_RemoveDevice: {
                ::boost::shared_ptr< RemoveDeviceError > payload = ::boost::shared_ptr< RemoveDeviceError >
                (new RemoveDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "RemoveDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((RemoveDeviceCallbackIF*) _callback)->onRemoveDeviceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_CreateDevice: {
                ::boost::shared_ptr< CreateDeviceError > payload = ::boost::shared_ptr< CreateDeviceError >
                (new CreateDeviceError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "CreateDevice", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((CreateDeviceCallbackIF*) _callback)->onCreateDeviceError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendHCICmd: {
                ::boost::shared_ptr< SendHCICmdError > payload = ::boost::shared_ptr< SendHCICmdError >
                (new SendHCICmdError(DBUS_ERROR_NO_SERVER, "The DBus service Adapter1 is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendHCICmd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<Adapter1Proxy> proxyShared = ::boost::static_pointer_cast<Adapter1Proxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendHCICmdCallbackIF*) _callback)->onSendHCICmdError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& Adapter1ProxyCallback::_logger (Adapter1Proxy::_logger);

Adapter1Proxy::Adapter1Proxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.Adapter1", serviceAvailable, _logger) {
}

Adapter1Proxy::~Adapter1Proxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< Adapter1Proxy > Adapter1Proxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<Adapter1Proxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< Adapter1Proxy > proxyNew(new Adapter1Proxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t Adapter1Proxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t Adapter1Proxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::clearAllProperties ()
{
    _address = ::asf::core::nullable< AddressUpdate >();
    _class = ::asf::core::nullable< ClassUpdate >();
    _alias = ::asf::core::nullable< AliasUpdate >();
    _powered = ::asf::core::nullable< PoweredUpdate >();
    _discoverable = ::asf::core::nullable< DiscoverableUpdate >();
    _discoverableTimeout = ::asf::core::nullable< DiscoverableTimeoutUpdate >();
    _pairable = ::asf::core::nullable< PairableUpdate >();
    _pairableTimeout = ::asf::core::nullable< PairableTimeoutUpdate >();
    _discovering = ::asf::core::nullable< DiscoveringUpdate >();
    _uUIDs = ::asf::core::nullable< UUIDsUpdate >();
    _wBSMode = ::asf::core::nullable< WBSModeUpdate >();
    _connectable = ::asf::core::nullable< ConnectableUpdate >();
    _hCIMode = ::asf::core::nullable< HCIModeUpdate >();
    _version = ::asf::core::nullable< VersionUpdate >();
    _traceLevel = ::asf::core::nullable< TraceLevelUpdate >();
    _traceCategory = ::asf::core::nullable< TraceCategoryUpdate >();
    _availableSPPServers = ::asf::core::nullable< AvailableSPPServersUpdate >();
}

void Adapter1Proxy::sendDeregisterAll () const
{
    sendAddressDeregisterAll();
    sendClassDeregisterAll();
    sendAliasDeregisterAll();
    sendPoweredDeregisterAll();
    sendDiscoverableDeregisterAll();
    sendDiscoverableTimeoutDeregisterAll();
    sendPairableDeregisterAll();
    sendPairableTimeoutDeregisterAll();
    sendDiscoveringDeregisterAll();
    sendUUIDsDeregisterAll();
    sendWBSModeDeregisterAll();
    sendConnectableDeregisterAll();
    sendHCIModeDeregisterAll();
    sendVersionDeregisterAll();
    sendTraceLevelDeregisterAll();
    sendTraceCategoryDeregisterAll();
    sendAvailableSPPServersDeregisterAll();
    sendAdapterInitializationDeregisterAll();
    sendDeviceCreatedDeregisterAll();
    sendDeviceRemovedDeregisterAll();
    sendBtStackLogDeregisterAll();
    sendHCIEventDeregisterAll();
    sendDeviceFoundDeregisterAll();
}

act_t Adapter1Proxy::sendAdapterInitializationRegister(AdapterInitializationCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "AdapterInitialization");
    act_t act = addSignalCallback(ID_AdapterInitialization, "AdapterInitialization", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AdapterInitialization", &cb, act);
    return act;
}

bool Adapter1Proxy::sendAdapterInitializationDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AdapterInitialization", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AdapterInitialization", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendAdapterInitializationDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AdapterInitialization");
    _dbusProxyDelegate->deregisterSignalCallback("AdapterInitialization", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendDeviceCreatedRegister(DeviceCreatedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DeviceCreated");
    act_t act = addSignalCallback(ID_DeviceCreated, "DeviceCreated", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceCreated", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDeviceCreatedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceCreated", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceCreated", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendDeviceCreatedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceCreated");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceCreated", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendDeviceRemovedRegister(DeviceRemovedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DeviceRemoved");
    act_t act = addSignalCallback(ID_DeviceRemoved, "DeviceRemoved", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceRemoved", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDeviceRemovedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceRemoved", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceRemoved", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendDeviceRemovedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceRemoved");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceRemoved", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendBtStackLogRegister(BtStackLogCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtStackLog");
    act_t act = addSignalCallback(ID_BtStackLog, "BtStackLog", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtStackLog", &cb, act);
    return act;
}

bool Adapter1Proxy::sendBtStackLogDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtStackLog", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtStackLog", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendBtStackLogDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtStackLog");
    _dbusProxyDelegate->deregisterSignalCallback("BtStackLog", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendHCIEventRegister(HCIEventCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "HCIEvent");
    act_t act = addSignalCallback(ID_HCIEvent, "HCIEvent", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HCIEvent", &cb, act);
    return act;
}

bool Adapter1Proxy::sendHCIEventDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("HCIEvent", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HCIEvent", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendHCIEventDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HCIEvent");
    _dbusProxyDelegate->deregisterSignalCallback("HCIEvent", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendDeviceFoundRegister(DeviceFoundCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DeviceFound");
    act_t act = addSignalCallback(ID_DeviceFound, "DeviceFound", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceFound", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDeviceFoundDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceFound", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceFound", act, static_cast<int>(rv));
    return rv;
}

void Adapter1Proxy::sendDeviceFoundDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceFound");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceFound", 0, _dbusDaemonProxy.get(), false);
}

act_t Adapter1Proxy::sendAddressRegister(AddressCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Address, "Address", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Address", &cb, act);
    return act;
}

bool Adapter1Proxy::sendAddressDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Address", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Address", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendAddressGet(AddressCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Address, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Address", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Address", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::string& Adapter1Proxy::getAddress() const {
    return _address.get().getAddress();
}

bool Adapter1Proxy::hasAddress() const {
    return _address.hasValue();
}

void Adapter1Proxy::sendAddressDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Address");
    _dbusProxyDelegate->deregisterSignalCallback("Address", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendClassRegister(ClassCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Class, "Class", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Class", &cb, act);
    return act;
}

bool Adapter1Proxy::sendClassDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Class", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Class", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendClassGet(ClassCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Class, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Class", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Class", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


uint32 Adapter1Proxy::getClass() const {
    return _class.get().getClass();
}

bool Adapter1Proxy::hasClass() const {
    return _class.hasValue();
}

void Adapter1Proxy::sendClassDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Class");
    _dbusProxyDelegate->deregisterSignalCallback("Class", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendAliasRegister(AliasCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Alias, "Alias", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, act);
    return act;
}

bool Adapter1Proxy::sendAliasDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Alias", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Alias", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendAliasGet(AliasCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Alias, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Alias", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendAliasSet(const ::std::string& alias) {
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Alias");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent);
}

act_t Adapter1Proxy::sendAliasSet(AliasCallbackIF& cb, const ::std::string& alias) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Alias, &cb);
    AliasSet parameter(alias);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Alias", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Alias", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& Adapter1Proxy::getAlias() const {
    return _alias.get().getAlias();
}

bool Adapter1Proxy::hasAlias() const {
    return _alias.hasValue();
}

void Adapter1Proxy::sendAliasDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Alias");
    _dbusProxyDelegate->deregisterSignalCallback("Alias", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendPoweredRegister(PoweredCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Powered, "Powered", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, act);
    return act;
}

bool Adapter1Proxy::sendPoweredDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Powered", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Powered", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendPoweredGet(PoweredCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Powered, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Powered", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendPoweredSet(bool powered) {
    PoweredSet parameter(powered);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Powered");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Powered", propertyContent);
}

act_t Adapter1Proxy::sendPoweredSet(PoweredCallbackIF& cb, bool powered) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Powered, &cb);
    PoweredSet parameter(powered);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Powered", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Powered", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getPowered() const {
    return _powered.get().getPowered();
}

bool Adapter1Proxy::hasPowered() const {
    return _powered.hasValue();
}

void Adapter1Proxy::sendPoweredDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Powered");
    _dbusProxyDelegate->deregisterSignalCallback("Powered", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendDiscoverableRegister(DiscoverableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Discoverable, "Discoverable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Discoverable", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDiscoverableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Discoverable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Discoverable", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendDiscoverableGet(DiscoverableCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Discoverable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Discoverable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Discoverable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendDiscoverableSet(bool discoverable) {
    DiscoverableSet parameter(discoverable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Discoverable");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Discoverable", propertyContent);
}

act_t Adapter1Proxy::sendDiscoverableSet(DiscoverableCallbackIF& cb, bool discoverable) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Discoverable, &cb);
    DiscoverableSet parameter(discoverable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Discoverable", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Discoverable", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getDiscoverable() const {
    return _discoverable.get().getDiscoverable();
}

bool Adapter1Proxy::hasDiscoverable() const {
    return _discoverable.hasValue();
}

void Adapter1Proxy::sendDiscoverableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Discoverable");
    _dbusProxyDelegate->deregisterSignalCallback("Discoverable", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendDiscoverableTimeoutRegister(DiscoverableTimeoutCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_DiscoverableTimeout, "DiscoverableTimeout", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DiscoverableTimeout", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDiscoverableTimeoutDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DiscoverableTimeout", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DiscoverableTimeout", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendDiscoverableTimeoutGet(DiscoverableTimeoutCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_DiscoverableTimeout, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "DiscoverableTimeout", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("DiscoverableTimeout", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendDiscoverableTimeoutSet(uint32 discoverableTimeout) {
    DiscoverableTimeoutSet parameter(discoverableTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "DiscoverableTimeout");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DiscoverableTimeout", propertyContent);
}

act_t Adapter1Proxy::sendDiscoverableTimeoutSet(DiscoverableTimeoutCallbackIF& cb, uint32 discoverableTimeout) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_DiscoverableTimeout, &cb);
    DiscoverableTimeoutSet parameter(discoverableTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "DiscoverableTimeout", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "DiscoverableTimeout", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 Adapter1Proxy::getDiscoverableTimeout() const {
    return _discoverableTimeout.get().getDiscoverableTimeout();
}

bool Adapter1Proxy::hasDiscoverableTimeout() const {
    return _discoverableTimeout.hasValue();
}

void Adapter1Proxy::sendDiscoverableTimeoutDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DiscoverableTimeout");
    _dbusProxyDelegate->deregisterSignalCallback("DiscoverableTimeout", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendPairableRegister(PairableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Pairable, "Pairable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Pairable", &cb, act);
    return act;
}

bool Adapter1Proxy::sendPairableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Pairable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Pairable", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendPairableGet(PairableCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Pairable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Pairable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Pairable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendPairableSet(bool pairable) {
    PairableSet parameter(pairable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Pairable");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Pairable", propertyContent);
}

act_t Adapter1Proxy::sendPairableSet(PairableCallbackIF& cb, bool pairable) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Pairable, &cb);
    PairableSet parameter(pairable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Pairable", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Pairable", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getPairable() const {
    return _pairable.get().getPairable();
}

bool Adapter1Proxy::hasPairable() const {
    return _pairable.hasValue();
}

void Adapter1Proxy::sendPairableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Pairable");
    _dbusProxyDelegate->deregisterSignalCallback("Pairable", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendPairableTimeoutRegister(PairableTimeoutCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_PairableTimeout, "PairableTimeout", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PairableTimeout", &cb, act);
    return act;
}

bool Adapter1Proxy::sendPairableTimeoutDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PairableTimeout", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PairableTimeout", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendPairableTimeoutGet(PairableTimeoutCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_PairableTimeout, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "PairableTimeout", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("PairableTimeout", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendPairableTimeoutSet(uint32 pairableTimeout) {
    PairableTimeoutSet parameter(pairableTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "PairableTimeout");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PairableTimeout", propertyContent);
}

act_t Adapter1Proxy::sendPairableTimeoutSet(PairableTimeoutCallbackIF& cb, uint32 pairableTimeout) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_PairableTimeout, &cb);
    PairableTimeoutSet parameter(pairableTimeout);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "PairableTimeout", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "PairableTimeout", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

uint32 Adapter1Proxy::getPairableTimeout() const {
    return _pairableTimeout.get().getPairableTimeout();
}

bool Adapter1Proxy::hasPairableTimeout() const {
    return _pairableTimeout.hasValue();
}

void Adapter1Proxy::sendPairableTimeoutDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PairableTimeout");
    _dbusProxyDelegate->deregisterSignalCallback("PairableTimeout", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendDiscoveringRegister(DiscoveringCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Discovering, "Discovering", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Discovering", &cb, act);
    return act;
}

bool Adapter1Proxy::sendDiscoveringDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Discovering", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Discovering", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendDiscoveringGet(DiscoveringCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Discovering, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Discovering", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Discovering", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


bool Adapter1Proxy::getDiscovering() const {
    return _discovering.get().getDiscovering();
}

bool Adapter1Proxy::hasDiscovering() const {
    return _discovering.hasValue();
}

void Adapter1Proxy::sendDiscoveringDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Discovering");
    _dbusProxyDelegate->deregisterSignalCallback("Discovering", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendUUIDsRegister(UUIDsCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_UUIDs, "UUIDs", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "UUIDs", &cb, act);
    return act;
}

bool Adapter1Proxy::sendUUIDsDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("UUIDs", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "UUIDs", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendUUIDsGet(UUIDsCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_UUIDs, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "UUIDs", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("UUIDs", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendUUIDsSet(const ::std::vector< ::std::string >& uUIDs) {
    UUIDsSet parameter(uUIDs);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "UUIDs");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UUIDs", propertyContent);
}

act_t Adapter1Proxy::sendUUIDsSet(UUIDsCallbackIF& cb, const ::std::vector< ::std::string >& uUIDs) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_UUIDs, &cb);
    UUIDsSet parameter(uUIDs);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "UUIDs", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "UUIDs", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< ::std::string >& Adapter1Proxy::getUUIDs() const {
    return _uUIDs.get().getUUIDs();
}

bool Adapter1Proxy::hasUUIDs() const {
    return _uUIDs.hasValue();
}

void Adapter1Proxy::sendUUIDsDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "UUIDs");
    _dbusProxyDelegate->deregisterSignalCallback("UUIDs", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendWBSModeRegister(WBSModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_WBSMode, "WBSMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "WBSMode", &cb, act);
    return act;
}

bool Adapter1Proxy::sendWBSModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("WBSMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "WBSMode", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendWBSModeGet(WBSModeCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_WBSMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "WBSMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("WBSMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendWBSModeSet(bool wBSMode) {
    WBSModeSet parameter(wBSMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "WBSMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WBSMode", propertyContent);
}

act_t Adapter1Proxy::sendWBSModeSet(WBSModeCallbackIF& cb, bool wBSMode) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_WBSMode, &cb);
    WBSModeSet parameter(wBSMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "WBSMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "WBSMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getWBSMode() const {
    return _wBSMode.get().getWBSMode();
}

bool Adapter1Proxy::hasWBSMode() const {
    return _wBSMode.hasValue();
}

void Adapter1Proxy::sendWBSModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "WBSMode");
    _dbusProxyDelegate->deregisterSignalCallback("WBSMode", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendConnectableRegister(ConnectableCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Connectable, "Connectable", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Connectable", &cb, act);
    return act;
}

bool Adapter1Proxy::sendConnectableDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Connectable", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Connectable", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendConnectableGet(ConnectableCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Connectable, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Connectable", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Connectable", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendConnectableSet(bool connectable) {
    ConnectableSet parameter(connectable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "Connectable");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Connectable", propertyContent);
}

act_t Adapter1Proxy::sendConnectableSet(ConnectableCallbackIF& cb, bool connectable) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Connectable, &cb);
    ConnectableSet parameter(connectable);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "Connectable", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "Connectable", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getConnectable() const {
    return _connectable.get().getConnectable();
}

bool Adapter1Proxy::hasConnectable() const {
    return _connectable.hasValue();
}

void Adapter1Proxy::sendConnectableDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Connectable");
    _dbusProxyDelegate->deregisterSignalCallback("Connectable", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendHCIModeRegister(HCIModeCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_HCIMode, "HCIMode", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "HCIMode", &cb, act);
    return act;
}

bool Adapter1Proxy::sendHCIModeDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("HCIMode", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "HCIMode", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendHCIModeGet(HCIModeCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_HCIMode, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "HCIMode", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("HCIMode", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendHCIModeSet(bool hCIMode) {
    HCIModeSet parameter(hCIMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "HCIMode");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "HCIMode", propertyContent);
}

act_t Adapter1Proxy::sendHCIModeSet(HCIModeCallbackIF& cb, bool hCIMode) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_HCIMode, &cb);
    HCIModeSet parameter(hCIMode);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "HCIMode", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "HCIMode", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

bool Adapter1Proxy::getHCIMode() const {
    return _hCIMode.get().getHCIMode();
}

bool Adapter1Proxy::hasHCIMode() const {
    return _hCIMode.hasValue();
}

void Adapter1Proxy::sendHCIModeDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "HCIMode");
    _dbusProxyDelegate->deregisterSignalCallback("HCIMode", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendVersionRegister(VersionCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_Version, "Version", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Version", &cb, act);
    return act;
}

bool Adapter1Proxy::sendVersionDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("Version", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Version", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendVersionGet(VersionCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_Version, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Version", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("Version", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& Adapter1Proxy::getVersion() const {
    return _version.get().getVersion();
}

bool Adapter1Proxy::hasVersion() const {
    return _version.hasValue();
}

void Adapter1Proxy::sendVersionDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Version");
    _dbusProxyDelegate->deregisterSignalCallback("Version", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendTraceLevelRegister(TraceLevelCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TraceLevel, "TraceLevel", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TraceLevel", &cb, act);
    return act;
}

bool Adapter1Proxy::sendTraceLevelDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TraceLevel", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TraceLevel", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendTraceLevelGet(TraceLevelCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_TraceLevel, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TraceLevel", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TraceLevel", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendTraceLevelSet(const ::std::vector< ::std::string >& traceLevel) {
    TraceLevelSet parameter(traceLevel);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TraceLevel");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "TraceLevel", propertyContent);
}

act_t Adapter1Proxy::sendTraceLevelSet(TraceLevelCallbackIF& cb, const ::std::vector< ::std::string >& traceLevel) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_TraceLevel, &cb);
    TraceLevelSet parameter(traceLevel);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TraceLevel", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "TraceLevel", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< ::std::string >& Adapter1Proxy::getTraceLevel() const {
    return _traceLevel.get().getTraceLevel();
}

bool Adapter1Proxy::hasTraceLevel() const {
    return _traceLevel.hasValue();
}

void Adapter1Proxy::sendTraceLevelDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TraceLevel");
    _dbusProxyDelegate->deregisterSignalCallback("TraceLevel", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendTraceCategoryRegister(TraceCategoryCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_TraceCategory, "TraceCategory", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "TraceCategory", &cb, act);
    return act;
}

bool Adapter1Proxy::sendTraceCategoryDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("TraceCategory", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "TraceCategory", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendTraceCategoryGet(TraceCategoryCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_TraceCategory, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "TraceCategory", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("TraceCategory", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendTraceCategorySet(const ::std::vector< ::std::string >& traceCategory) {
    TraceCategorySet parameter(traceCategory);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "TraceCategory");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "TraceCategory", propertyContent);
}

act_t Adapter1Proxy::sendTraceCategorySet(TraceCategoryCallbackIF& cb, const ::std::vector< ::std::string >& traceCategory) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_TraceCategory, &cb);
    TraceCategorySet parameter(traceCategory);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "TraceCategory", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "TraceCategory", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< ::std::string >& Adapter1Proxy::getTraceCategory() const {
    return _traceCategory.get().getTraceCategory();
}

bool Adapter1Proxy::hasTraceCategory() const {
    return _traceCategory.hasValue();
}

void Adapter1Proxy::sendTraceCategoryDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "TraceCategory");
    _dbusProxyDelegate->deregisterSignalCallback("TraceCategory", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendAvailableSPPServersRegister(AvailableSPPServersCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_AvailableSPPServers, "AvailableSPPServers", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "AvailableSPPServers", &cb, act);
    return act;
}

bool Adapter1Proxy::sendAvailableSPPServersDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("AvailableSPPServers", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "AvailableSPPServers", act, static_cast<int>(rv));
    return rv;
}

act_t Adapter1Proxy::sendAvailableSPPServersGet(AvailableSPPServersCallbackIF& cb) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_AvailableSPPServers, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "AvailableSPPServers", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("AvailableSPPServers", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void Adapter1Proxy::sendAvailableSPPServersSet(const ::std::vector< ::std::string >& availableSPPServers) {
    AvailableSPPServersSet parameter(availableSPPServers);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "AvailableSPPServers");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AvailableSPPServers", propertyContent);
}

act_t Adapter1Proxy::sendAvailableSPPServersSet(AvailableSPPServersCallbackIF& cb, const ::std::vector< ::std::string >& availableSPPServers) {
    Adapter1ProxyCallback* callback = new Adapter1ProxyCallback(ID_AvailableSPPServers, &cb);
    AvailableSPPServersSet parameter(availableSPPServers);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "AvailableSPPServers", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "AvailableSPPServers", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::vector< ::std::string >& Adapter1Proxy::getAvailableSPPServers() const {
    return _availableSPPServers.get().getAvailableSPPServers();
}

bool Adapter1Proxy::hasAvailableSPPServers() const {
    return _availableSPPServers.hasValue();
}

void Adapter1Proxy::sendAvailableSPPServersDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "AvailableSPPServers");
    _dbusProxyDelegate->deregisterSignalCallback("AvailableSPPServers", 0, _dbusDaemonProxy.get(), true);
}

act_t Adapter1Proxy::sendStartDiscoveryRequest(StartDiscoveryCallbackIF& cb) const {
    StartDiscoveryRequest* payload = new StartDiscoveryRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StartDiscovery", StartDiscoveryRequest, payload, true)
    act_t act = addMethodCallback(ID_StartDiscovery, dbusMessage.getUniqueSerial(), "StartDiscovery", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StartDiscovery", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Adapter1Proxy::sendStopDiscoveryRequest(StopDiscoveryCallbackIF& cb) const {
    StopDiscoveryRequest* payload = new StopDiscoveryRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "StopDiscovery", StopDiscoveryRequest, payload, true)
    act_t act = addMethodCallback(ID_StopDiscovery, dbusMessage.getUniqueSerial(), "StopDiscovery", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "StopDiscovery", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Adapter1Proxy::sendRemoveDeviceRequest(RemoveDeviceCallbackIF& cb, const ::std::string& device) const {
    RemoveDeviceRequest* payload = new RemoveDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setDevice(device);
    DBUS_MESSAGE_CALL(dbusMessage, "RemoveDevice", RemoveDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_RemoveDevice, dbusMessage.getUniqueSerial(), "RemoveDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "RemoveDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Adapter1Proxy::sendCreateDeviceRequest(CreateDeviceCallbackIF& cb, const ::std::string& address) const {
    CreateDeviceRequest* payload = new CreateDeviceRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddress(address);
    DBUS_MESSAGE_CALL(dbusMessage, "CreateDevice", CreateDeviceRequest, payload, true)
    act_t act = addMethodCallback(ID_CreateDevice, dbusMessage.getUniqueSerial(), "CreateDevice", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "CreateDevice", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t Adapter1Proxy::sendSendHCICmdRequest(SendHCICmdCallbackIF& cb, const ::std::vector< uint8 >& data) const {
    SendHCICmdRequest* payload = new SendHCICmdRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "SendHCICmd", SendHCICmdRequest, payload, true)
    act_t act = addMethodCallback(ID_SendHCICmd, dbusMessage.getUniqueSerial(), "SendHCICmd", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendHCICmd", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Adapter1
} // namespace bluez
} // namespace org
