/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_GENIVI_TRACESTUB_H
#define ORG_BLUEZ_GENIVI_TRACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include <string>
#include <vector>

namespace org {
namespace bluez {
namespace genivi {
namespace Trace {

class TraceStubDelegate;

class TraceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TraceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TraceStub (const std::string& portName);

    /**
     * Create an instance of the TraceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TraceStub (const std::string& portName, const std::string& objectPath);

    virtual ~TraceStub();

    // signal 'ReportDebugTrace'

    /**
     * Raise the signal 'ReportDebugTrace' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ReportDebugTrace'</b>:
     *
     * If the meaning of "ReportDebugTrace" isn't clear, then there should be a description here.
     */
    void sendReportDebugTraceSignal(uint16 err_file, uint16 err_line, uint16 level, uint32 category, uint16 error_code, const ::std::vector< uint8 >& data);

    // signal 'FatalError'

    /**
     * Raise the signal 'FatalError' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'FatalError'</b>:
     *
     * If the meaning of "FatalError" isn't clear, then there should be a description here.
     */
    void sendFatalErrorSignal(uint16 err_file, uint16 err_line, uint16 err_code, const ::std::string& fmt, const ::std::string& err_value);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class TraceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Trace
} // namespace genivi
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_GENIVI_TRACESTUB_H
