/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "org/bluez/genivi/Trace.h"
#include "org/bluez/genivi/TraceDBus.h"
#include "org/bluez/genivi/TraceJson.h"
#include "org/bluez/genivi/TraceStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace genivi {
namespace Trace {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/genivi/Trace", TraceStub);



class TraceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TraceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TraceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TraceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.genivi.Trace"),
          _logger(logger) {}

    virtual ~TraceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TraceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TraceStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.genivi.Trace\">\n"
            "      <signal name=\"ReportDebugTrace\">\n"
            "        <arg name=\"err_file\" type=\"q\"/>\n"
            "        <arg name=\"err_line\" type=\"q\"/>\n"
            "        <arg name=\"level\" type=\"q\"/>\n"
            "        <arg name=\"category\" type=\"u\"/>\n"
            "        <arg name=\"error_code\" type=\"q\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"FatalError\">\n"
            "        <arg name=\"err_file\" type=\"q\"/>\n"
            "        <arg name=\"err_line\" type=\"q\"/>\n"
            "        <arg name=\"err_code\" type=\"q\"/>\n"
            "        <arg name=\"fmt\" type=\"s\"/>\n"
            "        <arg name=\"err_value\" type=\"s\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void TraceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TraceStub*>(getStub()))->onGetAll (properties);
}

void TraceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TraceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TraceStub::TraceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TraceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TraceStub::TraceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TraceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TraceStub::~TraceStub() {
    delete _stubDelegate;
}

void TraceStub::sendReportDebugTraceSignal(uint16 err_file, uint16 err_line, uint16 level, uint32 category, uint16 error_code, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        ReportDebugTraceSignal* payload = new ReportDebugTraceSignal(err_file, err_line, level, category, error_code, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ReportDebugTrace", ReportDebugTraceSignal, payload)
        LOG_INFO ("-> send%sSignal", "ReportDebugTrace");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ReportDebugTrace");
    }
}

void TraceStub::sendFatalErrorSignal(uint16 err_file, uint16 err_line, uint16 err_code, const ::std::string& fmt, const ::std::string& err_value) {
    if (_stubDelegate->isConnected()) {
        FatalErrorSignal* payload = new FatalErrorSignal(err_file, err_line, err_code, fmt, err_value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FatalError", FatalErrorSignal, payload)
        LOG_INFO ("-> send%sSignal", "FatalError");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FatalError");
    }
}

void TraceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Trace
} // namespace genivi
} // namespace bluez
} // namespace org
