#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_GENIVI_TRACE_H
#define ORG_BLUEZ_GENIVI_TRACE_H

#include "asf/core/Logger.h"
#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/Utf8String.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstddef>
#include <cstring>
#include <string>
#include <vector>

/**
 * If the meaning of "Trace" isn't clear, then there should be a description here.
 */

namespace org {
namespace bluez {
namespace genivi {
namespace Trace {

// method IDs

// signal IDs
static const uint16 ID_ReportDebugTrace = 0;
static const uint16 ID_FatalError = 1;

// property IDs

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class ReportDebugTraceSignal;

class FatalErrorSignal;

// type definitions
/**
 * If the meaning of "ReportDebugTraceError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError ReportDebugTraceError;

/**
 * If the meaning of "FatalErrorError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError FatalErrorError;


/**
 * If the meaning of "ReportDebugTraceSignal" isn't clear, then there should be a description here.
 */
class ReportDebugTraceSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  ReportDebugTraceSignal ();

    /**
     * Copy constructor
     */
    inline  ReportDebugTraceSignal (const ReportDebugTraceSignal &rhs);

    /**
     * All fields constructor
     */
    inline  ReportDebugTraceSignal (uint16 err_file_, uint16 err_line_, uint16 level_, uint32 category_, uint16 error_code_, const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~ReportDebugTraceSignal();

    /**
     * Assignment operator
     */
    inline ReportDebugTraceSignal& operator = (const ReportDebugTraceSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const ReportDebugTraceSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const ReportDebugTraceSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const ReportDebugTraceSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const ReportDebugTraceSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "err_file"

    static const int kErr_file = 0;

    /**
     * Clears the field "err_file".
     *
     * The field will be set to its default value. The hasErr_file()
     * method will return false.
     */
    inline void clearErr_file();

    /**
     * Checks whether the field "err_file" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_file()). Otherwise it will return false.
     */
    inline bool hasErr_file () const;

    /**
     * Returns the value of the member "err_file".
     *
     * If the meaning of "err_file" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_file"
     */
    inline uint16 getErr_file () const;

    /**
     * Sets the value of the member "err_file".
     *
     * If the meaning of "err_file" isn't clear, then there should be a description here.
     *
     * @param err_file The value which will be set
     */
    inline void setErr_file (uint16 err_file_);

    // API of field "err_line"

    static const int kErr_line = 1;

    /**
     * Clears the field "err_line".
     *
     * The field will be set to its default value. The hasErr_line()
     * method will return false.
     */
    inline void clearErr_line();

    /**
     * Checks whether the field "err_line" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_line()). Otherwise it will return false.
     */
    inline bool hasErr_line () const;

    /**
     * Returns the value of the member "err_line".
     *
     * If the meaning of "err_line" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_line"
     */
    inline uint16 getErr_line () const;

    /**
     * Sets the value of the member "err_line".
     *
     * If the meaning of "err_line" isn't clear, then there should be a description here.
     *
     * @param err_line The value which will be set
     */
    inline void setErr_line (uint16 err_line_);

    // API of field "level"

    static const int kLevel = 2;

    /**
     * Clears the field "level".
     *
     * The field will be set to its default value. The hasLevel()
     * method will return false.
     */
    inline void clearLevel();

    /**
     * Checks whether the field "level" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setLevel()). Otherwise it will return false.
     */
    inline bool hasLevel () const;

    /**
     * Returns the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @return The value of the field "level"
     */
    inline uint16 getLevel () const;

    /**
     * Sets the value of the member "level".
     *
     * If the meaning of "level" isn't clear, then there should be a description here.
     *
     * @param level The value which will be set
     */
    inline void setLevel (uint16 level_);

    // API of field "category"

    static const int kCategory = 3;

    /**
     * Clears the field "category".
     *
     * The field will be set to its default value. The hasCategory()
     * method will return false.
     */
    inline void clearCategory();

    /**
     * Checks whether the field "category" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setCategory()). Otherwise it will return false.
     */
    inline bool hasCategory () const;

    /**
     * Returns the value of the member "category".
     *
     * If the meaning of "category" isn't clear, then there should be a description here.
     *
     * @return The value of the field "category"
     */
    inline uint32 getCategory () const;

    /**
     * Sets the value of the member "category".
     *
     * If the meaning of "category" isn't clear, then there should be a description here.
     *
     * @param category The value which will be set
     */
    inline void setCategory (uint32 category_);

    // API of field "error_code"

    static const int kError_code = 4;

    /**
     * Clears the field "error_code".
     *
     * The field will be set to its default value. The hasError_code()
     * method will return false.
     */
    inline void clearError_code();

    /**
     * Checks whether the field "error_code" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setError_code()). Otherwise it will return false.
     */
    inline bool hasError_code () const;

    /**
     * Returns the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @return The value of the field "error_code"
     */
    inline uint16 getError_code () const;

    /**
     * Sets the value of the member "error_code".
     *
     * If the meaning of "error_code" isn't clear, then there should be a description here.
     *
     * @param error_code The value which will be set
     */
    inline void setError_code (uint16 error_code_);

    // API of field "data"

    static const int kData = 5;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const ReportDebugTraceSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_err_file ();

    inline void clear_has_err_file ();

    inline void set_has_err_line ();

    inline void clear_has_err_line ();

    inline void set_has_level ();

    inline void clear_has_level ();

    inline void set_has_category ();

    inline void clear_has_category ();

    inline void set_has_error_code ();

    inline void clear_has_error_code ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (6 + 31) / 32];

    uint16 _err_file;

    uint16 _err_line;

    uint16 _level;

    uint32 _category;

    uint16 _error_code;

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "FatalErrorSignal" isn't clear, then there should be a description here.
 */
class FatalErrorSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  FatalErrorSignal ();

    /**
     * Copy constructor
     */
    inline  FatalErrorSignal (const FatalErrorSignal &rhs);

    /**
     * All fields constructor
     */
    inline  FatalErrorSignal (uint16 err_file_, uint16 err_line_, uint16 err_code_, const ::std::string& fmt_, const ::std::string& err_value_);

    /**
     * Destructor
     */
    inline virtual  ~FatalErrorSignal();

    /**
     * Assignment operator
     */
    inline FatalErrorSignal& operator = (const FatalErrorSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const FatalErrorSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const FatalErrorSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const FatalErrorSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const FatalErrorSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "err_file"

    static const int kErr_file = 0;

    /**
     * Clears the field "err_file".
     *
     * The field will be set to its default value. The hasErr_file()
     * method will return false.
     */
    inline void clearErr_file();

    /**
     * Checks whether the field "err_file" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_file()). Otherwise it will return false.
     */
    inline bool hasErr_file () const;

    /**
     * Returns the value of the member "err_file".
     *
     * If the meaning of "err_file" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_file"
     */
    inline uint16 getErr_file () const;

    /**
     * Sets the value of the member "err_file".
     *
     * If the meaning of "err_file" isn't clear, then there should be a description here.
     *
     * @param err_file The value which will be set
     */
    inline void setErr_file (uint16 err_file_);

    // API of field "err_line"

    static const int kErr_line = 1;

    /**
     * Clears the field "err_line".
     *
     * The field will be set to its default value. The hasErr_line()
     * method will return false.
     */
    inline void clearErr_line();

    /**
     * Checks whether the field "err_line" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_line()). Otherwise it will return false.
     */
    inline bool hasErr_line () const;

    /**
     * Returns the value of the member "err_line".
     *
     * If the meaning of "err_line" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_line"
     */
    inline uint16 getErr_line () const;

    /**
     * Sets the value of the member "err_line".
     *
     * If the meaning of "err_line" isn't clear, then there should be a description here.
     *
     * @param err_line The value which will be set
     */
    inline void setErr_line (uint16 err_line_);

    // API of field "err_code"

    static const int kErr_code = 2;

    /**
     * Clears the field "err_code".
     *
     * The field will be set to its default value. The hasErr_code()
     * method will return false.
     */
    inline void clearErr_code();

    /**
     * Checks whether the field "err_code" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_code()). Otherwise it will return false.
     */
    inline bool hasErr_code () const;

    /**
     * Returns the value of the member "err_code".
     *
     * If the meaning of "err_code" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_code"
     */
    inline uint16 getErr_code () const;

    /**
     * Sets the value of the member "err_code".
     *
     * If the meaning of "err_code" isn't clear, then there should be a description here.
     *
     * @param err_code The value which will be set
     */
    inline void setErr_code (uint16 err_code_);

    // API of field "fmt"

    static const int kFmt = 3;

    /**
     * Clears the field "fmt".
     *
     * The field will be set to its default value. The hasFmt()
     * method will return false.
     */
    inline void clearFmt();

    /**
     * Checks whether the field "fmt" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setFmt()). Otherwise it will return false.
     */
    inline bool hasFmt () const;

    /**
     * Returns the value of the member "fmt".
     *
     * If the meaning of "fmt" isn't clear, then there should be a description here.
     *
     * @return The value of the field "fmt"
     */
    inline const ::std::string& getFmt () const;

    /**
     * Retrieves the value of the field "fmt" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "fmt".
     */
    inline ::std::string& getFmtMutable ();

    /**
     * Sets the value of the member "fmt".
     *
     * If the meaning of "fmt" isn't clear, then there should be a description here.
     *
     * @param fmt The value which will be set
     */
    inline void setFmt (const ::std::string& fmt_);

    /**
     * Sets the value of the member "fmt".
     *
     * If the meaning of "fmt" isn't clear, then there should be a description here.
     *
     * @param fmt The value which will be set
     */
    inline void setFmt (const char* fmt_);

    /**
     * Sets the value of the member "fmt".
     *
     * If the meaning of "fmt" isn't clear, then there should be a description here.
     *
     * @param fmt The value which will be set
     */
    inline void setFmt (const char* value, size_t size);

    // API of field "err_value"

    static const int kErr_value = 4;

    /**
     * Clears the field "err_value".
     *
     * The field will be set to its default value. The hasErr_value()
     * method will return false.
     */
    inline void clearErr_value();

    /**
     * Checks whether the field "err_value" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setErr_value()). Otherwise it will return false.
     */
    inline bool hasErr_value () const;

    /**
     * Returns the value of the member "err_value".
     *
     * If the meaning of "err_value" isn't clear, then there should be a description here.
     *
     * @return The value of the field "err_value"
     */
    inline const ::std::string& getErr_value () const;

    /**
     * Retrieves the value of the field "err_value" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "err_value".
     */
    inline ::std::string& getErr_valueMutable ();

    /**
     * Sets the value of the member "err_value".
     *
     * If the meaning of "err_value" isn't clear, then there should be a description here.
     *
     * @param err_value The value which will be set
     */
    inline void setErr_value (const ::std::string& err_value_);

    /**
     * Sets the value of the member "err_value".
     *
     * If the meaning of "err_value" isn't clear, then there should be a description here.
     *
     * @param err_value The value which will be set
     */
    inline void setErr_value (const char* err_value_);

    /**
     * Sets the value of the member "err_value".
     *
     * If the meaning of "err_value" isn't clear, then there should be a description here.
     *
     * @param err_value The value which will be set
     */
    inline void setErr_value (const char* value, size_t size);

    static const FatalErrorSignal &getDefaultInstance();

private:

    inline void set_has_err_file ();

    inline void clear_has_err_file ();

    inline void set_has_err_line ();

    inline void clear_has_err_line ();

    inline void set_has_err_code ();

    inline void clear_has_err_code ();

    inline void set_has_fmt ();

    inline void clear_has_fmt ();

    inline void set_has_err_value ();

    inline void clear_has_err_value ();

    uint32 _has_bits_[ (5 + 31) / 32];

    uint16 _err_file;

    uint16 _err_line;

    uint16 _err_code;

    ::std::string _fmt;

    ::std::string _err_value;

};

inline  ReportDebugTraceSignal::ReportDebugTraceSignal ()  :
    _err_file (0u),
    _err_line (0u),
    _level (0u),
    _category (0u),
    _error_code (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  ReportDebugTraceSignal::ReportDebugTraceSignal (const ReportDebugTraceSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _err_file (0u),
    _err_line (0u),
    _level (0u),
    _category (0u),
    _error_code (0u),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  ReportDebugTraceSignal::ReportDebugTraceSignal (uint16 err_file_, uint16 err_line_, uint16 level_, uint32 category_, uint16 error_code_, const ::std::vector< uint8 >& data_)  :
    _err_file (err_file_),
    _err_line (err_line_),
    _level (level_),
    _category (category_),
    _error_code (error_code_),
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  ReportDebugTraceSignal::~ReportDebugTraceSignal() {
}

inline ReportDebugTraceSignal& ReportDebugTraceSignal::operator = (const ReportDebugTraceSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErr_file()) {
            setErr_file(rhs.getErr_file());
        } else {
            clearErr_file();
        }
        if (rhs.hasErr_line()) {
            setErr_line(rhs.getErr_line());
        } else {
            clearErr_line();
        }
        if (rhs.hasLevel()) {
            setLevel(rhs.getLevel());
        } else {
            clearLevel();
        }
        if (rhs.hasCategory()) {
            setCategory(rhs.getCategory());
        } else {
            clearCategory();
        }
        if (rhs.hasError_code()) {
            setError_code(rhs.getError_code());
        } else {
            clearError_code();
        }
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool ReportDebugTraceSignal::operator == (const ReportDebugTraceSignal& rhs) const {
    return (((!hasErr_file() && !rhs.hasErr_file()) || getErr_file() == rhs.getErr_file()) &&
        ((!hasErr_line() && !rhs.hasErr_line()) || getErr_line() == rhs.getErr_line()) &&
        ((!hasLevel() && !rhs.hasLevel()) || getLevel() == rhs.getLevel()) &&
        ((!hasCategory() && !rhs.hasCategory()) || getCategory() == rhs.getCategory()) &&
        ((!hasError_code() && !rhs.hasError_code()) || getError_code() == rhs.getError_code()) &&
        ((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool ReportDebugTraceSignal::operator != (const ReportDebugTraceSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool ReportDebugTraceSignal::operator < (const ReportDebugTraceSignal& rhs) const {
    if (hasErr_file() || rhs.hasErr_file()) {
        if (getErr_file() < rhs.getErr_file()) return true;
        if (getErr_file() > rhs.getErr_file()) return false;
    }
    if (hasErr_line() || rhs.hasErr_line()) {
        if (getErr_line() < rhs.getErr_line()) return true;
        if (getErr_line() > rhs.getErr_line()) return false;
    }
    if (hasLevel() || rhs.hasLevel()) {
        if (getLevel() < rhs.getLevel()) return true;
        if (getLevel() > rhs.getLevel()) return false;
    }
    if (hasCategory() || rhs.hasCategory()) {
        if (getCategory() < rhs.getCategory()) return true;
        if (getCategory() > rhs.getCategory()) return false;
    }
    if (hasError_code() || rhs.hasError_code()) {
        if (getError_code() < rhs.getError_code()) return true;
        if (getError_code() > rhs.getError_code()) return false;
    }
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* ReportDebugTraceSignal::clone() {
    return new ReportDebugTraceSignal(*this);
}

inline bool ReportDebugTraceSignal::operator > (const ReportDebugTraceSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void ReportDebugTraceSignal::clear() {
    clearErr_file();
    clearErr_line();
    clearLevel();
    clearCategory();
    clearError_code();
    clearData();
}

inline void ReportDebugTraceSignal::clearErr_file() {
    if (hasErr_file()) {
         clear_has_err_file();
        _err_file = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasErr_file () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 ReportDebugTraceSignal::getErr_file () const {
    return _err_file;
}

inline void ReportDebugTraceSignal::setErr_file (uint16 err_file_) {
    set_has_err_file();
    this->_err_file = err_file_;
}

inline void ReportDebugTraceSignal::clearErr_line() {
    if (hasErr_line()) {
         clear_has_err_line();
        _err_line = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasErr_line () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 ReportDebugTraceSignal::getErr_line () const {
    return _err_line;
}

inline void ReportDebugTraceSignal::setErr_line (uint16 err_line_) {
    set_has_err_line();
    this->_err_line = err_line_;
}

inline void ReportDebugTraceSignal::clearLevel() {
    if (hasLevel()) {
         clear_has_level();
        _level = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasLevel () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 ReportDebugTraceSignal::getLevel () const {
    return _level;
}

inline void ReportDebugTraceSignal::setLevel (uint16 level_) {
    set_has_level();
    this->_level = level_;
}

inline void ReportDebugTraceSignal::clearCategory() {
    if (hasCategory()) {
         clear_has_category();
        _category = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasCategory () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline uint32 ReportDebugTraceSignal::getCategory () const {
    return _category;
}

inline void ReportDebugTraceSignal::setCategory (uint32 category_) {
    set_has_category();
    this->_category = category_;
}

inline void ReportDebugTraceSignal::clearError_code() {
    if (hasError_code()) {
         clear_has_error_code();
        _error_code = 0u;
     }
}

inline bool ReportDebugTraceSignal::hasError_code () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline uint16 ReportDebugTraceSignal::getError_code () const {
    return _error_code;
}

inline void ReportDebugTraceSignal::setError_code (uint16 error_code_) {
    set_has_error_code();
    this->_error_code = error_code_;
}

inline void ReportDebugTraceSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool ReportDebugTraceSignal::hasData () const {
    return (_has_bits_[0] & (1u << 5)) > 0;
}

inline const ::std::vector< uint8 >& ReportDebugTraceSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& ReportDebugTraceSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void ReportDebugTraceSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void ReportDebugTraceSignal::set_has_err_file () {
    _has_bits_[0] |= 1u << 0;
}

inline void ReportDebugTraceSignal::clear_has_err_file () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void ReportDebugTraceSignal::set_has_err_line () {
    _has_bits_[0] |= 1u << 1;
}

inline void ReportDebugTraceSignal::clear_has_err_line () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void ReportDebugTraceSignal::set_has_level () {
    _has_bits_[0] |= 1u << 2;
}

inline void ReportDebugTraceSignal::clear_has_level () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void ReportDebugTraceSignal::set_has_category () {
    _has_bits_[0] |= 1u << 3;
}

inline void ReportDebugTraceSignal::clear_has_category () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void ReportDebugTraceSignal::set_has_error_code () {
    _has_bits_[0] |= 1u << 4;
}

inline void ReportDebugTraceSignal::clear_has_error_code () {
    _has_bits_[0] &= ~ (1u << 4);
}

inline void ReportDebugTraceSignal::set_has_data () {
    _has_bits_[0] |= 1u << 5;
}

inline void ReportDebugTraceSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 5);
}

inline  FatalErrorSignal::FatalErrorSignal ()  :
    _err_file (0u),
    _err_line (0u),
    _err_code (0u),
    _fmt (),
    _err_value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  FatalErrorSignal::FatalErrorSignal (const FatalErrorSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _err_file (0u),
    _err_line (0u),
    _err_code (0u),
    _fmt (),
    _err_value ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  FatalErrorSignal::FatalErrorSignal (uint16 err_file_, uint16 err_line_, uint16 err_code_, const ::std::string& fmt_, const ::std::string& err_value_)  :
    _err_file (err_file_),
    _err_line (err_line_),
    _err_code (err_code_),
    _fmt (fmt_),
    _err_value (err_value_)
{
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fmt_), "Detected invalid utf8 string (see above error messages)");
    }
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (err_value_), "Detected invalid utf8 string (see above error messages)");
    }
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  FatalErrorSignal::~FatalErrorSignal() {
}

inline FatalErrorSignal& FatalErrorSignal::operator = (const FatalErrorSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasErr_file()) {
            setErr_file(rhs.getErr_file());
        } else {
            clearErr_file();
        }
        if (rhs.hasErr_line()) {
            setErr_line(rhs.getErr_line());
        } else {
            clearErr_line();
        }
        if (rhs.hasErr_code()) {
            setErr_code(rhs.getErr_code());
        } else {
            clearErr_code();
        }
        if (rhs.hasFmt()) {
            setFmt(rhs.getFmt());
        } else {
            clearFmt();
        }
        if (rhs.hasErr_value()) {
            setErr_value(rhs.getErr_value());
        } else {
            clearErr_value();
        }
    }
    return *this;
}

inline bool FatalErrorSignal::operator == (const FatalErrorSignal& rhs) const {
    return (((!hasErr_file() && !rhs.hasErr_file()) || getErr_file() == rhs.getErr_file()) &&
        ((!hasErr_line() && !rhs.hasErr_line()) || getErr_line() == rhs.getErr_line()) &&
        ((!hasErr_code() && !rhs.hasErr_code()) || getErr_code() == rhs.getErr_code()) &&
        ((!hasFmt() && !rhs.hasFmt()) || getFmt() == rhs.getFmt()) &&
        ((!hasErr_value() && !rhs.hasErr_value()) || getErr_value() == rhs.getErr_value()));
}

inline bool FatalErrorSignal::operator != (const FatalErrorSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool FatalErrorSignal::operator < (const FatalErrorSignal& rhs) const {
    if (hasErr_file() || rhs.hasErr_file()) {
        if (getErr_file() < rhs.getErr_file()) return true;
        if (getErr_file() > rhs.getErr_file()) return false;
    }
    if (hasErr_line() || rhs.hasErr_line()) {
        if (getErr_line() < rhs.getErr_line()) return true;
        if (getErr_line() > rhs.getErr_line()) return false;
    }
    if (hasErr_code() || rhs.hasErr_code()) {
        if (getErr_code() < rhs.getErr_code()) return true;
        if (getErr_code() > rhs.getErr_code()) return false;
    }
    if (hasFmt() || rhs.hasFmt()) {
        if (getFmt() < rhs.getFmt()) return true;
        if (getFmt() > rhs.getFmt()) return false;
    }
    if (hasErr_value() || rhs.hasErr_value()) {
        if (getErr_value() < rhs.getErr_value()) return true;
        if (getErr_value() > rhs.getErr_value()) return false;
    }
    return false;
}

inline ::asf::core::Payload* FatalErrorSignal::clone() {
    return new FatalErrorSignal(*this);
}

inline bool FatalErrorSignal::operator > (const FatalErrorSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void FatalErrorSignal::clear() {
    clearErr_file();
    clearErr_line();
    clearErr_code();
    clearFmt();
    clearErr_value();
}

inline void FatalErrorSignal::clearErr_file() {
    if (hasErr_file()) {
         clear_has_err_file();
        _err_file = 0u;
     }
}

inline bool FatalErrorSignal::hasErr_file () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint16 FatalErrorSignal::getErr_file () const {
    return _err_file;
}

inline void FatalErrorSignal::setErr_file (uint16 err_file_) {
    set_has_err_file();
    this->_err_file = err_file_;
}

inline void FatalErrorSignal::clearErr_line() {
    if (hasErr_line()) {
         clear_has_err_line();
        _err_line = 0u;
     }
}

inline bool FatalErrorSignal::hasErr_line () const {
    return (_has_bits_[0] & (1u << 1)) > 0;
}

inline uint16 FatalErrorSignal::getErr_line () const {
    return _err_line;
}

inline void FatalErrorSignal::setErr_line (uint16 err_line_) {
    set_has_err_line();
    this->_err_line = err_line_;
}

inline void FatalErrorSignal::clearErr_code() {
    if (hasErr_code()) {
         clear_has_err_code();
        _err_code = 0u;
     }
}

inline bool FatalErrorSignal::hasErr_code () const {
    return (_has_bits_[0] & (1u << 2)) > 0;
}

inline uint16 FatalErrorSignal::getErr_code () const {
    return _err_code;
}

inline void FatalErrorSignal::setErr_code (uint16 err_code_) {
    set_has_err_code();
    this->_err_code = err_code_;
}

inline void FatalErrorSignal::clearFmt() {
    if (hasFmt()) {
         clear_has_fmt();
        _fmt.clear();
     }
}

inline bool FatalErrorSignal::hasFmt () const {
    return (_has_bits_[0] & (1u << 3)) > 0;
}

inline const ::std::string& FatalErrorSignal::getFmt () const {
    return _fmt;
}

inline ::std::string& FatalErrorSignal::getFmtMutable () {
    set_has_fmt();
    return _fmt;
}

inline void FatalErrorSignal::setFmt (const ::std::string& fmt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fmt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fmt();
    this->_fmt = fmt_;
}

inline void FatalErrorSignal::setFmt (const char* fmt_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (fmt_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fmt();
    this->_fmt.assign(fmt_);
}

inline void FatalErrorSignal::setFmt (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_fmt();
    this->_fmt.assign(value, size);
}

inline void FatalErrorSignal::clearErr_value() {
    if (hasErr_value()) {
         clear_has_err_value();
        _err_value.clear();
     }
}

inline bool FatalErrorSignal::hasErr_value () const {
    return (_has_bits_[0] & (1u << 4)) > 0;
}

inline const ::std::string& FatalErrorSignal::getErr_value () const {
    return _err_value;
}

inline ::std::string& FatalErrorSignal::getErr_valueMutable () {
    set_has_err_value();
    return _err_value;
}

inline void FatalErrorSignal::setErr_value (const ::std::string& err_value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (err_value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_err_value();
    this->_err_value = err_value_;
}

inline void FatalErrorSignal::setErr_value (const char* err_value_) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (err_value_), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_err_value();
    this->_err_value.assign(err_value_);
}

inline void FatalErrorSignal::setErr_value (const char* value, size_t size) {
    {
        LOG_SYSTEM_LOGGER();
        LOG_ASSERT_MSG_STATIC(::asf::core::Utf8String::isValidAndLog (value), "Detected invalid utf8 string (see above error messages)");
    }
    set_has_err_value();
    this->_err_value.assign(value, size);
}

inline void FatalErrorSignal::set_has_err_file () {
    _has_bits_[0] |= 1u << 0;
}

inline void FatalErrorSignal::clear_has_err_file () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline void FatalErrorSignal::set_has_err_line () {
    _has_bits_[0] |= 1u << 1;
}

inline void FatalErrorSignal::clear_has_err_line () {
    _has_bits_[0] &= ~ (1u << 1);
}

inline void FatalErrorSignal::set_has_err_code () {
    _has_bits_[0] |= 1u << 2;
}

inline void FatalErrorSignal::clear_has_err_code () {
    _has_bits_[0] &= ~ (1u << 2);
}

inline void FatalErrorSignal::set_has_fmt () {
    _has_bits_[0] |= 1u << 3;
}

inline void FatalErrorSignal::clear_has_fmt () {
    _has_bits_[0] &= ~ (1u << 3);
}

inline void FatalErrorSignal::set_has_err_value () {
    _has_bits_[0] |= 1u << 4;
}

inline void FatalErrorSignal::clear_has_err_value () {
    _has_bits_[0] &= ~ (1u << 4);
}

} // namespace Trace
} // namespace genivi
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_GENIVI_TRACE_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
