/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_BLUEZ_EVO_TRACESTUB_H
#define ORG_BLUEZ_EVO_TRACESTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/evo/Trace.h"
#include <vector>

namespace org {
namespace bluez {
namespace evo {
namespace Trace {

class TraceStubDelegate;

class TraceStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TraceStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TraceStub (const std::string& portName);

    /**
     * Create an instance of the TraceStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TraceStub (const std::string& portName, const std::string& objectPath);

    virtual ~TraceStub();

    // signal 'ReportDebugTrace'

    /**
     * Raise the signal 'ReportDebugTrace' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ReportDebugTrace'</b>:
     *
     * If the meaning of "ReportDebugTrace" isn't clear, then there should be a description here.
     */
    void sendReportDebugTraceSignal(uint32 location, uint8 level, uint8 category, uint16 error_code, const ::std::vector< uint8 >& data);

    // signal 'ReportProtocolTrace'

    /**
     * Raise the signal 'ReportProtocolTrace' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'ReportProtocolTrace'</b>:
     *
     * If the meaning of "ReportProtocolTrace" isn't clear, then there should be a description here.
     */
    void sendReportProtocolTraceSignal(uint16 type, uint8 direction, const ::std::vector< uint8 >& data);

    // signal 'FatalError'

    /**
     * Raise the signal 'FatalError' and send an update message to registered
     * clients.
     *
     * <b>Documentation of 'FatalError'</b>:
     *
     * If the meaning of "FatalError" isn't clear, then there should be a description here.
     */
    void sendFatalErrorSignal(uint32 err_localtion, uint32 err_type);

    // signal 'GeneralError'

    /**
     * Raise the signal 'GeneralError' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'GeneralError'</b>:
     *
     * If the meaning of "GeneralError" isn't clear, then there should be a description here.
     */
    void sendGeneralErrorSignal(uint8 status, uint16 op_code);

    // method 'DebugTraceConfig'

    /**
     * The method onDebugTraceConfig() is called by ASF when a client invokes
     * the method 'DebugTraceConfig'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendDebugTraceConfig() or sendDebugTraceConfigError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'DebugTraceConfig'</b>:
     *
     * If the meaning of "DebugTraceConfig" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDebugTraceConfigRequest (const ::boost::shared_ptr< DebugTraceConfigRequest >& request) = 0;

    /**
     * The method sendDebugTraceConfigResponse() sends a response of a
     * previous method invocation of 'DebugTraceConfig' back to the client.
     *
     * <b>Documentation of 'DebugTraceConfig'</b>:
     *
     * If the meaning of "DebugTraceConfig" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDebugTraceConfig(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDebugTraceConfigResponse (act_t act = 0);

    /**
     * The method sendDebugTraceConfigError() sends an error response of a
     * previous method invocation of 'DebugTraceConfig' back to the client.
     *
     * <b>Documentation of 'DebugTraceConfig'</b>:
     *
     * If the meaning of "DebugTraceConfig" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDebugTraceConfig(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDebugTraceConfigError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'ProtocolTraceConfig'

    /**
     * The method onProtocolTraceConfig() is called by ASF when a client
     * invokes the method 'ProtocolTraceConfig'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendProtocolTraceConfig() or sendProtocolTraceConfigError() method. Do
     * not invoke this method on your own.
     *
     * <b>Documentation of 'ProtocolTraceConfig'</b>:
     *
     * If the meaning of "ProtocolTraceConfig" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onProtocolTraceConfigRequest (const ::boost::shared_ptr< ProtocolTraceConfigRequest >& request) = 0;

    /**
     * The method sendProtocolTraceConfigResponse() sends a response of a
     * previous method invocation of 'ProtocolTraceConfig' back to the client.
     *
     * <b>Documentation of 'ProtocolTraceConfig'</b>:
     *
     * If the meaning of "ProtocolTraceConfig" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onProtocolTraceConfig(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendProtocolTraceConfigResponse (act_t act = 0);

    /**
     * The method sendProtocolTraceConfigError() sends an error response of a
     * previous method invocation of 'ProtocolTraceConfig' back to the client.
     *
     * <b>Documentation of 'ProtocolTraceConfig'</b>:
     *
     * If the meaning of "ProtocolTraceConfig" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onProtocolTraceConfig().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendProtocolTraceConfigError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class TraceStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Trace
} // namespace evo
} // namespace bluez
} // namespace org

#endif // ORG_BLUEZ_EVO_TRACESTUB_H
