/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/evo/Trace.h"
#include "org/bluez/evo/TraceDBus.h"
#include "org/bluez/evo/TraceJson.h"
#include "org/bluez/evo/TraceStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace evo {
namespace Trace {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/org/bluez/evo/Trace", TraceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "DebugTraceConfig", 0 },
    { 19, "ProtocolTraceConfig", 1 },
};


class TraceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    TraceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    TraceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    TraceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.evo.Trace"),
          _logger(logger) {}

    virtual ~TraceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void TraceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'DebugTraceConfig'

            LOG_DEBUG_STUB("process method '%s'", "DebugTraceConfig");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DebugTraceConfigRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "DebugTraceConfig", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DebugTraceConfigRequest > payload = ::boost::static_pointer_cast<DebugTraceConfigRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TraceStub*>(getStub())->onDebugTraceConfigRequest(payload);
            return;
        }
        case 1: {

            // method 'ProtocolTraceConfig'

            LOG_DEBUG_STUB("process method '%s'", "ProtocolTraceConfig");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ProtocolTraceConfigRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "ProtocolTraceConfig", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ProtocolTraceConfigRequest > payload = ::boost::static_pointer_cast<ProtocolTraceConfigRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<TraceStub*>(getStub())->onProtocolTraceConfigRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* TraceStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.evo.Trace\">\n"
            "      <method name=\"DebugTraceConfig\">\n"
            "        <arg direction=\"in\" name=\"level\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"current_time\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"mode\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"category1\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"category2\" type=\"u\"/>\n"
            "        <arg direction=\"in\" name=\"category3\" type=\"u\"/>\n"
            "      </method>\n"
            "      <method name=\"ProtocolTraceConfig\">\n"
            "        <arg direction=\"in\" name=\"filter\" type=\"q\"/>\n"
            "      </method>\n"
            "      <signal name=\"ReportDebugTrace\">\n"
            "        <arg name=\"location\" type=\"u\"/>\n"
            "        <arg name=\"level\" type=\"y\"/>\n"
            "        <arg name=\"category\" type=\"y\"/>\n"
            "        <arg name=\"error_code\" type=\"q\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"ReportProtocolTrace\">\n"
            "        <arg name=\"type\" type=\"q\"/>\n"
            "        <arg name=\"direction\" type=\"y\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"FatalError\">\n"
            "        <arg name=\"err_localtion\" type=\"u\"/>\n"
            "        <arg name=\"err_type\" type=\"u\"/>\n"
            "      </signal>\n"
            "      <signal name=\"GeneralError\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"op_code\" type=\"q\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void TraceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<TraceStub*>(getStub()))->onGetAll (properties);
}

void TraceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void TraceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

TraceStub::TraceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TraceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TraceStub::TraceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new TraceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

TraceStub::~TraceStub() {
    delete _stubDelegate;
}

void TraceStub::sendReportDebugTraceSignal(uint32 location, uint8 level, uint8 category, uint16 error_code, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        ReportDebugTraceSignal* payload = new ReportDebugTraceSignal(location, level, category, error_code, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ReportDebugTrace", ReportDebugTraceSignal, payload)
        LOG_INFO ("-> send%sSignal", "ReportDebugTrace");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ReportDebugTrace");
    }
}

void TraceStub::sendReportProtocolTraceSignal(uint16 type, uint8 direction, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        ReportProtocolTraceSignal* payload = new ReportProtocolTraceSignal(type, direction, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "ReportProtocolTrace", ReportProtocolTraceSignal, payload)
        LOG_INFO ("-> send%sSignal", "ReportProtocolTrace");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "ReportProtocolTrace");
    }
}

void TraceStub::sendFatalErrorSignal(uint32 err_localtion, uint32 err_type) {
    if (_stubDelegate->isConnected()) {
        FatalErrorSignal* payload = new FatalErrorSignal(err_localtion, err_type);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FatalError", FatalErrorSignal, payload)
        LOG_INFO ("-> send%sSignal", "FatalError");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FatalError");
    }
}

void TraceStub::sendGeneralErrorSignal(uint8 status, uint16 op_code) {
    if (_stubDelegate->isConnected()) {
        GeneralErrorSignal* payload = new GeneralErrorSignal(status, op_code);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "GeneralError", GeneralErrorSignal, payload)
        LOG_INFO ("-> send%sSignal", "GeneralError");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "GeneralError");
    }
}

void  TraceStub::sendDebugTraceConfigResponse (act_t act) {
    DebugTraceConfigResponse* payload = new DebugTraceConfigResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "DebugTraceConfig", DebugTraceConfigResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "DebugTraceConfig", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TraceStub::sendDebugTraceConfigError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DebugTraceConfigError* payload = new DebugTraceConfigError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "DebugTraceConfig", DebugTraceConfigError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "DebugTraceConfig", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TraceStub::sendProtocolTraceConfigResponse (act_t act) {
    ProtocolTraceConfigResponse* payload = new ProtocolTraceConfigResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "ProtocolTraceConfig", ProtocolTraceConfigResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "ProtocolTraceConfig", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  TraceStub::sendProtocolTraceConfigError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ProtocolTraceConfigError* payload = new ProtocolTraceConfigError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "ProtocolTraceConfig", ProtocolTraceConfigError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "ProtocolTraceConfig", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void TraceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Trace
} // namespace evo
} // namespace bluez
} // namespace org
