/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Serial.h"
#include "org/bluez/SerialDBus.h"
#include "org/bluez/SerialJson.h"
#include "org/bluez/SerialStub.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Serial {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/uuid/created/during/runtime/org/bluez/Serial", SerialStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 8, "SendData", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 11, "device_name", 1 },
    { 12, "FlowCtrlRecv", 0 },
};

class SerialStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SerialStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SerialStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SerialStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.bluez.Serial"),
          _logger(logger) {}

    virtual ~SerialStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SerialStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 1, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'SendData'

            LOG_DEBUG_STUB("process method '%s'", "SendData");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendDataRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SendData", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SendDataRequest > payload = ::boost::static_pointer_cast<SendDataRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SerialStub*>(getStub())->onSendDataRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SerialStubDelegate::introspect() const {
    return     "<interface name=\"org.bluez.Serial\">\n"
            "      <method name=\"SendData\">\n"
            "        <arg direction=\"in\" name=\"Data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <signal name=\"SppDataInd\">\n"
            "        <arg name=\"Data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"FlowCtrlSend\">\n"
            "        <arg name=\"Status\" type=\"s\"/>\n"
            "      </signal>\n"
            "      <signal name=\"DeviceFilePath\">\n"
            "        <arg name=\"Path\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <property access=\"readwrite\" name=\"FlowCtrlRecv\" type=\"s\"/>\n"
            "      <property access=\"read\" name=\"device_name\" type=\"ay\"/>\n"
            "</interface>\n";
}

void SerialStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SerialStub*>(getStub()))->onGetAll (properties);
}

void SerialStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FlowCtrlRecv");
            ::boost::shared_ptr< FlowCtrlRecvSet > payload(new FlowCtrlRecvSet());
            payload->setAct(act);
            deserializeDBus(const_cast< ::asf::dbus::DBusVariant& >(value).getReadIterator(), *payload);
            static_cast<SerialStub*>(getStub())->onFlowCtrlRecvSet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "device_name");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SerialStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 2, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "FlowCtrlRecv");
            ::boost::shared_ptr< FlowCtrlRecvGet > payload(new FlowCtrlRecvGet());
            payload->setAct(act);
            static_cast<SerialStub*>(getStub())->onFlowCtrlRecvGet (payload);
            return;
        }
        case 1: {
            LOG_DEBUG_STUB("process property '%s'", "device_name");
            ::boost::shared_ptr< Device_nameGet > payload(new Device_nameGet());
            payload->setAct(act);
            static_cast<SerialStub*>(getStub())->onDevice_nameGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SerialStub::SerialStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SerialStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SerialStub::SerialStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SerialStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SerialStub::~SerialStub() {
    delete _stubDelegate;
}

void SerialStub::sendSppDataIndSignal(const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        SppDataIndSignal* payload = new SppDataIndSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "SppDataInd", SppDataIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "SppDataInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "SppDataInd");
    }
}

void SerialStub::sendFlowCtrlSendSignal(const ::std::string& status) {
    if (_stubDelegate->isConnected()) {
        FlowCtrlSendSignal* payload = new FlowCtrlSendSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "FlowCtrlSend", FlowCtrlSendSignal, payload)
        LOG_INFO ("-> send%sSignal", "FlowCtrlSend");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "FlowCtrlSend");
    }
}

void SerialStub::sendDeviceFilePathSignal(const ::std::vector< uint8 >& path) {
    if (_stubDelegate->isConnected()) {
        DeviceFilePathSignal* payload = new DeviceFilePathSignal(path);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "DeviceFilePath", DeviceFilePathSignal, payload)
        LOG_INFO ("-> send%sSignal", "DeviceFilePath");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "DeviceFilePath");
    }
}

void SerialStub::sendFlowCtrlRecvUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        FlowCtrlRecvUpdate payload(_FlowCtrlRecvProperty);

        LOG_INFO ("-> send%s", "FlowCtrlRecvUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("FlowCtrlRecv", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Serial", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "FlowCtrlRecvUpdate");
    }
}

void SerialStub::onFlowCtrlRecvGet(const ::boost::shared_ptr< FlowCtrlRecvGet >& flowCtrlRecv) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FlowCtrlRecvGet", flowCtrlRecv->getAct());
    sendFlowCtrlRecvGetUpdate(_FlowCtrlRecvProperty.getFlowCtrlRecv(), flowCtrlRecv->getAct());
}

void SerialStub::sendFlowCtrlRecvGetUpdate(const ::std::string& flowCtrlRecv, act_t act) {
    ::asf::dbus::DBusVariant variant;
    FlowCtrlRecvGet payload(flowCtrlRecv);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FlowCtrlRecvGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SerialStub::onFlowCtrlRecvSet(const ::boost::shared_ptr< FlowCtrlRecvSet >& flowCtrlRecv) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "FlowCtrlRecvSet", flowCtrlRecv->getAct());
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(*flowCtrlRecv, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }
    setFlowCtrlRecv (flowCtrlRecv->getFlowCtrlRecv());
    sendFlowCtrlRecvSetUpdate(flowCtrlRecv->getAct());
}

void SerialStub::sendFlowCtrlRecvSetUpdate(act_t act) {
    LOG_INFO ("-> send%s, act=%" PRIuPTR, "FlowCtrlRecvSetUpdate", act);
    _stubDelegate->sendSetResponse(act);
}

void SerialStub::setFlowCtrlRecv(const ::std::string& flowCtrlRecv) {
    if(flowCtrlRecv!=_FlowCtrlRecvProperty.getFlowCtrlRecv()) {
        _FlowCtrlRecvProperty.setFlowCtrlRecv(flowCtrlRecv);
        sendFlowCtrlRecvUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::string& SerialStub::getFlowCtrlRecv() const {
    return _FlowCtrlRecvProperty.getFlowCtrlRecv();
}

::std::string& SerialStub::getFlowCtrlRecvMutable() {
    return _FlowCtrlRecvProperty.getFlowCtrlRecvMutable();
}

void SerialStub::sendDevice_nameUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        Device_nameUpdate payload(_device_nameProperty);

        LOG_INFO ("-> send%s", "Device_nameUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("device_name", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.bluez.Serial", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "Device_nameUpdate");
    }
}

void SerialStub::onDevice_nameGet(const ::boost::shared_ptr< Device_nameGet >& device_name) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "Device_nameGet", device_name->getAct());
    sendDevice_nameGetUpdate(_device_nameProperty.getDevice_name(), device_name->getAct());
}

void SerialStub::sendDevice_nameGetUpdate(const ::std::vector< uint8 >& device_name, act_t act) {
    ::asf::dbus::DBusVariant variant;
    Device_nameGet payload(device_name);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "Device_nameGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void SerialStub::setDevice_name(const ::std::vector< uint8 >& device_name) {
    if(device_name!=_device_nameProperty.getDevice_name()) {
        _device_nameProperty.setDevice_name(device_name);
        sendDevice_nameUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& SerialStub::getDevice_name() const {
    return _device_nameProperty.getDevice_name();
}

::std::vector< uint8 >& SerialStub::getDevice_nameMutable() {
    return _device_nameProperty.getDevice_nameMutable();
}

void  SerialStub::sendSendDataResponse (act_t act) {
    SendDataResponse* payload = new SendDataResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SendData", SendDataResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SendData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SerialStub::sendSendDataError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SendDataError* payload = new SendDataError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SendData", SendDataError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SendData", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SerialStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'FlowCtrlRecv'
    {
        ::asf::dbus::DBusVariant variant;
        FlowCtrlRecvGet payload(_FlowCtrlRecvProperty.getFlowCtrlRecv());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("FlowCtrlRecv", variant));
    }

    //property 'device_name'
    {
        ::asf::dbus::DBusVariant variant;
        Device_nameGet payload(_device_nameProperty.getDevice_name());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("device_name", variant));
    }
}

} // namespace Serial
} // namespace bluez
} // namespace org
