/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/bluez/Serial.h"
#include "org/bluez/SerialDBus.h"
#include "org/bluez/SerialJson.h"
#include "org/bluez/SerialProxy.h"
#include <string>
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace bluez {
namespace Serial {

DEFINE_CLASS_LOGGER("//org/bluez/hci1/dev_addr/uuid/created/during/runtime/org/bluez/Serial", SerialProxy);

class SerialProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SerialProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SerialProxy >& proxyShared = ::boost::static_pointer_cast< SerialProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_SppDataInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SppDataIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "SppDataInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<SppDataIndSignal> payload = ::boost::static_pointer_cast<SppDataIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((SppDataIndCallbackIF*) _callback)->onSppDataIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FlowCtrlSend:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FlowCtrlSendSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FlowCtrlSend", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<FlowCtrlSendSignal> payload = ::boost::static_pointer_cast<FlowCtrlSendSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((FlowCtrlSendCallbackIF*) _callback)->onFlowCtrlSendSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_DeviceFilePath:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DeviceFilePathSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "DeviceFilePath", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<DeviceFilePathSignal> payload = ::boost::static_pointer_cast<DeviceFilePathSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((DeviceFilePathCallbackIF*) _callback)->onDeviceFilePathSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_FlowCtrlRecv:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FlowCtrlRecvError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FlowCtrlRecv", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FlowCtrlRecvError> payload = ::boost::static_pointer_cast<FlowCtrlRecvError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((FlowCtrlRecvCallbackIF*) _callback)->onFlowCtrlRecvError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), FlowCtrlRecvUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "FlowCtrlRecv", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<FlowCtrlRecvUpdate> payload = ::boost::static_pointer_cast<FlowCtrlRecvUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((FlowCtrlRecvCallbackIF*) _callback)->onFlowCtrlRecvUpdate(proxyShared, payload);
                        proxyShared->_flowCtrlRecv = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_device_name:
                {
                    if (message.isPropertyError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Device_nameError);
                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Device_name", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Device_nameError> payload = ::boost::static_pointer_cast<Device_nameError>(message.getPropertyError()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        payload->setAct(reinterpret_cast<act_t>(this));
                        ((Device_nameCallbackIF*) _callback)->onDevice_nameError(proxyShared, payload);
                        return true;
                    } else {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), Device_nameUpdate);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sUpdate, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "Device_name", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<Device_nameUpdate> payload = ::boost::static_pointer_cast<Device_nameUpdate>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                        ((Device_nameCallbackIF*) _callback)->onDevice_nameUpdate(proxyShared, payload);
                        proxyShared->_device_name = *payload.get();
                        return true;
                    }
                }
                break;
            case ID_SendData:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SendDataError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendDataError> payload = ::boost::static_pointer_cast<SendDataError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendDataCallbackIF*) _callback)->onSendDataError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SendDataResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SendData", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SendDataResponse> payload = ::boost::static_pointer_cast<SendDataResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SendDataCallbackIF*) _callback)->onSendDataResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_SppDataInd: {
                ::boost::shared_ptr< SppDataIndError > payload = ::boost::shared_ptr< SppDataIndError >
                (new SppDataIndError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SppDataInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SppDataIndCallbackIF*) _callback)->onSppDataIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FlowCtrlSend: {
                ::boost::shared_ptr< FlowCtrlSendError > payload = ::boost::shared_ptr< FlowCtrlSendError >
                (new FlowCtrlSendError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FlowCtrlSend", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FlowCtrlSendCallbackIF*) _callback)->onFlowCtrlSendError (proxyShared,payload);
                return true;
            }
            break;
            case ID_DeviceFilePath: {
                ::boost::shared_ptr< DeviceFilePathError > payload = ::boost::shared_ptr< DeviceFilePathError >
                (new DeviceFilePathError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "DeviceFilePath", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DeviceFilePathCallbackIF*) _callback)->onDeviceFilePathError (proxyShared,payload);
                return true;
            }
            break;
            case ID_FlowCtrlRecv: {
                ::boost::shared_ptr< FlowCtrlRecvError > payload = ::boost::shared_ptr< FlowCtrlRecvError >
                (new FlowCtrlRecvError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "FlowCtrlRecv", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((FlowCtrlRecvCallbackIF*) _callback)->onFlowCtrlRecvError (proxyShared,payload);
                return true;
            }
            break;
            case ID_device_name: {
                ::boost::shared_ptr< Device_nameError > payload = ::boost::shared_ptr< Device_nameError >
                (new Device_nameError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Device_name", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((Device_nameCallbackIF*) _callback)->onDevice_nameError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SendData: {
                ::boost::shared_ptr< SendDataError > payload = ::boost::shared_ptr< SendDataError >
                (new SendDataError(DBUS_ERROR_NO_SERVER, "The DBus service Serial is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SendData", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SerialProxy> proxyShared = ::boost::static_pointer_cast<SerialProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SendDataCallbackIF*) _callback)->onSendDataError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SerialProxyCallback::_logger (SerialProxy::_logger);

SerialProxy::SerialProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.bluez.Serial", serviceAvailable, _logger) {
}

SerialProxy::~SerialProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SerialProxy > SerialProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SerialProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SerialProxy > proxyNew(new SerialProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(true);
    return proxyNew;
}

act_t SerialProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SerialProxyCallback* callback = new SerialProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SerialProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SerialProxyCallback* callback = new SerialProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SerialProxy::clearAllProperties ()
{
    _flowCtrlRecv = ::asf::core::nullable< FlowCtrlRecvUpdate >();
    _device_name = ::asf::core::nullable< Device_nameUpdate >();
}

void SerialProxy::sendDeregisterAll () const
{
    sendFlowCtrlRecvDeregisterAll();
    sendDevice_nameDeregisterAll();
    sendSppDataIndDeregisterAll();
    sendFlowCtrlSendDeregisterAll();
    sendDeviceFilePathDeregisterAll();
}

act_t SerialProxy::sendSppDataIndRegister(SppDataIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "SppDataInd");
    act_t act = addSignalCallback(ID_SppDataInd, "SppDataInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "SppDataInd", &cb, act);
    return act;
}

bool SerialProxy::sendSppDataIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("SppDataInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "SppDataInd", act, static_cast<int>(rv));
    return rv;
}

void SerialProxy::sendSppDataIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "SppDataInd");
    _dbusProxyDelegate->deregisterSignalCallback("SppDataInd", 0, _dbusDaemonProxy.get(), false);
}

act_t SerialProxy::sendFlowCtrlSendRegister(FlowCtrlSendCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "FlowCtrlSend");
    act_t act = addSignalCallback(ID_FlowCtrlSend, "FlowCtrlSend", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FlowCtrlSend", &cb, act);
    return act;
}

bool SerialProxy::sendFlowCtrlSendDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FlowCtrlSend", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FlowCtrlSend", act, static_cast<int>(rv));
    return rv;
}

void SerialProxy::sendFlowCtrlSendDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FlowCtrlSend");
    _dbusProxyDelegate->deregisterSignalCallback("FlowCtrlSend", 0, _dbusDaemonProxy.get(), false);
}

act_t SerialProxy::sendDeviceFilePathRegister(DeviceFilePathCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "DeviceFilePath");
    act_t act = addSignalCallback(ID_DeviceFilePath, "DeviceFilePath", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "DeviceFilePath", &cb, act);
    return act;
}

bool SerialProxy::sendDeviceFilePathDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("DeviceFilePath", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "DeviceFilePath", act, static_cast<int>(rv));
    return rv;
}

void SerialProxy::sendDeviceFilePathDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "DeviceFilePath");
    _dbusProxyDelegate->deregisterSignalCallback("DeviceFilePath", 0, _dbusDaemonProxy.get(), false);
}

act_t SerialProxy::sendFlowCtrlRecvRegister(FlowCtrlRecvCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_FlowCtrlRecv, "FlowCtrlRecv", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "FlowCtrlRecv", &cb, act);
    return act;
}

bool SerialProxy::sendFlowCtrlRecvDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("FlowCtrlRecv", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "FlowCtrlRecv", act, static_cast<int>(rv));
    return rv;
}

act_t SerialProxy::sendFlowCtrlRecvGet(FlowCtrlRecvCallbackIF& cb) {
    SerialProxyCallback* callback = new SerialProxyCallback(ID_FlowCtrlRecv, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "FlowCtrlRecv", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("FlowCtrlRecv", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

void SerialProxy::sendFlowCtrlRecvSet(const ::std::string& flowCtrlRecv) {
    FlowCtrlRecvSet parameter(flowCtrlRecv);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet()", "FlowCtrlRecv");
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FlowCtrlRecv", propertyContent);
}

act_t SerialProxy::sendFlowCtrlRecvSet(FlowCtrlRecvCallbackIF& cb, const ::std::string& flowCtrlRecv) {
    SerialProxyCallback* callback = new SerialProxyCallback(ID_FlowCtrlRecv, &cb);
    FlowCtrlRecvSet parameter(flowCtrlRecv);
    if (IS_LOG_INFO_ENABLED()) {
        LOG_INFO ("-> send%sSet(cb=%p), returning act=%" PRIuPTR, "FlowCtrlRecv", &cb, reinterpret_cast<act_t>(callback));
        std::string payload;
        serializeJson(parameter, payload);
        LOG_INFO ("payload: %s", payload.c_str());
    }
    ::asf::dbus::DBusVariant propertyContent;
    serializeDBus(parameter, propertyContent.getWriteIterator());
    _dbusPropertiesProxyWrapper->sendSetProperty(getInterfaceName(), "FlowCtrlRecv", propertyContent, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

const ::std::string& SerialProxy::getFlowCtrlRecv() const {
    return _flowCtrlRecv.get().getFlowCtrlRecv();
}

bool SerialProxy::hasFlowCtrlRecv() const {
    return _flowCtrlRecv.hasValue();
}

void SerialProxy::sendFlowCtrlRecvDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "FlowCtrlRecv");
    _dbusProxyDelegate->deregisterSignalCallback("FlowCtrlRecv", 0, _dbusDaemonProxy.get(), true);
}

act_t SerialProxy::sendDevice_nameRegister(Device_nameCallbackIF& cb) const {
    LOG_ASSERT(_dbusPropertiesProxyWrapper);
    _dbusPropertiesProxyWrapper->registerProperty();
    act_t act = addSignalCallback(ID_device_name, "device_name", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "Device_name", &cb, act);
    return act;
}

bool SerialProxy::sendDevice_nameDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("device_name", act, _dbusDaemonProxy.get(), true);
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "Device_name", act, static_cast<int>(rv));
    return rv;
}

act_t SerialProxy::sendDevice_nameGet(Device_nameCallbackIF& cb) {
    SerialProxyCallback* callback = new SerialProxyCallback(ID_device_name, &cb);
    LOG_INFO ("-> send%sGet(cb=%p), returning act=%" PRIuPTR, "Device_name", &cb, reinterpret_cast<act_t>(callback));
    _dbusPropertiesProxyWrapper->sendGetProperty("device_name", ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


const ::std::vector< uint8 >& SerialProxy::getDevice_name() const {
    return _device_name.get().getDevice_name();
}

bool SerialProxy::hasDevice_name() const {
    return _device_name.hasValue();
}

void SerialProxy::sendDevice_nameDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "Device_name");
    _dbusProxyDelegate->deregisterSignalCallback("device_name", 0, _dbusDaemonProxy.get(), true);
}

act_t SerialProxy::sendSendDataRequest(SendDataCallbackIF& cb, const ::std::vector< uint8 >& data) const {
    SendDataRequest* payload = new SendDataRequest();
    CHECK_ALLOCATION(payload);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "SendData", SendDataRequest, payload, true)
    act_t act = addMethodCallback(ID_SendData, dbusMessage.getUniqueSerial(), "SendData", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SendData", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Serial
} // namespace bluez
} // namespace org
