/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/SPP.h"
#include "org/alps/evo/SPPDBus.h"
#include "org/alps/evo/SPPJson.h"
#include "org/alps/evo/SPPStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace SPP {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/SPP", SPPStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 16, "BtApplSppDataReq", 0 },
    { 19, "BtApplSppSetUuidReq", 1 },
    { 20, "BtApplSppFlowCtrlReq", 2 },
};


class SPPStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SPPStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SPPStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SPPStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.alps.evo.SPP"),
          _logger(logger) {}

    virtual ~SPPStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SPPStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 3, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'BtApplSppDataReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplSppDataReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplSppDataReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplSppDataReqRequest > payload = ::boost::static_pointer_cast<BtApplSppDataReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SPPStub*>(getStub())->onBtApplSppDataReqRequest(payload);
            return;
        }
        case 1: {

            // method 'BtApplSppSetUuidReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplSppSetUuidReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppSetUuidReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplSppSetUuidReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplSppSetUuidReqRequest > payload = ::boost::static_pointer_cast<BtApplSppSetUuidReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SPPStub*>(getStub())->onBtApplSppSetUuidReqRequest(payload);
            return;
        }
        case 2: {

            // method 'BtApplSppFlowCtrlReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplSppFlowCtrlReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppFlowCtrlReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplSppFlowCtrlReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplSppFlowCtrlReqRequest > payload = ::boost::static_pointer_cast<BtApplSppFlowCtrlReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SPPStub*>(getStub())->onBtApplSppFlowCtrlReqRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SPPStubDelegate::introspect() const {
    return     "<interface name=\"org.alps.evo.SPP\">\n"
            "      <method name=\"BtApplSppDataReq\">\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplSppSetUuidReq\">\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplSppFlowCtrlReq\">\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"action\" type=\"y\"/>\n"
            "      </method>\n"
            "      <signal name=\"BtApplSppDataCfm\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSppDataInd\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSppSendInd\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSppSetUuidCfm\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSppFlowCtrlCfm\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSppDataSendFcInd\">\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void SPPStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SPPStub*>(getStub()))->onGetAll (properties);
}

void SPPStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SPPStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SPPStub::SPPStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SPPStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SPPStub::SPPStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SPPStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SPPStub::~SPPStub() {
    delete _stubDelegate;
}

void SPPStub::sendBtApplSppDataCfmSignal(uint8 instance, uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplSppDataCfmSignal* payload = new BtApplSppDataCfmSignal(instance, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppDataCfm", BtApplSppDataCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppDataCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppDataCfm");
    }
}

void SPPStub::sendBtApplSppDataIndSignal(uint8 instance, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        BtApplSppDataIndSignal* payload = new BtApplSppDataIndSignal(instance, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppDataInd", BtApplSppDataIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppDataInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppDataInd");
    }
}

void SPPStub::sendBtApplSppSendIndSignal(uint8 instance) {
    if (_stubDelegate->isConnected()) {
        BtApplSppSendIndSignal* payload = new BtApplSppSendIndSignal(instance);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppSendInd", BtApplSppSendIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppSendInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppSendInd");
    }
}

void SPPStub::sendBtApplSppSetUuidCfmSignal(uint8 instance, uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplSppSetUuidCfmSignal* payload = new BtApplSppSetUuidCfmSignal(instance, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppSetUuidCfm", BtApplSppSetUuidCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppSetUuidCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppSetUuidCfm");
    }
}

void SPPStub::sendBtApplSppFlowCtrlCfmSignal(uint8 instance, uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplSppFlowCtrlCfmSignal* payload = new BtApplSppFlowCtrlCfmSignal(instance, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppFlowCtrlCfm", BtApplSppFlowCtrlCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppFlowCtrlCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppFlowCtrlCfm");
    }
}

void SPPStub::sendBtApplSppDataSendFcIndSignal(uint8 instance, uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplSppDataSendFcIndSignal* payload = new BtApplSppDataSendFcIndSignal(instance, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSppDataSendFcInd", BtApplSppDataSendFcIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSppDataSendFcInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSppDataSendFcInd");
    }
}

void  SPPStub::sendBtApplSppDataReqResponse (act_t act) {
    BtApplSppDataReqResponse* payload = new BtApplSppDataReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplSppDataReq", BtApplSppDataReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplSppDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SPPStub::sendBtApplSppDataReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplSppDataReqError* payload = new BtApplSppDataReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplSppDataReq", BtApplSppDataReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplSppDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SPPStub::sendBtApplSppSetUuidReqResponse (act_t act) {
    BtApplSppSetUuidReqResponse* payload = new BtApplSppSetUuidReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplSppSetUuidReq", BtApplSppSetUuidReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplSppSetUuidReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SPPStub::sendBtApplSppSetUuidReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplSppSetUuidReqError* payload = new BtApplSppSetUuidReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplSppSetUuidReq", BtApplSppSetUuidReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplSppSetUuidReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SPPStub::sendBtApplSppFlowCtrlReqResponse (act_t act) {
    BtApplSppFlowCtrlReqResponse* payload = new BtApplSppFlowCtrlReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplSppFlowCtrlReq", BtApplSppFlowCtrlReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplSppFlowCtrlReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SPPStub::sendBtApplSppFlowCtrlReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplSppFlowCtrlReqError* payload = new BtApplSppFlowCtrlReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplSppFlowCtrlReq", BtApplSppFlowCtrlReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplSppFlowCtrlReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SPPStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace SPP
} // namespace evo
} // namespace alps
} // namespace org
