/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/SPP.h"
#include "org/alps/evo/SPPDBus.h"
#include "org/alps/evo/SPPJson.h"
#include "org/alps/evo/SPPProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace SPP {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/SPP", SPPProxy);

class SPPProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SPPProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SPPProxy >& proxyShared = ::boost::static_pointer_cast< SPPProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BtApplSppDataCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppDataCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppDataCfmSignal> payload = ::boost::static_pointer_cast<BtApplSppDataCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppDataCfmCallbackIF*) _callback)->onBtApplSppDataCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppDataInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppDataInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppDataIndSignal> payload = ::boost::static_pointer_cast<BtApplSppDataIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppDataIndCallbackIF*) _callback)->onBtApplSppDataIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppSendInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppSendIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppSendInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppSendIndSignal> payload = ::boost::static_pointer_cast<BtApplSppSendIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppSendIndCallbackIF*) _callback)->onBtApplSppSendIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppSetUuidCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppSetUuidCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppSetUuidCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppSetUuidCfmSignal> payload = ::boost::static_pointer_cast<BtApplSppSetUuidCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppSetUuidCfmCallbackIF*) _callback)->onBtApplSppSetUuidCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppFlowCtrlCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppFlowCtrlCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppFlowCtrlCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppFlowCtrlCfmSignal> payload = ::boost::static_pointer_cast<BtApplSppFlowCtrlCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppFlowCtrlCfmCallbackIF*) _callback)->onBtApplSppFlowCtrlCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppDataSendFcInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataSendFcIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSppDataSendFcInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSppDataSendFcIndSignal> payload = ::boost::static_pointer_cast<BtApplSppDataSendFcIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSppDataSendFcIndCallbackIF*) _callback)->onBtApplSppDataSendFcIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSppDataReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppDataReqError> payload = ::boost::static_pointer_cast<BtApplSppDataReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppDataReqCallbackIF*) _callback)->onBtApplSppDataReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppDataReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppDataReqResponse> payload = ::boost::static_pointer_cast<BtApplSppDataReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppDataReqCallbackIF*) _callback)->onBtApplSppDataReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplSppSetUuidReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppSetUuidReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppSetUuidReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppSetUuidReqError> payload = ::boost::static_pointer_cast<BtApplSppSetUuidReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppSetUuidReqCallbackIF*) _callback)->onBtApplSppSetUuidReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppSetUuidReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppSetUuidReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppSetUuidReqResponse> payload = ::boost::static_pointer_cast<BtApplSppSetUuidReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppSetUuidReqCallbackIF*) _callback)->onBtApplSppSetUuidReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplSppFlowCtrlReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppFlowCtrlReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppFlowCtrlReqError> payload = ::boost::static_pointer_cast<BtApplSppFlowCtrlReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppFlowCtrlReqCallbackIF*) _callback)->onBtApplSppFlowCtrlReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSppFlowCtrlReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSppFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSppFlowCtrlReqResponse> payload = ::boost::static_pointer_cast<BtApplSppFlowCtrlReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSppFlowCtrlReqCallbackIF*) _callback)->onBtApplSppFlowCtrlReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BtApplSppDataCfm: {
                ::boost::shared_ptr< BtApplSppDataCfmError > payload = ::boost::shared_ptr< BtApplSppDataCfmError >
                (new BtApplSppDataCfmError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppDataCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppDataCfmCallbackIF*) _callback)->onBtApplSppDataCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppDataInd: {
                ::boost::shared_ptr< BtApplSppDataIndError > payload = ::boost::shared_ptr< BtApplSppDataIndError >
                (new BtApplSppDataIndError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppDataInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppDataIndCallbackIF*) _callback)->onBtApplSppDataIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppSendInd: {
                ::boost::shared_ptr< BtApplSppSendIndError > payload = ::boost::shared_ptr< BtApplSppSendIndError >
                (new BtApplSppSendIndError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppSendInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppSendIndCallbackIF*) _callback)->onBtApplSppSendIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppSetUuidCfm: {
                ::boost::shared_ptr< BtApplSppSetUuidCfmError > payload = ::boost::shared_ptr< BtApplSppSetUuidCfmError >
                (new BtApplSppSetUuidCfmError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppSetUuidCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppSetUuidCfmCallbackIF*) _callback)->onBtApplSppSetUuidCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppFlowCtrlCfm: {
                ::boost::shared_ptr< BtApplSppFlowCtrlCfmError > payload = ::boost::shared_ptr< BtApplSppFlowCtrlCfmError >
                (new BtApplSppFlowCtrlCfmError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppFlowCtrlCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppFlowCtrlCfmCallbackIF*) _callback)->onBtApplSppFlowCtrlCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppDataSendFcInd: {
                ::boost::shared_ptr< BtApplSppDataSendFcIndError > payload = ::boost::shared_ptr< BtApplSppDataSendFcIndError >
                (new BtApplSppDataSendFcIndError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppDataSendFcInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppDataSendFcIndCallbackIF*) _callback)->onBtApplSppDataSendFcIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppDataReq: {
                ::boost::shared_ptr< BtApplSppDataReqError > payload = ::boost::shared_ptr< BtApplSppDataReqError >
                (new BtApplSppDataReqError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppDataReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppDataReqCallbackIF*) _callback)->onBtApplSppDataReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppSetUuidReq: {
                ::boost::shared_ptr< BtApplSppSetUuidReqError > payload = ::boost::shared_ptr< BtApplSppSetUuidReqError >
                (new BtApplSppSetUuidReqError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppSetUuidReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppSetUuidReqCallbackIF*) _callback)->onBtApplSppSetUuidReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSppFlowCtrlReq: {
                ::boost::shared_ptr< BtApplSppFlowCtrlReqError > payload = ::boost::shared_ptr< BtApplSppFlowCtrlReqError >
                (new BtApplSppFlowCtrlReqError(DBUS_ERROR_NO_SERVER, "The DBus service SPP is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSppFlowCtrlReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SPPProxy> proxyShared = ::boost::static_pointer_cast<SPPProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSppFlowCtrlReqCallbackIF*) _callback)->onBtApplSppFlowCtrlReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SPPProxyCallback::_logger (SPPProxy::_logger);

SPPProxy::SPPProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.alps.evo.SPP", serviceAvailable, _logger) {
}

SPPProxy::~SPPProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SPPProxy > SPPProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SPPProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SPPProxy > proxyNew(new SPPProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SPPProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SPPProxyCallback* callback = new SPPProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SPPProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SPPProxyCallback* callback = new SPPProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void SPPProxy::sendDeregisterAll () const
{
    sendBtApplSppDataCfmDeregisterAll();
    sendBtApplSppDataIndDeregisterAll();
    sendBtApplSppSendIndDeregisterAll();
    sendBtApplSppSetUuidCfmDeregisterAll();
    sendBtApplSppFlowCtrlCfmDeregisterAll();
    sendBtApplSppDataSendFcIndDeregisterAll();
}

act_t SPPProxy::sendBtApplSppDataCfmRegister(BtApplSppDataCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppDataCfm");
    act_t act = addSignalCallback(ID_BtApplSppDataCfm, "BtApplSppDataCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppDataCfm", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppDataCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppDataCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppDataCfm", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppDataCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppDataCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppDataCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppDataIndRegister(BtApplSppDataIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppDataInd");
    act_t act = addSignalCallback(ID_BtApplSppDataInd, "BtApplSppDataInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppDataInd", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppDataIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppDataInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppDataInd", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppDataIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppDataInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppDataInd", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppSendIndRegister(BtApplSppSendIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppSendInd");
    act_t act = addSignalCallback(ID_BtApplSppSendInd, "BtApplSppSendInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppSendInd", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppSendIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppSendInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppSendInd", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppSendIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppSendInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppSendInd", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppSetUuidCfmRegister(BtApplSppSetUuidCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppSetUuidCfm");
    act_t act = addSignalCallback(ID_BtApplSppSetUuidCfm, "BtApplSppSetUuidCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppSetUuidCfm", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppSetUuidCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppSetUuidCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppSetUuidCfm", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppSetUuidCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppSetUuidCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppSetUuidCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppFlowCtrlCfmRegister(BtApplSppFlowCtrlCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppFlowCtrlCfm");
    act_t act = addSignalCallback(ID_BtApplSppFlowCtrlCfm, "BtApplSppFlowCtrlCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppFlowCtrlCfm", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppFlowCtrlCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppFlowCtrlCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppFlowCtrlCfm", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppFlowCtrlCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppFlowCtrlCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppFlowCtrlCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppDataSendFcIndRegister(BtApplSppDataSendFcIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSppDataSendFcInd");
    act_t act = addSignalCallback(ID_BtApplSppDataSendFcInd, "BtApplSppDataSendFcInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSppDataSendFcInd", &cb, act);
    return act;
}

bool SPPProxy::sendBtApplSppDataSendFcIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSppDataSendFcInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSppDataSendFcInd", act, static_cast<int>(rv));
    return rv;
}

void SPPProxy::sendBtApplSppDataSendFcIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSppDataSendFcInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSppDataSendFcInd", 0, _dbusDaemonProxy.get(), false);
}

act_t SPPProxy::sendBtApplSppDataReqRequest(BtApplSppDataReqCallbackIF& cb, uint8 instance, const ::std::vector< uint8 >& data) const {
    BtApplSppDataReqRequest* payload = new BtApplSppDataReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setInstance(instance);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplSppDataReq", BtApplSppDataReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplSppDataReq, dbusMessage.getUniqueSerial(), "BtApplSppDataReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplSppDataReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SPPProxy::sendBtApplSppSetUuidReqRequest(BtApplSppSetUuidReqCallbackIF& cb, uint8 instance, const ::std::vector< uint8 >& data) const {
    BtApplSppSetUuidReqRequest* payload = new BtApplSppSetUuidReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setInstance(instance);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplSppSetUuidReq", BtApplSppSetUuidReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplSppSetUuidReq, dbusMessage.getUniqueSerial(), "BtApplSppSetUuidReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplSppSetUuidReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SPPProxy::sendBtApplSppFlowCtrlReqRequest(BtApplSppFlowCtrlReqCallbackIF& cb, uint8 instance, uint8 action) const {
    BtApplSppFlowCtrlReqRequest* payload = new BtApplSppFlowCtrlReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setInstance(instance);
    payload->setAction(action);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplSppFlowCtrlReq", BtApplSppFlowCtrlReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplSppFlowCtrlReq, dbusMessage.getUniqueSerial(), "BtApplSppFlowCtrlReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplSppFlowCtrlReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace SPP
} // namespace evo
} // namespace alps
} // namespace org
