/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_PANSTUB_H
#define ORG_ALPS_EVO_PANSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/PAN.h"
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace PAN {

class PANStubDelegate;

class PANStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the PANStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    PANStub (const std::string& portName);

    /**
     * Create an instance of the PANStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    PANStub (const std::string& portName, const std::string& objectPath);

    virtual ~PANStub();

    // signal 'BtApplPanSendDataCfm'

    /**
     * Raise the signal 'BtApplPanSendDataCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplPanSendDataCfm'</b>:
     *
     * If the meaning of "BtApplPanSendDataCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplPanSendDataCfmSignal(uint8 status);

    // signal 'BtApplPanSendInd'

    /**
     * Raise the signal 'BtApplPanSendInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplPanSendInd'</b>:
     *
     * If the meaning of "BtApplPanSendInd" isn't clear, then there should be a description here.
     */
    void sendBtApplPanSendIndSignal(uint8 status);

    // signal 'BtApplPanFilterNettypeCfm'

    /**
     * Raise the signal 'BtApplPanFilterNettypeCfm' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplPanFilterNettypeCfmSignal(uint8 status);

    // signal 'BtApplPanFilterNettypeInd'

    /**
     * Raise the signal 'BtApplPanFilterNettypeInd' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeInd'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeInd" isn't clear, then there should be a description here.
     */
    void sendBtApplPanFilterNettypeIndSignal(uint8 status);

    // signal 'BtApplPanFilterMuladdrCfm'

    /**
     * Raise the signal 'BtApplPanFilterMuladdrCfm' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplPanFilterMuladdrCfmSignal(uint8 status);

    // signal 'BtApplPanFilterMuladdrInd'

    /**
     * Raise the signal 'BtApplPanFilterMuladdrInd' and send an update message
     * to registered clients.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrInd'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrInd" isn't clear, then there should be a description here.
     */
    void sendBtApplPanFilterMuladdrIndSignal(uint8 status);

    // signal 'BtApplPanDataInd'

    /**
     * Raise the signal 'BtApplPanDataInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplPanDataInd'</b>:
     *
     * If the meaning of "BtApplPanDataInd" isn't clear, then there should be a description here.
     */
    void sendBtApplPanDataIndSignal(const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& packet);

    // method 'BtApplPanSendDataReq'

    /**
     * The method onBtApplPanSendDataReq() is called by ASF when a client
     * invokes the method 'BtApplPanSendDataReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendBtApplPanSendDataReq() or sendBtApplPanSendDataReqError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'BtApplPanSendDataReq'</b>:
     *
     * If the meaning of "BtApplPanSendDataReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplPanSendDataReqRequest (const ::boost::shared_ptr< BtApplPanSendDataReqRequest >& request) = 0;

    /**
     * The method sendBtApplPanSendDataReqResponse() sends a response of a
     * previous method invocation of 'BtApplPanSendDataReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplPanSendDataReq'</b>:
     *
     * If the meaning of "BtApplPanSendDataReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplPanSendDataReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanSendDataReqResponse (act_t act = 0);

    /**
     * The method sendBtApplPanSendDataReqError() sends an error response of a
     * previous method invocation of 'BtApplPanSendDataReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplPanSendDataReq'</b>:
     *
     * If the meaning of "BtApplPanSendDataReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplPanSendDataReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanSendDataReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplPanFilterNettypeReq'

    /**
     * The method onBtApplPanFilterNettypeReq() is called by ASF when a client
     * invokes the method 'BtApplPanFilterNettypeReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplPanFilterNettypeReq() or
     * sendBtApplPanFilterNettypeReqError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeReq'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplPanFilterNettypeReqRequest (const ::boost::shared_ptr< BtApplPanFilterNettypeReqRequest >& request) = 0;

    /**
     * The method sendBtApplPanFilterNettypeReqResponse() sends a response of
     * a previous method invocation of 'BtApplPanFilterNettypeReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeReq'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplPanFilterNettypeReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanFilterNettypeReqResponse (act_t act = 0);

    /**
     * The method sendBtApplPanFilterNettypeReqError() sends an error response
     * of a previous method invocation of 'BtApplPanFilterNettypeReq' back to
     * the client.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeReq'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplPanFilterNettypeReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanFilterNettypeReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplPanFilterMuladdrReq'

    /**
     * The method onBtApplPanFilterMuladdrReq() is called by ASF when a client
     * invokes the method 'BtApplPanFilterMuladdrReq'. A subclass has to
     * implement this method and send back a response to the client either
     * with the sendBtApplPanFilterMuladdrReq() or
     * sendBtApplPanFilterMuladdrReqError() method. Do not invoke this method
     * on your own.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrReq'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplPanFilterMuladdrReqRequest (const ::boost::shared_ptr< BtApplPanFilterMuladdrReqRequest >& request) = 0;

    /**
     * The method sendBtApplPanFilterMuladdrReqResponse() sends a response of
     * a previous method invocation of 'BtApplPanFilterMuladdrReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrReq'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplPanFilterMuladdrReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanFilterMuladdrReqResponse (act_t act = 0);

    /**
     * The method sendBtApplPanFilterMuladdrReqError() sends an error response
     * of a previous method invocation of 'BtApplPanFilterMuladdrReq' back to
     * the client.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrReq'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplPanFilterMuladdrReq(). If the act is not specified, i.e. the
     * most recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplPanFilterMuladdrReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class PANStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace PAN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_PANSTUB_H
