/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_PANPROXY_H
#define ORG_ALPS_EVO_PANPROXY_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "org/alps/evo/PAN.h"
#include <dbus/dbus.h>
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace PAN {

class PANProxy;

class BtApplPanDataIndCallbackIF {
public:
    virtual ~BtApplPanDataIndCallbackIF() {}

    virtual void onBtApplPanDataIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanDataIndError >& error) = 0;

    virtual void onBtApplPanDataIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanDataIndSignal >& signal) = 0;
};

class BtApplPanFilterMuladdrCfmCallbackIF {
public:
    virtual ~BtApplPanFilterMuladdrCfmCallbackIF() {}

    virtual void onBtApplPanFilterMuladdrCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrCfmError >& error) = 0;

    virtual void onBtApplPanFilterMuladdrCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrCfmSignal >& signal) = 0;
};

class BtApplPanFilterMuladdrIndCallbackIF {
public:
    virtual ~BtApplPanFilterMuladdrIndCallbackIF() {}

    virtual void onBtApplPanFilterMuladdrIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrIndError >& error) = 0;

    virtual void onBtApplPanFilterMuladdrIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrIndSignal >& signal) = 0;
};

class BtApplPanFilterMuladdrReqCallbackIF {
public:
    virtual ~BtApplPanFilterMuladdrReqCallbackIF() {}

    virtual void onBtApplPanFilterMuladdrReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrReqError >& error) = 0;

    virtual void onBtApplPanFilterMuladdrReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterMuladdrReqResponse >& response) = 0;
};

class BtApplPanFilterNettypeCfmCallbackIF {
public:
    virtual ~BtApplPanFilterNettypeCfmCallbackIF() {}

    virtual void onBtApplPanFilterNettypeCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeCfmError >& error) = 0;

    virtual void onBtApplPanFilterNettypeCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeCfmSignal >& signal) = 0;
};

class BtApplPanFilterNettypeIndCallbackIF {
public:
    virtual ~BtApplPanFilterNettypeIndCallbackIF() {}

    virtual void onBtApplPanFilterNettypeIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeIndError >& error) = 0;

    virtual void onBtApplPanFilterNettypeIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeIndSignal >& signal) = 0;
};

class BtApplPanFilterNettypeReqCallbackIF {
public:
    virtual ~BtApplPanFilterNettypeReqCallbackIF() {}

    virtual void onBtApplPanFilterNettypeReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeReqError >& error) = 0;

    virtual void onBtApplPanFilterNettypeReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanFilterNettypeReqResponse >& response) = 0;
};

class BtApplPanSendDataCfmCallbackIF {
public:
    virtual ~BtApplPanSendDataCfmCallbackIF() {}

    virtual void onBtApplPanSendDataCfmError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataCfmError >& error) = 0;

    virtual void onBtApplPanSendDataCfmSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataCfmSignal >& signal) = 0;
};

class BtApplPanSendDataReqCallbackIF {
public:
    virtual ~BtApplPanSendDataReqCallbackIF() {}

    virtual void onBtApplPanSendDataReqError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataReqError >& error) = 0;

    virtual void onBtApplPanSendDataReqResponse(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendDataReqResponse >& response) = 0;
};

class BtApplPanSendIndCallbackIF {
public:
    virtual ~BtApplPanSendIndCallbackIF() {}

    virtual void onBtApplPanSendIndError(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendIndError >& error) = 0;

    virtual void onBtApplPanSendIndSignal(const ::boost::shared_ptr< PANProxy >& proxy, const ::boost::shared_ptr< BtApplPanSendIndSignal >& signal) = 0;
};


/**
 * PANProxy is the client side representation of the D-Bus service
 * interface 'org.alps.evo.PAN' (specified in file pan_pan.xml).
 *
 * If the meaning of "org.alps.evo.PAN" isn't clear, then there should be a description here.
 */
class PANProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of PANProxy.
     */
    static ::boost::shared_ptr< PANProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of PANProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< PANProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of PANProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< PANProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< PANProxy > proxyNew(new PANProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~PANProxy ();


    // Signal 'BtApplPanSendDataCfm'

    /**
     * Notify on the signal 'BtApplPanSendDataCfm'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanSendDataCfm'</b>:
     *
     * If the meaning of "BtApplPanSendDataCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanSendDataCfmRegister(BtApplPanSendDataCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanSendDataCfm'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanSendDataCfm'</b>:
     *
     * If the meaning of "BtApplPanSendDataCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanSendDataCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanSendDataCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplPanSendDataCfm'.
     */
    void sendBtApplPanSendDataCfmDeregisterAll () const;

    // Signal 'BtApplPanSendInd'

    /**
     * Notify on the signal 'BtApplPanSendInd'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanSendInd'</b>:
     *
     * If the meaning of "BtApplPanSendInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanSendIndRegister(BtApplPanSendIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanSendInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanSendInd'</b>:
     *
     * If the meaning of "BtApplPanSendInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanSendIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanSendIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplPanSendInd'.
     */
    void sendBtApplPanSendIndDeregisterAll () const;

    // Signal 'BtApplPanFilterNettypeCfm'

    /**
     * Notify on the signal 'BtApplPanFilterNettypeCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterNettypeCfmRegister(BtApplPanFilterNettypeCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanFilterNettypeCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanFilterNettypeCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanFilterNettypeCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplPanFilterNettypeCfm'.
     */
    void sendBtApplPanFilterNettypeCfmDeregisterAll () const;

    // Signal 'BtApplPanFilterNettypeInd'

    /**
     * Notify on the signal 'BtApplPanFilterNettypeInd'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeInd'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterNettypeIndRegister(BtApplPanFilterNettypeIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanFilterNettypeInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeInd'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanFilterNettypeIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanFilterNettypeIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplPanFilterNettypeInd'.
     */
    void sendBtApplPanFilterNettypeIndDeregisterAll () const;

    // Signal 'BtApplPanFilterMuladdrCfm'

    /**
     * Notify on the signal 'BtApplPanFilterMuladdrCfm'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrCfm" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterMuladdrCfmRegister(BtApplPanFilterMuladdrCfmCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanFilterMuladdrCfm'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrCfm'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrCfm" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanFilterMuladdrCfmRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanFilterMuladdrCfmDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplPanFilterMuladdrCfm'.
     */
    void sendBtApplPanFilterMuladdrCfmDeregisterAll () const;

    // Signal 'BtApplPanFilterMuladdrInd'

    /**
     * Notify on the signal 'BtApplPanFilterMuladdrInd'. This method registers
     * for signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrInd'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterMuladdrIndRegister(BtApplPanFilterMuladdrIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanFilterMuladdrInd'. This
     * method deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrInd'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanFilterMuladdrIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanFilterMuladdrIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal
     * 'BtApplPanFilterMuladdrInd'.
     */
    void sendBtApplPanFilterMuladdrIndDeregisterAll () const;

    // Signal 'BtApplPanDataInd'

    /**
     * Notify on the signal 'BtApplPanDataInd'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'BtApplPanDataInd'</b>:
     *
     * If the meaning of "BtApplPanDataInd" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanDataIndRegister(BtApplPanDataIndCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'BtApplPanDataInd'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'BtApplPanDataInd'</b>:
     *
     * If the meaning of "BtApplPanDataInd" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendBtApplPanDataIndRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendBtApplPanDataIndDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'BtApplPanDataInd'.
     */
    void sendBtApplPanDataIndDeregisterAll () const;



    // Method 'BtApplPanSendDataReq'

    /**
     * Call the method 'BtApplPanSendDataReq'. This method sends a message to
     * the D-Bus server.
     *
     * <b>Documentation of 'BtApplPanSendDataReq'</b>:
     *
     * If the meaning of "BtApplPanSendDataReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param dest_addr If the meaning of "dest_addr" isn't clear, then there should be a description here.
     *
     * @param src_addr If the meaning of "src_addr" isn't clear, then there should be a description here.
     *
     * @param pkt_type If the meaning of "pkt_type" isn't clear, then there should be a description here.
     *
     * @param data If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanSendDataReqRequest(BtApplPanSendDataReqCallbackIF& cb, const ::std::vector< uint8 >& dest_addr, const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& data) const;

    // Method 'BtApplPanFilterNettypeReq'

    /**
     * Call the method 'BtApplPanFilterNettypeReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplPanFilterNettypeReq'</b>:
     *
     * If the meaning of "BtApplPanFilterNettypeReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param nettype_num If the meaning of "nettype_num" isn't clear, then there should be a description here.
     *
     * @param nettype_filter_list If the meaning of "nettype_filter_list" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterNettypeReqRequest(BtApplPanFilterNettypeReqCallbackIF& cb, uint16 nettype_num, const ::std::vector< uint8 >& nettype_filter_list) const;

    // Method 'BtApplPanFilterMuladdrReq'

    /**
     * Call the method 'BtApplPanFilterMuladdrReq'. This method sends a
     * message to the D-Bus server.
     *
     * <b>Documentation of 'BtApplPanFilterMuladdrReq'</b>:
     *
     * If the meaning of "BtApplPanFilterMuladdrReq" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param addr_num If the meaning of "addr_num" isn't clear, then there should be a description here.
     *
     * @param addr_filter_list If the meaning of "addr_filter_list" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendBtApplPanFilterMuladdrReqRequest(BtApplPanFilterMuladdrReqCallbackIF& cb, uint16 addr_num, const ::std::vector< uint8 >& addr_filter_list) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    PANProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class PANProxyCallback;
};

} // namespace PAN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_PANPROXY_H
