/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/PAN.h"
#include "org/alps/evo/PANDBus.h"
#include "org/alps/evo/PANJson.h"
#include "org/alps/evo/PANProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace PAN {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/PAN", PANProxy);

class PANProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    PANProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< PANProxy >& proxyShared = ::boost::static_pointer_cast< PANProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BtApplPanSendDataCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanSendDataCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanSendDataCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanSendDataCfmSignal> payload = ::boost::static_pointer_cast<BtApplPanSendDataCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanSendDataCfmCallbackIF*) _callback)->onBtApplPanSendDataCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanSendInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanSendIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanSendInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanSendIndSignal> payload = ::boost::static_pointer_cast<BtApplPanSendIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanSendIndCallbackIF*) _callback)->onBtApplPanSendIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanFilterNettypeCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterNettypeCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanFilterNettypeCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanFilterNettypeCfmSignal> payload = ::boost::static_pointer_cast<BtApplPanFilterNettypeCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanFilterNettypeCfmCallbackIF*) _callback)->onBtApplPanFilterNettypeCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanFilterNettypeInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterNettypeIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanFilterNettypeInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanFilterNettypeIndSignal> payload = ::boost::static_pointer_cast<BtApplPanFilterNettypeIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanFilterNettypeIndCallbackIF*) _callback)->onBtApplPanFilterNettypeIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanFilterMuladdrCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterMuladdrCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanFilterMuladdrCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanFilterMuladdrCfmSignal> payload = ::boost::static_pointer_cast<BtApplPanFilterMuladdrCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanFilterMuladdrCfmCallbackIF*) _callback)->onBtApplPanFilterMuladdrCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanFilterMuladdrInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterMuladdrIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanFilterMuladdrInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanFilterMuladdrIndSignal> payload = ::boost::static_pointer_cast<BtApplPanFilterMuladdrIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanFilterMuladdrIndCallbackIF*) _callback)->onBtApplPanFilterMuladdrIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanDataInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanDataIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplPanDataInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplPanDataIndSignal> payload = ::boost::static_pointer_cast<BtApplPanDataIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplPanDataIndCallbackIF*) _callback)->onBtApplPanDataIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplPanSendDataReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanSendDataReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanSendDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanSendDataReqError> payload = ::boost::static_pointer_cast<BtApplPanSendDataReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanSendDataReqCallbackIF*) _callback)->onBtApplPanSendDataReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanSendDataReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanSendDataReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanSendDataReqResponse> payload = ::boost::static_pointer_cast<BtApplPanSendDataReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanSendDataReqCallbackIF*) _callback)->onBtApplPanSendDataReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplPanFilterNettypeReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterNettypeReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanFilterNettypeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanFilterNettypeReqError> payload = ::boost::static_pointer_cast<BtApplPanFilterNettypeReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanFilterNettypeReqCallbackIF*) _callback)->onBtApplPanFilterNettypeReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterNettypeReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanFilterNettypeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanFilterNettypeReqResponse> payload = ::boost::static_pointer_cast<BtApplPanFilterNettypeReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanFilterNettypeReqCallbackIF*) _callback)->onBtApplPanFilterNettypeReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplPanFilterMuladdrReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterMuladdrReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanFilterMuladdrReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanFilterMuladdrReqError> payload = ::boost::static_pointer_cast<BtApplPanFilterMuladdrReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanFilterMuladdrReqCallbackIF*) _callback)->onBtApplPanFilterMuladdrReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplPanFilterMuladdrReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplPanFilterMuladdrReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplPanFilterMuladdrReqResponse> payload = ::boost::static_pointer_cast<BtApplPanFilterMuladdrReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplPanFilterMuladdrReqCallbackIF*) _callback)->onBtApplPanFilterMuladdrReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BtApplPanSendDataCfm: {
                ::boost::shared_ptr< BtApplPanSendDataCfmError > payload = ::boost::shared_ptr< BtApplPanSendDataCfmError >
                (new BtApplPanSendDataCfmError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanSendDataCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanSendDataCfmCallbackIF*) _callback)->onBtApplPanSendDataCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanSendInd: {
                ::boost::shared_ptr< BtApplPanSendIndError > payload = ::boost::shared_ptr< BtApplPanSendIndError >
                (new BtApplPanSendIndError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanSendInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanSendIndCallbackIF*) _callback)->onBtApplPanSendIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterNettypeCfm: {
                ::boost::shared_ptr< BtApplPanFilterNettypeCfmError > payload = ::boost::shared_ptr< BtApplPanFilterNettypeCfmError >
                (new BtApplPanFilterNettypeCfmError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterNettypeCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterNettypeCfmCallbackIF*) _callback)->onBtApplPanFilterNettypeCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterNettypeInd: {
                ::boost::shared_ptr< BtApplPanFilterNettypeIndError > payload = ::boost::shared_ptr< BtApplPanFilterNettypeIndError >
                (new BtApplPanFilterNettypeIndError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterNettypeInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterNettypeIndCallbackIF*) _callback)->onBtApplPanFilterNettypeIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterMuladdrCfm: {
                ::boost::shared_ptr< BtApplPanFilterMuladdrCfmError > payload = ::boost::shared_ptr< BtApplPanFilterMuladdrCfmError >
                (new BtApplPanFilterMuladdrCfmError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterMuladdrCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterMuladdrCfmCallbackIF*) _callback)->onBtApplPanFilterMuladdrCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterMuladdrInd: {
                ::boost::shared_ptr< BtApplPanFilterMuladdrIndError > payload = ::boost::shared_ptr< BtApplPanFilterMuladdrIndError >
                (new BtApplPanFilterMuladdrIndError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterMuladdrInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterMuladdrIndCallbackIF*) _callback)->onBtApplPanFilterMuladdrIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanDataInd: {
                ::boost::shared_ptr< BtApplPanDataIndError > payload = ::boost::shared_ptr< BtApplPanDataIndError >
                (new BtApplPanDataIndError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanDataInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanDataIndCallbackIF*) _callback)->onBtApplPanDataIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanSendDataReq: {
                ::boost::shared_ptr< BtApplPanSendDataReqError > payload = ::boost::shared_ptr< BtApplPanSendDataReqError >
                (new BtApplPanSendDataReqError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanSendDataReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanSendDataReqCallbackIF*) _callback)->onBtApplPanSendDataReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterNettypeReq: {
                ::boost::shared_ptr< BtApplPanFilterNettypeReqError > payload = ::boost::shared_ptr< BtApplPanFilterNettypeReqError >
                (new BtApplPanFilterNettypeReqError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterNettypeReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterNettypeReqCallbackIF*) _callback)->onBtApplPanFilterNettypeReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplPanFilterMuladdrReq: {
                ::boost::shared_ptr< BtApplPanFilterMuladdrReqError > payload = ::boost::shared_ptr< BtApplPanFilterMuladdrReqError >
                (new BtApplPanFilterMuladdrReqError(DBUS_ERROR_NO_SERVER, "The DBus service PAN is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplPanFilterMuladdrReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<PANProxy> proxyShared = ::boost::static_pointer_cast<PANProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplPanFilterMuladdrReqCallbackIF*) _callback)->onBtApplPanFilterMuladdrReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& PANProxyCallback::_logger (PANProxy::_logger);

PANProxy::PANProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.alps.evo.PAN", serviceAvailable, _logger) {
}

PANProxy::~PANProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< PANProxy > PANProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<PANProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< PANProxy > proxyNew(new PANProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t PANProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    PANProxyCallback* callback = new PANProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t PANProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    PANProxyCallback* callback = new PANProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void PANProxy::sendDeregisterAll () const
{
    sendBtApplPanSendDataCfmDeregisterAll();
    sendBtApplPanSendIndDeregisterAll();
    sendBtApplPanFilterNettypeCfmDeregisterAll();
    sendBtApplPanFilterNettypeIndDeregisterAll();
    sendBtApplPanFilterMuladdrCfmDeregisterAll();
    sendBtApplPanFilterMuladdrIndDeregisterAll();
    sendBtApplPanDataIndDeregisterAll();
}

act_t PANProxy::sendBtApplPanSendDataCfmRegister(BtApplPanSendDataCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanSendDataCfm");
    act_t act = addSignalCallback(ID_BtApplPanSendDataCfm, "BtApplPanSendDataCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanSendDataCfm", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanSendDataCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanSendDataCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanSendDataCfm", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanSendDataCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanSendDataCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanSendDataCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanSendIndRegister(BtApplPanSendIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanSendInd");
    act_t act = addSignalCallback(ID_BtApplPanSendInd, "BtApplPanSendInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanSendInd", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanSendIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanSendInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanSendInd", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanSendIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanSendInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanSendInd", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanFilterNettypeCfmRegister(BtApplPanFilterNettypeCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanFilterNettypeCfm");
    act_t act = addSignalCallback(ID_BtApplPanFilterNettypeCfm, "BtApplPanFilterNettypeCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanFilterNettypeCfm", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanFilterNettypeCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanFilterNettypeCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanFilterNettypeCfm", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanFilterNettypeCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanFilterNettypeCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanFilterNettypeCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanFilterNettypeIndRegister(BtApplPanFilterNettypeIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanFilterNettypeInd");
    act_t act = addSignalCallback(ID_BtApplPanFilterNettypeInd, "BtApplPanFilterNettypeInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanFilterNettypeInd", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanFilterNettypeIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanFilterNettypeInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanFilterNettypeInd", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanFilterNettypeIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanFilterNettypeInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanFilterNettypeInd", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanFilterMuladdrCfmRegister(BtApplPanFilterMuladdrCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanFilterMuladdrCfm");
    act_t act = addSignalCallback(ID_BtApplPanFilterMuladdrCfm, "BtApplPanFilterMuladdrCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanFilterMuladdrCfm", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanFilterMuladdrCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanFilterMuladdrCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanFilterMuladdrCfm", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanFilterMuladdrCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanFilterMuladdrCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanFilterMuladdrCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanFilterMuladdrIndRegister(BtApplPanFilterMuladdrIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanFilterMuladdrInd");
    act_t act = addSignalCallback(ID_BtApplPanFilterMuladdrInd, "BtApplPanFilterMuladdrInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanFilterMuladdrInd", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanFilterMuladdrIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanFilterMuladdrInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanFilterMuladdrInd", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanFilterMuladdrIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanFilterMuladdrInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanFilterMuladdrInd", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanDataIndRegister(BtApplPanDataIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplPanDataInd");
    act_t act = addSignalCallback(ID_BtApplPanDataInd, "BtApplPanDataInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplPanDataInd", &cb, act);
    return act;
}

bool PANProxy::sendBtApplPanDataIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplPanDataInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplPanDataInd", act, static_cast<int>(rv));
    return rv;
}

void PANProxy::sendBtApplPanDataIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplPanDataInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplPanDataInd", 0, _dbusDaemonProxy.get(), false);
}

act_t PANProxy::sendBtApplPanSendDataReqRequest(BtApplPanSendDataReqCallbackIF& cb, const ::std::vector< uint8 >& dest_addr, const ::std::vector< uint8 >& src_addr, uint16 pkt_type, const ::std::vector< uint8 >& data) const {
    BtApplPanSendDataReqRequest* payload = new BtApplPanSendDataReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setDest_addr(dest_addr);
    payload->setSrc_addr(src_addr);
    payload->setPkt_type(pkt_type);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplPanSendDataReq", BtApplPanSendDataReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplPanSendDataReq, dbusMessage.getUniqueSerial(), "BtApplPanSendDataReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplPanSendDataReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PANProxy::sendBtApplPanFilterNettypeReqRequest(BtApplPanFilterNettypeReqCallbackIF& cb, uint16 nettype_num, const ::std::vector< uint8 >& nettype_filter_list) const {
    BtApplPanFilterNettypeReqRequest* payload = new BtApplPanFilterNettypeReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setNettype_num(nettype_num);
    payload->setNettype_filter_list(nettype_filter_list);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplPanFilterNettypeReq", BtApplPanFilterNettypeReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplPanFilterNettypeReq, dbusMessage.getUniqueSerial(), "BtApplPanFilterNettypeReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplPanFilterNettypeReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t PANProxy::sendBtApplPanFilterMuladdrReqRequest(BtApplPanFilterMuladdrReqCallbackIF& cb, uint16 addr_num, const ::std::vector< uint8 >& addr_filter_list) const {
    BtApplPanFilterMuladdrReqRequest* payload = new BtApplPanFilterMuladdrReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddr_num(addr_num);
    payload->setAddr_filter_list(addr_filter_list);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplPanFilterMuladdrReq", BtApplPanFilterMuladdrReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplPanFilterMuladdrReq, dbusMessage.getUniqueSerial(), "BtApplPanFilterMuladdrReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplPanFilterMuladdrReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace PAN
} // namespace evo
} // namespace alps
} // namespace org
