/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DUNSTUB_H
#define ORG_ALPS_EVO_DUNSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DUN.h"
#include <vector>

namespace org {
namespace alps {
namespace evo {
namespace DUN {

class DUNStubDelegate;

class DUNStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DUNStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DUNStub (const std::string& portName);

    /**
     * Create an instance of the DUNStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DUNStub (const std::string& portName, const std::string& objectPath);

    virtual ~DUNStub();

    // signal 'BtApplDunSendDataCfm'

    /**
     * Raise the signal 'BtApplDunSendDataCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDunSendDataCfm'</b>:
     *
     * If the meaning of "BtApplDunSendDataCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplDunSendDataCfmSignal(uint8 status);

    // signal 'BtApplDunSendInd'

    /**
     * Raise the signal 'BtApplDunSendInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDunSendInd'</b>:
     *
     * If the meaning of "BtApplDunSendInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDunSendIndSignal(uint8 status);

    // signal 'BtApplDunDataInd'

    /**
     * Raise the signal 'BtApplDunDataInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDunDataInd'</b>:
     *
     * If the meaning of "BtApplDunDataInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDunDataIndSignal(const ::std::vector< uint8 >& data);

    // signal 'BtApplDunDataSendFcInd'

    /**
     * Raise the signal 'BtApplDunDataSendFcInd' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDunDataSendFcInd'</b>:
     *
     * If the meaning of "BtApplDunDataSendFcInd" isn't clear, then there should be a description here.
     */
    void sendBtApplDunDataSendFcIndSignal(uint8 status);

    // signal 'BtApplDunFlowCtrlCfm'

    /**
     * Raise the signal 'BtApplDunFlowCtrlCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlCfm'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplDunFlowCtrlCfmSignal(uint8 status);

    // property 'DeviceFilePath'

    /**
     * The method onDeviceFilePathGet() is called by ASF when a client invokes
     * the read method for the property 'DeviceFilePath'. The
     * onDeviceFilePathGet() method returns by default the current property
     * value to the caller. In case this default behavior doesn't match your
     * needs feel free to override this method.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    virtual void onDeviceFilePathGet(const ::boost::shared_ptr< DeviceFilePathGet >& payload);

    /**
     * Sends back the update to a previous onDeviceFilePathGet().
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param act Identifies a previous invocation of onDeviceFilePathGet().
     * If the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendDeviceFilePathGetUpdate(const ::std::vector< uint8 >& deviceFilePath, act_t act = 0);

    /**
     * Set the value of the property 'DeviceFilePath' and send updates to
     * registered clients. No updates will be sent if the property value does
     * not change.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    void setDeviceFilePath(const ::std::vector< uint8 >& deviceFilePath);

    /**
     * Returns the current value of the property 'DeviceFilePath'.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    const ::std::vector< uint8 >& getDeviceFilePath() const;

    /**
     * Returns the current value of the property 'DeviceFilePath' as a mutable
     * reference. If you change the content of the returned object you have to
     * send updates to registered clients by yourself with the help of the
     * sendDeviceFilePathUpdate() method.
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    ::std::vector< uint8 >& getDeviceFilePathMutable();


    /**
     * Sends updates to all registered clients with the current property
     * value, see sendDeviceFilePathUpdate().
     *
     * <b>Documentation of 'DeviceFilePath'</b>:
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     */
    void sendDeviceFilePathUpdate();

    // method 'BtApplDunSendDataReq'

    /**
     * The method onBtApplDunSendDataReq() is called by ASF when a client
     * invokes the method 'BtApplDunSendDataReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendBtApplDunSendDataReq() or sendBtApplDunSendDataReqError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'BtApplDunSendDataReq'</b>:
     *
     * If the meaning of "BtApplDunSendDataReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplDunSendDataReqRequest (const ::boost::shared_ptr< BtApplDunSendDataReqRequest >& request) = 0;

    /**
     * The method sendBtApplDunSendDataReqResponse() sends a response of a
     * previous method invocation of 'BtApplDunSendDataReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDunSendDataReq'</b>:
     *
     * If the meaning of "BtApplDunSendDataReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplDunSendDataReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDunSendDataReqResponse (act_t act = 0);

    /**
     * The method sendBtApplDunSendDataReqError() sends an error response of a
     * previous method invocation of 'BtApplDunSendDataReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDunSendDataReq'</b>:
     *
     * If the meaning of "BtApplDunSendDataReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplDunSendDataReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDunSendDataReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'BtApplDunFlowCtrlReq'

    /**
     * The method onBtApplDunFlowCtrlReq() is called by ASF when a client
     * invokes the method 'BtApplDunFlowCtrlReq'. A subclass has to implement
     * this method and send back a response to the client either with the
     * sendBtApplDunFlowCtrlReq() or sendBtApplDunFlowCtrlReqError() method.
     * Do not invoke this method on your own.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlReq'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplDunFlowCtrlReqRequest (const ::boost::shared_ptr< BtApplDunFlowCtrlReqRequest >& request) = 0;

    /**
     * The method sendBtApplDunFlowCtrlReqResponse() sends a response of a
     * previous method invocation of 'BtApplDunFlowCtrlReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlReq'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplDunFlowCtrlReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDunFlowCtrlReqResponse (act_t act = 0);

    /**
     * The method sendBtApplDunFlowCtrlReqError() sends an error response of a
     * previous method invocation of 'BtApplDunFlowCtrlReq' back to the
     * client.
     *
     * <b>Documentation of 'BtApplDunFlowCtrlReq'</b>:
     *
     * If the meaning of "BtApplDunFlowCtrlReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of
     * onBtApplDunFlowCtrlReq(). If the act is not specified, i.e. the most
     * recent invocation will be answered. In case multiple replies are
     * pending an act must be specified. An assertion will be thrown if no or
     * multiple method invocation could be found.
     */
    void sendBtApplDunFlowCtrlReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    DeviceFilePathUpdate _DeviceFilePathProperty;

    friend class DUNStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DUN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DUNSTUB_H
