/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DUN.h"
#include "org/alps/evo/DUNDBus.h"
#include "org/alps/evo/DUNJson.h"
#include "org/alps/evo/DUNStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DUN {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DUN", DUNStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 20, "BtApplDunFlowCtrlReq", 1 },
    { 20, "BtApplDunSendDataReq", 0 },
};

static ::asf::dbus::DBusUtils::stringEntry propertiesTable[] = {
    { 14, "DeviceFilePath", 0 },
};

class DUNStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DUNStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DUNStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DUNStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.alps.evo.DUN"),
          _logger(logger) {}

    virtual ~DUNStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DUNStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 2, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'BtApplDunSendDataReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplDunSendDataReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunSendDataReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplDunSendDataReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplDunSendDataReqRequest > payload = ::boost::static_pointer_cast<BtApplDunSendDataReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DUNStub*>(getStub())->onBtApplDunSendDataReqRequest(payload);
            return;
        }
        case 1: {

            // method 'BtApplDunFlowCtrlReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplDunFlowCtrlReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDunFlowCtrlReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplDunFlowCtrlReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplDunFlowCtrlReqRequest > payload = ::boost::static_pointer_cast<BtApplDunFlowCtrlReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DUNStub*>(getStub())->onBtApplDunFlowCtrlReqRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DUNStubDelegate::introspect() const {
    return     "<interface name=\"org.alps.evo.DUN\">\n"
            "      <method name=\"BtApplDunSendDataReq\">\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplDunFlowCtrlReq\">\n"
            "        <arg direction=\"in\" name=\"action\" type=\"y\"/>\n"
            "      </method>\n"
            "      <signal name=\"BtApplDunSendDataCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDunSendInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDunDataInd\">\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDunDataSendFcInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDunFlowCtrlCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <property access=\"read\" name=\"DeviceFilePath\" type=\"ay\"/>\n"
            "</interface>\n";
}

void DUNStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DUNStub*>(getStub()))->onGetAll (properties);
}

void DUNStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceFilePath");
            std::ostringstream errorMessage;
            errorMessage << "property '" << property << "' is read only";
            LOG_ERROR_STUB("%s", errorMessage.str().c_str());
            sendSetError(DBUS_ERROR_PROPERTY_READ_ONLY, errorMessage.str(), act);
            ((void)value);  // to get rid of unused variable warning
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DUNStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    unsigned int propertyIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (property.c_str(), property.length(), propertiesTable, 1, propertyIndex)) {
        switch (propertyIndex) {
        case 0: {
            LOG_DEBUG_STUB("process property '%s'", "DeviceFilePath");
            ::boost::shared_ptr< DeviceFilePathGet > payload(new DeviceFilePathGet());
            payload->setAct(act);
            static_cast<DUNStub*>(getStub())->onDeviceFilePathGet (payload);
            return;
        }
        default:
            break;
        }
    }
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DUNStub::DUNStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DUNStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DUNStub::DUNStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DUNStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DUNStub::~DUNStub() {
    delete _stubDelegate;
}

void DUNStub::sendBtApplDunSendDataCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDunSendDataCfmSignal* payload = new BtApplDunSendDataCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDunSendDataCfm", BtApplDunSendDataCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDunSendDataCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDunSendDataCfm");
    }
}

void DUNStub::sendBtApplDunSendIndSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDunSendIndSignal* payload = new BtApplDunSendIndSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDunSendInd", BtApplDunSendIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDunSendInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDunSendInd");
    }
}

void DUNStub::sendBtApplDunDataIndSignal(const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        BtApplDunDataIndSignal* payload = new BtApplDunDataIndSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDunDataInd", BtApplDunDataIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDunDataInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDunDataInd");
    }
}

void DUNStub::sendBtApplDunDataSendFcIndSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDunDataSendFcIndSignal* payload = new BtApplDunDataSendFcIndSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDunDataSendFcInd", BtApplDunDataSendFcIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDunDataSendFcInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDunDataSendFcInd");
    }
}

void DUNStub::sendBtApplDunFlowCtrlCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDunFlowCtrlCfmSignal* payload = new BtApplDunFlowCtrlCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDunFlowCtrlCfm", BtApplDunFlowCtrlCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDunFlowCtrlCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDunFlowCtrlCfm");
    }
}

void DUNStub::sendDeviceFilePathUpdate() {
    if (_stubDelegate->isConnected()) {
        ::asf::dbus::DBusVariant variant;
        DeviceFilePathUpdate payload(_DeviceFilePathProperty);

        LOG_INFO ("-> send%s", "DeviceFilePathUpdate");
        if (IS_LOG_INFO_ENABLED()) {
            std::string jsonPayload;
            serializeJson(payload, jsonPayload);
            LOG_INFO ("payload: %s", jsonPayload.c_str());
        }

        serializeDBus(payload, variant.getWriteIterator());
        ::std::map< ::std::string, ::asf::dbus::DBusVariant > changedProperties;
        changedProperties.insert(::std::pair< ::std::string, ::asf::dbus::DBusVariant >("DeviceFilePath", variant));
        ::std::vector< ::std::string > invalidatedProperties;
        _stubDelegate->sendPropertiesChangedSignal("org.alps.evo.DUN", changedProperties, invalidatedProperties);
    } else {
        LOG_INFO("Not connected, '%s' no property update sent", "DeviceFilePathUpdate");
    }
}

void DUNStub::onDeviceFilePathGet(const ::boost::shared_ptr< DeviceFilePathGet >& deviceFilePath) {
    LOG_INFO ("<- on%s, act=%" PRIuPTR, "DeviceFilePathGet", deviceFilePath->getAct());
    sendDeviceFilePathGetUpdate(_DeviceFilePathProperty.getDeviceFilePath(), deviceFilePath->getAct());
}

void DUNStub::sendDeviceFilePathGetUpdate(const ::std::vector< uint8 >& deviceFilePath, act_t act) {
    ::asf::dbus::DBusVariant variant;
    DeviceFilePathGet payload(deviceFilePath);
    serializeDBus(payload, variant.getWriteIterator());

    LOG_INFO ("-> send%s, act=%" PRIuPTR, "DeviceFilePathGetUpdate", act);
    if (IS_LOG_INFO_ENABLED()) {
        std::string jsonPayload;
        serializeJson(payload, jsonPayload);
        LOG_INFO ("payload: %s", jsonPayload.c_str());
    }

    _stubDelegate->sendGetResponse(variant, act);
}

void DUNStub::setDeviceFilePath(const ::std::vector< uint8 >& deviceFilePath) {
    if(deviceFilePath!=_DeviceFilePathProperty.getDeviceFilePath()) {
        _DeviceFilePathProperty.setDeviceFilePath(deviceFilePath);
        sendDeviceFilePathUpdate();
    } else {
        LOG_DEBUG ("Data not changed, no update sent");
    }
}

const ::std::vector< uint8 >& DUNStub::getDeviceFilePath() const {
    return _DeviceFilePathProperty.getDeviceFilePath();
}

::std::vector< uint8 >& DUNStub::getDeviceFilePathMutable() {
    return _DeviceFilePathProperty.getDeviceFilePathMutable();
}

void  DUNStub::sendBtApplDunSendDataReqResponse (act_t act) {
    BtApplDunSendDataReqResponse* payload = new BtApplDunSendDataReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplDunSendDataReq", BtApplDunSendDataReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplDunSendDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DUNStub::sendBtApplDunSendDataReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplDunSendDataReqError* payload = new BtApplDunSendDataReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplDunSendDataReq", BtApplDunSendDataReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplDunSendDataReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DUNStub::sendBtApplDunFlowCtrlReqResponse (act_t act) {
    BtApplDunFlowCtrlReqResponse* payload = new BtApplDunFlowCtrlReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplDunFlowCtrlReq", BtApplDunFlowCtrlReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplDunFlowCtrlReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DUNStub::sendBtApplDunFlowCtrlReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplDunFlowCtrlReqError* payload = new BtApplDunFlowCtrlReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplDunFlowCtrlReq", BtApplDunFlowCtrlReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplDunFlowCtrlReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DUNStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {

    //property 'DeviceFilePath'
    {
        ::asf::dbus::DBusVariant variant;
        DeviceFilePathGet payload(_DeviceFilePathProperty.getDeviceFilePath());
        serializeDBus(payload, variant.getWriteIterator());
        properties.insert(std::pair< ::std::string, ::asf::dbus::DBusVariant>("DeviceFilePath", variant));
    }
}

} // namespace DUN
} // namespace evo
} // namespace alps
} // namespace org
