#if defined(__GNUC__)
    #pragma GCC diagnostic push
    #pragma GCC diagnostic ignored "-Wfloat-equal"
#endif
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DUN_H
#define ORG_ALPS_EVO_DUN_H

#include "asf/core/Payload.h"
#include "asf/core/Types.h"
#include "asf/core/VersionCheck.h"
#include "asf/dbus/DBusTypes.h"
#include <cstring>
#include <vector>

/**
 * If the meaning of "DUN" isn't clear, then there should be a description here.
 */

namespace org {
namespace alps {
namespace evo {
namespace DUN {

// method IDs
static const uint16 ID_BtApplDunSendDataReq = 0;
static const uint16 ID_BtApplDunFlowCtrlReq = 1;

// signal IDs
static const uint16 ID_BtApplDunSendDataCfm = 2;
static const uint16 ID_BtApplDunSendInd = 3;
static const uint16 ID_BtApplDunDataInd = 4;
static const uint16 ID_BtApplDunDataSendFcInd = 5;
static const uint16 ID_BtApplDunFlowCtrlCfm = 6;

// property IDs
static const uint16 ID_DeviceFilePath = 7;

ASF_GENERATOR_VERSION_CHECK_DECLARE

// forward declarations
class BtApplDunSendDataReqRequest;

class BtApplDunFlowCtrlReqRequest;

class DeviceFilePathUpdate;

class DeviceFilePathRegister;

class BtApplDunSendDataCfmSignal;

class BtApplDunSendIndSignal;

class BtApplDunDataIndSignal;

class BtApplDunDataSendFcIndSignal;

class BtApplDunFlowCtrlCfmSignal;

// type definitions
/**
 * If the meaning of "BtApplDunSendDataReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDunSendDataReqResponse;

/**
 * If the meaning of "BtApplDunSendDataReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunSendDataReqError;

/**
 * If the meaning of "BtApplDunFlowCtrlReqResponse" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DefaultMessage BtApplDunFlowCtrlReqResponse;

/**
 * If the meaning of "BtApplDunFlowCtrlReqError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunFlowCtrlReqError;

/**
 * If the meaning of "DeviceFilePathSet" isn't clear, then there should be a description here.
 */
typedef DeviceFilePathUpdate DeviceFilePathSet;

/**
 * If the meaning of "DeviceFilePathGet" isn't clear, then there should be a description here.
 */
typedef DeviceFilePathUpdate DeviceFilePathGet;

/**
 * If the meaning of "DeviceFilePathError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError DeviceFilePathError;

/**
 * If the meaning of "BtApplDunSendDataCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunSendDataCfmError;

/**
 * If the meaning of "BtApplDunSendIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunSendIndError;

/**
 * If the meaning of "BtApplDunDataIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunDataIndError;

/**
 * If the meaning of "BtApplDunDataSendFcIndError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunDataSendFcIndError;

/**
 * If the meaning of "BtApplDunFlowCtrlCfmError" isn't clear, then there should be a description here.
 */
typedef ::asf::dbus::DBusTypes::DBusError BtApplDunFlowCtrlCfmError;


/**
 * If the meaning of "BtApplDunSendDataReqRequest" isn't clear, then there should be a description here.
 */
class BtApplDunSendDataReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunSendDataReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplDunSendDataReqRequest (const BtApplDunSendDataReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunSendDataReqRequest (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunSendDataReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplDunSendDataReqRequest& operator = (const BtApplDunSendDataReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunSendDataReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunSendDataReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunSendDataReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunSendDataReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplDunSendDataReqRequest &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplDunFlowCtrlReqRequest" isn't clear, then there should be a description here.
 */
class BtApplDunFlowCtrlReqRequest  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunFlowCtrlReqRequest ();

    /**
     * Copy constructor
     */
    inline  BtApplDunFlowCtrlReqRequest (const BtApplDunFlowCtrlReqRequest &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunFlowCtrlReqRequest (uint8 action_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunFlowCtrlReqRequest();

    /**
     * Assignment operator
     */
    inline BtApplDunFlowCtrlReqRequest& operator = (const BtApplDunFlowCtrlReqRequest& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunFlowCtrlReqRequest& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunFlowCtrlReqRequest& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunFlowCtrlReqRequest& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunFlowCtrlReqRequest& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "action"

    static const int kAction = 0;

    /**
     * Clears the field "action".
     *
     * The field will be set to its default value. The hasAction()
     * method will return false.
     */
    inline void clearAction();

    /**
     * Checks whether the field "action" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setAction()). Otherwise it will return false.
     */
    inline bool hasAction () const;

    /**
     * Returns the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @return The value of the field "action"
     */
    inline uint8 getAction () const;

    /**
     * Sets the value of the member "action".
     *
     * If the meaning of "action" isn't clear, then there should be a description here.
     *
     * @param action The value which will be set
     */
    inline void setAction (uint8 action_);

    static const BtApplDunFlowCtrlReqRequest &getDefaultInstance();

private:

    inline void set_has_action ();

    inline void clear_has_action ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _action;

};

/**
 * If the meaning of "DeviceFilePathUpdate" isn't clear, then there should be a description here.
 */
class DeviceFilePathUpdate  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceFilePathUpdate ();

    /**
     * Copy constructor
     */
    inline  DeviceFilePathUpdate (const DeviceFilePathUpdate &rhs);

    /**
     * All fields constructor
     */
    inline  DeviceFilePathUpdate (const ::std::vector< uint8 >& DeviceFilePath_);

    /**
     * Destructor
     */
    inline virtual  ~DeviceFilePathUpdate();

    /**
     * Assignment operator
     */
    inline DeviceFilePathUpdate& operator = (const DeviceFilePathUpdate& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceFilePathUpdate& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceFilePathUpdate& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceFilePathUpdate& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceFilePathUpdate& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "DeviceFilePath"

    static const int kDeviceFilePath = 0;

    /**
     * Clears the field "DeviceFilePath".
     *
     * The field will be set to its default value. The hasDeviceFilePath()
     * method will return false.
     */
    inline void clearDeviceFilePath();

    /**
     * Checks whether the field "DeviceFilePath" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setDeviceFilePath()). Otherwise it will return false.
     */
    inline bool hasDeviceFilePath () const;

    /**
     * Returns the value of the member "DeviceFilePath".
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @return The value of the field "DeviceFilePath"
     */
    inline const ::std::vector< uint8 >& getDeviceFilePath () const;

    /**
     * Retrieves the value of the field "DeviceFilePath" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "DeviceFilePath".
     */
    inline ::std::vector< uint8 >& getDeviceFilePathMutable ();

    /**
     * Sets the value of the member "DeviceFilePath".
     *
     * If the meaning of "DeviceFilePath" isn't clear, then there should be a description here.
     *
     * @param DeviceFilePath The value which will be set
     */
    inline void setDeviceFilePath (const ::std::vector< uint8 >& DeviceFilePath_);

    static const DeviceFilePathUpdate &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_DeviceFilePath ();

    inline void clear_has_DeviceFilePath ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _DeviceFilePath;

};

/**
 * If the meaning of "DeviceFilePathRegister" isn't clear, then there should be a description here.
 */
class DeviceFilePathRegister  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  DeviceFilePathRegister ();

    /**
     * Copy constructor
     */
    inline  DeviceFilePathRegister (const DeviceFilePathRegister &rhs);

    /**
     * All fields constructor
     */

    /**
     * Destructor
     */
    inline virtual  ~DeviceFilePathRegister();

    /**
     * Assignment operator
     */
    inline DeviceFilePathRegister& operator = (const DeviceFilePathRegister& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const DeviceFilePathRegister& ) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const DeviceFilePathRegister& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const DeviceFilePathRegister& ) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const DeviceFilePathRegister& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    static const DeviceFilePathRegister &getDefaultInstance();

private:

    uint32 _has_bits_[1]; // empty structure needs a member

};

/**
 * If the meaning of "BtApplDunSendDataCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplDunSendDataCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunSendDataCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDunSendDataCfmSignal (const BtApplDunSendDataCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunSendDataCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunSendDataCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplDunSendDataCfmSignal& operator = (const BtApplDunSendDataCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunSendDataCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunSendDataCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunSendDataCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunSendDataCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDunSendDataCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplDunSendIndSignal" isn't clear, then there should be a description here.
 */
class BtApplDunSendIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunSendIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDunSendIndSignal (const BtApplDunSendIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunSendIndSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunSendIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplDunSendIndSignal& operator = (const BtApplDunSendIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunSendIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunSendIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunSendIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunSendIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDunSendIndSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplDunDataIndSignal" isn't clear, then there should be a description here.
 */
class BtApplDunDataIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunDataIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDunDataIndSignal (const BtApplDunDataIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunDataIndSignal (const ::std::vector< uint8 >& data_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunDataIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplDunDataIndSignal& operator = (const BtApplDunDataIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunDataIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunDataIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunDataIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunDataIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "data"

    static const int kData = 0;

    /**
     * Clears the field "data".
     *
     * The field will be set to its default value. The hasData()
     * method will return false.
     */
    inline void clearData();

    /**
     * Checks whether the field "data" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setData()). Otherwise it will return false.
     */
    inline bool hasData () const;

    /**
     * Returns the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @return The value of the field "data"
     */
    inline const ::std::vector< uint8 >& getData () const;

    /**
     * Retrieves the value of the field "data" as a mutable object.
     * Any modifications on the returned object will affect the containing object.
     *
     * @return The value of the field "data".
     */
    inline ::std::vector< uint8 >& getDataMutable ();

    /**
     * Sets the value of the member "data".
     *
     * If the meaning of "data" isn't clear, then there should be a description here.
     *
     * @param data The value which will be set
     */
    inline void setData (const ::std::vector< uint8 >& data_);

    static const BtApplDunDataIndSignal &getDefaultInstance();

private:

    static const ::std::vector< uint8 >& getUint8List_DefaultInstance ();

    inline void set_has_data ();

    inline void clear_has_data ();

    uint32 _has_bits_[ (1 + 31) / 32];

    ::std::vector< uint8 > _data;

};

/**
 * If the meaning of "BtApplDunDataSendFcIndSignal" isn't clear, then there should be a description here.
 */
class BtApplDunDataSendFcIndSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunDataSendFcIndSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDunDataSendFcIndSignal (const BtApplDunDataSendFcIndSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunDataSendFcIndSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunDataSendFcIndSignal();

    /**
     * Assignment operator
     */
    inline BtApplDunDataSendFcIndSignal& operator = (const BtApplDunDataSendFcIndSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunDataSendFcIndSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunDataSendFcIndSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunDataSendFcIndSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunDataSendFcIndSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDunDataSendFcIndSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

/**
 * If the meaning of "BtApplDunFlowCtrlCfmSignal" isn't clear, then there should be a description here.
 */
class BtApplDunFlowCtrlCfmSignal  : public ::asf::core::Payload {
public:

    /**
     * Default constructor
     */
    inline  BtApplDunFlowCtrlCfmSignal ();

    /**
     * Copy constructor
     */
    inline  BtApplDunFlowCtrlCfmSignal (const BtApplDunFlowCtrlCfmSignal &rhs);

    /**
     * All fields constructor
     */
    inline  BtApplDunFlowCtrlCfmSignal (uint8 status_);

    /**
     * Destructor
     */
    inline virtual  ~BtApplDunFlowCtrlCfmSignal();

    /**
     * Assignment operator
     */
    inline BtApplDunFlowCtrlCfmSignal& operator = (const BtApplDunFlowCtrlCfmSignal& rhs);

    /**
     * Equality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are equal, otherwise returns false
     */
    inline bool operator == (const BtApplDunFlowCtrlCfmSignal& rhs) const;

    /**
     * Inequality operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if both objects are not equal, otherwise returns false
     */
    inline bool operator != (const BtApplDunFlowCtrlCfmSignal& rhs) const;

    /**
     * Less than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is less than the rhs object
     */
    inline bool operator < (const BtApplDunFlowCtrlCfmSignal& rhs) const;

    /**
     * Creates and returns a clone of this object.
     *
     * This method is intended to be used when the type of the object
     * is not known by the caller, e.g. you have a pointer to a base
     * class. In all other cases you should make use of the copy
     * constructor.
     *
     * @return The clone of this object
     */
    inline ::asf::core::Payload* clone();

    /**
     * Greater than operator
     *
     * @param rhs Right hand side object of the comparison
     *
     * @return True if this object is greater than the rhs object
     */
    inline bool operator > (const BtApplDunFlowCtrlCfmSignal& rhs) const;

    /**
     * Clear discards all contents from this structure.
     *
     * All fields will be set to their default value. The hasXYZ() methods
     * will return false for all fields.
     */
    inline void clear();

    // ---- Field accessors -------------------------------------------

    // API of field "status"

    static const int kStatus = 0;

    /**
     * Clears the field "status".
     *
     * The field will be set to its default value. The hasStatus()
     * method will return false.
     */
    inline void clearStatus();

    /**
     * Checks whether the field "status" was set before.
     *
     * @return Returns true if the field was set before (a field gets set by calling
     * the setter method setStatus()). Otherwise it will return false.
     */
    inline bool hasStatus () const;

    /**
     * Returns the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @return The value of the field "status"
     */
    inline uint8 getStatus () const;

    /**
     * Sets the value of the member "status".
     *
     * If the meaning of "status" isn't clear, then there should be a description here.
     *
     * @param status The value which will be set
     */
    inline void setStatus (uint8 status_);

    static const BtApplDunFlowCtrlCfmSignal &getDefaultInstance();

private:

    inline void set_has_status ();

    inline void clear_has_status ();

    uint32 _has_bits_[ (1 + 31) / 32];

    uint8 _status;

};

inline  BtApplDunSendDataReqRequest::BtApplDunSendDataReqRequest ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunSendDataReqRequest::BtApplDunSendDataReqRequest (const BtApplDunSendDataReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunSendDataReqRequest::BtApplDunSendDataReqRequest (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunSendDataReqRequest::~BtApplDunSendDataReqRequest() {
}

inline BtApplDunSendDataReqRequest& BtApplDunSendDataReqRequest::operator = (const BtApplDunSendDataReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplDunSendDataReqRequest::operator == (const BtApplDunSendDataReqRequest& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplDunSendDataReqRequest::operator != (const BtApplDunSendDataReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunSendDataReqRequest::operator < (const BtApplDunSendDataReqRequest& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunSendDataReqRequest::clone() {
    return new BtApplDunSendDataReqRequest(*this);
}

inline bool BtApplDunSendDataReqRequest::operator > (const BtApplDunSendDataReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunSendDataReqRequest::clear() {
    clearData();
}

inline void BtApplDunSendDataReqRequest::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplDunSendDataReqRequest::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplDunSendDataReqRequest::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplDunSendDataReqRequest::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplDunSendDataReqRequest::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplDunSendDataReqRequest::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunSendDataReqRequest::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDunFlowCtrlReqRequest::BtApplDunFlowCtrlReqRequest ()  :
    _action (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunFlowCtrlReqRequest::BtApplDunFlowCtrlReqRequest (const BtApplDunFlowCtrlReqRequest &rhs)  :
    ::asf::core::Payload(rhs),
    _action (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunFlowCtrlReqRequest::BtApplDunFlowCtrlReqRequest (uint8 action_)  :
    _action (action_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunFlowCtrlReqRequest::~BtApplDunFlowCtrlReqRequest() {
}

inline BtApplDunFlowCtrlReqRequest& BtApplDunFlowCtrlReqRequest::operator = (const BtApplDunFlowCtrlReqRequest& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasAction()) {
            setAction(rhs.getAction());
        } else {
            clearAction();
        }
    }
    return *this;
}

inline bool BtApplDunFlowCtrlReqRequest::operator == (const BtApplDunFlowCtrlReqRequest& rhs) const {
    return (((!hasAction() && !rhs.hasAction()) || getAction() == rhs.getAction()));
}

inline bool BtApplDunFlowCtrlReqRequest::operator != (const BtApplDunFlowCtrlReqRequest& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunFlowCtrlReqRequest::operator < (const BtApplDunFlowCtrlReqRequest& rhs) const {
    if (hasAction() || rhs.hasAction()) {
        if (getAction() < rhs.getAction()) return true;
        if (getAction() > rhs.getAction()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunFlowCtrlReqRequest::clone() {
    return new BtApplDunFlowCtrlReqRequest(*this);
}

inline bool BtApplDunFlowCtrlReqRequest::operator > (const BtApplDunFlowCtrlReqRequest& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunFlowCtrlReqRequest::clear() {
    clearAction();
}

inline void BtApplDunFlowCtrlReqRequest::clearAction() {
    if (hasAction()) {
         clear_has_action();
        _action = 0u;
     }
}

inline bool BtApplDunFlowCtrlReqRequest::hasAction () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDunFlowCtrlReqRequest::getAction () const {
    return _action;
}

inline void BtApplDunFlowCtrlReqRequest::setAction (uint8 action_) {
    set_has_action();
    this->_action = action_;
}

inline void BtApplDunFlowCtrlReqRequest::set_has_action () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunFlowCtrlReqRequest::clear_has_action () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceFilePathUpdate::DeviceFilePathUpdate ()  :
    _DeviceFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceFilePathUpdate::DeviceFilePathUpdate (const DeviceFilePathUpdate &rhs)  :
    ::asf::core::Payload(rhs),
    _DeviceFilePath ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceFilePathUpdate::DeviceFilePathUpdate (const ::std::vector< uint8 >& DeviceFilePath_)  :
    _DeviceFilePath (DeviceFilePath_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  DeviceFilePathUpdate::~DeviceFilePathUpdate() {
}

inline DeviceFilePathUpdate& DeviceFilePathUpdate::operator = (const DeviceFilePathUpdate& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasDeviceFilePath()) {
            setDeviceFilePath(rhs.getDeviceFilePath());
        } else {
            clearDeviceFilePath();
        }
    }
    return *this;
}

inline bool DeviceFilePathUpdate::operator == (const DeviceFilePathUpdate& rhs) const {
    return (((!hasDeviceFilePath() && !rhs.hasDeviceFilePath()) || getDeviceFilePath() == rhs.getDeviceFilePath()));
}

inline bool DeviceFilePathUpdate::operator != (const DeviceFilePathUpdate& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceFilePathUpdate::operator < (const DeviceFilePathUpdate& rhs) const {
    if (hasDeviceFilePath() || rhs.hasDeviceFilePath()) {
        if (getDeviceFilePath() < rhs.getDeviceFilePath()) return true;
        if (getDeviceFilePath() > rhs.getDeviceFilePath()) return false;
    }
    return false;
}

inline ::asf::core::Payload* DeviceFilePathUpdate::clone() {
    return new DeviceFilePathUpdate(*this);
}

inline bool DeviceFilePathUpdate::operator > (const DeviceFilePathUpdate& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceFilePathUpdate::clear() {
    clearDeviceFilePath();
}

inline void DeviceFilePathUpdate::clearDeviceFilePath() {
    if (hasDeviceFilePath()) {
         clear_has_DeviceFilePath();
        _DeviceFilePath.clear();
     }
}

inline bool DeviceFilePathUpdate::hasDeviceFilePath () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& DeviceFilePathUpdate::getDeviceFilePath () const {
    return _DeviceFilePath;
}

inline ::std::vector< uint8 >& DeviceFilePathUpdate::getDeviceFilePathMutable () {
    set_has_DeviceFilePath();
    return _DeviceFilePath;
}

inline void DeviceFilePathUpdate::setDeviceFilePath (const ::std::vector< uint8 >& DeviceFilePath_) {
    set_has_DeviceFilePath();
    this->_DeviceFilePath = DeviceFilePath_;
}

inline void DeviceFilePathUpdate::set_has_DeviceFilePath () {
    _has_bits_[0] |= 1u << 0;
}

inline void DeviceFilePathUpdate::clear_has_DeviceFilePath () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  DeviceFilePathRegister::DeviceFilePathRegister () {
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  DeviceFilePathRegister::DeviceFilePathRegister (const DeviceFilePathRegister &rhs)  :
    ::asf::core::Payload(rhs)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  DeviceFilePathRegister::~DeviceFilePathRegister() {
}

inline DeviceFilePathRegister& DeviceFilePathRegister::operator = (const DeviceFilePathRegister& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        _has_bits_[0] = rhs._has_bits_[0]; // to prevent lint 1539  _has_bits not assigned by assignment operator
    }
    return *this;
}

inline bool DeviceFilePathRegister::operator == (const DeviceFilePathRegister& ) const {
    return true;
}

inline bool DeviceFilePathRegister::operator != (const DeviceFilePathRegister& rhs) const {
    return ! (*this == rhs);
}

inline bool DeviceFilePathRegister::operator < (const DeviceFilePathRegister& ) const {
    return false;
}

inline ::asf::core::Payload* DeviceFilePathRegister::clone() {
    return new DeviceFilePathRegister(*this);
}

inline bool DeviceFilePathRegister::operator > (const DeviceFilePathRegister& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void DeviceFilePathRegister::clear() {
}

inline  BtApplDunSendDataCfmSignal::BtApplDunSendDataCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunSendDataCfmSignal::BtApplDunSendDataCfmSignal (const BtApplDunSendDataCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunSendDataCfmSignal::BtApplDunSendDataCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunSendDataCfmSignal::~BtApplDunSendDataCfmSignal() {
}

inline BtApplDunSendDataCfmSignal& BtApplDunSendDataCfmSignal::operator = (const BtApplDunSendDataCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDunSendDataCfmSignal::operator == (const BtApplDunSendDataCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDunSendDataCfmSignal::operator != (const BtApplDunSendDataCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunSendDataCfmSignal::operator < (const BtApplDunSendDataCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunSendDataCfmSignal::clone() {
    return new BtApplDunSendDataCfmSignal(*this);
}

inline bool BtApplDunSendDataCfmSignal::operator > (const BtApplDunSendDataCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunSendDataCfmSignal::clear() {
    clearStatus();
}

inline void BtApplDunSendDataCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDunSendDataCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDunSendDataCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplDunSendDataCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDunSendDataCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunSendDataCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDunSendIndSignal::BtApplDunSendIndSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunSendIndSignal::BtApplDunSendIndSignal (const BtApplDunSendIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunSendIndSignal::BtApplDunSendIndSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunSendIndSignal::~BtApplDunSendIndSignal() {
}

inline BtApplDunSendIndSignal& BtApplDunSendIndSignal::operator = (const BtApplDunSendIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDunSendIndSignal::operator == (const BtApplDunSendIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDunSendIndSignal::operator != (const BtApplDunSendIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunSendIndSignal::operator < (const BtApplDunSendIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunSendIndSignal::clone() {
    return new BtApplDunSendIndSignal(*this);
}

inline bool BtApplDunSendIndSignal::operator > (const BtApplDunSendIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunSendIndSignal::clear() {
    clearStatus();
}

inline void BtApplDunSendIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDunSendIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDunSendIndSignal::getStatus () const {
    return _status;
}

inline void BtApplDunSendIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDunSendIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunSendIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDunDataIndSignal::BtApplDunDataIndSignal ()  :
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunDataIndSignal::BtApplDunDataIndSignal (const BtApplDunDataIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _data ()
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunDataIndSignal::BtApplDunDataIndSignal (const ::std::vector< uint8 >& data_)  :
    _data (data_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunDataIndSignal::~BtApplDunDataIndSignal() {
}

inline BtApplDunDataIndSignal& BtApplDunDataIndSignal::operator = (const BtApplDunDataIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasData()) {
            setData(rhs.getData());
        } else {
            clearData();
        }
    }
    return *this;
}

inline bool BtApplDunDataIndSignal::operator == (const BtApplDunDataIndSignal& rhs) const {
    return (((!hasData() && !rhs.hasData()) || getData() == rhs.getData()));
}

inline bool BtApplDunDataIndSignal::operator != (const BtApplDunDataIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunDataIndSignal::operator < (const BtApplDunDataIndSignal& rhs) const {
    if (hasData() || rhs.hasData()) {
        if (getData() < rhs.getData()) return true;
        if (getData() > rhs.getData()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunDataIndSignal::clone() {
    return new BtApplDunDataIndSignal(*this);
}

inline bool BtApplDunDataIndSignal::operator > (const BtApplDunDataIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunDataIndSignal::clear() {
    clearData();
}

inline void BtApplDunDataIndSignal::clearData() {
    if (hasData()) {
         clear_has_data();
        _data.clear();
     }
}

inline bool BtApplDunDataIndSignal::hasData () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline const ::std::vector< uint8 >& BtApplDunDataIndSignal::getData () const {
    return _data;
}

inline ::std::vector< uint8 >& BtApplDunDataIndSignal::getDataMutable () {
    set_has_data();
    return _data;
}

inline void BtApplDunDataIndSignal::setData (const ::std::vector< uint8 >& data_) {
    set_has_data();
    this->_data = data_;
}

inline void BtApplDunDataIndSignal::set_has_data () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunDataIndSignal::clear_has_data () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDunDataSendFcIndSignal::BtApplDunDataSendFcIndSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunDataSendFcIndSignal::BtApplDunDataSendFcIndSignal (const BtApplDunDataSendFcIndSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunDataSendFcIndSignal::BtApplDunDataSendFcIndSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunDataSendFcIndSignal::~BtApplDunDataSendFcIndSignal() {
}

inline BtApplDunDataSendFcIndSignal& BtApplDunDataSendFcIndSignal::operator = (const BtApplDunDataSendFcIndSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDunDataSendFcIndSignal::operator == (const BtApplDunDataSendFcIndSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDunDataSendFcIndSignal::operator != (const BtApplDunDataSendFcIndSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunDataSendFcIndSignal::operator < (const BtApplDunDataSendFcIndSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunDataSendFcIndSignal::clone() {
    return new BtApplDunDataSendFcIndSignal(*this);
}

inline bool BtApplDunDataSendFcIndSignal::operator > (const BtApplDunDataSendFcIndSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunDataSendFcIndSignal::clear() {
    clearStatus();
}

inline void BtApplDunDataSendFcIndSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDunDataSendFcIndSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDunDataSendFcIndSignal::getStatus () const {
    return _status;
}

inline void BtApplDunDataSendFcIndSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDunDataSendFcIndSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunDataSendFcIndSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

inline  BtApplDunFlowCtrlCfmSignal::BtApplDunFlowCtrlCfmSignal ()  :
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
}

inline  BtApplDunFlowCtrlCfmSignal::BtApplDunFlowCtrlCfmSignal (const BtApplDunFlowCtrlCfmSignal &rhs)  :
    ::asf::core::Payload(rhs),
    _status (0u)
{
    ::memset(_has_bits_, 0, sizeof(_has_bits_));
    *this = rhs;
}

inline  BtApplDunFlowCtrlCfmSignal::BtApplDunFlowCtrlCfmSignal (uint8 status_)  :
    _status (status_)
{
    ::memset(_has_bits_, 0xFFu, sizeof(_has_bits_));
}

inline  BtApplDunFlowCtrlCfmSignal::~BtApplDunFlowCtrlCfmSignal() {
}

inline BtApplDunFlowCtrlCfmSignal& BtApplDunFlowCtrlCfmSignal::operator = (const BtApplDunFlowCtrlCfmSignal& rhs) {
    if( this != &rhs ) {
        Payload::operator = (rhs);
        if (rhs.hasStatus()) {
            setStatus(rhs.getStatus());
        } else {
            clearStatus();
        }
    }
    return *this;
}

inline bool BtApplDunFlowCtrlCfmSignal::operator == (const BtApplDunFlowCtrlCfmSignal& rhs) const {
    return (((!hasStatus() && !rhs.hasStatus()) || getStatus() == rhs.getStatus()));
}

inline bool BtApplDunFlowCtrlCfmSignal::operator != (const BtApplDunFlowCtrlCfmSignal& rhs) const {
    return ! (*this == rhs);
}

inline bool BtApplDunFlowCtrlCfmSignal::operator < (const BtApplDunFlowCtrlCfmSignal& rhs) const {
    if (hasStatus() || rhs.hasStatus()) {
        if (getStatus() < rhs.getStatus()) return true;
        if (getStatus() > rhs.getStatus()) return false;
    }
    return false;
}

inline ::asf::core::Payload* BtApplDunFlowCtrlCfmSignal::clone() {
    return new BtApplDunFlowCtrlCfmSignal(*this);
}

inline bool BtApplDunFlowCtrlCfmSignal::operator > (const BtApplDunFlowCtrlCfmSignal& rhs) const {
    return (rhs < *this && *this != rhs);
}

inline void BtApplDunFlowCtrlCfmSignal::clear() {
    clearStatus();
}

inline void BtApplDunFlowCtrlCfmSignal::clearStatus() {
    if (hasStatus()) {
         clear_has_status();
        _status = 0u;
     }
}

inline bool BtApplDunFlowCtrlCfmSignal::hasStatus () const {
    return (_has_bits_[0] & (1u << 0)) > 0;
}

inline uint8 BtApplDunFlowCtrlCfmSignal::getStatus () const {
    return _status;
}

inline void BtApplDunFlowCtrlCfmSignal::setStatus (uint8 status_) {
    set_has_status();
    this->_status = status_;
}

inline void BtApplDunFlowCtrlCfmSignal::set_has_status () {
    _has_bits_[0] |= 1u << 0;
}

inline void BtApplDunFlowCtrlCfmSignal::clear_has_status () {
    _has_bits_[0] &= ~ (1u << 0);
}

} // namespace DUN
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DUN_H
#if defined(__GNUC__)
    #pragma GCC diagnostic pop
#endif
