/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DM.h"
#include "org/alps/evo/DMDBus.h"
#include "org/alps/evo/DMJson.h"
#include "org/alps/evo/DMStub.h"
#include <vector>

#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DM {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DM", DMStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 17, "BtApplTestModeReq", 7 },
    { 21, "BtApplGetHwVersionReq", 3 },
    { 21, "BtApplSspDebugModeReq", 6 },
    { 22, "BtApplCancelConnectReq", 2 },
    { 22, "BtApplDeviceConnectReq", 0 },
    { 25, "BtApplDeviceDisconnectReq", 1 },
    { 25, "BtApplSetConfigurationReq", 4 },
    { 26, "BtApplReadConfigurationReq", 5 },
    { 28, "BtApplTestModeLinkQualityReq", 8 },
};


class DMStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    DMStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    DMStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    DMStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "org.alps.evo.DM"),
          _logger(logger) {}

    virtual ~DMStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void DMStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 9, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'BtApplDeviceConnectReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplDeviceConnectReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplDeviceConnectReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplDeviceConnectReqRequest > payload = ::boost::static_pointer_cast<BtApplDeviceConnectReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplDeviceConnectReqRequest(payload);
            return;
        }
        case 1: {

            // method 'BtApplDeviceDisconnectReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplDeviceDisconnectReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplDeviceDisconnectReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplDeviceDisconnectReqRequest > payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplDeviceDisconnectReqRequest(payload);
            return;
        }
        case 2: {

            // method 'BtApplCancelConnectReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplCancelConnectReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplCancelConnectReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplCancelConnectReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplCancelConnectReqRequest > payload = ::boost::static_pointer_cast<BtApplCancelConnectReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplCancelConnectReqRequest(payload);
            return;
        }
        case 3: {

            // method 'BtApplGetHwVersionReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplGetHwVersionReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplGetHwVersionReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplGetHwVersionReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplGetHwVersionReqRequest > payload = ::boost::static_pointer_cast<BtApplGetHwVersionReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplGetHwVersionReqRequest(payload);
            return;
        }
        case 4: {

            // method 'BtApplSetConfigurationReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplSetConfigurationReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSetConfigurationReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplSetConfigurationReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplSetConfigurationReqRequest > payload = ::boost::static_pointer_cast<BtApplSetConfigurationReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplSetConfigurationReqRequest(payload);
            return;
        }
        case 5: {

            // method 'BtApplReadConfigurationReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplReadConfigurationReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplReadConfigurationReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplReadConfigurationReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplReadConfigurationReqRequest > payload = ::boost::static_pointer_cast<BtApplReadConfigurationReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplReadConfigurationReqRequest(payload);
            return;
        }
        case 6: {

            // method 'BtApplSspDebugModeReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplSspDebugModeReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSspDebugModeReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplSspDebugModeReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplSspDebugModeReqRequest > payload = ::boost::static_pointer_cast<BtApplSspDebugModeReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplSspDebugModeReqRequest(payload);
            return;
        }
        case 7: {

            // method 'BtApplTestModeReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplTestModeReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplTestModeReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplTestModeReqRequest > payload = ::boost::static_pointer_cast<BtApplTestModeReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplTestModeReqRequest(payload);
            return;
        }
        case 8: {

            // method 'BtApplTestModeLinkQualityReq'

            LOG_DEBUG_STUB("process method '%s'", "BtApplTestModeLinkQualityReq");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeLinkQualityReqRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "BtApplTestModeLinkQualityReq", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< BtApplTestModeLinkQualityReqRequest > payload = ::boost::static_pointer_cast<BtApplTestModeLinkQualityReqRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<DMStub*>(getStub())->onBtApplTestModeLinkQualityReqRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* DMStubDelegate::introspect() const {
    return     "<interface name=\"org.alps.evo.DM\">\n"
            "      <method name=\"BtApplDeviceConnectReq\">\n"
            "        <arg direction=\"in\" name=\"address\" type=\"ay\"/>\n"
            "        <arg direction=\"in\" name=\"function\" type=\"t\"/>\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplDeviceDisconnectReq\">\n"
            "        <arg direction=\"in\" name=\"function\" type=\"t\"/>\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplCancelConnectReq\"/>\n"
            "      <method name=\"BtApplGetHwVersionReq\"/>\n"
            "      <method name=\"BtApplSetConfigurationReq\">\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"config_id\" type=\"q\"/>\n"
            "        <arg direction=\"in\" name=\"data\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplReadConfigurationReq\">\n"
            "        <arg direction=\"in\" name=\"instance\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"config_id\" type=\"q\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplSspDebugModeReq\">\n"
            "        <arg direction=\"in\" name=\"mode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplTestModeReq\">\n"
            "        <arg direction=\"in\" name=\"enable\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"mode\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"role\" type=\"y\"/>\n"
            "        <arg direction=\"in\" name=\"addr\" type=\"ay\"/>\n"
            "      </method>\n"
            "      <method name=\"BtApplTestModeLinkQualityReq\">\n"
            "        <arg direction=\"in\" name=\"mode\" type=\"y\"/>\n"
            "      </method>\n"
            "      <signal name=\"BtApplDeviceConnectCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDeviceConnectInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"address\" type=\"ay\"/>\n"
            "        <arg name=\"function\" type=\"t\"/>\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDeviceDisconnectCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDeviceDisconnectInd\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"address\" type=\"ay\"/>\n"
            "        <arg name=\"reason\" type=\"y\"/>\n"
            "        <arg name=\"function\" type=\"t\"/>\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplDeviceDisconnectCompInd\"/>\n"
            "      <signal name=\"BtApplDeviceConnectCompInd\"/>\n"
            "      <signal name=\"BtApplCancelConnectCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplStatusNotificationInd\">\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplGetHwVersionCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"bt_version\" type=\"y\"/>\n"
            "        <arg name=\"manufactory\" type=\"q\"/>\n"
            "        <arg name=\"hw_subversion\" type=\"q\"/>\n"
            "        <arg name=\"ext_info\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplSetConfigurationCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"config_id\" type=\"q\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplReadConfigurationCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"instance\" type=\"y\"/>\n"
            "        <arg name=\"config_id\" type=\"q\"/>\n"
            "        <arg name=\"data\" type=\"ay\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplTestModeCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplTestModeCompInd\">\n"
            "        <arg name=\"notiType\" type=\"y\"/>\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "      </signal>\n"
            "      <signal name=\"BtApplTestModeLinkQualityCfm\">\n"
            "        <arg name=\"status\" type=\"y\"/>\n"
            "        <arg name=\"rssi\" type=\"y\"/>\n"
            "        <arg name=\"linkquality\" type=\"y\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void DMStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<DMStub*>(getStub()))->onGetAll (properties);
}

void DMStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void DMStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

DMStub::DMStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DMStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DMStub::DMStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new DMStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

DMStub::~DMStub() {
    delete _stubDelegate;
}

void DMStub::sendBtApplDeviceConnectCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceConnectCfmSignal* payload = new BtApplDeviceConnectCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceConnectCfm", BtApplDeviceConnectCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceConnectCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceConnectCfm");
    }
}

void DMStub::sendBtApplDeviceConnectIndSignal(uint8 status, const ::std::vector< uint8 >& address, uint64 function, uint8 instance) {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceConnectIndSignal* payload = new BtApplDeviceConnectIndSignal(status, address, function, instance);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceConnectInd", BtApplDeviceConnectIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceConnectInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceConnectInd");
    }
}

void DMStub::sendBtApplDeviceDisconnectCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceDisconnectCfmSignal* payload = new BtApplDeviceDisconnectCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceDisconnectCfm", BtApplDeviceDisconnectCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceDisconnectCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceDisconnectCfm");
    }
}

void DMStub::sendBtApplDeviceDisconnectIndSignal(uint8 status, const ::std::vector< uint8 >& address, uint8 reason, uint64 function, uint8 instance) {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceDisconnectIndSignal* payload = new BtApplDeviceDisconnectIndSignal(status, address, reason, function, instance);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceDisconnectInd", BtApplDeviceDisconnectIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceDisconnectInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceDisconnectInd");
    }
}

void DMStub::sendBtApplDeviceDisconnectCompIndSignal() {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceDisconnectCompIndSignal* payload = new BtApplDeviceDisconnectCompIndSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceDisconnectCompInd", BtApplDeviceDisconnectCompIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceDisconnectCompInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceDisconnectCompInd");
    }
}

void DMStub::sendBtApplDeviceConnectCompIndSignal() {
    if (_stubDelegate->isConnected()) {
        BtApplDeviceConnectCompIndSignal* payload = new BtApplDeviceConnectCompIndSignal;
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplDeviceConnectCompInd", BtApplDeviceConnectCompIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplDeviceConnectCompInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplDeviceConnectCompInd");
    }
}

void DMStub::sendBtApplCancelConnectCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplCancelConnectCfmSignal* payload = new BtApplCancelConnectCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplCancelConnectCfm", BtApplCancelConnectCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplCancelConnectCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplCancelConnectCfm");
    }
}

void DMStub::sendBtApplStatusNotificationIndSignal(const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        BtApplStatusNotificationIndSignal* payload = new BtApplStatusNotificationIndSignal(data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplStatusNotificationInd", BtApplStatusNotificationIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplStatusNotificationInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplStatusNotificationInd");
    }
}

void DMStub::sendBtApplGetHwVersionCfmSignal(uint8 status, uint8 bt_version, uint16 manufactory, uint16 hw_subversion, const ::std::vector< uint8 >& ext_info) {
    if (_stubDelegate->isConnected()) {
        BtApplGetHwVersionCfmSignal* payload = new BtApplGetHwVersionCfmSignal(status, bt_version, manufactory, hw_subversion, ext_info);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplGetHwVersionCfm", BtApplGetHwVersionCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplGetHwVersionCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplGetHwVersionCfm");
    }
}

void DMStub::sendBtApplSetConfigurationCfmSignal(uint8 status, uint8 instance, uint16 config_id) {
    if (_stubDelegate->isConnected()) {
        BtApplSetConfigurationCfmSignal* payload = new BtApplSetConfigurationCfmSignal(status, instance, config_id);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplSetConfigurationCfm", BtApplSetConfigurationCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplSetConfigurationCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplSetConfigurationCfm");
    }
}

void DMStub::sendBtApplReadConfigurationCfmSignal(uint8 status, uint8 instance, uint16 config_id, const ::std::vector< uint8 >& data) {
    if (_stubDelegate->isConnected()) {
        BtApplReadConfigurationCfmSignal* payload = new BtApplReadConfigurationCfmSignal(status, instance, config_id, data);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplReadConfigurationCfm", BtApplReadConfigurationCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplReadConfigurationCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplReadConfigurationCfm");
    }
}

void DMStub::sendBtApplTestModeCfmSignal(uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplTestModeCfmSignal* payload = new BtApplTestModeCfmSignal(status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplTestModeCfm", BtApplTestModeCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplTestModeCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplTestModeCfm");
    }
}

void DMStub::sendBtApplTestModeCompIndSignal(uint8 notiType, uint8 status) {
    if (_stubDelegate->isConnected()) {
        BtApplTestModeCompIndSignal* payload = new BtApplTestModeCompIndSignal(notiType, status);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplTestModeCompInd", BtApplTestModeCompIndSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplTestModeCompInd");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplTestModeCompInd");
    }
}

void DMStub::sendBtApplTestModeLinkQualityCfmSignal(uint8 status, uint8 rssi, uint8 linkquality) {
    if (_stubDelegate->isConnected()) {
        BtApplTestModeLinkQualityCfmSignal* payload = new BtApplTestModeLinkQualityCfmSignal(status, rssi, linkquality);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "BtApplTestModeLinkQualityCfm", BtApplTestModeLinkQualityCfmSignal, payload)
        LOG_INFO ("-> send%sSignal", "BtApplTestModeLinkQualityCfm");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "BtApplTestModeLinkQualityCfm");
    }
}

void  DMStub::sendBtApplDeviceConnectReqResponse (act_t act) {
    BtApplDeviceConnectReqResponse* payload = new BtApplDeviceConnectReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplDeviceConnectReq", BtApplDeviceConnectReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplDeviceConnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplDeviceConnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplDeviceConnectReqError* payload = new BtApplDeviceConnectReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplDeviceConnectReq", BtApplDeviceConnectReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplDeviceConnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplDeviceDisconnectReqResponse (act_t act) {
    BtApplDeviceDisconnectReqResponse* payload = new BtApplDeviceDisconnectReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplDeviceDisconnectReq", BtApplDeviceDisconnectReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplDeviceDisconnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplDeviceDisconnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplDeviceDisconnectReqError* payload = new BtApplDeviceDisconnectReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplDeviceDisconnectReq", BtApplDeviceDisconnectReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplDeviceDisconnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplCancelConnectReqResponse (act_t act) {
    BtApplCancelConnectReqResponse* payload = new BtApplCancelConnectReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplCancelConnectReq", BtApplCancelConnectReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplCancelConnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplCancelConnectReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplCancelConnectReqError* payload = new BtApplCancelConnectReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplCancelConnectReq", BtApplCancelConnectReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplCancelConnectReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplGetHwVersionReqResponse (act_t act) {
    BtApplGetHwVersionReqResponse* payload = new BtApplGetHwVersionReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplGetHwVersionReq", BtApplGetHwVersionReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplGetHwVersionReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplGetHwVersionReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplGetHwVersionReqError* payload = new BtApplGetHwVersionReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplGetHwVersionReq", BtApplGetHwVersionReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplGetHwVersionReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplSetConfigurationReqResponse (act_t act) {
    BtApplSetConfigurationReqResponse* payload = new BtApplSetConfigurationReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplSetConfigurationReq", BtApplSetConfigurationReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplSetConfigurationReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplSetConfigurationReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplSetConfigurationReqError* payload = new BtApplSetConfigurationReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplSetConfigurationReq", BtApplSetConfigurationReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplSetConfigurationReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplReadConfigurationReqResponse (act_t act) {
    BtApplReadConfigurationReqResponse* payload = new BtApplReadConfigurationReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplReadConfigurationReq", BtApplReadConfigurationReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplReadConfigurationReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplReadConfigurationReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplReadConfigurationReqError* payload = new BtApplReadConfigurationReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplReadConfigurationReq", BtApplReadConfigurationReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplReadConfigurationReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplSspDebugModeReqResponse (act_t act) {
    BtApplSspDebugModeReqResponse* payload = new BtApplSspDebugModeReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplSspDebugModeReq", BtApplSspDebugModeReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplSspDebugModeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplSspDebugModeReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplSspDebugModeReqError* payload = new BtApplSspDebugModeReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplSspDebugModeReq", BtApplSspDebugModeReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplSspDebugModeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplTestModeReqResponse (act_t act) {
    BtApplTestModeReqResponse* payload = new BtApplTestModeReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplTestModeReq", BtApplTestModeReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplTestModeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplTestModeReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplTestModeReqError* payload = new BtApplTestModeReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplTestModeReq", BtApplTestModeReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplTestModeReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplTestModeLinkQualityReqResponse (act_t act) {
    BtApplTestModeLinkQualityReqResponse* payload = new BtApplTestModeLinkQualityReqResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "BtApplTestModeLinkQualityReq", BtApplTestModeLinkQualityReqResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "BtApplTestModeLinkQualityReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  DMStub::sendBtApplTestModeLinkQualityReqError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    BtApplTestModeLinkQualityReqError* payload = new BtApplTestModeLinkQualityReqError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "BtApplTestModeLinkQualityReq", BtApplTestModeLinkQualityReqError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "BtApplTestModeLinkQualityReq", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void DMStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace DM
} // namespace evo
} // namespace alps
} // namespace org
