/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DM.h"
#include "org/alps/evo/DMDBus.h"
#include "org/alps/evo/DMJson.h"
#include "org/alps/evo/DMProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DM {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DM", DMProxy);

class DMProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DMProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DMProxy >& proxyShared = ::boost::static_pointer_cast< DMProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BtApplDeviceConnectCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceConnectCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceConnectCfmSignal> payload = ::boost::static_pointer_cast<BtApplDeviceConnectCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceConnectCfmCallbackIF*) _callback)->onBtApplDeviceConnectCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceConnectInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceConnectInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceConnectIndSignal> payload = ::boost::static_pointer_cast<BtApplDeviceConnectIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceConnectIndCallbackIF*) _callback)->onBtApplDeviceConnectIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceDisconnectCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceDisconnectCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceDisconnectCfmSignal> payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceDisconnectCfmCallbackIF*) _callback)->onBtApplDeviceDisconnectCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceDisconnectInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceDisconnectInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceDisconnectIndSignal> payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceDisconnectIndCallbackIF*) _callback)->onBtApplDeviceDisconnectIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceDisconnectCompInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectCompIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceDisconnectCompInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceDisconnectCompIndSignal> payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectCompIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceDisconnectCompIndCallbackIF*) _callback)->onBtApplDeviceDisconnectCompIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceConnectCompInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectCompIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDeviceConnectCompInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDeviceConnectCompIndSignal> payload = ::boost::static_pointer_cast<BtApplDeviceConnectCompIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDeviceConnectCompIndCallbackIF*) _callback)->onBtApplDeviceConnectCompIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplCancelConnectCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplCancelConnectCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplCancelConnectCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplCancelConnectCfmSignal> payload = ::boost::static_pointer_cast<BtApplCancelConnectCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplCancelConnectCfmCallbackIF*) _callback)->onBtApplCancelConnectCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplStatusNotificationInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplStatusNotificationIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplStatusNotificationInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplStatusNotificationIndSignal> payload = ::boost::static_pointer_cast<BtApplStatusNotificationIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplStatusNotificationIndCallbackIF*) _callback)->onBtApplStatusNotificationIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplGetHwVersionCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplGetHwVersionCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplGetHwVersionCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplGetHwVersionCfmSignal> payload = ::boost::static_pointer_cast<BtApplGetHwVersionCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplGetHwVersionCfmCallbackIF*) _callback)->onBtApplGetHwVersionCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplSetConfigurationCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSetConfigurationCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplSetConfigurationCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplSetConfigurationCfmSignal> payload = ::boost::static_pointer_cast<BtApplSetConfigurationCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplSetConfigurationCfmCallbackIF*) _callback)->onBtApplSetConfigurationCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplReadConfigurationCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplReadConfigurationCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplReadConfigurationCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplReadConfigurationCfmSignal> payload = ::boost::static_pointer_cast<BtApplReadConfigurationCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplReadConfigurationCfmCallbackIF*) _callback)->onBtApplReadConfigurationCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplTestModeCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplTestModeCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplTestModeCfmSignal> payload = ::boost::static_pointer_cast<BtApplTestModeCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplTestModeCfmCallbackIF*) _callback)->onBtApplTestModeCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplTestModeCompInd:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeCompIndSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplTestModeCompInd", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplTestModeCompIndSignal> payload = ::boost::static_pointer_cast<BtApplTestModeCompIndSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplTestModeCompIndCallbackIF*) _callback)->onBtApplTestModeCompIndSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplTestModeLinkQualityCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeLinkQualityCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplTestModeLinkQualityCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplTestModeLinkQualityCfmSignal> payload = ::boost::static_pointer_cast<BtApplTestModeLinkQualityCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplTestModeLinkQualityCfmCallbackIF*) _callback)->onBtApplTestModeLinkQualityCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDeviceConnectReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDeviceConnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDeviceConnectReqError> payload = ::boost::static_pointer_cast<BtApplDeviceConnectReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDeviceConnectReqCallbackIF*) _callback)->onBtApplDeviceConnectReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceConnectReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDeviceConnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDeviceConnectReqResponse> payload = ::boost::static_pointer_cast<BtApplDeviceConnectReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDeviceConnectReqCallbackIF*) _callback)->onBtApplDeviceConnectReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplDeviceDisconnectReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDeviceDisconnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDeviceDisconnectReqError> payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDeviceDisconnectReqCallbackIF*) _callback)->onBtApplDeviceDisconnectReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDeviceDisconnectReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDeviceDisconnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDeviceDisconnectReqResponse> payload = ::boost::static_pointer_cast<BtApplDeviceDisconnectReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDeviceDisconnectReqCallbackIF*) _callback)->onBtApplDeviceDisconnectReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplCancelConnectReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplCancelConnectReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplCancelConnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplCancelConnectReqError> payload = ::boost::static_pointer_cast<BtApplCancelConnectReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplCancelConnectReqCallbackIF*) _callback)->onBtApplCancelConnectReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplCancelConnectReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplCancelConnectReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplCancelConnectReqResponse> payload = ::boost::static_pointer_cast<BtApplCancelConnectReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplCancelConnectReqCallbackIF*) _callback)->onBtApplCancelConnectReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplGetHwVersionReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplGetHwVersionReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplGetHwVersionReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplGetHwVersionReqError> payload = ::boost::static_pointer_cast<BtApplGetHwVersionReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplGetHwVersionReqCallbackIF*) _callback)->onBtApplGetHwVersionReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplGetHwVersionReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplGetHwVersionReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplGetHwVersionReqResponse> payload = ::boost::static_pointer_cast<BtApplGetHwVersionReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplGetHwVersionReqCallbackIF*) _callback)->onBtApplGetHwVersionReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplSetConfigurationReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSetConfigurationReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSetConfigurationReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSetConfigurationReqError> payload = ::boost::static_pointer_cast<BtApplSetConfigurationReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSetConfigurationReqCallbackIF*) _callback)->onBtApplSetConfigurationReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSetConfigurationReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSetConfigurationReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSetConfigurationReqResponse> payload = ::boost::static_pointer_cast<BtApplSetConfigurationReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSetConfigurationReqCallbackIF*) _callback)->onBtApplSetConfigurationReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplReadConfigurationReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplReadConfigurationReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplReadConfigurationReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplReadConfigurationReqError> payload = ::boost::static_pointer_cast<BtApplReadConfigurationReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplReadConfigurationReqCallbackIF*) _callback)->onBtApplReadConfigurationReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplReadConfigurationReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplReadConfigurationReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplReadConfigurationReqResponse> payload = ::boost::static_pointer_cast<BtApplReadConfigurationReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplReadConfigurationReqCallbackIF*) _callback)->onBtApplReadConfigurationReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplSspDebugModeReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSspDebugModeReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSspDebugModeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSspDebugModeReqError> payload = ::boost::static_pointer_cast<BtApplSspDebugModeReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSspDebugModeReqCallbackIF*) _callback)->onBtApplSspDebugModeReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplSspDebugModeReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplSspDebugModeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplSspDebugModeReqResponse> payload = ::boost::static_pointer_cast<BtApplSspDebugModeReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplSspDebugModeReqCallbackIF*) _callback)->onBtApplSspDebugModeReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplTestModeReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplTestModeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplTestModeReqError> payload = ::boost::static_pointer_cast<BtApplTestModeReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplTestModeReqCallbackIF*) _callback)->onBtApplTestModeReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplTestModeReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplTestModeReqResponse> payload = ::boost::static_pointer_cast<BtApplTestModeReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplTestModeReqCallbackIF*) _callback)->onBtApplTestModeReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_BtApplTestModeLinkQualityReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeLinkQualityReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplTestModeLinkQualityReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplTestModeLinkQualityReqError> payload = ::boost::static_pointer_cast<BtApplTestModeLinkQualityReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplTestModeLinkQualityReqCallbackIF*) _callback)->onBtApplTestModeLinkQualityReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplTestModeLinkQualityReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplTestModeLinkQualityReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplTestModeLinkQualityReqResponse> payload = ::boost::static_pointer_cast<BtApplTestModeLinkQualityReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplTestModeLinkQualityReqCallbackIF*) _callback)->onBtApplTestModeLinkQualityReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BtApplDeviceConnectCfm: {
                ::boost::shared_ptr< BtApplDeviceConnectCfmError > payload = ::boost::shared_ptr< BtApplDeviceConnectCfmError >
                (new BtApplDeviceConnectCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceConnectCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceConnectCfmCallbackIF*) _callback)->onBtApplDeviceConnectCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceConnectInd: {
                ::boost::shared_ptr< BtApplDeviceConnectIndError > payload = ::boost::shared_ptr< BtApplDeviceConnectIndError >
                (new BtApplDeviceConnectIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceConnectInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceConnectIndCallbackIF*) _callback)->onBtApplDeviceConnectIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceDisconnectCfm: {
                ::boost::shared_ptr< BtApplDeviceDisconnectCfmError > payload = ::boost::shared_ptr< BtApplDeviceDisconnectCfmError >
                (new BtApplDeviceDisconnectCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceDisconnectCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceDisconnectCfmCallbackIF*) _callback)->onBtApplDeviceDisconnectCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceDisconnectInd: {
                ::boost::shared_ptr< BtApplDeviceDisconnectIndError > payload = ::boost::shared_ptr< BtApplDeviceDisconnectIndError >
                (new BtApplDeviceDisconnectIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceDisconnectInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceDisconnectIndCallbackIF*) _callback)->onBtApplDeviceDisconnectIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceDisconnectCompInd: {
                ::boost::shared_ptr< BtApplDeviceDisconnectCompIndError > payload = ::boost::shared_ptr< BtApplDeviceDisconnectCompIndError >
                (new BtApplDeviceDisconnectCompIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceDisconnectCompInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceDisconnectCompIndCallbackIF*) _callback)->onBtApplDeviceDisconnectCompIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceConnectCompInd: {
                ::boost::shared_ptr< BtApplDeviceConnectCompIndError > payload = ::boost::shared_ptr< BtApplDeviceConnectCompIndError >
                (new BtApplDeviceConnectCompIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceConnectCompInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceConnectCompIndCallbackIF*) _callback)->onBtApplDeviceConnectCompIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplCancelConnectCfm: {
                ::boost::shared_ptr< BtApplCancelConnectCfmError > payload = ::boost::shared_ptr< BtApplCancelConnectCfmError >
                (new BtApplCancelConnectCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplCancelConnectCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplCancelConnectCfmCallbackIF*) _callback)->onBtApplCancelConnectCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplStatusNotificationInd: {
                ::boost::shared_ptr< BtApplStatusNotificationIndError > payload = ::boost::shared_ptr< BtApplStatusNotificationIndError >
                (new BtApplStatusNotificationIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplStatusNotificationInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplStatusNotificationIndCallbackIF*) _callback)->onBtApplStatusNotificationIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplGetHwVersionCfm: {
                ::boost::shared_ptr< BtApplGetHwVersionCfmError > payload = ::boost::shared_ptr< BtApplGetHwVersionCfmError >
                (new BtApplGetHwVersionCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplGetHwVersionCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplGetHwVersionCfmCallbackIF*) _callback)->onBtApplGetHwVersionCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSetConfigurationCfm: {
                ::boost::shared_ptr< BtApplSetConfigurationCfmError > payload = ::boost::shared_ptr< BtApplSetConfigurationCfmError >
                (new BtApplSetConfigurationCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSetConfigurationCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSetConfigurationCfmCallbackIF*) _callback)->onBtApplSetConfigurationCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplReadConfigurationCfm: {
                ::boost::shared_ptr< BtApplReadConfigurationCfmError > payload = ::boost::shared_ptr< BtApplReadConfigurationCfmError >
                (new BtApplReadConfigurationCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplReadConfigurationCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplReadConfigurationCfmCallbackIF*) _callback)->onBtApplReadConfigurationCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplTestModeCfm: {
                ::boost::shared_ptr< BtApplTestModeCfmError > payload = ::boost::shared_ptr< BtApplTestModeCfmError >
                (new BtApplTestModeCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplTestModeCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplTestModeCfmCallbackIF*) _callback)->onBtApplTestModeCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplTestModeCompInd: {
                ::boost::shared_ptr< BtApplTestModeCompIndError > payload = ::boost::shared_ptr< BtApplTestModeCompIndError >
                (new BtApplTestModeCompIndError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplTestModeCompInd", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplTestModeCompIndCallbackIF*) _callback)->onBtApplTestModeCompIndError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplTestModeLinkQualityCfm: {
                ::boost::shared_ptr< BtApplTestModeLinkQualityCfmError > payload = ::boost::shared_ptr< BtApplTestModeLinkQualityCfmError >
                (new BtApplTestModeLinkQualityCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplTestModeLinkQualityCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplTestModeLinkQualityCfmCallbackIF*) _callback)->onBtApplTestModeLinkQualityCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceConnectReq: {
                ::boost::shared_ptr< BtApplDeviceConnectReqError > payload = ::boost::shared_ptr< BtApplDeviceConnectReqError >
                (new BtApplDeviceConnectReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceConnectReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceConnectReqCallbackIF*) _callback)->onBtApplDeviceConnectReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDeviceDisconnectReq: {
                ::boost::shared_ptr< BtApplDeviceDisconnectReqError > payload = ::boost::shared_ptr< BtApplDeviceDisconnectReqError >
                (new BtApplDeviceDisconnectReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDeviceDisconnectReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDeviceDisconnectReqCallbackIF*) _callback)->onBtApplDeviceDisconnectReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplCancelConnectReq: {
                ::boost::shared_ptr< BtApplCancelConnectReqError > payload = ::boost::shared_ptr< BtApplCancelConnectReqError >
                (new BtApplCancelConnectReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplCancelConnectReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplCancelConnectReqCallbackIF*) _callback)->onBtApplCancelConnectReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplGetHwVersionReq: {
                ::boost::shared_ptr< BtApplGetHwVersionReqError > payload = ::boost::shared_ptr< BtApplGetHwVersionReqError >
                (new BtApplGetHwVersionReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplGetHwVersionReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplGetHwVersionReqCallbackIF*) _callback)->onBtApplGetHwVersionReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSetConfigurationReq: {
                ::boost::shared_ptr< BtApplSetConfigurationReqError > payload = ::boost::shared_ptr< BtApplSetConfigurationReqError >
                (new BtApplSetConfigurationReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSetConfigurationReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSetConfigurationReqCallbackIF*) _callback)->onBtApplSetConfigurationReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplReadConfigurationReq: {
                ::boost::shared_ptr< BtApplReadConfigurationReqError > payload = ::boost::shared_ptr< BtApplReadConfigurationReqError >
                (new BtApplReadConfigurationReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplReadConfigurationReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplReadConfigurationReqCallbackIF*) _callback)->onBtApplReadConfigurationReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplSspDebugModeReq: {
                ::boost::shared_ptr< BtApplSspDebugModeReqError > payload = ::boost::shared_ptr< BtApplSspDebugModeReqError >
                (new BtApplSspDebugModeReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplSspDebugModeReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplSspDebugModeReqCallbackIF*) _callback)->onBtApplSspDebugModeReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplTestModeReq: {
                ::boost::shared_ptr< BtApplTestModeReqError > payload = ::boost::shared_ptr< BtApplTestModeReqError >
                (new BtApplTestModeReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplTestModeReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplTestModeReqCallbackIF*) _callback)->onBtApplTestModeReqError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplTestModeLinkQualityReq: {
                ::boost::shared_ptr< BtApplTestModeLinkQualityReqError > payload = ::boost::shared_ptr< BtApplTestModeLinkQualityReqError >
                (new BtApplTestModeLinkQualityReqError(DBUS_ERROR_NO_SERVER, "The DBus service DM is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplTestModeLinkQualityReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DMProxy> proxyShared = ::boost::static_pointer_cast<DMProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplTestModeLinkQualityReqCallbackIF*) _callback)->onBtApplTestModeLinkQualityReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DMProxyCallback::_logger (DMProxy::_logger);

DMProxy::DMProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.alps.evo.DM", serviceAvailable, _logger) {
}

DMProxy::~DMProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DMProxy > DMProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DMProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DMProxy > proxyNew(new DMProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DMProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DMProxyCallback* callback = new DMProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DMProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DMProxyCallback* callback = new DMProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DMProxy::sendDeregisterAll () const
{
    sendBtApplDeviceConnectCfmDeregisterAll();
    sendBtApplDeviceConnectIndDeregisterAll();
    sendBtApplDeviceDisconnectCfmDeregisterAll();
    sendBtApplDeviceDisconnectIndDeregisterAll();
    sendBtApplDeviceDisconnectCompIndDeregisterAll();
    sendBtApplDeviceConnectCompIndDeregisterAll();
    sendBtApplCancelConnectCfmDeregisterAll();
    sendBtApplStatusNotificationIndDeregisterAll();
    sendBtApplGetHwVersionCfmDeregisterAll();
    sendBtApplSetConfigurationCfmDeregisterAll();
    sendBtApplReadConfigurationCfmDeregisterAll();
    sendBtApplTestModeCfmDeregisterAll();
    sendBtApplTestModeCompIndDeregisterAll();
    sendBtApplTestModeLinkQualityCfmDeregisterAll();
}

act_t DMProxy::sendBtApplDeviceConnectCfmRegister(BtApplDeviceConnectCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceConnectCfm");
    act_t act = addSignalCallback(ID_BtApplDeviceConnectCfm, "BtApplDeviceConnectCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceConnectCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceConnectCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceConnectCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceConnectCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceConnectCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceConnectCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceConnectCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceConnectIndRegister(BtApplDeviceConnectIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceConnectInd");
    act_t act = addSignalCallback(ID_BtApplDeviceConnectInd, "BtApplDeviceConnectInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceConnectInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceConnectIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceConnectInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceConnectInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceConnectIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceConnectInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceConnectInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceDisconnectCfmRegister(BtApplDeviceDisconnectCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceDisconnectCfm");
    act_t act = addSignalCallback(ID_BtApplDeviceDisconnectCfm, "BtApplDeviceDisconnectCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceDisconnectCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceDisconnectCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceDisconnectCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceDisconnectCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceDisconnectCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceDisconnectCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceDisconnectCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceDisconnectIndRegister(BtApplDeviceDisconnectIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceDisconnectInd");
    act_t act = addSignalCallback(ID_BtApplDeviceDisconnectInd, "BtApplDeviceDisconnectInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceDisconnectInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceDisconnectIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceDisconnectInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceDisconnectInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceDisconnectIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceDisconnectInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceDisconnectInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceDisconnectCompIndRegister(BtApplDeviceDisconnectCompIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceDisconnectCompInd");
    act_t act = addSignalCallback(ID_BtApplDeviceDisconnectCompInd, "BtApplDeviceDisconnectCompInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceDisconnectCompInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceDisconnectCompIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceDisconnectCompInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceDisconnectCompInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceDisconnectCompIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceDisconnectCompInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceDisconnectCompInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceConnectCompIndRegister(BtApplDeviceConnectCompIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDeviceConnectCompInd");
    act_t act = addSignalCallback(ID_BtApplDeviceConnectCompInd, "BtApplDeviceConnectCompInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDeviceConnectCompInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplDeviceConnectCompIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDeviceConnectCompInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDeviceConnectCompInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplDeviceConnectCompIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDeviceConnectCompInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDeviceConnectCompInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplCancelConnectCfmRegister(BtApplCancelConnectCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplCancelConnectCfm");
    act_t act = addSignalCallback(ID_BtApplCancelConnectCfm, "BtApplCancelConnectCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplCancelConnectCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplCancelConnectCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplCancelConnectCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplCancelConnectCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplCancelConnectCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplCancelConnectCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplCancelConnectCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplStatusNotificationIndRegister(BtApplStatusNotificationIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplStatusNotificationInd");
    act_t act = addSignalCallback(ID_BtApplStatusNotificationInd, "BtApplStatusNotificationInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplStatusNotificationInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplStatusNotificationIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplStatusNotificationInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplStatusNotificationInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplStatusNotificationIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplStatusNotificationInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplStatusNotificationInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplGetHwVersionCfmRegister(BtApplGetHwVersionCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplGetHwVersionCfm");
    act_t act = addSignalCallback(ID_BtApplGetHwVersionCfm, "BtApplGetHwVersionCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplGetHwVersionCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplGetHwVersionCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplGetHwVersionCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplGetHwVersionCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplGetHwVersionCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplGetHwVersionCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplGetHwVersionCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplSetConfigurationCfmRegister(BtApplSetConfigurationCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplSetConfigurationCfm");
    act_t act = addSignalCallback(ID_BtApplSetConfigurationCfm, "BtApplSetConfigurationCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplSetConfigurationCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplSetConfigurationCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplSetConfigurationCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplSetConfigurationCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplSetConfigurationCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplSetConfigurationCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplSetConfigurationCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplReadConfigurationCfmRegister(BtApplReadConfigurationCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplReadConfigurationCfm");
    act_t act = addSignalCallback(ID_BtApplReadConfigurationCfm, "BtApplReadConfigurationCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplReadConfigurationCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplReadConfigurationCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplReadConfigurationCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplReadConfigurationCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplReadConfigurationCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplReadConfigurationCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplReadConfigurationCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplTestModeCfmRegister(BtApplTestModeCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplTestModeCfm");
    act_t act = addSignalCallback(ID_BtApplTestModeCfm, "BtApplTestModeCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplTestModeCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplTestModeCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplTestModeCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplTestModeCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplTestModeCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplTestModeCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplTestModeCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplTestModeCompIndRegister(BtApplTestModeCompIndCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplTestModeCompInd");
    act_t act = addSignalCallback(ID_BtApplTestModeCompInd, "BtApplTestModeCompInd", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplTestModeCompInd", &cb, act);
    return act;
}

bool DMProxy::sendBtApplTestModeCompIndDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplTestModeCompInd", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplTestModeCompInd", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplTestModeCompIndDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplTestModeCompInd");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplTestModeCompInd", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplTestModeLinkQualityCfmRegister(BtApplTestModeLinkQualityCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplTestModeLinkQualityCfm");
    act_t act = addSignalCallback(ID_BtApplTestModeLinkQualityCfm, "BtApplTestModeLinkQualityCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplTestModeLinkQualityCfm", &cb, act);
    return act;
}

bool DMProxy::sendBtApplTestModeLinkQualityCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplTestModeLinkQualityCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplTestModeLinkQualityCfm", act, static_cast<int>(rv));
    return rv;
}

void DMProxy::sendBtApplTestModeLinkQualityCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplTestModeLinkQualityCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplTestModeLinkQualityCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DMProxy::sendBtApplDeviceConnectReqRequest(BtApplDeviceConnectReqCallbackIF& cb, const ::std::vector< uint8 >& address, uint64 function, uint8 instance) const {
    BtApplDeviceConnectReqRequest* payload = new BtApplDeviceConnectReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setAddress(address);
    payload->setFunction(function);
    payload->setInstance(instance);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplDeviceConnectReq", BtApplDeviceConnectReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplDeviceConnectReq, dbusMessage.getUniqueSerial(), "BtApplDeviceConnectReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplDeviceConnectReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplDeviceDisconnectReqRequest(BtApplDeviceDisconnectReqCallbackIF& cb, uint64 function, uint8 instance) const {
    BtApplDeviceDisconnectReqRequest* payload = new BtApplDeviceDisconnectReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setFunction(function);
    payload->setInstance(instance);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplDeviceDisconnectReq", BtApplDeviceDisconnectReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplDeviceDisconnectReq, dbusMessage.getUniqueSerial(), "BtApplDeviceDisconnectReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplDeviceDisconnectReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplCancelConnectReqRequest(BtApplCancelConnectReqCallbackIF& cb) const {
    BtApplCancelConnectReqRequest* payload = new BtApplCancelConnectReqRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplCancelConnectReq", BtApplCancelConnectReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplCancelConnectReq, dbusMessage.getUniqueSerial(), "BtApplCancelConnectReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplCancelConnectReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplGetHwVersionReqRequest(BtApplGetHwVersionReqCallbackIF& cb) const {
    BtApplGetHwVersionReqRequest* payload = new BtApplGetHwVersionReqRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplGetHwVersionReq", BtApplGetHwVersionReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplGetHwVersionReq, dbusMessage.getUniqueSerial(), "BtApplGetHwVersionReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplGetHwVersionReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplSetConfigurationReqRequest(BtApplSetConfigurationReqCallbackIF& cb, uint8 instance, uint16 config_id, const ::std::vector< uint8 >& data) const {
    BtApplSetConfigurationReqRequest* payload = new BtApplSetConfigurationReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setInstance(instance);
    payload->setConfig_id(config_id);
    payload->setData(data);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplSetConfigurationReq", BtApplSetConfigurationReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplSetConfigurationReq, dbusMessage.getUniqueSerial(), "BtApplSetConfigurationReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplSetConfigurationReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplReadConfigurationReqRequest(BtApplReadConfigurationReqCallbackIF& cb, uint8 instance, uint16 config_id) const {
    BtApplReadConfigurationReqRequest* payload = new BtApplReadConfigurationReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setInstance(instance);
    payload->setConfig_id(config_id);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplReadConfigurationReq", BtApplReadConfigurationReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplReadConfigurationReq, dbusMessage.getUniqueSerial(), "BtApplReadConfigurationReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplReadConfigurationReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplSspDebugModeReqRequest(BtApplSspDebugModeReqCallbackIF& cb, uint8 mode) const {
    BtApplSspDebugModeReqRequest* payload = new BtApplSspDebugModeReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplSspDebugModeReq", BtApplSspDebugModeReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplSspDebugModeReq, dbusMessage.getUniqueSerial(), "BtApplSspDebugModeReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplSspDebugModeReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplTestModeReqRequest(BtApplTestModeReqCallbackIF& cb, uint8 enable, uint8 mode, uint8 role, const ::std::vector< uint8 >& addr) const {
    BtApplTestModeReqRequest* payload = new BtApplTestModeReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setEnable(enable);
    payload->setMode(mode);
    payload->setRole(role);
    payload->setAddr(addr);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplTestModeReq", BtApplTestModeReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplTestModeReq, dbusMessage.getUniqueSerial(), "BtApplTestModeReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplTestModeReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t DMProxy::sendBtApplTestModeLinkQualityReqRequest(BtApplTestModeLinkQualityReqCallbackIF& cb, uint8 mode) const {
    BtApplTestModeLinkQualityReqRequest* payload = new BtApplTestModeLinkQualityReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setMode(mode);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplTestModeLinkQualityReq", BtApplTestModeLinkQualityReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplTestModeLinkQualityReq, dbusMessage.getUniqueSerial(), "BtApplTestModeLinkQualityReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplTestModeLinkQualityReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DM
} // namespace evo
} // namespace alps
} // namespace org
