/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef ORG_ALPS_EVO_DIDSTUB_H
#define ORG_ALPS_EVO_DIDSTUB_H

#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DID.h"

namespace org {
namespace alps {
namespace evo {
namespace DID {

class DIDStubDelegate;

class DIDStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the DIDStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    DIDStub (const std::string& portName);

    /**
     * Create an instance of the DIDStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    DIDStub (const std::string& portName, const std::string& objectPath);

    virtual ~DIDStub();

    // signal 'BtApplDidSetCfm'

    /**
     * Raise the signal 'BtApplDidSetCfm' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'BtApplDidSetCfm'</b>:
     *
     * If the meaning of "BtApplDidSetCfm" isn't clear, then there should be a description here.
     */
    void sendBtApplDidSetCfmSignal(uint8 status);

    // method 'BtApplDidSetReq'

    /**
     * The method onBtApplDidSetReq() is called by ASF when a client invokes
     * the method 'BtApplDidSetReq'. A subclass has to implement this method
     * and send back a response to the client either with the
     * sendBtApplDidSetReq() or sendBtApplDidSetReqError() method. Do not
     * invoke this method on your own.
     *
     * <b>Documentation of 'BtApplDidSetReq'</b>:
     *
     * If the meaning of "BtApplDidSetReq" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onBtApplDidSetReqRequest (const ::boost::shared_ptr< BtApplDidSetReqRequest >& request) = 0;

    /**
     * The method sendBtApplDidSetReqResponse() sends a response of a previous
     * method invocation of 'BtApplDidSetReq' back to the client.
     *
     * <b>Documentation of 'BtApplDidSetReq'</b>:
     *
     * If the meaning of "BtApplDidSetReq" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onBtApplDidSetReq(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendBtApplDidSetReqResponse (act_t act = 0);

    /**
     * The method sendBtApplDidSetReqError() sends an error response of a
     * previous method invocation of 'BtApplDidSetReq' back to the client.
     *
     * <b>Documentation of 'BtApplDidSetReq'</b>:
     *
     * If the meaning of "BtApplDidSetReq" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onBtApplDidSetReq(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendBtApplDidSetReqError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class DIDStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace DID
} // namespace evo
} // namespace alps
} // namespace org

#endif // ORG_ALPS_EVO_DIDSTUB_H
