/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "org/alps/evo/DID.h"
#include "org/alps/evo/DIDDBus.h"
#include "org/alps/evo/DIDJson.h"
#include "org/alps/evo/DIDProxy.h"
#include <vector>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace org {
namespace alps {
namespace evo {
namespace DID {

DEFINE_CLASS_LOGGER("//org/alps/evolution/hli/org/alps/evo/DID", DIDProxy);

class DIDProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    DIDProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< DIDProxy >& proxyShared = ::boost::static_pointer_cast< DIDProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_BtApplDidSetCfm:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDidSetCfmSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "BtApplDidSetCfm", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<BtApplDidSetCfmSignal> payload = ::boost::static_pointer_cast<BtApplDidSetCfmSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((BtApplDidSetCfmCallbackIF*) _callback)->onBtApplDidSetCfmSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_BtApplDidSetReq:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDidSetReqError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDidSetReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDidSetReqError> payload = ::boost::static_pointer_cast<BtApplDidSetReqError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDidSetReqCallbackIF*) _callback)->onBtApplDidSetReqError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), BtApplDidSetReqResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "BtApplDidSetReq", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<BtApplDidSetReqResponse> payload = ::boost::static_pointer_cast<BtApplDidSetReqResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((BtApplDidSetReqCallbackIF*) _callback)->onBtApplDidSetReqResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_BtApplDidSetCfm: {
                ::boost::shared_ptr< BtApplDidSetCfmError > payload = ::boost::shared_ptr< BtApplDidSetCfmError >
                (new BtApplDidSetCfmError(DBUS_ERROR_NO_SERVER, "The DBus service DID is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDidSetCfm", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DIDProxy> proxyShared = ::boost::static_pointer_cast<DIDProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDidSetCfmCallbackIF*) _callback)->onBtApplDidSetCfmError (proxyShared,payload);
                return true;
            }
            break;
            case ID_BtApplDidSetReq: {
                ::boost::shared_ptr< BtApplDidSetReqError > payload = ::boost::shared_ptr< BtApplDidSetReqError >
                (new BtApplDidSetReqError(DBUS_ERROR_NO_SERVER, "The DBus service DID is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "BtApplDidSetReq", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<DIDProxy> proxyShared = ::boost::static_pointer_cast<DIDProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((BtApplDidSetReqCallbackIF*) _callback)->onBtApplDidSetReqError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& DIDProxyCallback::_logger (DIDProxy::_logger);

DIDProxy::DIDProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "org.alps.evo.DID", serviceAvailable, _logger) {
}

DIDProxy::~DIDProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< DIDProxy > DIDProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<DIDProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< DIDProxy > proxyNew(new DIDProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t DIDProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    DIDProxyCallback* callback = new DIDProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t DIDProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    DIDProxyCallback* callback = new DIDProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void DIDProxy::sendDeregisterAll () const
{
    sendBtApplDidSetCfmDeregisterAll();
}

act_t DIDProxy::sendBtApplDidSetCfmRegister(BtApplDidSetCfmCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "BtApplDidSetCfm");
    act_t act = addSignalCallback(ID_BtApplDidSetCfm, "BtApplDidSetCfm", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "BtApplDidSetCfm", &cb, act);
    return act;
}

bool DIDProxy::sendBtApplDidSetCfmDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("BtApplDidSetCfm", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "BtApplDidSetCfm", act, static_cast<int>(rv));
    return rv;
}

void DIDProxy::sendBtApplDidSetCfmDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "BtApplDidSetCfm");
    _dbusProxyDelegate->deregisterSignalCallback("BtApplDidSetCfm", 0, _dbusDaemonProxy.get(), false);
}

act_t DIDProxy::sendBtApplDidSetReqRequest(BtApplDidSetReqCallbackIF& cb, uint8 index, const ::std::vector< uint8 >& record) const {
    BtApplDidSetReqRequest* payload = new BtApplDidSetReqRequest();
    CHECK_ALLOCATION(payload);
    payload->setIndex(index);
    payload->setRecord(record);
    DBUS_MESSAGE_CALL(dbusMessage, "BtApplDidSetReq", BtApplDidSetReqRequest, payload, true)
    act_t act = addMethodCallback(ID_BtApplDidSetReq, dbusMessage.getUniqueSerial(), "BtApplDidSetReq", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "BtApplDidSetReq", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace DID
} // namespace evo
} // namespace alps
} // namespace org
