/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_TECHNOLOGYSTUB_H
#define NET_CONNMAN_TECHNOLOGYSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Technology.h"
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Technology {

class TechnologyStubDelegate;

class TechnologyStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the TechnologyStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    TechnologyStub (const std::string& portName);

    /**
     * Create an instance of the TechnologyStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    TechnologyStub (const std::string& portName, const std::string& objectPath);

    virtual ~TechnologyStub();

    // signal 'PropertyChanged'

    /**
     * Raise the signal 'PropertyChanged' and send an update message to
     * registered clients.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     */
    void sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value);

    // method 'GetProperties'

    /**
     * The method onGetProperties() is called by ASF when a client invokes the
     * method 'GetProperties'. A subclass has to implement this method and
     * send back a response to the client either with the sendGetProperties()
     * or sendGetPropertiesError() method. Do not invoke this method on your
     * own.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onGetPropertiesRequest (const ::boost::shared_ptr< GetPropertiesRequest >& request) = 0;

    /**
     * The method sendGetPropertiesResponse() sends a response of a previous
     * method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param properties If the meaning of "properties" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onGetProperties(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act = 0);

    /**
     * The method sendGetPropertiesError() sends an error response of a
     * previous method invocation of 'GetProperties' back to the client.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onGetProperties(). If
     * the act is not specified, i.e. the most recent invocation will be
     * answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'SetProperty'

    /**
     * The method onSetProperty() is called by ASF when a client invokes the
     * method 'SetProperty'. A subclass has to implement this method and send
     * back a response to the client either with the sendSetProperty() or
     * sendSetPropertyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onSetPropertyRequest (const ::boost::shared_ptr< SetPropertyRequest >& request) = 0;

    /**
     * The method sendSetPropertyResponse() sends a response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onSetProperty(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendSetPropertyResponse (act_t act = 0);

    /**
     * The method sendSetPropertyError() sends an error response of a previous
     * method invocation of 'SetProperty' back to the client.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onSetProperty(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Scan'

    /**
     * The method onScan() is called by ASF when a client invokes the method
     * 'Scan'. A subclass has to implement this method and send back a
     * response to the client either with the sendScan() or sendScanError()
     * method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onScanRequest (const ::boost::shared_ptr< ScanRequest >& request) = 0;

    /**
     * The method sendScanResponse() sends a response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onScan(). If the act is not specified, i.e. the most recent invocation
     * will be answered. In case multiple replies are pending an act must be
     * specified. An assertion will be thrown if no or multiple method
     * invocation could be found.
     */
    void sendScanResponse (act_t act = 0);

    /**
     * The method sendScanError() sends an error response of a previous method
     * invocation of 'Scan' back to the client.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onScan(). If the act is
     * not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendScanError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class TechnologyStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Technology
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_TECHNOLOGYSTUB_H
