/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_TECHNOLOGYPROXY_H
#define NET_CONNMAN_TECHNOLOGYPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Technology.h"
#include <dbus/dbus.h>
#include <string>

namespace net {
namespace connman {
namespace Technology {

class TechnologyProxy;

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};

class ScanCallbackIF {
public:
    virtual ~ScanCallbackIF() {}

    virtual void onScanError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ScanError >& error) = 0;

    virtual void onScanResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< ScanResponse >& response) = 0;
};

class SetPropertyCallbackIF {
public:
    virtual ~SetPropertyCallbackIF() {}

    virtual void onSetPropertyError(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< SetPropertyError >& error) = 0;

    virtual void onSetPropertyResponse(const ::boost::shared_ptr< TechnologyProxy >& proxy, const ::boost::shared_ptr< SetPropertyResponse >& response) = 0;
};


/**
 * TechnologyProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Technology' (specified in file
 * ConnectionManagerInterface.xml).
 *
 * If the meaning of "net.connman.Technology" isn't clear, then there should be a description here.
 */
class TechnologyProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of TechnologyProxy.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of TechnologyProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of TechnologyProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< TechnologyProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< TechnologyProxy > proxyNew(new TechnologyProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~TechnologyProxy ();


    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;



    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'SetProperty'

    /**
     * Call the method 'SetProperty'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'SetProperty'</b>:
     *
     * If the meaning of "SetProperty" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param name If the meaning of "name" isn't clear, then there should be a description here.
     *
     * @param value If the meaning of "value" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const;

    // Method 'Scan'

    /**
     * Call the method 'Scan'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'Scan'</b>:
     *
     * If the meaning of "Scan" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendScanRequest(ScanCallbackIF& cb) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    TechnologyProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class TechnologyProxyCallback;
};

} // namespace Technology
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_TECHNOLOGYPROXY_H
