/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Technology.h"
#include "net/connman/TechnologyDBus.h"
#include "net/connman/TechnologyJson.h"
#include "net/connman/TechnologyProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Technology {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Technology", TechnologyProxy);

class TechnologyProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    TechnologyProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< TechnologyProxy >& proxyShared = ::boost::static_pointer_cast< TechnologyProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_PropertyChanged:
                {
                    INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), PropertyChangedSignal);
                    message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                    LOG_INFO ("<- on%sSignal, act=%" PRIuPTR ", cb=%p, proxy=%p, message:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                    message.logInfoMessage(_logger);

                    ::boost::shared_ptr<PropertyChangedSignal> payload = ::boost::static_pointer_cast<PropertyChangedSignal>(message.getPayload()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                    ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedSignal (proxyShared, payload);
                    return true;
                }
                break;
            case ID_GetProperties:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesError> payload = ::boost::static_pointer_cast<GetPropertiesError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "GetProperties", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<GetPropertiesResponse> payload = ::boost::static_pointer_cast<GetPropertiesResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_SetProperty:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertyError> payload = ::boost::static_pointer_cast<SetPropertyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertyCallbackIF*) _callback)->onSetPropertyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "SetProperty", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<SetPropertyResponse> payload = ::boost::static_pointer_cast<SetPropertyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((SetPropertyCallbackIF*) _callback)->onSetPropertyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Scan:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ScanError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Scan", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScanError> payload = ::boost::static_pointer_cast<ScanError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ScanCallbackIF*) _callback)->onScanError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ScanResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Scan", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ScanResponse> payload = ::boost::static_pointer_cast<ScanResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ScanCallbackIF*) _callback)->onScanResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_PropertyChanged: {
                ::boost::shared_ptr< PropertyChangedError > payload = ::boost::shared_ptr< PropertyChangedError >
                (new PropertyChangedError(DBUS_ERROR_NO_SERVER, "The DBus service Technology is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "PropertyChanged", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TechnologyProxy> proxyShared = ::boost::static_pointer_cast<TechnologyProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((PropertyChangedCallbackIF*) _callback)->onPropertyChangedError (proxyShared,payload);
                return true;
            }
            break;
            case ID_GetProperties: {
                ::boost::shared_ptr< GetPropertiesError > payload = ::boost::shared_ptr< GetPropertiesError >
                (new GetPropertiesError(DBUS_ERROR_NO_SERVER, "The DBus service Technology is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "GetProperties", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TechnologyProxy> proxyShared = ::boost::static_pointer_cast<TechnologyProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((GetPropertiesCallbackIF*) _callback)->onGetPropertiesError (proxyShared,payload);
                return true;
            }
            break;
            case ID_SetProperty: {
                ::boost::shared_ptr< SetPropertyError > payload = ::boost::shared_ptr< SetPropertyError >
                (new SetPropertyError(DBUS_ERROR_NO_SERVER, "The DBus service Technology is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "SetProperty", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TechnologyProxy> proxyShared = ::boost::static_pointer_cast<TechnologyProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((SetPropertyCallbackIF*) _callback)->onSetPropertyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Scan: {
                ::boost::shared_ptr< ScanError > payload = ::boost::shared_ptr< ScanError >
                (new ScanError(DBUS_ERROR_NO_SERVER, "The DBus service Technology is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Scan", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<TechnologyProxy> proxyShared = ::boost::static_pointer_cast<TechnologyProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ScanCallbackIF*) _callback)->onScanError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& TechnologyProxyCallback::_logger (TechnologyProxy::_logger);

TechnologyProxy::TechnologyProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "net.connman.Technology", serviceAvailable, _logger) {
}

TechnologyProxy::~TechnologyProxy()
{
    sendDeregisterAll();
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< TechnologyProxy > TechnologyProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<TechnologyProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< TechnologyProxy > proxyNew(new TechnologyProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t TechnologyProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    TechnologyProxyCallback* callback = new TechnologyProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t TechnologyProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    TechnologyProxyCallback* callback = new TechnologyProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}


void TechnologyProxy::sendDeregisterAll () const
{
    sendPropertyChangedDeregisterAll();
}

act_t TechnologyProxy::sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const {
    LOG_ASSERT(_dbusDaemonProxy);
    _dbusDaemonProxy->addMatch("signal", _dbusProxyDelegate->getDBusObjectPath(), _dbusProxyDelegate->getInterfaceName(), "PropertyChanged");
    act_t act = addSignalCallback(ID_PropertyChanged, "PropertyChanged", &cb);
    LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "PropertyChanged", &cb, act);
    return act;
}

bool TechnologyProxy::sendPropertyChangedDeregister(act_t act) const {
    bool rv = _dbusProxyDelegate->deregisterSignalCallback ("PropertyChanged", act, _dbusDaemonProxy.get());
    LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "PropertyChanged", act, static_cast<int>(rv));
    return rv;
}

void TechnologyProxy::sendPropertyChangedDeregisterAll() const {
    LOG_INFO ("-> send%sDeregisterAll()", "PropertyChanged");
    _dbusProxyDelegate->deregisterSignalCallback("PropertyChanged", 0, _dbusDaemonProxy.get(), false);
}

act_t TechnologyProxy::sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const {
    GetPropertiesRequest* payload = new GetPropertiesRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "GetProperties", GetPropertiesRequest, payload, true)
    act_t act = addMethodCallback(ID_GetProperties, dbusMessage.getUniqueSerial(), "GetProperties", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "GetProperties", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t TechnologyProxy::sendSetPropertyRequest(SetPropertyCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const {
    SetPropertyRequest* payload = new SetPropertyRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "SetProperty", SetPropertyRequest, payload, true)
    act_t act = addMethodCallback(ID_SetProperty, dbusMessage.getUniqueSerial(), "SetProperty", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "SetProperty", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t TechnologyProxy::sendScanRequest(ScanCallbackIF& cb) const {
    ScanRequest* payload = new ScanRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Scan", ScanRequest, payload, true)
    act_t act = addMethodCallback(ID_Scan, dbusMessage.getUniqueSerial(), "Scan", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Scan", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Technology
} // namespace connman
} // namespace net
