/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_SESSIONSTUB_H
#define NET_CONNMAN_SESSIONSTUB_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusStub.h"
#include "asf/dbus/DBusVariant.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Session.h"

namespace net {
namespace connman {
namespace Session {

class SessionStubDelegate;

class SessionStub : public ::asf::dbus::DBusStub
{
public:

    /**
     * Create an instance of the SessionStub
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     */
    SessionStub (const std::string& portName);

    /**
     * Create an instance of the SessionStub
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @param portName the port name as specified in the component manifest (cmc)
     *
     * @param objectPath the dbus object path, see
     * http://dbus.freedesktop.org/doc/dbus-specification.html#message-protocol-marshaling-object-path
     */
    SessionStub (const std::string& portName, const std::string& objectPath);

    virtual ~SessionStub();

    // method 'Destroy'

    /**
     * The method onDestroy() is called by ASF when a client invokes the
     * method 'Destroy'. A subclass has to implement this method and send back
     * a response to the client either with the sendDestroy() or
     * sendDestroyError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Destroy'</b>:
     *
     * If the meaning of "Destroy" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDestroyRequest (const ::boost::shared_ptr< DestroyRequest >& request) = 0;

    /**
     * The method sendDestroyResponse() sends a response of a previous method
     * invocation of 'Destroy' back to the client.
     *
     * <b>Documentation of 'Destroy'</b>:
     *
     * If the meaning of "Destroy" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDestroy(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDestroyResponse (act_t act = 0);

    /**
     * The method sendDestroyError() sends an error response of a previous
     * method invocation of 'Destroy' back to the client.
     *
     * <b>Documentation of 'Destroy'</b>:
     *
     * If the meaning of "Destroy" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDestroy(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDestroyError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Connect'

    /**
     * The method onConnect() is called by ASF when a client invokes the
     * method 'Connect'. A subclass has to implement this method and send back
     * a response to the client either with the sendConnect() or
     * sendConnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onConnectRequest (const ::boost::shared_ptr< ConnectRequest >& request) = 0;

    /**
     * The method sendConnectResponse() sends a response of a previous method
     * invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onConnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendConnectResponse (act_t act = 0);

    /**
     * The method sendConnectError() sends an error response of a previous
     * method invocation of 'Connect' back to the client.
     *
     * <b>Documentation of 'Connect'</b>:
     *
     * If the meaning of "Connect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onConnect(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Disconnect'

    /**
     * The method onDisconnect() is called by ASF when a client invokes the
     * method 'Disconnect'. A subclass has to implement this method and send
     * back a response to the client either with the sendDisconnect() or
     * sendDisconnectError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onDisconnectRequest (const ::boost::shared_ptr< DisconnectRequest >& request) = 0;

    /**
     * The method sendDisconnectResponse() sends a response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onDisconnect(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendDisconnectResponse (act_t act = 0);

    /**
     * The method sendDisconnectError() sends an error response of a previous
     * method invocation of 'Disconnect' back to the client.
     *
     * <b>Documentation of 'Disconnect'</b>:
     *
     * If the meaning of "Disconnect" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onDisconnect(). If the
     * act is not specified, i.e. the most recent invocation will be answered.
     * In case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

    // method 'Change'

    /**
     * The method onChange() is called by ASF when a client invokes the method
     * 'Change'. A subclass has to implement this method and send back a
     * response to the client either with the sendChange() or
     * sendChangeError() method. Do not invoke this method on your own.
     *
     * <b>Documentation of 'Change'</b>:
     *
     * If the meaning of "Change" isn't clear, then there should be a description here.
     *
     * @param request The parameter request provides the method call
     * parameters. Additionally the request provides the field act
     * (Asynchronous Completion Token) which can later be passed to the
     * response methods.
     */
    virtual void onChangeRequest (const ::boost::shared_ptr< ChangeRequest >& request) = 0;

    /**
     * The method sendChangeResponse() sends a response of a previous method
     * invocation of 'Change' back to the client.
     *
     * <b>Documentation of 'Change'</b>:
     *
     * If the meaning of "Change" isn't clear, then there should be a description here.
     *
     * @param act The parameter act identifies a previous invocation of
     * onChange(). If the act is not specified, i.e. the most recent
     * invocation will be answered. In case multiple replies are pending an
     * act must be specified. An assertion will be thrown if no or multiple
     * method invocation could be found.
     */
    void sendChangeResponse (act_t act = 0);

    /**
     * The method sendChangeError() sends an error response of a previous
     * method invocation of 'Change' back to the client.
     *
     * <b>Documentation of 'Change'</b>:
     *
     * If the meaning of "Change" isn't clear, then there should be a description here.
     *
     * @param errorName The error name as specified in
     * /usr/include/dbus-1.0/dbus/dbus-protocol.h
     *
     * @param errorMessage An arbitrary string send back to the client
     *
     * @param act Identifies a previous invocation of onChange(). If the act
     * is not specified, i.e. the most recent invocation will be answered. In
     * case multiple replies are pending an act must be specified. An
     * assertion will be thrown if no or multiple method invocation could be
     * found.
     */
    void sendChangeError (const std::string &errorName, const std::string &errorMessage, act_t act = 0);

private:
    void onGetAll(std::map<std::basic_string<char>, ::asf::dbus::DBusVariant>&) const;

    friend class SessionStubDelegate;

    DECLARE_CLASS_LOGGER();
};

} // namespace Session
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_SESSIONSTUB_H
