/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Session.h"
#include "net/connman/SessionDBus.h"
#include "net/connman/SessionJson.h"
#include "net/connman/SessionStub.h"

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Session {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Session", SessionStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Change", 3 },
    { 7, "Connect", 1 },
    { 7, "Destroy", 0 },
    { 10, "Disconnect", 2 },
};


class SessionStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    SessionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    SessionStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    SessionStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Session"),
          _logger(logger) {}

    virtual ~SessionStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void SessionStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 4, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'Destroy'

            LOG_DEBUG_STUB("process method '%s'", "Destroy");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestroyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Destroy", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DestroyRequest > payload = ::boost::static_pointer_cast<DestroyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SessionStub*>(getStub())->onDestroyRequest(payload);
            return;
        }
        case 1: {

            // method 'Connect'

            LOG_DEBUG_STUB("process method '%s'", "Connect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Connect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectRequest > payload = ::boost::static_pointer_cast<ConnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SessionStub*>(getStub())->onConnectRequest(payload);
            return;
        }
        case 2: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SessionStub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        case 3: {

            // method 'Change'

            LOG_DEBUG_STUB("process method '%s'", "Change");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Change", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ChangeRequest > payload = ::boost::static_pointer_cast<ChangeRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<SessionStub*>(getStub())->onChangeRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* SessionStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Session\">\n"
            "      <method name=\"Destroy\"/>\n"
            "      <method name=\"Connect\"/>\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <method name=\"Change\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "</interface>\n";
}

void SessionStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<SessionStub*>(getStub()))->onGetAll (properties);
}

void SessionStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void SessionStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

SessionStub::SessionStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SessionStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SessionStub::SessionStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new SessionStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

SessionStub::~SessionStub() {
    delete _stubDelegate;
}

void  SessionStub::sendDestroyResponse (act_t act) {
    DestroyResponse* payload = new DestroyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Destroy", DestroyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Destroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendDestroyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DestroyError* payload = new DestroyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Destroy", DestroyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Destroy", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendConnectResponse (act_t act) {
    ConnectResponse* payload = new ConnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Connect", ConnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectError* payload = new ConnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Connect", ConnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendChangeResponse (act_t act) {
    ChangeResponse* payload = new ChangeResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Change", ChangeResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Change", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  SessionStub::sendChangeError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ChangeError* payload = new ChangeError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Change", ChangeError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Change", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void SessionStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Session
} // namespace connman
} // namespace net
