/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Session.h"
#include "net/connman/SessionDBus.h"
#include "net/connman/SessionJson.h"
#include "net/connman/SessionProxy.h"
#include <string>

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Session {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Session", SessionProxy);

class SessionProxyCallback : public ::asf::dbus::DBusProxyCallback {
public:

    SessionProxyCallback(uint16 functionId, void* callback) :
        ::asf::dbus::DBusProxyCallback (functionId, callback)
    {}

    bool processMessage (::asf::dbus::DBusMessage &message) {
        const ::boost::shared_ptr< SessionProxy >& proxyShared = ::boost::static_pointer_cast< SessionProxy >(message.getDBusProxyShared()); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
        switch (_functionId) {
            case ID_Destroy:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DestroyError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Destroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestroyError> payload = ::boost::static_pointer_cast<DestroyError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DestroyCallbackIF*) _callback)->onDestroyError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DestroyResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Destroy", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DestroyResponse> payload = ::boost::static_pointer_cast<DestroyResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DestroyCallbackIF*) _callback)->onDestroyResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Connect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ConnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectError> payload = ::boost::static_pointer_cast<ConnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Connect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ConnectResponse> payload = ::boost::static_pointer_cast<ConnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ConnectCallbackIF*) _callback)->onConnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Disconnect:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectError> payload = ::boost::static_pointer_cast<DisconnectError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Disconnect", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<DisconnectResponse> payload = ::boost::static_pointer_cast<DisconnectResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((DisconnectCallbackIF*) _callback)->onDisconnectResponse (proxyShared, payload);
                        return true;
                    }
                }
            case ID_Change:
                {
                    if (message.isError()) {
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_ERROR_DESERIALIZATION(message.getPayloadDecorator(), ChangeError);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p", "Change", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChangeError> payload = ::boost::static_pointer_cast<ChangeError>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ChangeCallbackIF*) _callback)->onChangeError (proxyShared, payload);
                        return true;
                    }
                    else { // no error
                        INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ChangeResponse);
                        message.getPayload()->setAct(reinterpret_cast<act_t>(this));

                        LOG_INFO ("<- on%sResponse, act=%" PRIuPTR ", cb=%p, proxy=%p", "Change", reinterpret_cast<act_t>(this), _callback, message.getProxy());
                        message.logInfoMessage(_logger);

                        ::boost::shared_ptr<ChangeResponse> payload = ::boost::static_pointer_cast<ChangeResponse>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
                        ((ChangeCallbackIF*) _callback)->onChangeResponse (proxyShared, payload);
                        return true;
                    }
                }
            default:
            LOG_FATAL ("Received an invalid functionId, proxy=%p", message.getProxy());
        }
        LOG_FATAL("Receveid an invalid message, proxy=%p", message.getProxy());
        return false;
    }

    bool onServiceUnavailable (const ::boost::shared_ptr< ::asf::core::Proxy >& baseProxy) {
        switch (_functionId) {
            case ID_Destroy: {
                ::boost::shared_ptr< DestroyError > payload = ::boost::shared_ptr< DestroyError >
                (new DestroyError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Destroy", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DestroyCallbackIF*) _callback)->onDestroyError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Connect: {
                ::boost::shared_ptr< ConnectError > payload = ::boost::shared_ptr< ConnectError >
                (new ConnectError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Connect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ConnectCallbackIF*) _callback)->onConnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Disconnect: {
                ::boost::shared_ptr< DisconnectError > payload = ::boost::shared_ptr< DisconnectError >
                (new DisconnectError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Disconnect", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((DisconnectCallbackIF*) _callback)->onDisconnectError (proxyShared,payload);
                return true;
            }
            break;
            case ID_Change: {
                ::boost::shared_ptr< ChangeError > payload = ::boost::shared_ptr< ChangeError >
                (new ChangeError(DBUS_ERROR_NO_SERVER, "The DBus service Session is currently not available"));
                payload->setAct(reinterpret_cast<act_t>(this));

                // log the payload
                if (IS_LOG_INFO_ENABLED()) {
                    LOG_INFO ("<- on%sError, act=%" PRIuPTR ", cb=%p, proxy=%p, payload:", "Change", reinterpret_cast<act_t>(this), _callback, &baseProxy);
                    std::string jsonPayload;
                    serializeJson(*payload,jsonPayload);
                    LOG_INFO("payload: %s", jsonPayload.c_str());
                }

                ::boost::shared_ptr<SessionProxy> proxyShared = ::boost::static_pointer_cast<SessionProxy>(baseProxy); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
                ((ChangeCallbackIF*) _callback)->onChangeError (proxyShared,payload);
                return true;
            }
            break;
            default:
                break;
        }
        return false;
    }

    static ::asf::core::Logger&_logger;
};

::asf::core::Logger& SessionProxyCallback::_logger (SessionProxy::_logger);

SessionProxy::SessionProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable) :
    ::asf::dbus::DBusProxy(portName, "net.connman.Session", serviceAvailable, _logger) {
}

SessionProxy::~SessionProxy()
{
    ::asf::dbus::DBusConnector::getConnector(getConnectorOptions())->deregisterProxyDelegate(_dbusProxyDelegate);
}

// static
::boost::shared_ptr< SessionProxy > SessionProxy::createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable) {
    ::boost::shared_ptr< Proxy > proxyReuse = ::asf::dbus::DBusConnector::getProxy(portName, serviceAvailable);
    if(proxyReuse) {
        LOG_INFO_STATIC ("createProxy, reuse existing proxy");
        return ::boost::static_pointer_cast<SessionProxy>(proxyReuse); // no RTTI, use static_pointer_cast instead of dynamic_pointer_cast
    }
    LOG_INFO_STATIC ("createProxy, create new proxy");
    ::boost::shared_ptr< SessionProxy > proxyNew(new SessionProxy(portName, serviceAvailable));
    ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew);
    proxyNew->createHelperProxies(false);
    return proxyNew;
}

act_t SessionProxy::addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const {
    SessionProxyCallback* callback = new SessionProxyCallback(methodId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->addMethodCallback (serial, memberName, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}

act_t SessionProxy::addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const {
    SessionProxyCallback* callback = new SessionProxyCallback(signalId, cb);
    CHECK_ALLOCATION(callback);
    _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
    return reinterpret_cast<act_t>(callback);
}



act_t SessionProxy::sendDestroyRequest(DestroyCallbackIF& cb) const {
    DestroyRequest* payload = new DestroyRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Destroy", DestroyRequest, payload, true)
    act_t act = addMethodCallback(ID_Destroy, dbusMessage.getUniqueSerial(), "Destroy", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Destroy", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SessionProxy::sendConnectRequest(ConnectCallbackIF& cb) const {
    ConnectRequest* payload = new ConnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Connect", ConnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Connect, dbusMessage.getUniqueSerial(), "Connect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Connect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SessionProxy::sendDisconnectRequest(DisconnectCallbackIF& cb) const {
    DisconnectRequest* payload = new DisconnectRequest();
    CHECK_ALLOCATION(payload);
    DBUS_MESSAGE_CALL(dbusMessage, "Disconnect", DisconnectRequest, payload, true)
    act_t act = addMethodCallback(ID_Disconnect, dbusMessage.getUniqueSerial(), "Disconnect", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Disconnect", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

act_t SessionProxy::sendChangeRequest(ChangeCallbackIF& cb, const ::std::string& name, const ::asf::dbus::DBusVariant& value) const {
    ChangeRequest* payload = new ChangeRequest();
    CHECK_ALLOCATION(payload);
    payload->setName(name);
    payload->setValue(value);
    DBUS_MESSAGE_CALL(dbusMessage, "Change", ChangeRequest, payload, true)
    act_t act = addMethodCallback(ID_Change, dbusMessage.getUniqueSerial(), "Change", &cb);
    LOG_INFO ("-> send%sRequest(cb=%p), returning act=%" PRIuPTR ", message:", "Change", &cb, act);
    dbusMessage.logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    return act;
}

} // namespace Session
} // namespace connman
} // namespace net
