/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/dbus/DBusStubDelegate.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "net/connman/Service.h"
#include "net/connman/ServiceDBus.h"
#include "net/connman/ServiceJson.h"
#include "net/connman/ServiceStub.h"
#include <map>
#include <string>

#include "asf/dbus/DBusMessage.h"

namespace net {
namespace connman {
namespace Service {

DEFINE_CLASS_LOGGER("/net/Connman/net/connman/Service", ServiceStub);

static ::asf::dbus::DBusUtils::stringEntry methodsTable[] = {
    { 6, "Remove", 4 },
    { 7, "Connect", 2 },
    { 10, "Disconnect", 3 },
    { 11, "SetProperty", 1 },
    { 13, "GetProperties", 0 },
};


class ServiceStubDelegate : public ::asf::dbus::DBusStubDelegate {
public:

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger) :
        ::asf::dbus::DBusStubDelegate( stub, logger),
        _logger(logger)
    {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub, ::asf::core::Logger &logger, const std::string& objectPath) :
        ::asf::dbus::DBusStubDelegate( stub, logger, objectPath),
        _logger(logger) {}

    ServiceStubDelegate(::asf::dbus::DBusStub* stub,
                               ::asf::core::Logger& logger,
                               ::asf::dbus::DBusConnector& connector,
                               const std::string& objectPath)
        : ::asf::dbus::DBusStubDelegate(
              stub, logger, connector, objectPath, "net.connman.Service"),
          _logger(logger) {}

    virtual ~ServiceStubDelegate() {}

    virtual void process(::asf::core::ServiceMessage& msg);

    const char* introspect() const;

    virtual void getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties);

    virtual void setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act);

    virtual void getProperty(const ::std::string& property, const act_t& act);

private:

    ::asf::core::Logger& _logger;

};

void ServiceStubDelegate::process(::asf::core::ServiceMessage& msg) {
    ::asf::dbus::DBusMessage& message = static_cast< ::asf::dbus::DBusMessage& >(msg);
    LOG_DEBUG_STUB("Entering process(memberName='%s')", message.getMemberName().c_str());

    unsigned int methodIndex = 0;
    if (::asf::dbus::DBusUtils::lookupInStringEntryTable (message.getMemberName().c_str(), message.getMemberName().length(), methodsTable, 5, methodIndex)) {
        switch (methodIndex) {
        case 0: {

            // method 'GetProperties'

            LOG_DEBUG_STUB("process method '%s'", "GetProperties");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), GetPropertiesRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "GetProperties", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< GetPropertiesRequest > payload = ::boost::static_pointer_cast<GetPropertiesRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onGetPropertiesRequest(payload);
            return;
        }
        case 1: {

            // method 'SetProperty'

            LOG_DEBUG_STUB("process method '%s'", "SetProperty");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), SetPropertyRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "SetProperty", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< SetPropertyRequest > payload = ::boost::static_pointer_cast<SetPropertyRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onSetPropertyRequest(payload);
            return;
        }
        case 2: {

            // method 'Connect'

            LOG_DEBUG_STUB("process method '%s'", "Connect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), ConnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Connect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< ConnectRequest > payload = ::boost::static_pointer_cast<ConnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onConnectRequest(payload);
            return;
        }
        case 3: {

            // method 'Disconnect'

            LOG_DEBUG_STUB("process method '%s'", "Disconnect");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), DisconnectRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Disconnect", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< DisconnectRequest > payload = ::boost::static_pointer_cast<DisconnectRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onDisconnectRequest(payload);
            return;
        }
        case 4: {

            // method 'Remove'

            LOG_DEBUG_STUB("process method '%s'", "Remove");
            INIT_DBUS_PAYLOAD_DECORATOR_FOR_DESERIALIZATION(message.getPayloadDecorator(), RemoveRequest);
            message.getPayload()->setAct(static_cast<act_t>(message.getUniqueSerial()));
            registerMessage(message.getPayload()->getAct(),message.getCurrentMessage());

            LOG_INFO_STUB ("<- on%s, act=%" PRIuPTR, "Remove", message.getPayload()->getAct());
            message.logInfoMessage(_logger);

            ::boost::shared_ptr< RemoveRequest > payload = ::boost::static_pointer_cast<RemoveRequest>(message.getPayload()); // no RTTI, use static_pointer_cast instead of
            static_cast<ServiceStub*>(getStub())->onRemoveRequest(payload);
            return;
        }
        default:
            break;
        }
    }
    LOG_FATAL_STUB("can't process message %s", message.getMemberName().c_str());
}

const char* ServiceStubDelegate::introspect() const {
    return     "<interface name=\"net.connman.Service\">\n"
            "      <method name=\"GetProperties\">\n"
            "        <arg direction=\"out\" name=\"properties\" type=\"a{sv}\"/>\n"
            "      </method>\n"
            "      <method name=\"SetProperty\">\n"
            "        <arg direction=\"in\" name=\"name\" type=\"s\"/>\n"
            "        <arg direction=\"in\" name=\"value\" type=\"v\"/>\n"
            "      </method>\n"
            "      <method name=\"Connect\"/>\n"
            "      <method name=\"Disconnect\"/>\n"
            "      <method name=\"Remove\"/>\n"
            "      <signal name=\"PropertyChanged\">\n"
            "        <arg name=\"name\" type=\"s\"/>\n"
            "        <arg name=\"value\" type=\"v\"/>\n"
            "      </signal>\n"
            "</interface>\n";
}

void ServiceStubDelegate::getAllProperties(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) {
    (static_cast<ServiceStub*>(getStub()))->onGetAll (properties);
}

void ServiceStubDelegate::setProperty(const ::std::string& property, const ::asf::dbus::DBusVariant& value, const act_t& act) {
    ((void)value);  // to get rid of unused variable warning
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendSetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

void ServiceStubDelegate::getProperty(const ::std::string& property, const act_t& act) {
    std::ostringstream errorMessage;
    errorMessage << "unknown property '" << property << "'";
    sendGetError(DBUS_ERROR_UNKNOWN_PROPERTY, errorMessage.str(), act);
}

ServiceStub::ServiceStub (const std::string& portName) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::ServiceStub (const std::string& portName, const std::string& objectPath) :
    ::asf::dbus::DBusStub ( portName, _logger ) {
    _stubDelegate = new ServiceStubDelegate(this, _logger, objectPath);
    CHECK_ALLOCATION(_stubDelegate);
    _stubDelegate->init();
}

ServiceStub::~ServiceStub() {
    delete _stubDelegate;
}

void ServiceStub::sendPropertyChangedSignal(const ::std::string& name, const ::asf::dbus::DBusVariant& value) {
    if (_stubDelegate->isConnected()) {
        PropertyChangedSignal* payload = new PropertyChangedSignal(name, value);
        DBUS_MESSAGE_SIGNAL(dbusMessage, "PropertyChanged", PropertyChangedSignal, payload)
        LOG_INFO ("-> send%sSignal", "PropertyChanged");
        dbusMessage.logInfoMessage(_logger);
        ::asf::core::ComponentMessageAdapter::sendMessage (dbusMessage);
    } else {
        LOG_INFO("Not connected, '%s' no signal sent", "PropertyChanged");
    }
}

void  ServiceStub::sendGetPropertiesResponse (const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties, act_t act) {
    GetPropertiesResponse* payload = new GetPropertiesResponse(properties);
    DBUS_MESSAGE_REPLY(dbusMessage, "GetProperties", GetPropertiesResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendGetPropertiesError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    GetPropertiesError* payload = new GetPropertiesError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "GetProperties", GetPropertiesError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "GetProperties", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendSetPropertyResponse (act_t act) {
    SetPropertyResponse* payload = new SetPropertyResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "SetProperty", SetPropertyResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendSetPropertyError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    SetPropertyError* payload = new SetPropertyError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "SetProperty", SetPropertyError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "SetProperty", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendConnectResponse (act_t act) {
    ConnectResponse* payload = new ConnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Connect", ConnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendConnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    ConnectError* payload = new ConnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Connect", ConnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Connect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendDisconnectResponse (act_t act) {
    DisconnectResponse* payload = new DisconnectResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Disconnect", DisconnectResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendDisconnectError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    DisconnectError* payload = new DisconnectError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Disconnect", DisconnectError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Disconnect", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendRemoveResponse (act_t act) {
    RemoveResponse* payload = new RemoveResponse;
    DBUS_MESSAGE_REPLY(dbusMessage, "Remove", RemoveResponse, payload)
    LOG_INFO ("-> send%sResponse, act=%" PRIuPTR, "Remove", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void  ServiceStub::sendRemoveError (const std::string &errorName, const std::string &errorMessage, act_t act) {
    RemoveError* payload = new RemoveError(errorName, errorMessage);
    DBUS_MESSAGE_ERRORREPLY(dbusMessage, "Remove", RemoveError, payload)
    LOG_INFO ("-> send%sError, act=%" PRIuPTR, "Remove", act);
    dbusMessage->logInfoMessage(_logger);
    ::asf::core::ComponentMessageAdapter::sendMessage (*dbusMessage);
}

void ServiceStub::onGetAll(::std::map< ::std::string, ::asf::dbus::DBusVariant >& properties) const {
    ((void)properties);  // to get rid of unused variable warning
}

} // namespace Service
} // namespace connman
} // namespace net
