/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * THIS FILE IS GENERATED. DO NOT EDIT.
 * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
 ****************************************************************************/

#ifndef NET_CONNMAN_MANAGERPROXY_H
#define NET_CONNMAN_MANAGERPROXY_H

#include "asf/core/Logger.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusProxy.h"
#include "asf/dbus/DBusUtils.h"
#include "asf/dbus/DBusVariant.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "net/connman/Manager.h"
#include <dbus/dbus.h>
#include <map>
#include <string>

namespace net {
namespace connman {
namespace Manager {

class ManagerProxy;

class CreateSessionCallbackIF {
public:
    virtual ~CreateSessionCallbackIF() {}

    virtual void onCreateSessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionError >& error) = 0;

    virtual void onCreateSessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< CreateSessionResponse >& response) = 0;
};

class DestroySessionCallbackIF {
public:
    virtual ~DestroySessionCallbackIF() {}

    virtual void onDestroySessionError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionError >& error) = 0;

    virtual void onDestroySessionResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< DestroySessionResponse >& response) = 0;
};

class GetPropertiesCallbackIF {
public:
    virtual ~GetPropertiesCallbackIF() {}

    virtual void onGetPropertiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesError >& error) = 0;

    virtual void onGetPropertiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetPropertiesResponse >& response) = 0;
};

class GetServicesCallbackIF {
public:
    virtual ~GetServicesCallbackIF() {}

    virtual void onGetServicesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesError >& error) = 0;

    virtual void onGetServicesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetServicesResponse >& response) = 0;
};

class GetTechnologiesCallbackIF {
public:
    virtual ~GetTechnologiesCallbackIF() {}

    virtual void onGetTechnologiesError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesError >& error) = 0;

    virtual void onGetTechnologiesResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< GetTechnologiesResponse >& response) = 0;
};

class PropertyChangedCallbackIF {
public:
    virtual ~PropertyChangedCallbackIF() {}

    virtual void onPropertyChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedError >& error) = 0;

    virtual void onPropertyChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< PropertyChangedSignal >& signal) = 0;
};

class RegisterAgentCallbackIF {
public:
    virtual ~RegisterAgentCallbackIF() {}

    virtual void onRegisterAgentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentError >& error) = 0;

    virtual void onRegisterAgentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< RegisterAgentResponse >& response) = 0;
};

class ServicesChangedCallbackIF {
public:
    virtual ~ServicesChangedCallbackIF() {}

    virtual void onServicesChangedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedError >& error) = 0;

    virtual void onServicesChangedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< ServicesChangedSignal >& signal) = 0;
};

class TechnologyAddedCallbackIF {
public:
    virtual ~TechnologyAddedCallbackIF() {}

    virtual void onTechnologyAddedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedError >& error) = 0;

    virtual void onTechnologyAddedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyAddedSignal >& signal) = 0;
};

class TechnologyRemovedCallbackIF {
public:
    virtual ~TechnologyRemovedCallbackIF() {}

    virtual void onTechnologyRemovedError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedError >& error) = 0;

    virtual void onTechnologyRemovedSignal(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< TechnologyRemovedSignal >& signal) = 0;
};

class UnregisterAgentCallbackIF {
public:
    virtual ~UnregisterAgentCallbackIF() {}

    virtual void onUnregisterAgentError(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentError >& error) = 0;

    virtual void onUnregisterAgentResponse(const ::boost::shared_ptr< ManagerProxy >& proxy, const ::boost::shared_ptr< UnregisterAgentResponse >& response) = 0;
};


/**
 * ManagerProxy is the client side representation of the D-Bus service
 * interface 'net.connman.Manager' (specified in file
 * ConnectionManagerInterface.xml).
 *
 * If the meaning of "net.connman.Manager" isn't clear, then there should be a description here.
 */
class ManagerProxy : public ::asf::dbus::DBusProxy
{
public:
    /**
     * Create a new instance of ManagerProxy.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     *
     * @deprecated use the createProxy() method with the parameter
     * ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector instead.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        ::DBusBusType busType,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector connectorOptions;
        connectorOptions.setBusType(::asf::dbus::DBusUtils::toOptions(busType).getBusType());
        return createProxy(portName, busName, objectPath, connectorOptions, serviceAvailable);
    }

    /**
     * Create a new instance of ManagerProxy.
     *
     * Use this method if you have the annotation @WiredAtRuntime set in your
     * component manifest for this service.
     */
    static ::boost::shared_ptr< ManagerProxy > createProxy(const std::string& portName,
        const std::string& busName,
        const std::string& objectPath,
        const ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector& connectorOptions,
        ::asf::core::ServiceAvailableIF& serviceAvailable) {
        LOG_INFO_STATIC ("createProxy, create new proxy");
        ::boost::shared_ptr< ManagerProxy > proxyNew(new ManagerProxy(portName, serviceAvailable));
        ::asf::dbus::DBusConnector::registerProxyDelegate(proxyNew->_dbusProxyDelegate, proxyNew, busName, objectPath, connectorOptions);
        proxyNew->createHelperProxies(false);
        return proxyNew;
    }

    virtual ~ManagerProxy ();


    // Signal 'TechnologyAdded'

    /**
     * Notify on the signal 'TechnologyAdded'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'TechnologyAdded'</b>:
     *
     * If the meaning of "TechnologyAdded" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTechnologyAddedRegister(TechnologyAddedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'TechnologyAdded'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'TechnologyAdded'</b>:
     *
     * If the meaning of "TechnologyAdded" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTechnologyAddedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTechnologyAddedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'TechnologyAdded'.
     */
    void sendTechnologyAddedDeregisterAll () const;

    // Signal 'TechnologyRemoved'

    /**
     * Notify on the signal 'TechnologyRemoved'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'TechnologyRemoved'</b>:
     *
     * If the meaning of "TechnologyRemoved" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendTechnologyRemovedRegister(TechnologyRemovedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'TechnologyRemoved'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'TechnologyRemoved'</b>:
     *
     * If the meaning of "TechnologyRemoved" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendTechnologyRemovedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendTechnologyRemovedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'TechnologyRemoved'.
     */
    void sendTechnologyRemovedDeregisterAll () const;

    // Signal 'PropertyChanged'

    /**
     * Notify on the signal 'PropertyChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendPropertyChangedRegister(PropertyChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'PropertyChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'PropertyChanged'</b>:
     *
     * If the meaning of "PropertyChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendPropertyChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendPropertyChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'PropertyChanged'.
     */
    void sendPropertyChangedDeregisterAll () const;

    // Signal 'ServicesChanged'

    /**
     * Notify on the signal 'ServicesChanged'. This method registers for
     * signal changes by D-Bus service.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when any status or error
     * messages are received in return to the register message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendServicesChangedRegister(ServicesChangedCallbackIF& cb) const;

    /**
     * Remove the notifcation on signal 'ServicesChanged'. This method
     * deregisters signal changes from the D-Bus service.
     *
     * <b>Documentation of 'ServicesChanged'</b>:
     *
     * If the meaning of "ServicesChanged" isn't clear, then there should be a description here.
     *
     * @param act The act which was previously returned by the
     * sendServicesChangedRegister() method.
     *
     * @return true if the registration was removed, otherwise false (invalid
     * act)
     */
    bool sendServicesChangedDeregister(act_t act) const;

    /**
     * Deregisters for all registrations on signal 'ServicesChanged'.
     */
    void sendServicesChangedDeregisterAll () const;



    // Method 'GetProperties'

    /**
     * Call the method 'GetProperties'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetProperties'</b>:
     *
     * If the meaning of "GetProperties" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetPropertiesRequest(GetPropertiesCallbackIF& cb) const;

    // Method 'GetTechnologies'

    /**
     * Call the method 'GetTechnologies'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'GetTechnologies'</b>:
     *
     * If the meaning of "GetTechnologies" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetTechnologiesRequest(GetTechnologiesCallbackIF& cb) const;

    // Method 'GetServices'

    /**
     * Call the method 'GetServices'. This method sends a message to the D-Bus
     * server.
     *
     * <b>Documentation of 'GetServices'</b>:
     *
     * If the meaning of "GetServices" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendGetServicesRequest(GetServicesCallbackIF& cb) const;

    // Method 'RegisterAgent'

    /**
     * Call the method 'RegisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'RegisterAgent'</b>:
     *
     * If the meaning of "RegisterAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendRegisterAgentRequest(RegisterAgentCallbackIF& cb, const ::std::string& path) const;

    // Method 'UnregisterAgent'

    /**
     * Call the method 'UnregisterAgent'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'UnregisterAgent'</b>:
     *
     * If the meaning of "UnregisterAgent" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param path If the meaning of "path" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendUnregisterAgentRequest(UnregisterAgentCallbackIF& cb, const ::std::string& path) const;

    // Method 'CreateSession'

    /**
     * Call the method 'CreateSession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'CreateSession'</b>:
     *
     * If the meaning of "CreateSession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param settings If the meaning of "settings" isn't clear, then there should be a description here.
     *
     * @param notifier If the meaning of "notifier" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendCreateSessionRequest(CreateSessionCallbackIF& cb, const ::std::map< ::std::string, ::asf::dbus::DBusVariant >& settings, const ::std::string& notifier) const;

    // Method 'DestroySession'

    /**
     * Call the method 'DestroySession'. This method sends a message to the
     * D-Bus server.
     *
     * <b>Documentation of 'DestroySession'</b>:
     *
     * If the meaning of "DestroySession" isn't clear, then there should be a description here.
     *
     * @param cb this callback will be called when a response or error message
     * is received in return to the request message.
     *
     * @param session If the meaning of "session" isn't clear, then there should be a description here.
     *
     * @return act (Asynchronous Completion Token). If a callback is called
     * this act will be part of the payload object.
     */
    act_t sendDestroySessionRequest(DestroySessionCallbackIF& cb, const ::std::string& session) const;

    /**
     * Release all property and signal notifications.
     */
    void sendDeregisterAll () const;

private:

    ManagerProxy (const std::string &portName, ::asf::core::ServiceAvailableIF& serviceAvailable);

    act_t addMethodCallback(uint16 methodId, uint32 serial, const std::string memberName, void* cb) const;

    act_t addSignalCallback(uint16 signalId, const std::string& signal, void* cb) const;


    DECLARE_CLASS_LOGGER();

    friend class ManagerProxyCallback;
};

} // namespace Manager
} // namespace connman
} // namespace net

#endif // NET_CONNMAN_MANAGERPROXY_H
